// cosh.testdata
// copyright (C) 2005  F. de Dinechin and V.Lefevre
// This file is part of crlibm and is distributed under the GNU Public Licence
// See file COPYING for details
// The following lines are either comments (beginning with a #)
// or give
//   1/ a rounding mode : RN|RU|RD|RZ (crlibm syntax) or  N|P|M|Z (libmcr syntax)
//   2/ The high and low hexadecimal halves of an input
//   3/ The high and low hexadecimal halves of the expected corresponding output
// Special cases
T(RN,                  0x0p+0,                  0x1p+0,          0x0p+0, 0) // zero
T(RN,                 -0x0p+0,                  0x1p+0,          0x0p+0, 0) // -zero
T(RU,                  0x0p+0,                  0x1p+0,          0x0p+0, 0) // zero
T(RU,                 -0x0p+0,                  0x1p+0,          0x0p+0, 0) // -zero
T(RD,                  0x0p+0,                  0x1p+0,          0x0p+0, 0) // zero
T(RD,                 -0x0p+0,                  0x1p+0,          0x0p+0, 0) // -zero
T(RZ,                  0x0p+0,                  0x1p+0,          0x0p+0, 0) // zero
T(RZ,                 -0x0p+0,                  0x1p+0,          0x0p+0, 0) // -zero
T(RN,               0x1p-1074,                  0x1p+0,          0x0p+0, INEXACT) // smallest denorm positive
T(RN,              -0x1p-1074,                  0x1p+0,          0x0p+0, INEXACT) // smallest denorm negative
T(RU,               0x1p-1074,    0x1.0000000000001p+0,          0x1p+0, INEXACT) // smallest denorm positive
T(RU,              -0x1p-1074,    0x1.0000000000001p+0,          0x1p+0, INEXACT) // smallest denorm negative
T(RD,               0x1p-1074,                  0x1p+0,          0x0p+0, INEXACT) // smallest denorm positive
T(RD,              -0x1p-1074,                  0x1p+0,          0x0p+0, INEXACT) // smallest denorm negative
T(RZ,               0x1p-1074,                  0x1p+0,          0x0p+0, INEXACT) // smallest denorm positive
T(RZ,              -0x1p-1074,                  0x1p+0,          0x0p+0, INEXACT) // smallest denorm negative
T(RN,                     inf,                     inf,          0x0p+0, 0) // +inf
T(RN,                    -inf,                     inf,          0x0p+0, 0) // -inf
T(RU,                     inf,                     inf,          0x0p+0, 0) // +inf
T(RU,                    -inf,                     inf,          0x0p+0, 0) // -inf
T(RD,                     inf,                     inf,          0x0p+0, 0) // +inf
T(RD,                    -inf,                     inf,          0x0p+0, 0) // -inf
T(RZ,                     inf,                     inf,          0x0p+0, 0) // +inf
T(RZ,                    -inf,                     inf,          0x0p+0, 0) // -inf
T(RN,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RU,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RD,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RZ,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RN,               0x1.f4p+9,                     inf,          0x0p+0, INEXACT|OVERFLOW) // A large positive
T(RU,               0x1.f4p+9,                     inf,          0x0p+0, INEXACT|OVERFLOW)
T(RD,               0x1.f4p+9, 0x1.fffffffffffffp+1023,         -0x1p+0, INEXACT|OVERFLOW) // (returns infty rounded down)
T(RZ,               0x1.f4p+9, 0x1.fffffffffffffp+1023,         -0x1p+0, INEXACT|OVERFLOW)
T(RN,              -0x1.f4p+9,                     inf,          0x0p+0, INEXACT|OVERFLOW) // A large negative
T(RU,              -0x1.f4p+9,                     inf,          0x0p+0, INEXACT|OVERFLOW)
T(RD,              -0x1.f4p+9, 0x1.fffffffffffffp+1023,         -0x1p+0, INEXACT|OVERFLOW)
T(RZ,              -0x1.f4p+9, 0x1.fffffffffffffp+1023,         -0x1p+0, INEXACT|OVERFLOW)
//TODO check the transition to infinity (as in exp.checkdate)
// Behaviour at the bounds of the domain
T(RN,    0x1.633ce8fb9f87ep+9,                     inf,          0x0p+0, INEXACT|OVERFLOW) // The first value whose cosh is  +inf
T(RN,    0x1.633ce8fb9f87dp+9, 0x1.ffffffffffd3bp+1023,   0x1.a6b164p-4, INEXACT) // and the one before
T(RN,   -0x1.633ce8fb9f87ep+9,                     inf,          0x0p+0, INEXACT|OVERFLOW) // Same in negative
T(RN,   -0x1.633ce8fb9f87dp+9, 0x1.ffffffffffd3bp+1023,   0x1.a6b164p-4, INEXACT) //
T(RU,    0x1.633ce8fb9f87ep+9,                     inf,          0x0p+0, INEXACT|OVERFLOW)
T(RU,    0x1.633ce8fb9f87dp+9, 0x1.ffffffffffd3bp+1023,   0x1.a6b164p-4, INEXACT)
T(RU,   -0x1.633ce8fb9f87ep+9,                     inf,          0x0p+0, INEXACT|OVERFLOW)
T(RU,   -0x1.633ce8fb9f87dp+9, 0x1.ffffffffffd3bp+1023,   0x1.a6b164p-4, INEXACT)
T(RD,    0x1.633ce8fb9f87ep+9, 0x1.fffffffffffffp+1023,         -0x1p+0, INEXACT|OVERFLOW)
T(RD,    0x1.633ce8fb9f87dp+9, 0x1.ffffffffffd3ap+1023,  -0x1.cb29d4p-1, INEXACT)
T(RD,   -0x1.633ce8fb9f87ep+9, 0x1.fffffffffffffp+1023,         -0x1p+0, INEXACT|OVERFLOW)
T(RD,   -0x1.633ce8fb9f87dp+9, 0x1.ffffffffffd3ap+1023,  -0x1.cb29d4p-1, INEXACT)
T(RZ,    0x1.633ce8fb9f87ep+9, 0x1.fffffffffffffp+1023,         -0x1p+0, INEXACT|OVERFLOW)
T(RZ,    0x1.633ce8fb9f87dp+9, 0x1.ffffffffffd3ap+1023,  -0x1.cb29d4p-1, INEXACT)
T(RZ,   -0x1.633ce8fb9f87ep+9, 0x1.fffffffffffffp+1023,         -0x1p+0, INEXACT|OVERFLOW)
T(RZ,   -0x1.633ce8fb9f87dp+9, 0x1.ffffffffffd3ap+1023,  -0x1.cb29d4p-1, INEXACT)
T(RU,    0x1.65294a5294a53p+9,                     inf,          0x0p+0, INEXACT|OVERFLOW)
T(RD,    0x1.65294a5294a53p+9, 0x1.fffffffffffffp+1023,         -0x1p+0, INEXACT|OVERFLOW) // Thanks to Evgeny Gozdev for this one
T(RZ,    0x1.65294a5294a53p+9, 0x1.fffffffffffffp+1023,         -0x1p+0, INEXACT|OVERFLOW)
// One in five of the very worst cases computed by Lefevre and Muller.
// Rounding these values requires evaluating the function to at least 2^(-100).
// These worst cases have been selected thanks to the filterlists 5 script
// If you want the full list please contact Jean-Michel Muller
T(RZ,    0x1.a371d4786dfecp-1,    0x1.5ad1863802312p+0, -0x1.93d3a4p-51, INEXACT) // 8.192278286942360487898895371472e-01
T(RZ,    0x1.a6031cd5f93bap-1,    0x1.5bff041b260fdp+0,         -0x1p+0, INEXACT) // 8.242424975584221602531442840700e-01
T(RZ,   0x1.2de226a769899p-10,     0x1.00000b1feccap+0,         -0x1p+0, INEXACT) // 1.151593789339189080958569810775e-03
T(RZ,   0x1.169b343aefc91p-11,     0x1.0000025e6ae8p+0, -0x1.8e05cap-52, INEXACT) // 5.313992800139046403587461675500e-04
T(RZ,   0x1.4b18ec239dd1cp-11,     0x1.0000035872ecp+0, -0x1.e6d7b4p-51, INEXACT) // 6.315180839483766454811597412800e-04
T(RN,   0x1.bab406f54dc75p-11,    0x1.000005fb24533p+0,         -0x1p-1, INEXACT) // 8.443894027213698924919094146446e-04
T(RZ,   0x1.37de272a6ae0bp-12,     0x1.000000bdf6c2p+0,         -0x1p+0, INEXACT) // 2.974202967844514068455896715903e-04
T(RZ,   0x1.339b18635f8f8p-13,    0x1.0000002e33ab5p+0, -0x1.928e3ap-52, INEXACT) // 1.466778950138314992907018208257e-04
T(RZ,   0x1.37f9ba95b4dc6p-13,    0x1.0000002f8616dp+0,         -0x1p+0, INEXACT) // 1.487615124263609134129537903135e-04
T(RZ,   0x1.3bcd3ae3ab7bcp-13,    0x1.00000030b2566p+0,         -0x1p+0, INEXACT) // 1.505859755658848662604465395987e-04
T(RZ,   0x1.95fb693ba6d75p-13,    0x1.000000507aae4p+0, -0x1.fca8ecp-51, INEXACT) // 1.935873386756760199892829499291e-04
T(RZ,   0x1.acf3ac3b13951p-13,     0x1.00000059d7f6p+0, -0x1.a59068p-54, INEXACT) // 2.045401796259651878030078053783e-04
T(RZ,   0x1.4bb56d9865189p-14,    0x1.0000000d6e755p+0, -0x1.9bd548p-54, INEXACT) // 7.908551777397443123627379657492e-05
T(RZ,   0x1.6bba69de5832dp-14,    0x1.0000001026518p+0,  -0x1.957edp-55, INEXACT) // 8.671955536022615742153957230087e-05
T(RN,   0x1.03a2e96d68f7ep-15,    0x1.000000020ea61p+0,         -0x1p-1, INEXACT) // 3.095106772413226019820958745399e-05
T(RZ,   0x1.4a05395d02434p-15,    0x1.0000000352e2ep+0,         -0x1p+0, INEXACT) // 3.934149820145789997784258051894e-05
T(RN,   0x1.86e4eeb1477b6p-15,    0x1.00000004a9bcbp+0,          0x1p-1, INEXACT) // 4.659822787743356047301251932069e-05
T(RZ,   0x1.9d47096269363p-15,    0x1.00000005365c8p+0,         -0x1p+0, INEXACT) // 4.926651560602822915507434387017e-05
T(RZ,   0x1.9f5684dc2fe64p-16,    0x1.0000000150eccp+0,         -0x1p+0, INEXACT) // 2.475607185270372343020156558069e-05
T(RZ,   0x1.57a340e4654bap-16,    0x1.00000000e6a37p+0, -0x1.9eca6cp-51, INEXACT) // 2.048240357195995356648712815151e-05
T(RN,   0x1.61fe4e18e28e2p-16,    0x1.00000000f4bfap+0,         -0x1p-1, INEXACT) // 2.109964961819692474661105952016e-05
T(RZ,   0x1.a53b9ceb3aae6p-16,    0x1.000000015a8e9p+0,  -0x1.9e3d3p-51, INEXACT) // 2.510743517529058710857289837826e-05
T(RZ,   0x1.07fffffffd135p-17,    0x1.000000002207fp+0,         -0x1p+0, INEXACT) // 7.867813110331269284649681472477e-06
T(RZ,   0x1.4ffffffff9f88p-17,    0x1.00000000371ffp+0,         -0x1p+0, INEXACT) // 1.001358032222378834866921559765e-05
T(RZ,   0x1.67fffffff8959p-17,    0x1.000000003f47fp+0,         -0x1p+0, INEXACT) // 1.072883605951885524845430125440e-05
T(RZ,      0x1.7ffffffff7p-17,    0x1.0000000047fffp+0,         -0x1p+0, INEXACT) // 1.144409179681254995486483494460e-05
T(RZ,   0x1.c7fffffff0eddp-17,    0x1.000000006587fp+0,         -0x1p+0, INEXACT) // 1.358985900868448611826608957154e-05
T(RZ,   0x1.d855ef7faf8ccp-17,    0x1.000000006cefap+0, -0x1.d84bf4p-51, INEXACT) // 1.407670038077977889756295382107e-05
T(RZ,    0x1.dfffffffee6cp-17,    0x1.00000000707ffp+0,         -0x1p+0, INEXACT) // 1.430511474597177725559538075117e-05
T(RZ,   0x1.f7ffffffeba6bp-17,    0x1.000000007c07fp+0,         -0x1p+0, INEXACT) // 1.502037048325723880175860264208e-05
T(RZ,   0x1.db0044fc30f03p-18,    0x1.000000001b8acp+0,         -0x1p+0, INEXACT) // 7.078067252478317224271674862335e-06
T(RN,   0x1.f70104945433ap-18,    0x1.000000001ee2ap+0,         -0x1p-1, INEXACT) // 7.495343329403525642882534507638e-06
T(RN,   0x1.853ae1e0b20cbp-19,    0x1.00000000049fap+0,          0x1p-1, INEXACT) // 2.899989553693196818023305669221e-06
T(RN,    0x1.0625e9242e3a8p-2,    0x1.086f4e1e148c1p+0,         -0x1p-1, INEXACT) // 2.560039928753732318966740422184e-01
T(RZ,    0x1.17326ffc09f68p-2,     0x1.099318a43ac8p+0, -0x1.b55288p-53, INEXACT) // 2.726533410627696163430755404988e-01
T(RZ,    0x1.3d27bf16d8bdbp-2,    0x1.0c6091056e069p+0,         -0x1p+0, INEXACT) // 3.097219331449971302383517013368e-01
T(RN,    0x1.5af6c11c57ab4p-2,    0x1.0ed620c79ad42p+0,          0x1p-1, INEXACT) // 3.388319181012022784926784879644e-01
T(RN,    0x1.69f7bea1fe40dp-2,    0x1.102934e6af4b3p+0,          0x1p-1, INEXACT) // 3.534841333744800917493478209508e-01
T(RN,   0x1.68b02fe890af9p-20,    0x1.0000000000fe2p+0,          0x1p-1, INEXACT) // 1.343668367807011348159470544295e-06
T(RZ,    0x1.7fffffffffdcp-20,    0x1.00000000011ffp+0,         -0x1p+0, INEXACT) // 1.430511474609253027255595380751e-06
T(RN,    0x1.890a189f9d37p-20,    0x1.00000000012dcp+0,          0x1p-1, INEXACT) // 1.464186006131322877665476567266e-06
T(RN,   0x1.a49beccf0cae9p-20,    0x1.0000000001599p+0,          0x1p-1, INEXACT) // 1.566890933235484920064300475018e-06
T(RZ,   0x1.a92b0f4971c75p-20,    0x1.0000000001611p+0, -0x1.d4673cp-51, INEXACT) // 1.583874978160359496247582174189e-06
T(RN,   0x1.c03246526a33bp-20,    0x1.0000000001886p+0,          0x1p-1, INEXACT) // 1.669661646811449171292555775092e-06
T(RZ,   0x1.40598d11d7dc6p-20,    0x1.0000000000c86p+0,         -0x1p+0, INEXACT) // 1.193396034847184240676931307745e-06
T(RN,    0x1.0d84a171c74bp-21,    0x1.0000000000237p+0,         -0x1p-1, INEXACT) // 5.020165600753676748068884960752e-07
T(RZ,   0x1.25f0532c88edbp-21,    0x1.00000000002a3p+0, -0x1.f7b11ep-51, INEXACT) // 5.475036224983217207268651992302e-07
T(RN,   0x1.33debf093874dp-21,    0x1.00000000002e4p+0,         -0x1p-1, INEXACT) // 5.734527529744384752083256363842e-07
T(RZ,   0x1.4975cd5768071p-22,    0x1.00000000000d4p+0,  -0x1.74902p-51, INEXACT) // 3.068336886461663229440507364570e-07
T(RN,   0x1.bf245c71ee658p-22,    0x1.0000000000187p+0,          0x1p-1, INEXACT) // 4.164334718132620831215675444303e-07
T(RN,   0x1.c2906842b6bcbp-22,    0x1.000000000018dp+0,          0x1p-1, INEXACT) // 4.196205091574376845753996650296e-07
T(RZ,   0x1.caba8aa3d76a4p-22,    0x1.000000000019ap+0,         -0x1p+0, INEXACT) // 4.272243734249872580043200578914e-07
T(RZ,   0x1.03f81f636b809p-23,    0x1.0000000000021p+0, -0x1.dc7574p-51, INEXACT) // 1.210576058124893233399990049096e-07
T(RN,   0x1.09cfdcd8ed006p-23,    0x1.0000000000022p+0,         -0x1p-1, INEXACT) // 1.237783411580036511136476262002e-07
T(RZ,   0x1.c48c6001f0ab1p-23,    0x1.0000000000064p+0, -0x1.72e4ecp-51, INEXACT) // 2.107342425544697696760955115194e-07
T(RZ,   0x1.4c8dc2e42397ap-23,    0x1.0000000000036p+0, -0x1.1de61cp-53, INEXACT) // 1.548574096771069376036078935749e-07
T(RZ,   0x1.4f9e6bbc4ecadp-23,    0x1.0000000000036p+0,         -0x1p+0, INEXACT) // 1.562846970811710471159977154168e-07
T(RZ,   0x1.a13a9cb996645p-23,    0x1.0000000000055p+0, -0x1.fe8c2ap-51, INEXACT) // 1.942873717904877214145928929559e-07
T(RN,   0x1.07e0f66afed06p-24,    0x1.0000000000008p+0,         -0x1p-1, INEXACT) // 6.143906154658883359235969131434e-08
T(RN,   0x1.6fa6ea162d0eep-24,     0x1.000000000001p+0,         -0x1p-1, INEXACT) // 8.560065398421923577708815122217e-08
T(RN,   0x1.2548eb9151e84p-24,    0x1.000000000000ap+0,         -0x1p-1, INEXACT) // 6.828569911354540200254200667251e-08
T(RZ,   0x1.465655f122ff5p-24,    0x1.000000000000cp+0,         -0x1p+0, INEXACT) // 7.598131170262073879582309004002e-08
T(RN,   0x1.854bfb363dc37p-24,    0x1.0000000000012p+0,         -0x1p-1, INEXACT) // 9.064022496787037793657685258095e-08
T(RZ,   0x1.c48c6001f0abcp-24,    0x1.0000000000018p+0,         -0x1p+0, INEXACT) // 1.053671212772350304218355650926e-07
T(RN,   0x1.7ffffffffffffp-25,    0x1.0000000000004p+0,         -0x1p-1, INEXACT) // 4.470348358154296213255509957578e-08
T(RZ,   0x1.94c583ada5b52p-25,    0x1.0000000000005p+0, -0x1.1e5588p-53, INEXACT) // 4.712160915387241659608264865780e-08
T(RN,   0x1.a887293fd6f33p-25,    0x1.0000000000005p+0,         -0x1p-1, INEXACT) // 4.942156062059699544151370408616e-08
T(RN,   0x1.cd82b446159f2p-25,    0x1.0000000000006p+0,         -0x1p-1, INEXACT) // 5.372690074837190927221610087586e-08
T(RN,   0x1.efbdeb14f4ed8p-25,    0x1.0000000000007p+0,         -0x1p-1, INEXACT) // 5.771194914292419155256680211863e-08
T(RZ,    0x1.0460265bb6595p-3,    0x1.02125da072322p+0, -0x1.1ce5bep-52, INEXACT) // 1.271365162599919218511246299386e-01
T(RZ,    0x1.a837d832315e3p-3,    0x1.0582facf5b353p+0, -0x1.af40f4p-51, INEXACT) // 2.071377649610176285843721188940e-01
T(RZ,    0x1.bf0305e2c6c37p-3,    0x1.061f4c39e16f2p+0,  -0x1.a465cp-56, INEXACT) // 2.182674846488638908947876871025e-01
T(RN,    0x1.cc6043d217baep-3,    0x1.067ed033ca8eap+0,          0x1p-1, INEXACT) // 2.247929857721521762492500329245e-01
T(RN,    0x1.2ab59e1e984b9p-5,    0x1.002b92a6ff59ep+0,         -0x1p-1, INEXACT) // 3.646355517117556149786494756881e-02
T(RZ,    0x1.49303c25c4ea4p-5,    0x1.0034eb731c1fbp+0, -0x1.bff064p-51, INEXACT) // 4.018413302960979760491966317204e-02
T(RZ,    0x1.593c43f3dcae4p-5,     0x1.003a34a42ee1p+0,  -0x1.30e49p-51, INEXACT) // 4.214299461354700793158656324522e-02
T(RZ,    0x1.944cf384c0f97p-5,    0x1.004fd484c3aabp+0, -0x1.3fc22cp-51, INEXACT) // 4.935309946270576703097887616423e-02
T(RN,    0x1.a0cd7537a1987p-5,    0x1.0054d83b962f3p+0,          0x1p-1, INEXACT) // 5.087921995168458860758775585964e-02
T(RN,    0x1.a593cf5fbf96cp-5,    0x1.0056ccd6f1a7ep+0,         -0x1p-1, INEXACT) // 5.146208288896300664383431922033e-02
T(RZ,    0x1.cf861086f8404p-5,    0x1.0068eff145549p+0, -0x1.be1fd4p-51, INEXACT) // 5.658248165105564386756498151954e-02
T(RZ,    0x1.03eb517fef62fp-6,    0x1.00083f3b4f871p+0,  -0x1.b0361p-51, INEXACT) // 1.586420973739260595336553194556e-02
T(RN,    0x1.722a969a7de31p-6,    0x1.0010ba27b4a0dp+0,          0x1p-1, INEXACT) // 2.259316165324615557907783625069e-02
T(RZ,    0x1.c81b6e17869e6p-6,    0x1.0019657955466p+0,         -0x1p+0, INEXACT) // 2.783857108270550856365943559467e-02
T(RN,    0x1.3cbbe0469c99dp-6,    0x1.000c3f1bdb338p+0,         -0x1p-1, INEXACT) // 1.933190252243265419562767704065e-02
T(RZ,    0x1.379d22b34a168p-7,    0x1.0002f69fcc33ap+0,         -0x1p+0, INEXACT) // 9.509698813943770479006900586683e-03
T(RN,    0x1.4a9172dc745b4p-7,    0x1.000355b87806dp+0,         -0x1p-1, INEXACT) // 1.008813961462604741337045766159e-02
T(RZ,    0x1.c36a970e51ebcp-7,    0x1.00063807eb4c2p+0,         -0x1p+0, INEXACT) // 1.377613425996970092368698601604e-02
T(RZ,    0x1.2574217de6f45p-8,    0x1.0000a83197171p+0,         -0x1p+0, INEXACT) // 4.477747132025038274971695528848e-03
T(RZ,    0x1.0d471ebfc64f9p-9,    0x1.00002367d21d1p+0, -0x1.7ae498p-51, INEXACT) // 2.054426673464445924494059525500e-03
T(RN,    0x1.1e14e7b7e7dc6p-9,    0x1.000027f657f8bp+0,          0x1p-1, INEXACT) // 2.182629857955228729060603853895e-03
T(RN,    0x1.529e2c5d5ac61p-9,    0x1.000037fcc3e6ap+0,          0x1p-1, INEXACT) // 2.583449283226666327167864167791e-03
T(RN,    0x1.a42646a7dbd23p-9,    0x1.00005631b8884p+0,          0x1p-1, INEXACT) // 3.205486416781548521942601936985e-03
T(RN,    0x1.f4f3b828fec86p-9,    0x1.00007a8927b37p+0,          0x1p-1, INEXACT) // 3.821960669026905170475583162215e-03
T(RN,    0x1.f8484b7cd4154p-9,    0x1.00007c2ba1be8p+0,          0x1p-1, INEXACT) // 3.847369398876457693980945862222e-03
T(RZ,    0x1.67fc7c96c1262p+0,     0x1.14d4a6f5b4e5p+1, -0x1.aeca8ep-52, INEXACT) // 1.406196390919966621169123754953e+00
T(RN,    0x1.3e73d00a39464p+1,    0x1.83d03cf9a8438p+2,          0x1p-1, INEXACT) // 2.487909321777395987851377867628e+00
T(RN,    0x1.4e4a537fa4c71p+1,    0x1.b63c0b90124a6p+2,          0x1p-1, INEXACT) // 2.611643254590994889241528653656e+00
T(RZ,    0x1.5ee88f48c08a5p+1,    0x1.f2607936aab74p+2, -0x1.6d55eap-51, INEXACT) // 2.741472158931247182778179194429e+00
T(RZ,    0x1.6374b96712753p+1,    0x1.022095f247aa5p+3, -0x1.ed1618p-52, INEXACT) // 2.776999640777753963760687838658e+00
T(RZ,    0x1.6d7071bdcd62ap+1,    0x1.16e905141cae4p+3,         -0x1p+0, INEXACT) // 2.854994027783296139944013702916e+00
T(RN,     0x1.df7ed606c636p+1,    0x1.5304f1b6a2972p+4,         -0x1p-1, INEXACT) // 3.746058228786225186013325583190e+00
T(RN,    0x1.ff15fb9c40b06p+3,   0x1.078ba0fedcf4bp+22,         -0x1p-1, INEXACT) // 1.597143345373252643071282363962e+01
T(RN,    0x1.013065f3561b2p+4,   0x1.241a8076917cep+22,         -0x1p-1, INEXACT) // 1.607431597760450614487126586027e+01
T(RN,    0x1.ff59f1eeb6e2cp+4,   0x1.13da3ed2fb031p+45,          0x1p-1, INEXACT) // 3.195945924041568275697500212118e+01
T(RN,    0x1.2e182ad682f39p+4,   0x1.2e345749045b6p+26,          0x1p-1, INEXACT) // 1.888090022843900683824358566198e+01
T(RZ,     0x1.ef5029032f67p+4,   0x1.94f40e6702c6bp+43,         -0x1p+0, INEXACT) // 3.095707036251263843951164744794e+01
T(RN,    0x1.088beface97a9p+5,   0x1.a20b6cdabbab4p+46,          0x1p-1, INEXACT) // 3.306832823836823109786564600654e+01
T(RZ,    0x1.94925476814e9p+5,    0x1.f1b76b88f075p+71, -0x1.b710acp-51, INEXACT) // 5.057145016271699233811887097545e+01
T(RN,    0x1.a1d3b2f33674ep+5,   0x1.4632f06b68116p+74,         -0x1p-1, INEXACT) // 5.222836866388261967131256824359e+01
T(RZ,    0x1.e07e71bfcf06fp+5,   0x1.91ec4412c344fp+85,  -0x1.09d28p-57, INEXACT) // 6.006174039698168343193174223416e+01
T(RN,    0x1.f0a1fc4b9f04bp+5,    0x1.79ba395af901p+88,          0x1p-1, INEXACT) // 6.207909449652705546895958832465e+01
T(RN,    0x1.181ccd8144be7p+6,  0x1.053d7702a0c15p+100,         -0x1p-1, INEXACT) // 7.002812768919066854778066044673e+01
T(RZ,    0x1.7945e34b18a9ap+7,  0x1.1b0e4936a8c9ap+271,         -0x1p+0, INEXACT) // 1.886364997356038770703889895231e+02
T(RZ,    0x1.f44c934fc9053p+7,  0x1.da4255c59658dp+359,         -0x1p+0, INEXACT) // 2.501495613987814010670263087377e+02
T(RZ,    0x1.204684c1167e9p+8,  0x1.db9797d3d32e7p+414,         -0x1p+0, INEXACT) // 2.882754631690900737339688930660e+02
T(RZ,     0x1.2da9e5e6af0bp+8,  0x1.27d6fe867d6f6p+434,  -0x1.0a1d5p-53, INEXACT) // 3.016636642625189779209904372692e+02
T(RN,    0x1.4b857492a59ebp+8,  0x1.37bab2ac649f8p+477,         -0x1p-1, INEXACT) // 3.315213100103707688504073303193e+02
T(RZ,     0x1.532627c210d1p+8,  0x1.38b3af1b0b785p+488,         -0x1p+0, INEXACT) // 3.391490441599898986169137060642e+02
T(RN,    0x1.9cd6b6d99965bp+8,  0x1.84208270e2e4cp+594,          0x1p-1, INEXACT) // 4.128387275695328639812942128628e+02
T(RZ,    0x1.c7206c1b753e4p+8,  0x1.8670de0b68cacp+655,         -0x1p+0, INEXACT) // 4.551266495858419602882349863648e+02
T(RN,    0x1.fee02d3d0ec9ap+8,  0x1.06ccf59e5ed14p+736,         -0x1p-1, INEXACT) // 5.108756902848341496792272664607e+02
T(RZ,    0x1.f419d873a3f83p+8,  0x1.685463d30fb68p+720,         -0x1p+0, INEXACT) // 5.001009590411487693017988931388e+02
T(RZ,    0x1.0bc04af1b09f5p+9,  0x1.7b1d97c902985p+771, -0x1.551dfcp-53, INEXACT) // 5.355022871124662060537957586348e+02
// Bad cases generated by crlibm_generate_test_vectors cosh 18 1
T(RD,   -0x1.1cc2ca20e0341p-7,    0x1.000279828ea85p+0, -0x1.2800d2p-22, INEXACT) // -8.690212913053609392055598448223e-03
T(RU,   -0x1.1cc2ca20e0341p-7,    0x1.000279828ea86p+0,   0x1.fffff6p-1, INEXACT) // -8.690212913053609392055598448223e-03
T(RZ,   -0x1.1cc2ca20e0341p-7,    0x1.000279828ea85p+0, -0x1.2800d2p-22, INEXACT) // -8.690212913053609392055598448223e-03
T(RN,    0x1.3a1c272a684cap+8,  0x1.1effa30012b93p+452,   -0x1.ffffep-2, INEXACT) // 3.141099726204525950379320420325e+02
T(RN,    0x1.4aca55df1308cp-5,    0x1.00356fa4767dap+0,   0x1.ffffc8p-2, INEXACT) // 4.037968417887424776857585584366e-02
T(RN,    0x1.7460149b27bc7p+1,    0x1.26574b074596fp+3,   0x1.ffffdep-2, INEXACT) // 2.909182143935570064030571302283e+00
T(RD,    0x1.dd1aebb331b6ep+0,    0x1.a690ef7cbd4c9p+1,  -0x1.ffffeep-1, INEXACT) // 1.863692027329047373740422699484e+00
T(RU,    0x1.dd1aebb331b6ep+0,    0x1.a690ef7cbd4cap+1,   0x1.1669ep-21, INEXACT) // 1.863692027329047373740422699484e+00
T(RZ,    0x1.dd1aebb331b6ep+0,    0x1.a690ef7cbd4c9p+1,  -0x1.ffffeep-1, INEXACT) // 1.863692027329047373740422699484e+00
T(RN,    0x1.4a2feb906924ep-2,    0x1.0d6c9be0d0b04p+0,   0x1.fffffep-2, INEXACT) // 3.224484259501750882392911989882e-01
T(RD,   -0x1.aa40c6f84a7efp-2,    0x1.1680532df7436p+0, -0x1.c8b8aap-23, INEXACT) // -4.162627305073546835068043492356e-01
T(RU,   -0x1.aa40c6f84a7efp-2,    0x1.1680532df7437p+0,   0x1.fffff8p-1, INEXACT) // -4.162627305073546835068043492356e-01
T(RZ,   -0x1.aa40c6f84a7efp-2,    0x1.1680532df7436p+0, -0x1.c8b8aap-23, INEXACT) // -4.162627305073546835068043492356e-01
T(RD,   -0x1.b9e31e713ea74p+7,  0x1.afcd25a9301b5p+317, -0x1.614478p-24, INEXACT) // -2.209435916317921737572760321200e+02
T(RU,   -0x1.b9e31e713ea74p+7,  0x1.afcd25a9301b6p+317,   0x1.fffffep-1, INEXACT) // -2.209435916317921737572760321200e+02
T(RZ,   -0x1.b9e31e713ea74p+7,  0x1.afcd25a9301b5p+317, -0x1.614478p-24, INEXACT) // -2.209435916317921737572760321200e+02
T(RN,   -0x1.b8367596cbaecp-4,    0x1.017adaecf6e1bp+0,   -0x1.fffffp-2, INEXACT) // -1.074738114664161581224277597357e-01
T(RD,   -0x1.466219b3d522fp+0,    0x1.edd030743fca2p+0,  -0x1.fffff2p-1, INEXACT) // -1.274934393314776093220075381396e+00
T(RU,   -0x1.466219b3d522fp+0,    0x1.edd030743fca3p+0,   0x1.c061ap-22, INEXACT) // -1.274934393314776093220075381396e+00
T(RZ,   -0x1.466219b3d522fp+0,    0x1.edd030743fca2p+0,  -0x1.fffff2p-1, INEXACT) // -1.274934393314776093220075381396e+00
T(RN,   -0x1.6a9cbb0a275dfp-4,    0x1.0100fac3621a5p+0,  -0x1.fffffap-2, INEXACT) // -8.852837622040209131224486327483e-02
T(RN,    0x1.a10983b33e9f5p+6,  0x1.552c798f6b072p+149,   0x1.ffffcap-2, INEXACT) // 1.042592914587947490190344979055e+02
T(RN,   -0x1.a2ce0ae841763p-2,    0x1.15b600d5e40c7p+0,  -0x1.fffffep-2, INEXACT) // -4.089891151673922808917893689795e-01
T(RD,  -0x1.58849acf064c6p-10,    0x1.00000e7d2548ep+0, -0x1.11dec2p-21, INEXACT) // -1.314231823704313430883905411406e-03
T(RU,  -0x1.58849acf064c6p-10,    0x1.00000e7d2548fp+0,   0x1.ffffeep-1, INEXACT) // -1.314231823704313430883905411406e-03
T(RZ,  -0x1.58849acf064c6p-10,    0x1.00000e7d2548ep+0, -0x1.11dec2p-21, INEXACT) // -1.314231823704313430883905411406e-03
T(RD,    0x1.67ae00610273ap-5,    0x1.003f2dc8819e7p+0, -0x1.0c3628p-21, INEXACT) // 4.390621255886491269837534900944e-02
T(RU,    0x1.67ae00610273ap-5,    0x1.003f2dc8819e8p+0,    0x1.fffffp-1, INEXACT) // 4.390621255886491269837534900944e-02
T(RZ,    0x1.67ae00610273ap-5,    0x1.003f2dc8819e7p+0, -0x1.0c3628p-21, INEXACT) // 4.390621255886491269837534900944e-02
T(RD,   -0x1.8a5e338c77a2dp-5,    0x1.004bf48466974p+0, -0x1.f9caa6p-22, INEXACT) // -4.814062183480802975532597542951e-02
T(RU,   -0x1.8a5e338c77a2dp-5,    0x1.004bf48466975p+0,    0x1.fffffp-1, INEXACT) // -4.814062183480802975532597542951e-02
T(RZ,   -0x1.8a5e338c77a2dp-5,    0x1.004bf48466974p+0, -0x1.f9caa6p-22, INEXACT) // -4.814062183480802975532597542951e-02
T(RD,   -0x1.ab9affce7abb8p-1,    0x1.5e9794a753735p+0, -0x1.8cd698p-22, INEXACT) // -8.351669253873899023687954468187e-01
T(RU,   -0x1.ab9affce7abb8p-1,    0x1.5e9794a753736p+0,   0x1.fffff4p-1, INEXACT) // -8.351669253873899023687954468187e-01
T(RZ,   -0x1.ab9affce7abb8p-1,    0x1.5e9794a753735p+0, -0x1.8cd698p-22, INEXACT) // -8.351669253873899023687954468187e-01
T(RD,     0x1.612efb949a6cp-9,    0x1.00003ce855b83p+0,   -0x1.aee2p-22, INEXACT) // 2.694576464183778830019377892313e-03
T(RU,     0x1.612efb949a6cp-9,    0x1.00003ce855b84p+0,   0x1.fffff2p-1, INEXACT) // 2.694576464183778830019377892313e-03
T(RZ,     0x1.612efb949a6cp-9,    0x1.00003ce855b83p+0,   -0x1.aee2p-22, INEXACT) // 2.694576464183778830019377892313e-03
T(RN,   0x1.831bb18025e31p-10,     0x1.0000124ae625p+0,  -0x1.fffff6p-2, INEXACT) // 1.476700505042571410010965315962e-03
T(RD,    0x1.8644517c22ce3p-9,     0x1.00004a5e8aeap+0, -0x1.114bdap-21, INEXACT) // 2.977499911201429618617941841308e-03
T(RU,    0x1.8644517c22ce3p-9,    0x1.00004a5e8aea1p+0,   0x1.ffffeep-1, INEXACT) // 2.977499911201429618617941841308e-03
T(RZ,    0x1.8644517c22ce3p-9,     0x1.00004a5e8aeap+0, -0x1.114bdap-21, INEXACT) // 2.977499911201429618617941841308e-03
T(RD,   -0x1.422f1878bd742p-9,    0x1.000032af51f35p+0,  -0x1.fffffap-1, INEXACT) // -2.458068597088664854199979714622e-03
T(RU,   -0x1.422f1878bd742p-9,    0x1.000032af51f36p+0,   0x1.8a292p-23, INEXACT) // -2.458068597088664854199979714622e-03
T(RZ,   -0x1.422f1878bd742p-9,    0x1.000032af51f35p+0,  -0x1.fffffap-1, INEXACT) // -2.458068597088664854199979714622e-03
T(RN,   -0x1.ee03ce1cd03cdp-1,    0x1.80b3bf15b459dp+0,  -0x1.fffff6p-2, INEXACT) // -9.648727808163301000732303691620e-01
T(RN,    0x1.d3ea2fd0a92a1p-4,    0x1.01ac173adccddp+0,  -0x1.ffffc6p-2, INEXACT) // 1.142370097900973352489373269236e-01
T(RN,   -0x1.9b8f8957d4c3cp-7,    0x1.00052b50db042p+0,  -0x1.ffffd6p-2, INEXACT) // -1.255983549314098474125600546358e-02
T(RD,   -0x1.62e3abb73b1e7p-2,    0x1.0f87611e2b04ep+0,  -0x1.fffffcp-1, INEXACT) // -3.465716200433050508955545865319e-01
T(RU,   -0x1.62e3abb73b1e7p-2,    0x1.0f87611e2b04fp+0,  0x1.0186d6p-23, INEXACT) // -3.465716200433050508955545865319e-01
T(RZ,   -0x1.62e3abb73b1e7p-2,    0x1.0f87611e2b04ep+0,  -0x1.fffffcp-1, INEXACT) // -3.465716200433050508955545865319e-01
T(RD,   -0x1.452f6f9f8ebeep-9,    0x1.000033a23102fp+0,  -0x1.ffffe4p-1, INEXACT) // -2.480966926467590392968443069321e-03
T(RU,   -0x1.452f6f9f8ebeep-9,     0x1.000033a23103p+0,  0x1.b212acp-21, INEXACT) // -2.480966926467590392968443069321e-03
T(RZ,   -0x1.452f6f9f8ebeep-9,    0x1.000033a23102fp+0,  -0x1.ffffe4p-1, INEXACT) // -2.480966926467590392968443069321e-03
T(RN,   -0x1.36d5b7d28edbdp-5,    0x1.002f2ebc69b94p+0,   0x1.fffff2p-2, INEXACT) // -3.794370558577096069763356922522e-02
T(RN,   -0x1.e3f3c91941187p-3,    0x1.072e4b67cf8a3p+0,   -0x1.ffffcp-2, INEXACT) // -2.363048277694696774897664681703e-01
T(RN,   -0x1.efa05637ed2b4p+1,    0x1.80812225c5b6ep+4,   0x1.fffffap-2, INEXACT) // -3.872080590541679967486743407790e+00
T(RN,    0x1.51a69fb21b7bcp+9,  0x1.316277f3b6a8fp+973,   0x1.ffffd6p-2, INEXACT) // 6.753017485269733697350602596998e+02
T(RD,    0x1.0f4fa575042d8p+0,    0x1.9dbd60ef6bf8fp+0, -0x1.fbebb8p-21, INEXACT) // 1.059809056347310374235348717775e+00
T(RU,    0x1.0f4fa575042d8p+0,     0x1.9dbd60ef6bf9p+0,    0x1.ffffep-1, INEXACT) // 1.059809056347310374235348717775e+00
T(RZ,    0x1.0f4fa575042d8p+0,    0x1.9dbd60ef6bf8fp+0, -0x1.fbebb8p-21, INEXACT) // 1.059809056347310374235348717775e+00
T(RD,     0x1.ee9d87087203p-3,    0x1.0780978f75dc1p+0, -0x1.87773ap-21, INEXACT) // 2.415113973095244226385602814844e-01
T(RU,     0x1.ee9d87087203p-3,    0x1.0780978f75dc2p+0,   0x1.ffffe8p-1, INEXACT) // 2.415113973095244226385602814844e-01
T(RZ,     0x1.ee9d87087203p-3,    0x1.0780978f75dc1p+0, -0x1.87773ap-21, INEXACT) // 2.415113973095244226385602814844e-01
T(RD,   -0x1.0ef0358d22c25p+7,  0x1.5b74896f241a2p+194,  -0x1.fffff8p-1, INEXACT) // -1.354691585640840969517739722505e+02
T(RU,   -0x1.0ef0358d22c25p+7,  0x1.5b74896f241a3p+194,  0x1.1c2dd2p-22, INEXACT) // -1.354691585640840969517739722505e+02
T(RZ,   -0x1.0ef0358d22c25p+7,  0x1.5b74896f241a2p+194,  -0x1.fffff8p-1, INEXACT) // -1.354691585640840969517739722505e+02
T(RD,   -0x1.06565a7aae79cp+8,  0x1.634398532ae52p+377, -0x1.abefb8p-25, INEXACT) // -2.623373181034055505733704194427e+02
T(RU,   -0x1.06565a7aae79cp+8,  0x1.634398532ae53p+377,   0x1.fffffep-1, INEXACT) // -2.623373181034055505733704194427e+02
T(RZ,   -0x1.06565a7aae79cp+8,  0x1.634398532ae52p+377, -0x1.abefb8p-25, INEXACT) // -2.623373181034055505733704194427e+02
T(RD,    0x1.3d1fb19be0403p-1,    0x1.32b2000ed4643p+0,  -0x1.ffffecp-1, INEXACT) // 6.193824293878836817484057064576e-01
T(RU,    0x1.3d1fb19be0403p-1,    0x1.32b2000ed4644p+0,  0x1.418b1ap-21, INEXACT) // 6.193824293878836817484057064576e-01
T(RZ,    0x1.3d1fb19be0403p-1,    0x1.32b2000ed4643p+0,  -0x1.ffffecp-1, INEXACT) // 6.193824293878836817484057064576e-01
T(RD,    0x1.ccaa3dc8603b7p-6,    0x1.0019e811d291ap+0, -0x1.6f085ep-22, INEXACT) // 2.811676057308762008424274370100e-02
T(RU,    0x1.ccaa3dc8603b7p-6,    0x1.0019e811d291bp+0,   0x1.fffff4p-1, INEXACT) // 2.811676057308762008424274370100e-02
T(RZ,    0x1.ccaa3dc8603b7p-6,    0x1.0019e811d291ap+0, -0x1.6f085ep-22, INEXACT) // 2.811676057308762008424274370100e-02
T(RN,    0x1.e6f383457c5f3p+8,   0x1.6fa16b80aa08p+701,   0x1.ffffcap-2, INEXACT) // 4.869512217930452493419579695910e+02
T(RN,   -0x1.157263b25d659p+1,    0x1.1b3e2c2c5ba7ep+2,   0x1.ffffd8p-2, INEXACT) // -2.167553388683512327617108894628e+00
T(RN,    0x1.692c6cbb1682cp-3,    0x1.03fdc18273877p+0,  -0x1.fffff2p-2, INEXACT) // 1.763542646975236882767035240249e-01
T(RN,   -0x1.db7eb66f21027p+5,   0x1.ae52f41a57e1ap+84,   0x1.ffffdcp-2, INEXACT) // -5.943687140292632165028408053331e+01
T(RN,    0x1.0abd1fc687364p-9,    0x1.000022bdb3013p+0,  -0x1.fffffep-2, INEXACT) // 2.035055283398911132874964380335e-03
T(RD,   -0x1.d2b84c1412548p+2,    0x1.6f4f38cdc2993p+9,  -0x1.fffffcp-1, INEXACT) // -7.292498607255147646810655714944e+00
T(RU,   -0x1.d2b84c1412548p+2,    0x1.6f4f38cdc2994p+9,  0x1.e1a308p-24, INEXACT) // -7.292498607255147646810655714944e+00
T(RZ,   -0x1.d2b84c1412548p+2,    0x1.6f4f38cdc2993p+9,  -0x1.fffffcp-1, INEXACT) // -7.292498607255147646810655714944e+00
T(RD,    0x1.a8b2783f62c55p+8,  0x1.a2524dcb6611cp+611,  -0x1.fffff8p-1, INEXACT) // 4.246971473327769786010321695358e+02
T(RU,    0x1.a8b2783f62c55p+8,  0x1.a2524dcb6611dp+611,  0x1.ec4862p-23, INEXACT) // 4.246971473327769786010321695358e+02
T(RZ,    0x1.a8b2783f62c55p+8,  0x1.a2524dcb6611cp+611,  -0x1.fffff8p-1, INEXACT) // 4.246971473327769786010321695358e+02
T(RN,    0x1.38d3c529ccfa2p+1,    0x1.735f87d481389p+2,  -0x1.ffffc6p-2, INEXACT) // 2.443962712679380366864734241972e+00
T(RN,   -0x1.1b54e0655e076p+4,   0x1.762c6e2d02005p+24,  -0x1.ffffdap-2, INEXACT) // -1.770822181316949439633390284143e+01
T(RD,    0x1.f1bed4e699d73p-5,    0x1.00790257f2c16p+0, -0x1.dfbc48p-21, INEXACT) // 6.075994093117289412964154848851e-02
T(RU,    0x1.f1bed4e699d73p-5,    0x1.00790257f2c17p+0,   0x1.ffffe2p-1, INEXACT) // 6.075994093117289412964154848851e-02
T(RZ,    0x1.f1bed4e699d73p-5,    0x1.00790257f2c16p+0, -0x1.dfbc48p-21, INEXACT) // 6.075994093117289412964154848851e-02
T(RN,    0x1.389ff524c4414p+2,    0x1.08888a8a05d31p+6,         -0x1p-1, INEXACT) // 4.884763036637213673429869231768e+00
T(RN,    0x1.1a3913fcdfc03p+2,    0x1.4909f49ca7c72p+5,  -0x1.ffffdep-2, INEXACT) // 4.409733769366542155410115810810e+00
T(RD,    0x1.cc913d8aef435p+6,  0x1.152806cc553b2p+165,   -0x1.fffffp-1, INEXACT) // 1.151418363293203839248235453852e+02
T(RU,    0x1.cc913d8aef435p+6,  0x1.152806cc553b3p+165,  0x1.f3578ap-22, INEXACT) // 1.151418363293203839248235453852e+02
T(RZ,    0x1.cc913d8aef435p+6,  0x1.152806cc553b2p+165,   -0x1.fffffp-1, INEXACT) // 1.151418363293203839248235453852e+02
T(RN,   -0x1.e2e760aeda62ep+1,     0x1.5c286a72e37ep+4,   0x1.ffffe8p-2, INEXACT) // -3.772686086060978105649610370165e+00
T(RN,   -0x1.01c929bb846efp-3,    0x1.0207da9a0acc8p+0,   0x1.ffffd8p-2, INEXACT) // -1.258719692564720105121267579307e-01
T(RD,   -0x1.d0a726a180382p+8,  0x1.46d975d0e2dc5p+669,  -0x1.ffffe2p-1, INEXACT) // -4.646529332101855516157229430974e+02
T(RU,   -0x1.d0a726a180382p+8,  0x1.46d975d0e2dc6p+669,  0x1.d4cfd2p-21, INEXACT) // -4.646529332101855516157229430974e+02
T(RZ,   -0x1.d0a726a180382p+8,  0x1.46d975d0e2dc5p+669,  -0x1.ffffe2p-1, INEXACT) // -4.646529332101855516157229430974e+02
T(RN,   -0x1.0e663b60748adp+1,     0x1.0c79164f801ap+2,  -0x1.ffffdap-2, INEXACT) // -2.112494871232306170583115090267e+00
T(RD,    0x1.33c971b211cbcp-5,    0x1.002e42fd462d3p+0, -0x1.2e242ap-21, INEXACT) // 3.757164198082693640223794773192e-02
T(RU,    0x1.33c971b211cbcp-5,    0x1.002e42fd462d4p+0,   0x1.ffffeep-1, INEXACT) // 3.757164198082693640223794773192e-02
T(RZ,    0x1.33c971b211cbcp-5,    0x1.002e42fd462d3p+0, -0x1.2e242ap-21, INEXACT) // 3.757164198082693640223794773192e-02
T(RN,   -0x1.9d36682457848p+1,    0x1.9463f08eec6cap+3,   0x1.fffff2p-2, INEXACT) // -3.228222863907863171561984927393e+00
T(RD,    0x1.cee6df31f493cp+1,    0x1.29d92c2146097p+4, -0x1.3948aep-21, INEXACT) // 3.616420649902606143655248160940e+00
T(RU,    0x1.cee6df31f493cp+1,    0x1.29d92c2146098p+4,   0x1.ffffecp-1, INEXACT) // 3.616420649902606143655248160940e+00
T(RZ,    0x1.cee6df31f493cp+1,    0x1.29d92c2146097p+4, -0x1.3948aep-21, INEXACT) // 3.616420649902606143655248160940e+00
T(RN,    0x1.36bc3e2aa5a4fp+9,  0x1.820b36870e956p+895,  -0x1.ffffd2p-2, INEXACT) // 6.214706471737680431033368222415e+02
T(RD,    0x1.110703c5c85d1p-9,    0x1.00002465ffa46p+0,  -0x1.ffffeep-1, INEXACT) // 2.083033762475074591319357253383e-03
T(RU,    0x1.110703c5c85d1p-9,    0x1.00002465ffa47p+0,  0x1.112d8cp-21, INEXACT) // 2.083033762475074591319357253383e-03
T(RZ,    0x1.110703c5c85d1p-9,    0x1.00002465ffa46p+0,  -0x1.ffffeep-1, INEXACT) // 2.083033762475074591319357253383e-03
T(RN,   -0x1.cd2f9d4125332p-3,    0x1.0684b1aed6e43p+0,  -0x1.ffffe6p-2, INEXACT) // -2.251884732728740012852597374149e-01
T(RN,   -0x1.899b5fd85ea18p-6,    0x1.0012e9aef1168p+0,  -0x1.ffffdep-2, INEXACT) // -2.402386054880353838392181842210e-02
T(RN,   -0x1.23ef53beac3c6p-8,    0x1.0000a6750e1a8p+0,   0x1.ffffe4p-2, INEXACT) // -4.454572625648139591603147380283e-03
T(RN,    0x1.ddbcd587771d5p-5,    0x1.006f793dffd0fp+0,  -0x1.ffffc2p-2, INEXACT) // 5.831758217729868937206916257310e-02
T(RD,   -0x1.fb306b6e63b0ep-1,    0x1.88381bd57af9ep+0,   -0x1.fffffp-1, INEXACT) // -9.906037876370150652149959569215e-01
T(RU,   -0x1.fb306b6e63b0ep-1,    0x1.88381bd57af9fp+0,  0x1.ebce1cp-22, INEXACT) // -9.906037876370150652149959569215e-01
T(RZ,   -0x1.fb306b6e63b0ep-1,    0x1.88381bd57af9ep+0,   -0x1.fffffp-1, INEXACT) // -9.906037876370150652149959569215e-01
T(RN,   -0x1.53ae68ee89381p-9,    0x1.00003856ee286p+0,   0x1.ffffdcp-2, INEXACT) // -2.591562565856298395311485549541e-03
T(RD,    0x1.50e6c7f9bd56ep-4,    0x1.00ddcf4f07975p+0, -0x1.af305cp-21, INEXACT) // 8.225134005973241957399011425878e-02
T(RU,    0x1.50e6c7f9bd56ep-4,    0x1.00ddcf4f07976p+0,   0x1.ffffe6p-1, INEXACT) // 8.225134005973241957399011425878e-02
T(RZ,    0x1.50e6c7f9bd56ep-4,    0x1.00ddcf4f07975p+0, -0x1.af305cp-21, INEXACT) // 8.225134005973241957399011425878e-02
T(RN,   0x1.ccbd2c507cf52p-10,    0x1.000019e9c3884p+0,  -0x1.ffffc6p-2, INEXACT) // 1.757579641091096007282645885539e-03
T(RN,    0x1.f343aa029fe28p-1,     0x1.83aaa59046b5p+0,  -0x1.ffffe6p-2, INEXACT) // 9.751256111339374754720665805507e-01
T(RD,   -0x1.9f1f28da36b49p+0,    0x1.508d22efe9c46p+1, -0x1.eaa246p-21, INEXACT) // -1.621569207453563032927945641859e+00
T(RU,   -0x1.9f1f28da36b49p+0,    0x1.508d22efe9c47p+1,   0x1.ffffe2p-1, INEXACT) // -1.621569207453563032927945641859e+00
T(RZ,   -0x1.9f1f28da36b49p+0,    0x1.508d22efe9c46p+1, -0x1.eaa246p-21, INEXACT) // -1.621569207453563032927945641859e+00
T(RD,     0x1.fccdc2a31747p-1,    0x1.8928807276c78p+0, -0x1.9ed692p-26, INEXACT) // 9.937573265157322310869858483784e-01
T(RU,     0x1.fccdc2a31747p-1,    0x1.8928807276c79p+0,          0x1p+0, INEXACT) // 9.937573265157322310869858483784e-01
T(RZ,     0x1.fccdc2a31747p-1,    0x1.8928807276c78p+0, -0x1.9ed692p-26, INEXACT) // 9.937573265157322310869858483784e-01
T(RD,   -0x1.fea3702be28c4p+7,   0x1.45c85608b64cp+367,  -0x1.fffff2p-1, INEXACT) // -2.553192151750610037197475321591e+02
T(RU,   -0x1.fea3702be28c4p+7,  0x1.45c85608b64c1p+367,   0x1.b2075p-22, INEXACT) // -2.553192151750610037197475321591e+02
T(RZ,   -0x1.fea3702be28c4p+7,   0x1.45c85608b64cp+367,  -0x1.fffff2p-1, INEXACT) // -2.553192151750610037197475321591e+02
T(RD,    0x1.da908ea4d7a9cp-8,    0x1.0001b7de4ee4cp+0, -0x1.acec28p-21, INEXACT) // 7.241282296347375385670019909412e-03
T(RU,    0x1.da908ea4d7a9cp-8,    0x1.0001b7de4ee4dp+0,   0x1.ffffe6p-1, INEXACT) // 7.241282296347375385670019909412e-03
T(RZ,    0x1.da908ea4d7a9cp-8,    0x1.0001b7de4ee4cp+0, -0x1.acec28p-21, INEXACT) // 7.241282296347375385670019909412e-03
T(RN,    0x1.da71cfc780aecp+5,   0x1.795ffaff15069p+84,  -0x1.ffffc8p-2, INEXACT) // 5.930557208882768804869556333870e+01
T(RD,   -0x1.ef91cc867a443p-1,    0x1.81936af4f3675p+0, -0x1.dbf848p-22, INEXACT) // -9.679092325360517667931503638101e-01
T(RU,   -0x1.ef91cc867a443p-1,    0x1.81936af4f3676p+0,   0x1.fffff2p-1, INEXACT) // -9.679092325360517667931503638101e-01
T(RZ,   -0x1.ef91cc867a443p-1,    0x1.81936af4f3675p+0, -0x1.dbf848p-22, INEXACT) // -9.679092325360517667931503638101e-01
T(RD,     0x1.43b8255c99e3p-1,    0x1.34e58282e1b5ap+0,  -0x1.ffffe6p-1, INEXACT) // 6.322642970598675304927382967435e-01
T(RU,     0x1.43b8255c99e3p-1,    0x1.34e58282e1b5bp+0,  0x1.a93f3cp-21, INEXACT) // 6.322642970598675304927382967435e-01
T(RZ,     0x1.43b8255c99e3p-1,    0x1.34e58282e1b5ap+0,  -0x1.ffffe6p-1, INEXACT) // 6.322642970598675304927382967435e-01
T(RD,   -0x1.9fd2660e7b611p+1,    0x1.9cb15d98bd368p+3, -0x1.7e8dfep-21, INEXACT) // -3.248608357497467569174887103145e+00
T(RU,   -0x1.9fd2660e7b611p+1,    0x1.9cb15d98bd369p+3,   0x1.ffffe8p-1, INEXACT) // -3.248608357497467569174887103145e+00
T(RZ,   -0x1.9fd2660e7b611p+1,    0x1.9cb15d98bd368p+3, -0x1.7e8dfep-21, INEXACT) // -3.248608357497467569174887103145e+00
T(RN,   -0x1.fea6621dc0732p-6,    0x1.001fd583b99fdp+0,   0x1.fffffcp-2, INEXACT) // -3.116759854947943192415849011923e-02
T(RD,   -0x1.d7673d401a97ep-1,    0x1.746432cebc809p+0, -0x1.35745cp-24, INEXACT) // -9.207095280410582116559226051322e-01
T(RU,   -0x1.d7673d401a97ep-1,    0x1.746432cebc80ap+0,   0x1.fffffep-1, INEXACT) // -9.207095280410582116559226051322e-01
T(RZ,   -0x1.d7673d401a97ep-1,    0x1.746432cebc809p+0, -0x1.35745cp-24, INEXACT) // -9.207095280410582116559226051322e-01
T(RD,   -0x1.7cb096dfee8f3p+5,   0x1.92610651413f8p+67,  -0x1.fffffep-1, INEXACT) // -4.758622527071738517179255723022e+01
T(RU,   -0x1.7cb096dfee8f3p+5,   0x1.92610651413f9p+67,  0x1.27ed2cp-24, INEXACT) // -4.758622527071738517179255723022e+01
T(RZ,   -0x1.7cb096dfee8f3p+5,   0x1.92610651413f8p+67,  -0x1.fffffep-1, INEXACT) // -4.758622527071738517179255723022e+01
T(RN,    0x1.ade8ffe9be95p-10,     0x1.0000168fb643p+0,   -0x1.fffffp-2, INEXACT) // 1.639977092450967816050777514647e-03
T(RD,   -0x1.5e47c30a15edfp-8,     0x1.0000efa44c1ap+0, -0x1.d71c48p-22, INEXACT) // -5.344853512802421290073251469721e-03
T(RU,   -0x1.5e47c30a15edfp-8,    0x1.0000efa44c1a1p+0,   0x1.fffff2p-1, INEXACT) // -5.344853512802421290073251469721e-03
T(RZ,   -0x1.5e47c30a15edfp-8,     0x1.0000efa44c1ap+0, -0x1.d71c48p-22, INEXACT) // -5.344853512802421290073251469721e-03
T(RD,    0x1.b29fdb0dde13cp-1,    0x1.61e8b2dcd76edp+0,  -0x1.fffff6p-1, INEXACT) // 8.488758520534598339679632772459e-01
T(RU,    0x1.b29fdb0dde13cp-1,    0x1.61e8b2dcd76eep+0,   0x1.2ade1p-22, INEXACT) // 8.488758520534598339679632772459e-01
T(RZ,    0x1.b29fdb0dde13cp-1,    0x1.61e8b2dcd76edp+0,  -0x1.fffff6p-1, INEXACT) // 8.488758520534598339679632772459e-01
T(RD,    0x1.3afe8a1874f81p+7,  0x1.2a3eae799b15ap+226, -0x1.75bdc6p-21, INEXACT) // 1.574971473353180329013412119821e+02
T(RU,    0x1.3afe8a1874f81p+7,  0x1.2a3eae799b15bp+226,   0x1.ffffe8p-1, INEXACT) // 1.574971473353180329013412119821e+02
T(RZ,    0x1.3afe8a1874f81p+7,  0x1.2a3eae799b15ap+226, -0x1.75bdc6p-21, INEXACT) // 1.574971473353180329013412119821e+02
T(RD,    0x1.9d2211b75da55p+8,  0x1.047bda1eab29cp+595, -0x1.b06c94p-25, INEXACT) // 4.131330828288676570991810876876e+02
T(RU,    0x1.9d2211b75da55p+8,  0x1.047bda1eab29dp+595,   0x1.fffffep-1, INEXACT) // 4.131330828288676570991810876876e+02
T(RZ,    0x1.9d2211b75da55p+8,  0x1.047bda1eab29cp+595, -0x1.b06c94p-25, INEXACT) // 4.131330828288676570991810876876e+02
T(RN,    0x1.475068f9b64fep-7,    0x1.000344fed2f61p+0,  -0x1.ffffc6p-2, INEXACT) // 9.988833673036708743486755679442e-03
T(RN,   -0x1.9fca72c2b99acp+6,  0x1.f3abe96913cdfp+148,   0x1.ffffdcp-2, INEXACT) // -1.039477034021171562017116229981e+02
T(RD,   -0x1.24a9ef40a1439p-6,    0x1.000a74b30d1ecp+0, -0x1.7c2806p-27, INEXACT) // -1.786278118608583889703744773669e-02
T(RU,   -0x1.24a9ef40a1439p-6,    0x1.000a74b30d1edp+0,          0x1p+0, INEXACT) // -1.786278118608583889703744773669e-02
T(RZ,   -0x1.24a9ef40a1439p-6,    0x1.000a74b30d1ecp+0, -0x1.7c2806p-27, INEXACT) // -1.786278118608583889703744773669e-02
T(RD,    -0x1.669b012c0af9p+0,    0x1.1382c048f77dcp+1,  -0x1.ffffe4p-1, INEXACT) // -1.400802682163860168884639278986e+00
T(RU,    -0x1.669b012c0af9p+0,    0x1.1382c048f77ddp+1,  0x1.b0c3a4p-21, INEXACT) // -1.400802682163860168884639278986e+00
T(RZ,    -0x1.669b012c0af9p+0,    0x1.1382c048f77dcp+1,  -0x1.ffffe4p-1, INEXACT) // -1.400802682163860168884639278986e+00
T(RD,   -0x1.76bedbde64e98p-1,    0x1.47b0144b34437p+0,  -0x1.ffffe2p-1, INEXACT) // -7.319248875596313652636126789730e-01
T(RU,   -0x1.76bedbde64e98p-1,    0x1.47b0144b34438p+0,  0x1.e2ebccp-21, INEXACT) // -7.319248875596313652636126789730e-01
T(RZ,   -0x1.76bedbde64e98p-1,    0x1.47b0144b34437p+0,  -0x1.ffffe2p-1, INEXACT) // -7.319248875596313652636126789730e-01
T(RD,    0x1.b291d32b3edb6p+2,    0x1.bc8632e8c2cc2p+8,  -0x1.ffffe8p-1, INEXACT) // 6.790150444251983330445909814443e+00
T(RU,    0x1.b291d32b3edb6p+2,    0x1.bc8632e8c2cc3p+8,  0x1.879126p-21, INEXACT) // 6.790150444251983330445909814443e+00
T(RZ,    0x1.b291d32b3edb6p+2,    0x1.bc8632e8c2cc2p+8,  -0x1.ffffe8p-1, INEXACT) // 6.790150444251983330445909814443e+00
T(RD,    0x1.4ff1ff35b8627p-7,    0x1.000371b877844p+0, -0x1.6acafap-23, INEXACT) // 1.025223695200157096596438321967e-02
T(RU,    0x1.4ff1ff35b8627p-7,    0x1.000371b877845p+0,   0x1.fffffap-1, INEXACT) // 1.025223695200157096596438321967e-02
T(RZ,    0x1.4ff1ff35b8627p-7,    0x1.000371b877844p+0, -0x1.6acafap-23, INEXACT) // 1.025223695200157096596438321967e-02
T(RN,    0x1.7fed3781d4c6ap-2,    0x1.12347392a4fb4p+0,   0x1.ffffdcp-2, INEXACT) // 3.749283478729866780909674162103e-01
T(RN,   -0x1.d59e15303deb6p-3,    0x1.06c2894f733bfp+0,  -0x1.fffff2p-2, INEXACT) // -2.293054252002001969223954347399e-01
T(RD,   -0x1.f491d2641353bp+7,  0x1.0f7873d75976fp+360, -0x1.665ab8p-21, INEXACT) // -2.502848082803337490531703224406e+02
T(RU,   -0x1.f491d2641353bp+7,   0x1.0f7873d75977p+360,   0x1.ffffeap-1, INEXACT) // -2.502848082803337490531703224406e+02
T(RZ,   -0x1.f491d2641353bp+7,  0x1.0f7873d75976fp+360, -0x1.665ab8p-21, INEXACT) // -2.502848082803337490531703224406e+02
T(RD,    0x1.b863023864ac5p+2,    0x1.e6d2395797df6p+8, -0x1.86f07cp-23, INEXACT) // 6.881043009826218970204081415432e+00
T(RU,    0x1.b863023864ac5p+2,    0x1.e6d2395797df7p+8,   0x1.fffffap-1, INEXACT) // 6.881043009826218970204081415432e+00
T(RZ,    0x1.b863023864ac5p+2,    0x1.e6d2395797df6p+8, -0x1.86f07cp-23, INEXACT) // 6.881043009826218970204081415432e+00
T(RD,   -0x1.4a2d6a060c262p-2,    0x1.0d6c6743207cbp+0, -0x1.f3d882p-22, INEXACT) // -3.224388662520479842399367953476e-01
T(RU,   -0x1.4a2d6a060c262p-2,    0x1.0d6c6743207ccp+0,    0x1.fffffp-1, INEXACT) // -3.224388662520479842399367953476e-01
T(RZ,   -0x1.4a2d6a060c262p-2,    0x1.0d6c6743207cbp+0, -0x1.f3d882p-22, INEXACT) // -3.224388662520479842399367953476e-01
T(RN,   -0x1.2630ef59d426cp+1,     0x1.41ddf49b52c8p+2,   0x1.ffffd6p-2, INEXACT) // -2.298368376599958295969372557011e+00
T(RN,    0x1.ef6cab3856151p-5,    0x1.0077e207af6f8p+0,  -0x1.ffffc2p-2, INEXACT) // 6.047662202280668780618455571130e-02
T(RN,   0x1.4c1b1453a302cp-10,    0x1.00000d76b21aep+0,  -0x1.fffff2p-2, INEXACT) // 1.266883006709749841245393753297e-03
T(RN,   -0x1.9ac232321cfbep+3,   0x1.6ec502656887cp+17,  -0x1.fffffep-2, INEXACT) // -1.283620557582605314905777049717e+01
T(RN,    0x1.0a83e33dc56fep+6,   0x1.172d37759aefep+95,   0x1.ffffccp-2, INEXACT) // 6.662879654424247632960032206029e+01
T(RN,   -0x1.67b58588bf64bp-9,    0x1.00003f2dd640bp+0,  -0x1.fffff4p-2, INEXACT) // -2.744362402494348370657339941658e-03
T(RD,    -0x1.30eed433210ap-4,    0x1.00b5b185698b7p+0,  -0x1.ffffe4p-1, INEXACT) // -7.444651499287369134094660694245e-02
T(RU,    -0x1.30eed433210ap-4,    0x1.00b5b185698b8p+0,  0x1.b5e24ep-21, INEXACT) // -7.444651499287369134094660694245e-02
T(RZ,    -0x1.30eed433210ap-4,    0x1.00b5b185698b7p+0,  -0x1.ffffe4p-1, INEXACT) // -7.444651499287369134094660694245e-02
T(RN,    0x1.80b49445cc612p+0,    0x1.2ddc4d8c0f99cp+1,   0x1.fffff8p-2, INEXACT) // 1.502755419769873146407235253719e+00
T(RN,   -0x1.39cd63cb60237p-8,    0x1.0000c054097d2p+0,  -0x1.ffffc8p-2, INEXACT) // -4.788243163944153578392981529532e-03
T(RN,    0x1.0716cfd2c1be1p-2,    0x1.087eebacdeb88p+0,   0x1.ffffdap-2, INEXACT) // 2.569229576478715970644373101095e-01
T(RN,  -0x1.f0da594e5958fp-10,    0x1.00001e227739bp+0,  -0x1.ffffc6p-2, INEXACT) // -1.895343495186583215525444323646e-03
T(RD,   -0x1.9e1f7a7f0fa57p-4,    0x1.014f3dfbbd2bap+0,  -0x1.ffffecp-1, INEXACT) // -1.011042389882076258933452095334e-01
T(RU,   -0x1.9e1f7a7f0fa57p-4,    0x1.014f3dfbbd2bbp+0,  0x1.37701ep-21, INEXACT) // -1.011042389882076258933452095334e-01
T(RZ,   -0x1.9e1f7a7f0fa57p-4,    0x1.014f3dfbbd2bap+0,  -0x1.ffffecp-1, INEXACT) // -1.011042389882076258933452095334e-01
T(RD,    0x1.4c107a1fd4a7ap+7,  0x1.729f43e575b9cp+238,  -0x1.ffffeap-1, INEXACT) // 1.660321817347610817705572117120e+02
T(RU,    0x1.4c107a1fd4a7ap+7,  0x1.729f43e575b9dp+238,   0x1.637afp-21, INEXACT) // 1.660321817347610817705572117120e+02
T(RZ,    0x1.4c107a1fd4a7ap+7,  0x1.729f43e575b9cp+238,  -0x1.ffffeap-1, INEXACT) // 1.660321817347610817705572117120e+02
T(RN,   -0x1.80d2a1345fa24p-7,    0x1.000484f48942dp+0,   0x1.ffffdcp-2, INEXACT) // -1.174385901753988853402077552346e-02
T(RN,   -0x1.30f62ec91a464p-1,    0x1.2ec4fbd0812d8p+0,  -0x1.ffffeep-2, INEXACT) // -5.956282253729452413892886397662e-01
T(RD,   -0x1.ff18c093be283p+8,  0x1.47cbfa4093299p+736,  -0x1.fffff2p-1, INEXACT) // -5.110966884936571545949846040457e+02
T(RU,   -0x1.ff18c093be283p+8,  0x1.47cbfa409329ap+736,  0x1.d9880ap-22, INEXACT) // -5.110966884936571545949846040457e+02
T(RZ,   -0x1.ff18c093be283p+8,  0x1.47cbfa4093299p+736,  -0x1.fffff2p-1, INEXACT) // -5.110966884936571545949846040457e+02
T(RN,   -0x1.f6ff2a43e4e19p-3,    0x1.07c290298d115p+0,   0x1.fffff8p-2, INEXACT) // -2.456038763017296677748646516193e-01
T(RN,   -0x1.ada97db7269b9p-2,    0x1.16de2f7374c94p+0,   0x1.ffffe8p-2, INEXACT) // -4.195918696438201700438241914526e-01
T(RN,    0x1.fa7058786ba5fp-8,    0x1.0001f4f0cae41p+0,    0x1.ffffdp-2, INEXACT) // 7.727643584458292712324745110664e-03
T(RN,    0x1.ea09e4ed7087fp+4,   0x1.233b28f185a69p+43,  -0x1.ffffd2p-2, INEXACT) // 3.062741558790048301830211130437e+01
T(RD,   -0x1.5258d5e23204bp-5,    0x1.0037e7df3df5dp+0, -0x1.b54c1ap-21, INEXACT) // -4.130212568412668788786490381426e-02
T(RU,   -0x1.5258d5e23204bp-5,    0x1.0037e7df3df5ep+0,   0x1.ffffe4p-1, INEXACT) // -4.130212568412668788786490381426e-02
T(RZ,   -0x1.5258d5e23204bp-5,    0x1.0037e7df3df5dp+0, -0x1.b54c1ap-21, INEXACT) // -4.130212568412668788786490381426e-02
T(RD,    0x1.102cd7c018787p-5,    0x1.00242cc45cad3p+0,  -0x1.fffff2p-1, INEXACT) // 3.322450770134737635386201759502e-02
T(RU,    0x1.102cd7c018787p-5,    0x1.00242cc45cad4p+0,   0x1.d046ap-22, INEXACT) // 3.322450770134737635386201759502e-02
T(RZ,    0x1.102cd7c018787p-5,    0x1.00242cc45cad3p+0,  -0x1.fffff2p-1, INEXACT) // 3.322450770134737635386201759502e-02
T(RN,    0x1.7491915c4987cp-3,    0x1.043f6d39d3e16p+0,  -0x1.fffff4p-2, INEXACT) // 1.819182735718561927384939735930e-01
T(RD,   -0x1.c67989494174ep+1,    0x1.16e61e0ef6164p+4, -0x1.d59d9ap-21, INEXACT) // -3.550583992738132188549116108334e+00
T(RU,   -0x1.c67989494174ep+1,    0x1.16e61e0ef6165p+4,   0x1.ffffe2p-1, INEXACT) // -3.550583992738132188549116108334e+00
T(RZ,   -0x1.c67989494174ep+1,    0x1.16e61e0ef6164p+4, -0x1.d59d9ap-21, INEXACT) // -3.550583992738132188549116108334e+00
T(RN,    0x1.3bd6372a5ccafp-9,    0x1.000030b51d6bbp+0,  -0x1.ffffc8p-2, INEXACT) // 2.409643396441639006527735134000e-03
T(RN,    0x1.41ee7ac59e7b8p+7,  0x1.2b1c345bde735p+231,  -0x1.fffffcp-2, INEXACT) // 1.609657804256401050224667415023e+02
T(RD,   -0x1.a4115d7c85767p+8,  0x1.0556ceb077bf5p+605,  -0x1.fffff6p-1, INEXACT) // -4.200678327394329585331433918327e+02
T(RU,   -0x1.a4115d7c85767p+8,  0x1.0556ceb077bf6p+605,  0x1.3d9716p-22, INEXACT) // -4.200678327394329585331433918327e+02
T(RZ,   -0x1.a4115d7c85767p+8,  0x1.0556ceb077bf5p+605,  -0x1.fffff6p-1, INEXACT) // -4.200678327394329585331433918327e+02
T(RN,    0x1.651feca7a5ffcp-2,    0x1.0fba2012e0568p+0,   0x1.ffffeep-2, INEXACT) // 3.487545945476993036749036036781e-01
T(RN,   -0x1.7564458eb7c46p-3,    0x1.04443ff7ea054p+0,  -0x1.fffffcp-2, INEXACT) // -1.823201593569782619219665775745e-01
T(RD,    0x1.57b7f1d35616cp+3,   0x1.691b5aedd723dp+14,   -0x1.fffffp-1, INEXACT) // 1.074120417858713238956624991260e+01
T(RU,    0x1.57b7f1d35616cp+3,   0x1.691b5aedd723ep+14,  0x1.eea1cap-22, INEXACT) // 1.074120417858713238956624991260e+01
T(RZ,    0x1.57b7f1d35616cp+3,   0x1.691b5aedd723dp+14,   -0x1.fffffp-1, INEXACT) // 1.074120417858713238956624991260e+01
T(RN,    0x1.917fa55d31469p+3,   0x1.129cba220027dp+17,   0x1.ffffdap-2, INEXACT) // 1.254683178140312982407067465829e+01
T(RN,   -0x1.298b52e0f5f37p-4,    0x1.00acfdc137b9ep+0,  -0x1.ffffd8p-2, INEXACT) // -7.264263510239464538553733063964e-02
T(RD,   -0x1.a9cd81e1209d5p-2,    0x1.1673fc9abc40cp+0, -0x1.4cd5e8p-21, INEXACT) // -4.158230107933865160596553778305e-01
T(RU,   -0x1.a9cd81e1209d5p-2,    0x1.1673fc9abc40dp+0,   0x1.ffffecp-1, INEXACT) // -4.158230107933865160596553778305e-01
T(RZ,   -0x1.a9cd81e1209d5p-2,    0x1.1673fc9abc40cp+0, -0x1.4cd5e8p-21, INEXACT) // -4.158230107933865160596553778305e-01
T(RN,    0x1.b2076b74cd6afp-9,     0x1.00005bfbaa94p+0,   -0x1.fffffp-2, INEXACT) // 3.311378352374237232086384707941e-03
T(RN,    0x1.f0b8fa6663d1fp+7,  0x1.3d46aafbda77ap+357,  -0x1.ffffd4p-2, INEXACT) // 2.483612854000902814277651486918e+02
T(RN,    -0x1.aef67dcaa5c3p+0,    0x1.647800116c65bp+1,  -0x1.fffffap-2, INEXACT) // -1.683448659872521346869689296000e+00
T(RD,    0x1.0d9034c78e09ap-2,    0x1.08ebe7c5f5e4dp+0, -0x1.c36bd2p-22, INEXACT) // 2.632454153822522124883676042373e-01
T(RU,    0x1.0d9034c78e09ap-2,    0x1.08ebe7c5f5e4ep+0,   0x1.fffff2p-1, INEXACT) // 2.632454153822522124883676042373e-01
T(RZ,    0x1.0d9034c78e09ap-2,    0x1.08ebe7c5f5e4dp+0, -0x1.c36bd2p-22, INEXACT) // 2.632454153822522124883676042373e-01
T(RN,    0x1.3b0d4d38be423p+8,  0x1.70160e4ab4f72p+453,  -0x1.ffffe4p-2, INEXACT) // 3.150519595589159393966838251799e+02
T(RD,   0x1.4875291c41bd8p-10,    0x1.00000d2b6394ap+0, -0x1.e7fec2p-21, INEXACT) // 1.252966531923629597833347304459e-03
T(RU,   0x1.4875291c41bd8p-10,    0x1.00000d2b6394bp+0,   0x1.ffffe2p-1, INEXACT) // 1.252966531923629597833347304459e-03
T(RZ,   0x1.4875291c41bd8p-10,    0x1.00000d2b6394ap+0, -0x1.e7fec2p-21, INEXACT) // 1.252966531923629597833347304459e-03
T(RD,   -0x1.de693267555c5p-3,    0x1.07043f65bd821p+0, -0x1.b182b2p-22, INEXACT) // -2.335990846428740719264993686011e-01
T(RU,   -0x1.de693267555c5p-3,    0x1.07043f65bd822p+0,   0x1.fffff2p-1, INEXACT) // -2.335990846428740719264993686011e-01
T(RZ,   -0x1.de693267555c5p-3,    0x1.07043f65bd821p+0, -0x1.b182b2p-22, INEXACT) // -2.335990846428740719264993686011e-01
T(RD,   -0x1.d5d5aa6403f5dp-8,    0x1.0001af24c3584p+0,  -0x1.ffffe6p-1, INEXACT) // -7.169107531822619013006647747943e-03
T(RU,   -0x1.d5d5aa6403f5dp-8,    0x1.0001af24c3585p+0,  0x1.994b68p-21, INEXACT) // -7.169107531822619013006647747943e-03
T(RZ,   -0x1.d5d5aa6403f5dp-8,    0x1.0001af24c3584p+0,  -0x1.ffffe6p-1, INEXACT) // -7.169107531822619013006647747943e-03
T(RN,   -0x1.7a5ea95a3f457p-7,     0x1.00045e7a8caep+0,  -0x1.ffffd4p-2, INEXACT) // -1.154692906538394396587232648699e-02
T(RD,    -0x1.f3cdc33d095bp+1,    0x1.8d3fd6da37bb5p+4,  -0x1.ffffe2p-1, INEXACT) // -3.904716877749443426637299126014e+00
T(RU,    -0x1.f3cdc33d095bp+1,    0x1.8d3fd6da37bb6p+4,  0x1.d8408ap-21, INEXACT) // -3.904716877749443426637299126014e+00
T(RZ,    -0x1.f3cdc33d095bp+1,    0x1.8d3fd6da37bb5p+4,  -0x1.ffffe2p-1, INEXACT) // -3.904716877749443426637299126014e+00
T(RD,    0x1.58b11fbbe3b4cp-3,    0x1.03a26a76e132fp+0,  -0x1.fffff4p-1, INEXACT) // 1.683065871443097938353616882523e-01
T(RU,    0x1.58b11fbbe3b4cp-3,     0x1.03a26a76e133p+0,  0x1.97f3fcp-22, INEXACT) // 1.683065871443097938353616882523e-01
T(RZ,    0x1.58b11fbbe3b4cp-3,    0x1.03a26a76e132fp+0,  -0x1.fffff4p-1, INEXACT) // 1.683065871443097938353616882523e-01
T(RN,    0x1.4ee8732e12bc3p-1,    0x1.38bf83ea883eap+0,  -0x1.ffffe8p-2, INEXACT) // 6.541172021619491294686099536193e-01
T(RN,   -0x1.80741e589066fp+7,  0x1.409a461bf2fd1p+276,  -0x1.fffff4p-2, INEXACT) // -1.922267940212509245156979886815e+02
T(RN,   -0x1.91bfec39f242fp-3,    0x1.04f10223301a5p+0,   0x1.fffffcp-2, INEXACT) // -1.961668448623483385073740237203e-01
T(RN,    0x1.3bcd633bb1dd8p+5,   0x1.eed57e117dd87p+55,  -0x1.ffffe8p-2, INEXACT) // 3.947528692852546328140306286514e+01
T(RN,   -0x1.aab09768c4137p+7,  0x1.bb253feb69db8p+306,  -0x1.fffffep-2, INEXACT) // -2.133449051608419893000245792791e+02
T(RD,   -0x1.dc92866b282f4p-2,    0x1.1c3a93b3dad94p+0,  -0x1.fffffcp-1, INEXACT) // -4.654026987937378567750101865386e-01
T(RU,   -0x1.dc92866b282f4p-2,    0x1.1c3a93b3dad95p+0,  0x1.9c00d6p-24, INEXACT) // -4.654026987937378567750101865386e-01
T(RZ,   -0x1.dc92866b282f4p-2,    0x1.1c3a93b3dad94p+0,  -0x1.fffffcp-1, INEXACT) // -4.654026987937378567750101865386e-01
T(RN,   -0x1.17e6d7188b6e3p+1,    0x1.209648b2a7935p+2,  -0x1.fffffcp-2, INEXACT) // -2.186732184395496769724331898033e+00
T(RD,    0x1.8c4312d4d404dp-1,    0x1.50937a4a8447bp+0,  -0x1.ffffecp-1, INEXACT) // 7.739492306518599429310256709869e-01
T(RU,    0x1.8c4312d4d404dp-1,    0x1.50937a4a8447cp+0,   0x1.40afbp-21, INEXACT) // 7.739492306518599429310256709869e-01
T(RZ,    0x1.8c4312d4d404dp-1,    0x1.50937a4a8447bp+0,  -0x1.ffffecp-1, INEXACT) // 7.739492306518599429310256709869e-01
T(RN,    0x1.14268b054dcabp+9,  0x1.be5db3abbebe1p+795,   0x1.fffff8p-2, INEXACT) // 5.523011175756304282913333736360e+02
T(RN,   -0x1.6cd77f495ecbep+3,   0x1.5d5e6fdc122bcp+15,  -0x1.ffffd6p-2, INEXACT) // -1.140130581216942218247822893318e+01
T(RN,   -0x1.2fbd1a42544cbp-4,    0x1.00b445bc4f7eap+0,  -0x1.ffffe6p-2, INEXACT) // -7.415495164356682156192590582577e-02
T(RD,   -0x1.e8f9386ebdcfdp-3,    0x1.0754d21d08bc4p+0, -0x1.b7bfb2p-21, INEXACT) // -2.387566002650841900933897932191e-01
T(RU,   -0x1.e8f9386ebdcfdp-3,    0x1.0754d21d08bc5p+0,   0x1.ffffe4p-1, INEXACT) // -2.387566002650841900933897932191e-01
T(RZ,   -0x1.e8f9386ebdcfdp-3,    0x1.0754d21d08bc4p+0, -0x1.b7bfb2p-21, INEXACT) // -2.387566002650841900933897932191e-01
T(RN,   -0x1.05ca442b14eebp-8,    0x1.000085db1311fp+0,  -0x1.ffffcep-2, INEXACT) // -3.994599955223536273674067587081e-03
T(RN,    0x1.c81f970d0c93ep-7,    0x1.00065967d4016p+0,   0x1.ffffeap-2, INEXACT) // 1.391978145156668941750943702118e-02
T(RD,   -0x1.83101f2d1f70cp+8,  0x1.550c90ac881afp+557, -0x1.2f310cp-23, INEXACT) // -3.870629757119902478734729811549e+02
T(RU,   -0x1.83101f2d1f70cp+8,   0x1.550c90ac881bp+557,   0x1.fffffcp-1, INEXACT) // -3.870629757119902478734729811549e+02
T(RZ,   -0x1.83101f2d1f70cp+8,  0x1.550c90ac881afp+557, -0x1.2f310cp-23, INEXACT) // -3.870629757119902478734729811549e+02
T(RD,  -0x1.e36b145655b33p-10,    0x1.00001c86ea63ep+0, -0x1.80e734p-21, INEXACT) // -1.844094387328087903885065479415e-03
T(RU,  -0x1.e36b145655b33p-10,    0x1.00001c86ea63fp+0,   0x1.ffffe8p-1, INEXACT) // -1.844094387328087903885065479415e-03
T(RZ,  -0x1.e36b145655b33p-10,    0x1.00001c86ea63ep+0, -0x1.80e734p-21, INEXACT) // -1.844094387328087903885065479415e-03
T(RD,    0x1.6129508a76f0ep+2,    0x1.f25a87aae57fdp+6, -0x1.7aac48p-22, INEXACT) // 5.518146643847797960802381567191e+00
T(RU,    0x1.6129508a76f0ep+2,    0x1.f25a87aae57fep+6,   0x1.fffff4p-1, INEXACT) // 5.518146643847797960802381567191e+00
T(RZ,    0x1.6129508a76f0ep+2,    0x1.f25a87aae57fdp+6, -0x1.7aac48p-22, INEXACT) // 5.518146643847797960802381567191e+00
T(RN,    0x1.40d9c9a15dd66p-8,    0x1.0000c910b2ff5p+0,   0x1.ffffdcp-2, INEXACT) // 4.895793653637658601751603271168e-03
T(RN,    0x1.6298dfd285b1bp-9,    0x1.00003d65673ddp+0,  -0x1.ffffeep-2, INEXACT) // 2.705361673416629194471871855399e-03
T(RD,    0x1.bee5fc087f6e3p-2,    0x1.18c4e284c712ep+0,   -0x1.ffffep-1, INEXACT) // 4.364241962610845848580254369153e-01
T(RU,    0x1.bee5fc087f6e3p-2,    0x1.18c4e284c712fp+0,  0x1.fef5f6p-21, INEXACT) // 4.364241962610845848580254369153e-01
T(RZ,    0x1.bee5fc087f6e3p-2,    0x1.18c4e284c712ep+0,   -0x1.ffffep-1, INEXACT) // 4.364241962610845848580254369153e-01
T(RD,    0x1.b66ca2a54123ep+2,    0x1.d81ee1518c44fp+8, -0x1.9f5caap-23, INEXACT) // 6.850380574590017701552824291866e+00
T(RU,    0x1.b66ca2a54123ep+2,     0x1.d81ee1518c45p+8,   0x1.fffffap-1, INEXACT) // 6.850380574590017701552824291866e+00
T(RZ,    0x1.b66ca2a54123ep+2,    0x1.d81ee1518c44fp+8, -0x1.9f5caap-23, INEXACT) // 6.850380574590017701552824291866e+00
T(RD,    0x1.2f91a2bcfdb8ep+4,   0x1.4b60b87ab3f12p+26,  -0x1.ffffeep-1, INEXACT) // 1.897305558991097740317854913883e+01
T(RU,    0x1.2f91a2bcfdb8ep+4,   0x1.4b60b87ab3f13p+26,  0x1.2d48bep-21, INEXACT) // 1.897305558991097740317854913883e+01
T(RZ,    0x1.2f91a2bcfdb8ep+4,   0x1.4b60b87ab3f12p+26,  -0x1.ffffeep-1, INEXACT) // 1.897305558991097740317854913883e+01
T(RD,   -0x1.f9f9d46e4a489p+3,   0x1.c14c47155820bp+21,  -0x1.ffffeep-1, INEXACT) // -1.581174680272148869164539064514e+01
T(RU,   -0x1.f9f9d46e4a489p+3,   0x1.c14c47155820cp+21,  0x1.28e026p-21, INEXACT) // -1.581174680272148869164539064514e+01
T(RZ,   -0x1.f9f9d46e4a489p+3,   0x1.c14c47155820bp+21,  -0x1.ffffeep-1, INEXACT) // -1.581174680272148869164539064514e+01
T(RN,    0x1.b088f49dc92d5p-7,     0x1.0005b5a27489p+0,  -0x1.ffffe6p-2, INEXACT) // 1.319992012174379426847625751407e-02
T(RD,    0x1.5617f923d484bp-3,    0x1.039468d7fc4bbp+0,  -0x1.4381dp-21, INEXACT) // 1.670379127559179222028973299530e-01
T(RU,    0x1.5617f923d484bp-3,    0x1.039468d7fc4bcp+0,   0x1.ffffecp-1, INEXACT) // 1.670379127559179222028973299530e-01
T(RZ,    0x1.5617f923d484bp-3,    0x1.039468d7fc4bbp+0,  -0x1.4381dp-21, INEXACT) // 1.670379127559179222028973299530e-01
T(RN,  -0x1.648665147d389p-10,    0x1.00000f8430a5ap+0,   0x1.ffffdcp-2, INEXACT) // -1.360034865794919898066006602733e-03
T(RN,    0x1.bf1aa49e8cddap-9,    0x1.0000619bc7e8ep+0,   0x1.ffffecp-2, INEXACT) // 3.411133380063918925373389612332e-03
T(RN,    0x1.1eb56dd122a43p-5,    0x1.00282448c28e4p+0,   -0x1.ffffep-2, INEXACT) // 3.499862145061573975857172058568e-02
T(RN,   -0x1.5c5a99e25ddd6p+8,  0x1.7ba1e4551ec57p+501,   -0x1.ffffep-2, INEXACT) // -3.483539105872308709876961074769e+02
T(RD,    0x1.7d20cbaa22887p-9,    0x1.000046ed5793fp+0, -0x1.9efde4p-22, INEXACT) // 2.907776700401379626342857065424e-03
T(RU,    0x1.7d20cbaa22887p-9,     0x1.000046ed5794p+0,   0x1.fffff4p-1, INEXACT) // 2.907776700401379626342857065424e-03
T(RZ,    0x1.7d20cbaa22887p-9,    0x1.000046ed5793fp+0, -0x1.9efde4p-22, INEXACT) // 2.907776700401379626342857065424e-03
T(RN,    0x1.fde7d79d1c6a6p+3,    0x1.fc012e4680a1p+21,   0x1.ffffcep-2, INEXACT) // 1.593455105481855227367304905783e+01
T(RD,   -0x1.8deffdab4ebcap-3,    0x1.04d90a23a0e2ap+0,  -0x1.fffff8p-1, INEXACT) // -1.943054025558395569994729612517e-01
T(RU,   -0x1.8deffdab4ebcap-3,    0x1.04d90a23a0e2bp+0,  0x1.fd0ceap-23, INEXACT) // -1.943054025558395569994729612517e-01
T(RZ,   -0x1.8deffdab4ebcap-3,    0x1.04d90a23a0e2ap+0,  -0x1.fffff8p-1, INEXACT) // -1.943054025558395569994729612517e-01
T(RN,    0x1.0efcb1d03417fp+4,   0x1.59f715d15f6e8p+23,   -0x1.ffffdp-2, INEXACT) // 1.693669301347244626754218188580e+01
T(RN,   -0x1.57448a4ea136bp-6,    0x1.000e62686374ap+0,  -0x1.ffffd4p-2, INEXACT) // -2.095139986569753351441924849041e-02
T(RN,    -0x1.374228a0444dp+5,   0x1.1867fee1bc8ebp+55,  -0x1.ffffe4p-2, INEXACT) // -3.890730405052602236537495627999e+01
T(RN,    0x1.05e6eb7170afbp-5,    0x1.00217ed0830f1p+0,   0x1.ffffecp-2, INEXACT) // 3.197046265588273511459860287687e-02
T(RN,    0x1.6011eef47a7a9p+3,   0x1.d4cab7539671ep+14,   0x1.fffff6p-2, INEXACT) // 1.100218913793271902079595747637e+01
T(RD,    0x1.2bd9ad110db89p-2,    0x1.0b0dd3e31592ep+0, -0x1.524b12p-21, INEXACT) // 2.928225557001771783838250939880e-01
T(RU,    0x1.2bd9ad110db89p-2,    0x1.0b0dd3e31592fp+0,   0x1.ffffeap-1, INEXACT) // 2.928225557001771783838250939880e-01
T(RZ,    0x1.2bd9ad110db89p-2,    0x1.0b0dd3e31592ep+0, -0x1.524b12p-21, INEXACT) // 2.928225557001771783838250939880e-01
T(RD,   -0x1.c364cdf3af275p+4,   0x1.a04c37e02c84dp+39, -0x1.035556p-21, INEXACT) // -2.821211047352922562936328176875e+01
T(RU,   -0x1.c364cdf3af275p+4,   0x1.a04c37e02c84ep+39,    0x1.fffffp-1, INEXACT) // -2.821211047352922562936328176875e+01
T(RZ,   -0x1.c364cdf3af275p+4,   0x1.a04c37e02c84dp+39, -0x1.035556p-21, INEXACT) // -2.821211047352922562936328176875e+01
T(RN,   -0x1.b551f425982c6p+7,    0x1.60168cbd086p+314,  -0x1.ffffd6p-2, INEXACT) // -2.186600658176668616761162411422e+02
T(RD,     0x1.bf0b844e06cdp+8,  0x1.ee6aeefaf29d5p+643,   -0x1.fffffp-1, INEXACT) // 4.470449875609019727562554180622e+02
T(RU,     0x1.bf0b844e06cdp+8,  0x1.ee6aeefaf29d6p+643,  0x1.ebe1c6p-22, INEXACT) // 4.470449875609019727562554180622e+02
T(RZ,     0x1.bf0b844e06cdp+8,  0x1.ee6aeefaf29d5p+643,   -0x1.fffffp-1, INEXACT) // 4.470449875609019727562554180622e+02
T(RN,   -0x1.14a8b1682f1a6p+7,  0x1.7b50a47eccff4p+198,   0x1.ffffdap-2, INEXACT) // -1.383294785077570736575580667704e+02
T(RN,   -0x1.bf0d0f85082c1p+3,   0x1.1d067dc93ea83p+19,   0x1.fffff8p-2, INEXACT) // -1.397034431441113788707752974005e+01
T(RD,     0x1.3d82e1c63f24p+1,    0x1.8102f4330f9f9p+2, -0x1.8ae506p-21, INEXACT) // 2.480556699562185940521885640919e+00
T(RU,     0x1.3d82e1c63f24p+1,    0x1.8102f4330f9fap+2,   0x1.ffffe8p-1, INEXACT) // 2.480556699562185940521885640919e+00
T(RZ,     0x1.3d82e1c63f24p+1,    0x1.8102f4330f9f9p+2, -0x1.8ae506p-21, INEXACT) // 2.480556699562185940521885640919e+00
T(RN,    0x1.c4ea3219df055p-5,    0x1.0064300323721p+0,   0x1.fffff6p-2, INEXACT) // 5.528745446551456416139913585539e-02
T(RD,  -0x1.d9e23d0f3ea5dp-10,    0x1.00001b69aee9cp+0,  -0x1.fffff2p-1, INEXACT) // -1.807723023203997763166950285552e-03
T(RU,  -0x1.d9e23d0f3ea5dp-10,    0x1.00001b69aee9dp+0,  0x1.dcc7c2p-22, INEXACT) // -1.807723023203997763166950285552e-03
T(RZ,  -0x1.d9e23d0f3ea5dp-10,    0x1.00001b69aee9cp+0,  -0x1.fffff2p-1, INEXACT) // -1.807723023203997763166950285552e-03
T(RD,   -0x1.fa9ced2599058p-6,    0x1.001f55296761cp+0,  -0x1.53e83p-22, INEXACT) // -3.092120322106980956355926082324e-02
T(RU,   -0x1.fa9ced2599058p-6,    0x1.001f55296761dp+0,   0x1.fffff6p-1, INEXACT) // -3.092120322106980956355926082324e-02
T(RZ,   -0x1.fa9ced2599058p-6,    0x1.001f55296761cp+0,  -0x1.53e83p-22, INEXACT) // -3.092120322106980956355926082324e-02
T(RD,    0x1.4206b74d12d71p+2,    0x1.326320754de75p+6, -0x1.c68f08p-24, INEXACT) // 5.031659913317853671799184667179e+00
T(RU,    0x1.4206b74d12d71p+2,    0x1.326320754de76p+6,   0x1.fffffcp-1, INEXACT) // 5.031659913317853671799184667179e+00
T(RZ,    0x1.4206b74d12d71p+2,    0x1.326320754de75p+6, -0x1.c68f08p-24, INEXACT) // 5.031659913317853671799184667179e+00
T(RD,   -0x1.c8cae0fb14655p-8,    0x1.0001978a1d445p+0,  -0x1.fffffep-1, INEXACT) // -6.970100333164437785005151937412e-03
T(RU,   -0x1.c8cae0fb14655p-8,    0x1.0001978a1d446p+0,  0x1.65d7aep-24, INEXACT) // -6.970100333164437785005151937412e-03
T(RZ,   -0x1.c8cae0fb14655p-8,    0x1.0001978a1d445p+0,  -0x1.fffffep-1, INEXACT) // -6.970100333164437785005151937412e-03
T(RD,    0x1.e609cf281ee9dp+5,   0x1.91e230c844794p+86,  -0x1.ffffe6p-1, INEXACT) // 6.075478965133991238189992145635e+01
T(RU,    0x1.e609cf281ee9dp+5,   0x1.91e230c844795p+86,  0x1.a21ea4p-21, INEXACT) // 6.075478965133991238189992145635e+01
T(RZ,    0x1.e609cf281ee9dp+5,   0x1.91e230c844794p+86,  -0x1.ffffe6p-1, INEXACT) // 6.075478965133991238189992145635e+01
T(RD,    0x1.2eb519eed5b76p+1,    0x1.57951c14ec5e3p+2, -0x1.ae5bb4p-24, INEXACT) // 2.364901773088997849470160872443e+00
T(RU,    0x1.2eb519eed5b76p+1,    0x1.57951c14ec5e4p+2,   0x1.fffffcp-1, INEXACT) // 2.364901773088997849470160872443e+00
T(RZ,    0x1.2eb519eed5b76p+1,    0x1.57951c14ec5e3p+2, -0x1.ae5bb4p-24, INEXACT) // 2.364901773088997849470160872443e+00
T(RN,     -0x1.6dc7cf9ac64p-6,    0x1.0010554785161p+0,   0x1.fffff4p-2, INEXACT) // -2.232547067533019458096532616764e-02
T(RD,    0x1.958fa6e03fcadp+2,    0x1.1a8513feac571p+8,  -0x1.fffffap-1, INEXACT) // 6.336892813676212377060892322334e+00
T(RU,    0x1.958fa6e03fcadp+2,    0x1.1a8513feac572p+8,  0x1.4db6fep-23, INEXACT) // 6.336892813676212377060892322334e+00
T(RZ,    0x1.958fa6e03fcadp+2,    0x1.1a8513feac571p+8,  -0x1.fffffap-1, INEXACT) // 6.336892813676212377060892322334e+00
T(RD,    0x1.bf074189bccadp-4,    0x1.0186b062d2f26p+0, -0x1.f6763ap-21, INEXACT) // 1.091377792434282262279410247174e-01
T(RU,    0x1.bf074189bccadp-4,    0x1.0186b062d2f27p+0,    0x1.ffffep-1, INEXACT) // 1.091377792434282262279410247174e-01
T(RZ,    0x1.bf074189bccadp-4,    0x1.0186b062d2f26p+0, -0x1.f6763ap-21, INEXACT) // 1.091377792434282262279410247174e-01
T(RD,   -0x1.55d8d8b93ac66p+1,    0x1.d09ba34bc1aabp+2,  -0x1.fffffep-1, INEXACT) // -2.670680132335792045239486469654e+00
T(RU,   -0x1.55d8d8b93ac66p+1,    0x1.d09ba34bc1aacp+2,   0x1.f2a5fp-25, INEXACT) // -2.670680132335792045239486469654e+00
T(RZ,   -0x1.55d8d8b93ac66p+1,    0x1.d09ba34bc1aabp+2,  -0x1.fffffep-1, INEXACT) // -2.670680132335792045239486469654e+00
T(RN,   0x1.d6ed17df9ef62p-10,    0x1.00001b125bf42p+0,   0x1.ffffe8p-2, INEXACT) // 1.796440679668408636066034844703e-03
T(RD,    0x1.5b35fc8401927p-9,    0x1.00003add6eff9p+0, -0x1.912396p-23, INEXACT) // 2.649008822120841027264459555113e-03
T(RU,    0x1.5b35fc8401927p-9,    0x1.00003add6effap+0,   0x1.fffffap-1, INEXACT) // 2.649008822120841027264459555113e-03
T(RZ,    0x1.5b35fc8401927p-9,    0x1.00003add6eff9p+0, -0x1.912396p-23, INEXACT) // 2.649008822120841027264459555113e-03
T(RD,    0x1.8c47b6f1ee1f6p+3,   0x1.d2947e24f4aa5p+16, -0x1.df8ee2p-21, INEXACT) // 1.238375422718034357671967882197e+01
T(RU,    0x1.8c47b6f1ee1f6p+3,   0x1.d2947e24f4aa6p+16,   0x1.ffffe2p-1, INEXACT) // 1.238375422718034357671967882197e+01
T(RZ,    0x1.8c47b6f1ee1f6p+3,   0x1.d2947e24f4aa5p+16, -0x1.df8ee2p-21, INEXACT) // 1.238375422718034357671967882197e+01
T(RN,    0x1.091a3adbf5ebfp-2,    0x1.08a085c9da9eep+0,  -0x1.ffffd2p-2, INEXACT) // 2.588891216996493382929145354865e-01
T(RD,    0x1.cccc677fd1c9bp+5,   0x1.122cea832c49dp+82,   -0x1.fffffp-1, INEXACT) // 5.759980678423854527636649436317e+01
T(RU,    0x1.cccc677fd1c9bp+5,   0x1.122cea832c49ep+82,  0x1.fef5ecp-22, INEXACT) // 5.759980678423854527636649436317e+01
T(RZ,    0x1.cccc677fd1c9bp+5,   0x1.122cea832c49dp+82,   -0x1.fffffp-1, INEXACT) // 5.759980678423854527636649436317e+01
T(RD,   -0x1.6891d91fcbd54p+4,   0x1.6d109cbc3fd86p+31,  -0x1.ffffeep-1, INEXACT) // -2.253560745640182005899987416342e+01
T(RU,   -0x1.6891d91fcbd54p+4,   0x1.6d109cbc3fd87p+31,  0x1.2680bap-21, INEXACT) // -2.253560745640182005899987416342e+01
T(RZ,   -0x1.6891d91fcbd54p+4,   0x1.6d109cbc3fd86p+31,  -0x1.ffffeep-1, INEXACT) // -2.253560745640182005899987416342e+01
T(RN,    0x1.455c26bf1a156p+0,    0x1.ec211c58ac883p+0,    0x1.fffffp-2, INEXACT) // 1.270937368064627204233829615987e+00
T(RD,    0x1.2528674f20097p+5,   0x1.d2f6ce5cc57f4p+51,  -0x1.fffff4p-1, INEXACT) // 3.664472829643744233862889814191e+01
T(RU,    0x1.2528674f20097p+5,   0x1.d2f6ce5cc57f5p+51,  0x1.7ee5fep-22, INEXACT) // 3.664472829643744233862889814191e+01
T(RZ,    0x1.2528674f20097p+5,   0x1.d2f6ce5cc57f4p+51,  -0x1.fffff4p-1, INEXACT) // 3.664472829643744233862889814191e+01
T(RN,   -0x1.ee8f5a7e1afabp-7,    0x1.000776e46c403p+0,  -0x1.ffffdap-2, INEXACT) // -1.509277266105598334922088810117e-02
T(RD,    0x1.46d4b6ee67387p+1,    0x1.9db31651c1d0ep+2,  -0x1.ffffecp-1, INEXACT) // 2.553366533668341542551161182928e+00
T(RU,    0x1.46d4b6ee67387p+1,    0x1.9db31651c1d0fp+2,  0x1.3e0f98p-21, INEXACT) // 2.553366533668341542551161182928e+00
T(RZ,    0x1.46d4b6ee67387p+1,    0x1.9db31651c1d0ep+2,  -0x1.ffffecp-1, INEXACT) // 2.553366533668341542551161182928e+00
T(RD,   -0x1.152964dfb0fe8p+9,  0x1.a59054640692fp+798, -0x1.56c882p-25, INEXACT) // -5.543233909239033891935832798481e+02
T(RU,   -0x1.152964dfb0fe8p+9,   0x1.a59054640693p+798,   0x1.fffffep-1, INEXACT) // -5.543233909239033891935832798481e+02
T(RZ,   -0x1.152964dfb0fe8p+9,  0x1.a59054640692fp+798, -0x1.56c882p-25, INEXACT) // -5.543233909239033891935832798481e+02
T(RN,   -0x1.4c7d1998eb02fp+7,  0x1.ca36e33f81172p+238,  -0x1.ffffeap-2, INEXACT) // -1.662443359171752206293604103848e+02
T(RD,   -0x1.5dd7d71766d93p+1,    0x1.ee47d1d94a5aep+2, -0x1.49f1d8p-23, INEXACT) // -2.733149420191418155212659257813e+00
T(RU,   -0x1.5dd7d71766d93p+1,    0x1.ee47d1d94a5afp+2,   0x1.fffffap-1, INEXACT) // -2.733149420191418155212659257813e+00
T(RZ,   -0x1.5dd7d71766d93p+1,    0x1.ee47d1d94a5aep+2, -0x1.49f1d8p-23, INEXACT) // -2.733149420191418155212659257813e+00
T(RD,    0x1.a7adb664b2b69p+6,  0x1.c0bdd590fdcf6p+151, -0x1.ea898ep-25, INEXACT) // 1.059196410879209366839859285392e+02
T(RU,    0x1.a7adb664b2b69p+6,  0x1.c0bdd590fdcf7p+151,   0x1.fffffep-1, INEXACT) // 1.059196410879209366839859285392e+02
T(RZ,    0x1.a7adb664b2b69p+6,  0x1.c0bdd590fdcf6p+151, -0x1.ea898ep-25, INEXACT) // 1.059196410879209366839859285392e+02
T(RD,    0x1.185f5918f777cp-1,    0x1.275a19e34caecp+0, -0x1.46bb84p-25, INEXACT) // 5.476024477936642931297228642507e-01
T(RU,    0x1.185f5918f777cp-1,    0x1.275a19e34caedp+0,   0x1.fffffep-1, INEXACT) // 5.476024477936642931297228642507e-01
T(RZ,    0x1.185f5918f777cp-1,    0x1.275a19e34caecp+0, -0x1.46bb84p-25, INEXACT) // 5.476024477936642931297228642507e-01
T(RN,    -0x1.29fdbdc1b1c7p+5,   0x1.ab35920da226ep+52,  -0x1.ffffd4p-2, INEXACT) // -3.724889708827765844034729525447e+01
T(RN,   -0x1.1e303e05a6e37p+3,   0x1.de91a51054f07p+11,  -0x1.ffffd6p-2, INEXACT) // -8.943388949431307466397811367642e+00
T(RD,   -0x1.ab2c9461902c1p-9,    0x1.00005919bd034p+0, -0x1.406e4ap-21, INEXACT) // -3.259080040863033145975835580543e-03
T(RU,   -0x1.ab2c9461902c1p-9,    0x1.00005919bd035p+0,   0x1.ffffecp-1, INEXACT) // -3.259080040863033145975835580543e-03
T(RZ,   -0x1.ab2c9461902c1p-9,    0x1.00005919bd034p+0, -0x1.406e4ap-21, INEXACT) // -3.259080040863033145975835580543e-03
T(RD,    -0x1.5fd2e254f743p-5,    0x1.003c72dfa75d7p+0,  -0x1.ffffe6p-1, INEXACT) // -4.294723706673442276127161676413e-02
T(RU,    -0x1.5fd2e254f743p-5,    0x1.003c72dfa75d8p+0,  0x1.9619aap-21, INEXACT) // -4.294723706673442276127161676413e-02
T(RZ,    -0x1.5fd2e254f743p-5,    0x1.003c72dfa75d7p+0,  -0x1.ffffe6p-1, INEXACT) // -4.294723706673442276127161676413e-02
T(RN,    0x1.f119107973ee2p-9,    0x1.000078a85407dp+0,  -0x1.ffffdep-2, INEXACT) // 3.792556057966454431673586356055e-03
T(RN,   -0x1.648aec624ee56p+1,    0x1.044fab04345c1p+3,   0x1.fffff2p-2, INEXACT) // -2.785489604951901121410173800541e+00
T(RD,   -0x1.5b43ed59779cep+0,    0x1.08f86217ac199p+1,  -0x1.994e7p-23, INEXACT) // -1.356505235998713754241862261551e+00
T(RU,   -0x1.5b43ed59779cep+0,    0x1.08f86217ac19ap+1,   0x1.fffffap-1, INEXACT) // -1.356505235998713754241862261551e+00
T(RZ,   -0x1.5b43ed59779cep+0,    0x1.08f86217ac199p+1,  -0x1.994e7p-23, INEXACT) // -1.356505235998713754241862261551e+00
T(RN,    0x1.26d4d41ed07d2p+6,  0x1.43920628f1b1cp+105,  -0x1.ffffe6p-2, INEXACT) // 7.370784042499079191657074261457e+01
T(RD,   -0x1.76239ac9c9f07p+5,   0x1.62da2b332ec81p+66,  -0x1.fffffap-1, INEXACT) // -4.676738507888335760753761860542e+01
T(RU,   -0x1.76239ac9c9f07p+5,   0x1.62da2b332ec82p+66,   0x1.623c6p-23, INEXACT) // -4.676738507888335760753761860542e+01
T(RZ,   -0x1.76239ac9c9f07p+5,   0x1.62da2b332ec81p+66,  -0x1.fffffap-1, INEXACT) // -4.676738507888335760753761860542e+01
T(RN,    0x1.cc82289bf1d65p-2,    0x1.1a53928c6a52bp+0,   -0x1.ffffcp-2, INEXACT) // 4.497152657681538490130890295404e-01
T(RD,    -0x1.f3f357adcb27p+7,  0x1.8e67d9ea16627p+359, -0x1.21073ep-22, INEXACT) // -2.499752783117760372988414019346e+02
T(RU,    -0x1.f3f357adcb27p+7,  0x1.8e67d9ea16628p+359,   0x1.fffff6p-1, INEXACT) // -2.499752783117760372988414019346e+02
T(RZ,    -0x1.f3f357adcb27p+7,  0x1.8e67d9ea16627p+359, -0x1.21073ep-22, INEXACT) // -2.499752783117760372988414019346e+02
T(RN,    0x1.76ee4005a658fp-2,    0x1.115a33dc62c93p+0,    0x1.ffffdp-2, INEXACT) // 3.661432269523964833091156378941e-01
T(RN,   -0x1.575be51cc0dbep+8,  0x1.4913609bbb1d2p+494,   0x1.ffffeap-2, INEXACT) // -3.433589647265288249400327913463e+02
T(RD,    0x1.855139568fd0dp-5,    0x1.004a058f2e3a8p+0,  -0x1.a5b63p-22, INEXACT) // 4.752408217290780140240613604874e-02
T(RU,    0x1.855139568fd0dp-5,    0x1.004a058f2e3a9p+0,   0x1.fffff2p-1, INEXACT) // 4.752408217290780140240613604874e-02
T(RZ,    0x1.855139568fd0dp-5,    0x1.004a058f2e3a8p+0,  -0x1.a5b63p-22, INEXACT) // 4.752408217290780140240613604874e-02
T(RD,    0x1.f1654d71d27e8p+1,    0x1.85da15cd10da2p+4, -0x1.d2cd82p-21, INEXACT) // 3.885904007508532487236152519472e+00
T(RU,    0x1.f1654d71d27e8p+1,    0x1.85da15cd10da3p+4,   0x1.ffffe2p-1, INEXACT) // 3.885904007508532487236152519472e+00
T(RZ,    0x1.f1654d71d27e8p+1,    0x1.85da15cd10da2p+4, -0x1.d2cd82p-21, INEXACT) // 3.885904007508532487236152519472e+00
T(RN,    0x1.9e41ca98fc755p-6,     0x1.0014f310056ep+0,  -0x1.ffffc2p-2, INEXACT) // 2.528424057886210010726024677297e-02
T(RN,   -0x1.2a0b866896f5ap+5,   0x1.ae181fb1038fbp+52,   0x1.ffffc2p-2, INEXACT) // -3.725562745772067785310355247930e+01
T(RN,   -0x1.4b563bc177eccp-5,    0x1.00359ce265e16p+0,          0x1p-1, INEXACT) // -4.044639273683756086619212055666e-02
T(RN,    0x1.3712251a9a91cp-6,    0x1.000bcffffcb5bp+0,  -0x1.ffffc4p-2, INEXACT) // 1.898625968389310025852267926894e-02
T(RN,    0x1.42f10cb8f7336p-7,    0x1.00032ec83e281p+0,  -0x1.ffffe8p-2, INEXACT) // 9.855395519417702726583385697268e-03
T(RD,    0x1.c83ea73236917p-2,    0x1.19d54daf3923ep+0,         -0x1p+0, INEXACT) // 4.455515026471785211548137795035e-01
T(RU,    0x1.c83ea73236917p-2,    0x1.19d54daf3923fp+0,  0x1.3eeb12p-26, INEXACT) // 4.455515026471785211548137795035e-01
T(RZ,    0x1.c83ea73236917p-2,    0x1.19d54daf3923ep+0,         -0x1p+0, INEXACT) // 4.455515026471785211548137795035e-01
T(RD,   -0x1.59eaeab11f4c9p+5,    0x1.4d89ce084d93p+61,  -0x1.ffffe6p-1, INEXACT) // -4.323970545174376667318938416429e+01
T(RU,   -0x1.59eaeab11f4c9p+5,   0x1.4d89ce084d931p+61,  0x1.addc88p-21, INEXACT) // -4.323970545174376667318938416429e+01
T(RZ,   -0x1.59eaeab11f4c9p+5,    0x1.4d89ce084d93p+61,  -0x1.ffffe6p-1, INEXACT) // -4.323970545174376667318938416429e+01
T(RD,    0x1.fb82230d42aa2p+8,  0x1.21f925df2046ep+731,   -0x1.5e67p-21, INEXACT) // 5.075083473479991198473726399243e+02
T(RU,    0x1.fb82230d42aa2p+8,  0x1.21f925df2046fp+731,   0x1.ffffeap-1, INEXACT) // 5.075083473479991198473726399243e+02
T(RZ,    0x1.fb82230d42aa2p+8,  0x1.21f925df2046ep+731,   -0x1.5e67p-21, INEXACT) // 5.075083473479991198473726399243e+02
T(RN,   -0x1.e11aa815ef109p+0,    0x1.ace8a35b9f0b7p+1,   0x1.ffffd4p-2, INEXACT) // -1.879312997202818857900297189190e+00
T(RD,   -0x1.77c750074b4cfp-4,    0x1.0113fe4cf833ep+0, -0x1.7ea618p-21, INEXACT) // -9.174281369333246727304498335798e-02
T(RU,   -0x1.77c750074b4cfp-4,    0x1.0113fe4cf833fp+0,   0x1.ffffe8p-1, INEXACT) // -9.174281369333246727304498335798e-02
T(RZ,   -0x1.77c750074b4cfp-4,    0x1.0113fe4cf833ep+0, -0x1.7ea618p-21, INEXACT) // -9.174281369333246727304498335798e-02
T(RD,   -0x1.3b7076af7655fp-5,    0x1.003097481efa3p+0,  -0x1.ffffecp-1, INEXACT) // -3.850577526800224442693476589739e-02
T(RU,   -0x1.3b7076af7655fp-5,    0x1.003097481efa4p+0,   0x1.4e6fap-21, INEXACT) // -3.850577526800224442693476589739e-02
T(RZ,   -0x1.3b7076af7655fp-5,    0x1.003097481efa3p+0,  -0x1.ffffecp-1, INEXACT) // -3.850577526800224442693476589739e-02
T(RD,   -0x1.208444cdb4632p+4,   0x1.02b177acb18c1p+25, -0x1.b01cb8p-22, INEXACT) // -1.803229217866300615469299373217e+01
T(RU,   -0x1.208444cdb4632p+4,   0x1.02b177acb18c2p+25,   0x1.fffff2p-1, INEXACT) // -1.803229217866300615469299373217e+01
T(RZ,   -0x1.208444cdb4632p+4,   0x1.02b177acb18c1p+25, -0x1.b01cb8p-22, INEXACT) // -1.803229217866300615469299373217e+01
T(RD,   0x1.d3df288ab6b4ap-10,    0x1.00001ab8bffa8p+0,  -0x1.ffffe4p-1, INEXACT) // 1.784788941839381918447182684417e-03
T(RU,   0x1.d3df288ab6b4ap-10,    0x1.00001ab8bffa9p+0,  0x1.bf5362p-21, INEXACT) // 1.784788941839381918447182684417e-03
T(RZ,   0x1.d3df288ab6b4ap-10,    0x1.00001ab8bffa8p+0,  -0x1.ffffe4p-1, INEXACT) // 1.784788941839381918447182684417e-03
T(RD,     0x1.94db7de72b43p-8,    0x1.0001402303824p+0,  -0x1.fffff4p-1, INEXACT) // 6.177633512533239890096581348189e-03
T(RU,     0x1.94db7de72b43p-8,    0x1.0001402303825p+0,   0x1.85f2ep-22, INEXACT) // 6.177633512533239890096581348189e-03
T(RZ,     0x1.94db7de72b43p-8,    0x1.0001402303824p+0,  -0x1.fffff4p-1, INEXACT) // 6.177633512533239890096581348189e-03
T(RD,   -0x1.ff0c5e1f88fefp+5,   0x1.1e32175a79244p+91, -0x1.b2216ap-22, INEXACT) // -6.388103890072658685994611005299e+01
T(RU,   -0x1.ff0c5e1f88fefp+5,   0x1.1e32175a79245p+91,   0x1.fffff2p-1, INEXACT) // -6.388103890072658685994611005299e+01
T(RZ,   -0x1.ff0c5e1f88fefp+5,   0x1.1e32175a79244p+91, -0x1.b2216ap-22, INEXACT) // -6.388103890072658685994611005299e+01
T(RD,    0x1.14889a4040f5ep-6,    0x1.000955c531ebfp+0, -0x1.676cfcp-22, INEXACT) // 1.687827170918809044364294891238e-02
T(RU,    0x1.14889a4040f5ep-6,     0x1.000955c531ecp+0,   0x1.fffff4p-1, INEXACT) // 1.687827170918809044364294891238e-02
T(RZ,    0x1.14889a4040f5ep-6,    0x1.000955c531ebfp+0, -0x1.676cfcp-22, INEXACT) // 1.687827170918809044364294891238e-02
T(RN,    0x1.4996397daa937p+8,  0x1.685a1ec1a572cp+474,  -0x1.ffffeep-2, INEXACT) // 3.295868147412724624700786080211e+02
T(RN,   -0x1.2c1eb0d5ea527p-1,    0x1.2d41169115785p+0,   0x1.fffffcp-2, INEXACT) // -5.861716519476986020364961404994e-01
T(RD,    0x1.a3884e58419c8p+0,    0x1.55f6e04128037p+1,  -0x1.fffff4p-1, INEXACT) // 1.638798615023562277315249957610e+00
T(RU,    0x1.a3884e58419c8p+0,    0x1.55f6e04128038p+1,   0x1.9e53cp-22, INEXACT) // 1.638798615023562277315249957610e+00
T(RZ,    0x1.a3884e58419c8p+0,    0x1.55f6e04128037p+1,  -0x1.fffff4p-1, INEXACT) // 1.638798615023562277315249957610e+00
T(RN,   -0x1.699a96a1ddbb5p-8,    0x1.0000ff62d78d5p+0,  -0x1.ffffcap-2, INEXACT) // -5.517637038670854428279444192640e-03
T(RD,   -0x1.fd20fc0f34eacp+0,    0x1.dc6274723015bp+1,  -0x1.6897fp-21, INEXACT) // -1.988784555161070777273835119558e+00
T(RU,   -0x1.fd20fc0f34eacp+0,    0x1.dc6274723015cp+1,   0x1.ffffeap-1, INEXACT) // -1.988784555161070777273835119558e+00
T(RZ,   -0x1.fd20fc0f34eacp+0,    0x1.dc6274723015bp+1,  -0x1.6897fp-21, INEXACT) // -1.988784555161070777273835119558e+00
T(RN,  -0x1.505358ecb5bfdp-10,    0x1.00000dced7445p+0,    0x1.ffffcp-2, INEXACT) // -1.282980253724862922462546244162e-03
T(RD,   -0x1.b0dfc1941ac92p+4,   0x1.05aa42cfb3c68p+38,  -0x1.ffffecp-1, INEXACT) // -2.705462797025081300716919940896e+01
T(RU,   -0x1.b0dfc1941ac92p+4,   0x1.05aa42cfb3c69p+38,  0x1.3c5b3cp-21, INEXACT) // -2.705462797025081300716919940896e+01
T(RZ,   -0x1.b0dfc1941ac92p+4,   0x1.05aa42cfb3c68p+38,  -0x1.ffffecp-1, INEXACT) // -2.705462797025081300716919940896e+01
T(RN,   -0x1.ba1854a338789p-6,    0x1.0017dc1f14106p+0,   0x1.ffffd8p-2, INEXACT) // -2.698333993328775118336615435055e-02
T(RD,   -0x1.0dbf358c91075p+9,  0x1.40b21887eb21fp+777, -0x1.e19d32p-21, INEXACT) // -5.394938216884753501290106214583e+02
T(RU,   -0x1.0dbf358c91075p+9,   0x1.40b21887eb22p+777,   0x1.ffffe2p-1, INEXACT) // -5.394938216884753501290106214583e+02
T(RZ,   -0x1.0dbf358c91075p+9,  0x1.40b21887eb21fp+777, -0x1.e19d32p-21, INEXACT) // -5.394938216884753501290106214583e+02
T(RD,   -0x1.a0f49f31b4395p-9,    0x1.000054e382952p+0,  -0x1.fffff2p-1, INEXACT) // -3.181118424301530248771152642462e-03
T(RU,   -0x1.a0f49f31b4395p-9,    0x1.000054e382953p+0,  0x1.d1f836p-22, INEXACT) // -3.181118424301530248771152642462e-03
T(RZ,   -0x1.a0f49f31b4395p-9,    0x1.000054e382952p+0,  -0x1.fffff2p-1, INEXACT) // -3.181118424301530248771152642462e-03
T(RD,    0x1.40d78fc88c798p+3,   0x1.61570652c9e36p+13, -0x1.d08244p-22, INEXACT) // 1.002631367845224019674787996337e+01
T(RU,    0x1.40d78fc88c798p+3,   0x1.61570652c9e37p+13,   0x1.fffff2p-1, INEXACT) // 1.002631367845224019674787996337e+01
T(RZ,    0x1.40d78fc88c798p+3,   0x1.61570652c9e36p+13, -0x1.d08244p-22, INEXACT) // 1.002631367845224019674787996337e+01
T(RN,    0x1.fa3490ab3e6dap-4,    0x1.01f51d12ae992p+0,   0x1.ffffdep-2, INEXACT) // 1.235852862481822411755416624146e-01
T(RN,    0x1.19db4db08890ap+6,  0x1.94064beeed0c5p+100,  -0x1.fffffap-2, INEXACT) // 7.046416354974294904423004481941e+01
T(RN,   -0x1.c795a1c78c012p+6,  0x1.3efdd9ce43f3cp+163,   0x1.ffffe6p-2, INEXACT) // -1.138961249522401715239539043978e+02
T(RN,    0x1.120e76d532094p-8,    0x1.000092b1899b4p+0,  -0x1.fffff4p-2, INEXACT) // 4.181770336067942156477172943596e-03
T(RD,    0x1.578623f17c5c4p-1,    0x1.3bd0d572b148cp+0, -0x1.a8d0dcp-22, INEXACT) // 6.709452850611161700555840070592e-01
T(RU,    0x1.578623f17c5c4p-1,    0x1.3bd0d572b148dp+0,   0x1.fffff2p-1, INEXACT) // 6.709452850611161700555840070592e-01
T(RZ,    0x1.578623f17c5c4p-1,    0x1.3bd0d572b148cp+0, -0x1.a8d0dcp-22, INEXACT) // 6.709452850611161700555840070592e-01
T(RN,     0x1.2eeebfe1cf76p+7,  0x1.6f0390428ac85p+217,    0x1.ffffep-2, INEXACT) // 1.514663076940296377870254218578e+02
T(RD,   -0x1.b42096eed8caap+2,    0x1.c779de6205fcfp+8,  -0x1.fffff4p-1, INEXACT) // -6.814489110230320889627364522312e+00
T(RU,   -0x1.b42096eed8caap+2,     0x1.c779de6205fdp+8,    0x1.9d8cp-22, INEXACT) // -6.814489110230320889627364522312e+00
T(RZ,   -0x1.b42096eed8caap+2,    0x1.c779de6205fcfp+8,  -0x1.fffff4p-1, INEXACT) // -6.814489110230320889627364522312e+00
T(RN,    0x1.8d44c1bba8918p+2,    0x1.f05f3b2c5c76bp+7,   0x1.fffff4p-2, INEXACT) // 6.207321580181336173609452089295e+00
T(RD,    0x1.78993210deca3p+3,   0x1.f87a3babb98e8p+15,  -0x1.d3415p-24, INEXACT) // 1.176870063109374164866949286079e+01
T(RU,    0x1.78993210deca3p+3,   0x1.f87a3babb98e9p+15,   0x1.fffffcp-1, INEXACT) // 1.176870063109374164866949286079e+01
T(RZ,    0x1.78993210deca3p+3,   0x1.f87a3babb98e8p+15,  -0x1.d3415p-24, INEXACT) // 1.176870063109374164866949286079e+01
T(RN,    0x1.d6fc8b5a61146p-9,    0x1.00006c5090bdbp+0,    0x1.ffffep-2, INEXACT) // 3.593341837758642735856096095404e-03
T(RN,   -0x1.7d436e376a3d2p+0,    0x1.2a364b57c1f3dp+1,  -0x1.fffffap-2, INEXACT) // -1.489310158280421791943126663682e+00
T(RD,    0x1.d745bde736dd3p+6,  0x1.f769c2e76c6f3p+168, -0x1.5b9062p-22, INEXACT) // 1.178181072356449448079729336314e+02
T(RU,    0x1.d745bde736dd3p+6,  0x1.f769c2e76c6f4p+168,   0x1.fffff6p-1, INEXACT) // 1.178181072356449448079729336314e+02
T(RZ,    0x1.d745bde736dd3p+6,  0x1.f769c2e76c6f3p+168, -0x1.5b9062p-22, INEXACT) // 1.178181072356449448079729336314e+02
T(RD,   -0x1.1d2d9ef90cf19p+2,    0x1.58959183a5d23p+5, -0x1.acb908p-22, INEXACT) // -4.455909484113157681406391930068e+00
T(RU,   -0x1.1d2d9ef90cf19p+2,    0x1.58959183a5d24p+5,   0x1.fffff2p-1, INEXACT) // -4.455909484113157681406391930068e+00
T(RZ,   -0x1.1d2d9ef90cf19p+2,    0x1.58959183a5d23p+5, -0x1.acb908p-22, INEXACT) // -4.455909484113157681406391930068e+00
T(RN,    0x1.9664fb5fbb7ecp-5,    0x1.0050a8ca9c607p+0,  -0x1.ffffe6p-2, INEXACT) // 4.960869881129767455796297781490e-02
T(RD,    0x1.d59f6fb3a0fedp-8,    0x1.0001aec14216cp+0,  -0x1.ffffe6p-1, INEXACT) // 7.165875216404754728671822050501e-03
T(RU,    0x1.d59f6fb3a0fedp-8,    0x1.0001aec14216dp+0,  0x1.98e37ap-21, INEXACT) // 7.165875216404754728671822050501e-03
T(RZ,    0x1.d59f6fb3a0fedp-8,    0x1.0001aec14216cp+0,  -0x1.ffffe6p-1, INEXACT) // 7.165875216404754728671822050501e-03
T(RN,  -0x1.23930136a2178p-10,    0x1.00000a60bc5b5p+0,  -0x1.ffffc4p-2, INEXACT) // -1.112267445622176428865479635988e-03
T(RN,   -0x1.d6fe9a2814d56p-9,    0x1.00006c51830bap+0,  -0x1.ffffeep-2, INEXACT) // -3.593403165760437716069741753699e-03
T(RD,    0x1.bb81cb2aa2e6dp+5,   0x1.f92f8646d6f81p+78,  -0x1.ffffe4p-1, INEXACT) // 5.543837579068790688552326173522e+01
T(RU,    0x1.bb81cb2aa2e6dp+5,   0x1.f92f8646d6f82p+78,  0x1.b9fb14p-21, INEXACT) // 5.543837579068790688552326173522e+01
T(RZ,    0x1.bb81cb2aa2e6dp+5,   0x1.f92f8646d6f81p+78,  -0x1.ffffe4p-1, INEXACT) // 5.543837579068790688552326173522e+01
T(RN,   -0x1.1d196657847c7p-5,    0x1.0027b13895f7cp+0,  -0x1.fffffcp-2, INEXACT) // -3.480215061803409309915124936197e-02
T(RN,   -0x1.def6ecaed39ecp+7,    0x1.6a02d2185a4p+344,   0x1.ffffecp-2, INEXACT) // -2.394822744973492945064208470285e+02
T(RN,   -0x1.3e4ccdf2b44e5p+2,    0x1.210f40b65c769p+6,   0x1.ffffe6p-2, INEXACT) // -4.973437773719727950094693369465e+00
T(RD,   -0x1.8206015b69634p-4,    0x1.01234237fc79fp+0,  -0x1.ffffe2p-1, INEXACT) // -9.424400835140361865072122782294e-02
T(RU,   -0x1.8206015b69634p-4,     0x1.01234237fc7ap+0,   0x1.e401ep-21, INEXACT) // -9.424400835140361865072122782294e-02
T(RZ,   -0x1.8206015b69634p-4,    0x1.01234237fc79fp+0,  -0x1.ffffe2p-1, INEXACT) // -9.424400835140361865072122782294e-02
T(RN,   -0x1.ba514eab0d90fp-3,    0x1.05fe6d15c4082p+0,   0x1.fffff2p-2, INEXACT) // -2.159753938628416747302907197081e-01
T(RN,    0x1.5775f127d5b09p-8,    0x1.0000e666c3d6fp+0,  -0x1.ffffe2p-2, INEXACT) // 5.240794540290812965344091622910e-03
T(RN,    0x1.4daf1d9c1492ep+8,  0x1.52ce76e633cc1p+480,  -0x1.fffffcp-2, INEXACT) // 3.336840455579975923683377914131e+02
T(RD,   -0x1.16353f1f32916p-4,    0x1.00973ab9762b3p+0,   -0x1.fffffp-1, INEXACT) // -6.792187363604215710743972067576e-02
T(RU,   -0x1.16353f1f32916p-4,    0x1.00973ab9762b4p+0,  0x1.0c190ap-21, INEXACT) // -6.792187363604215710743972067576e-02
T(RZ,   -0x1.16353f1f32916p-4,    0x1.00973ab9762b3p+0,   -0x1.fffffp-1, INEXACT) // -6.792187363604215710743972067576e-02
T(RN,    0x1.f7c61a831cfbfp+8,  0x1.bb43aed68b27bp+725,  -0x1.ffffeep-2, INEXACT) // 5.037738420434724844199081417173e+02
T(RN,    0x1.ca6e7e49ea5c6p+6,  0x1.44fd986b97b8fp+164,   0x1.ffffd2p-2, INEXACT) // 1.146079036282818321978993481025e+02
T(RN,   -0x1.29357e851eb72p+6,   0x1.25254916e646p+106,   0x1.ffffeap-2, INEXACT) // -7.430224044799777516345784533769e+01
T(RN,   -0x1.89b0230de9315p+7,  0x1.fb042027efffcp+282,  -0x1.ffffcap-2, INEXACT) // -1.968440174433859795044554630294e+02
T(RN,    0x1.1d1ddb2c07ea3p+3,   0x1.cece15dafc561p+11,   0x1.ffffcap-2, INEXACT) // 8.909894548414120762913626094814e+00
T(RD,   -0x1.4b4b1358ec934p+7,  0x1.f81a5901e701ap+237, -0x1.66dee8p-22, INEXACT) // -1.656466319836414413657621480525e+02
T(RU,   -0x1.4b4b1358ec934p+7,  0x1.f81a5901e701bp+237,   0x1.fffff4p-1, INEXACT) // -1.656466319836414413657621480525e+02
T(RZ,   -0x1.4b4b1358ec934p+7,  0x1.f81a5901e701ap+237, -0x1.66dee8p-22, INEXACT) // -1.656466319836414413657621480525e+02
T(RN,    -0x1.37640538a259p-4,    0x1.00bd7970b2547p+0,   -0x1.ffffdp-2, INEXACT) // -7.602312125722776592340323986718e-02
T(RD,   -0x1.1e1057124c9d9p+2,    0x1.5d6268cb6fc78p+5,  -0x1.ffffeap-1, INEXACT) // -4.469747321958913666151147481287e+00
T(RU,   -0x1.1e1057124c9d9p+2,    0x1.5d6268cb6fc79p+5,  0x1.6f97eap-21, INEXACT) // -4.469747321958913666151147481287e+00
T(RZ,   -0x1.1e1057124c9d9p+2,    0x1.5d6268cb6fc78p+5,  -0x1.ffffeap-1, INEXACT) // -4.469747321958913666151147481287e+00
T(RN,   -0x1.969c59a0dd37ap+6,  0x1.92c60dd3a193dp+145,  -0x1.ffffecp-2, INEXACT) // -1.016526856551189723631978267804e+02
T(RN,   -0x1.15bae5a071d4dp+7,  0x1.440291d273772p+199,   0x1.ffffeep-2, INEXACT) // -1.388650331629709455683041596785e+02
T(RD,    -0x1.b9c9fb572826p-5,    0x1.005f531a4a4dbp+0,  -0x1.ffffe8p-1, INEXACT) // -5.392932023938068475388263323111e-02
T(RU,    -0x1.b9c9fb572826p-5,    0x1.005f531a4a4dcp+0,  0x1.78c708p-21, INEXACT) // -5.392932023938068475388263323111e-02
T(RZ,    -0x1.b9c9fb572826p-5,    0x1.005f531a4a4dbp+0,  -0x1.ffffe8p-1, INEXACT) // -5.392932023938068475388263323111e-02
T(RN,    0x1.ace5e36c95742p+8,  0x1.b440a7503d7bep+617,   0x1.ffffccp-2, INEXACT) // 4.288980014672162042188574559987e+02
T(RN,    -0x1.0e40aa1edbf1p+0,    0x1.9c663b3aedeaap+0,   0x1.ffffd6p-2, INEXACT) // -1.055674202474566669707201072015e+00
T(RD,   -0x1.dc148abf9749ap+6,  0x1.a2aa22ac216a5p+170,  -0x1.ffffe6p-1, INEXACT) // -1.190200605331505414596904302016e+02
T(RU,   -0x1.dc148abf9749ap+6,  0x1.a2aa22ac216a6p+170,  0x1.ad63acp-21, INEXACT) // -1.190200605331505414596904302016e+02
T(RZ,   -0x1.dc148abf9749ap+6,  0x1.a2aa22ac216a5p+170,  -0x1.ffffe6p-1, INEXACT) // -1.190200605331505414596904302016e+02
T(RN,   -0x1.63565d1facc89p+1,    0x1.01e3dc6249193p+3,    0x1.fffffp-2, INEXACT) // -2.776073112932469388880463156966e+00
T(RD,    0x1.3c51229c27cd8p+9,  0x1.9f394675303d5p+911,  -0x1.ffffeap-1, INEXACT) // 6.326338687128400124493055045605e+02
T(RU,    0x1.3c51229c27cd8p+9,  0x1.9f394675303d6p+911,  0x1.630ba2p-21, INEXACT) // 6.326338687128400124493055045605e+02
T(RZ,    0x1.3c51229c27cd8p+9,  0x1.9f394675303d5p+911,  -0x1.ffffeap-1, INEXACT) // 6.326338687128400124493055045605e+02
T(RD,   -0x1.aeb023f8e82cdp+1,    0x1.cf5fa09a71e2ep+3, -0x1.6c8422p-24, INEXACT) // -3.364750381981457483249187134788e+00
T(RU,   -0x1.aeb023f8e82cdp+1,    0x1.cf5fa09a71e2fp+3,   0x1.fffffep-1, INEXACT) // -3.364750381981457483249187134788e+00
T(RZ,   -0x1.aeb023f8e82cdp+1,    0x1.cf5fa09a71e2ep+3, -0x1.6c8422p-24, INEXACT) // -3.364750381981457483249187134788e+00
T(RD,    0x1.a4c87c8599072p+6,  0x1.b32bf54f47b41p+150, -0x1.2c8f78p-22, INEXACT) // 1.051957875132227684389363275841e+02
T(RU,    0x1.a4c87c8599072p+6,  0x1.b32bf54f47b42p+150,   0x1.fffff6p-1, INEXACT) // 1.051957875132227684389363275841e+02
T(RZ,    0x1.a4c87c8599072p+6,  0x1.b32bf54f47b41p+150, -0x1.2c8f78p-22, INEXACT) // 1.051957875132227684389363275841e+02
T(RD,    0x1.b900bed0554e6p+7,  0x1.1580a19f36e39p+317,   -0x1.fffffp-1, INEXACT) // 2.205014557937749373195401858538e+02
T(RU,    0x1.b900bed0554e6p+7,  0x1.1580a19f36e3ap+317,  0x1.0e6b16p-21, INEXACT) // 2.205014557937749373195401858538e+02
T(RZ,    0x1.b900bed0554e6p+7,  0x1.1580a19f36e39p+317,   -0x1.fffffp-1, INEXACT) // 2.205014557937749373195401858538e+02
T(RD,   -0x1.0fbf12c2b2efap+8,  0x1.0881736c3cbd4p+391,  -0x1.fffffap-1, INEXACT) // -2.717463800131660036640823818743e+02
T(RU,   -0x1.0fbf12c2b2efap+8,  0x1.0881736c3cbd5p+391,  0x1.b6f98cp-23, INEXACT) // -2.717463800131660036640823818743e+02
T(RZ,   -0x1.0fbf12c2b2efap+8,  0x1.0881736c3cbd4p+391,  -0x1.fffffap-1, INEXACT) // -2.717463800131660036640823818743e+02
T(RD,   -0x1.bbb33ccd4e348p-1,    0x1.664be569f477fp+0, -0x1.782318p-26, INEXACT) // -8.666018486611415383435996773187e-01
T(RU,   -0x1.bbb33ccd4e348p-1,     0x1.664be569f478p+0,          0x1p+0, INEXACT) // -8.666018486611415383435996773187e-01
T(RZ,   -0x1.bbb33ccd4e348p-1,    0x1.664be569f477fp+0, -0x1.782318p-26, INEXACT) // -8.666018486611415383435996773187e-01
T(RD,    0x1.2305854eea642p+0,    0x1.b8044c13ce2c5p+0,  -0x1.8b00ep-22, INEXACT) // 1.136802989737035307626911162515e+00
T(RU,    0x1.2305854eea642p+0,    0x1.b8044c13ce2c6p+0,   0x1.fffff4p-1, INEXACT) // 1.136802989737035307626911162515e+00
T(RZ,    0x1.2305854eea642p+0,    0x1.b8044c13ce2c5p+0,  -0x1.8b00ep-22, INEXACT) // 1.136802989737035307626911162515e+00
T(RN,   -0x1.568a4c447631ep+5,   0x1.b558eb60e3044p+60,  -0x1.fffffcp-2, INEXACT) // -4.281752828107549646574625512585e+01
T(RN,    0x1.b6508b6253faap-9,    0x1.00005dcefc842p+0,  -0x1.ffffdcp-2, INEXACT) // 3.344075216922666633767580179892e-03
T(RN,     0x1.ac6521a25b09p+6,  0x1.6cc5a7de468eep+153,   0x1.ffffeep-2, INEXACT) // 1.070987611167968225345248356462e+02
T(RN,    0x1.71136842173a7p+4,   0x1.369dc9dd05b3dp+32,  -0x1.ffffd4p-2, INEXACT) // 2.306723810021108178602844418492e+01
T(RD,     0x1.e487d3c67116p+4,   0x1.9cd1b48297569p+42,  -0x1.fffff4p-1, INEXACT) // 3.028316094890885779022937640548e+01
T(RU,     0x1.e487d3c67116p+4,   0x1.9cd1b4829756ap+42,  0x1.77f3eep-22, INEXACT) // 3.028316094890885779022937640548e+01
T(RZ,     0x1.e487d3c67116p+4,   0x1.9cd1b48297569p+42,  -0x1.fffff4p-1, INEXACT) // 3.028316094890885779022937640548e+01
T(RD,    0x1.3384437658115p+8,  0x1.9279615013cf8p+442, -0x1.270c2ap-24, INEXACT) // 3.075166543927201132646587211639e+02
T(RU,    0x1.3384437658115p+8,  0x1.9279615013cf9p+442,   0x1.fffffep-1, INEXACT) // 3.075166543927201132646587211639e+02
T(RZ,    0x1.3384437658115p+8,  0x1.9279615013cf8p+442, -0x1.270c2ap-24, INEXACT) // 3.075166543927201132646587211639e+02
T(RD,   -0x1.2dc8a00318781p+5,   0x1.5728764ca754ap+53,  -0x1.ffffeep-1, INEXACT) // -3.772296144884513324768704478629e+01
T(RU,   -0x1.2dc8a00318781p+5,   0x1.5728764ca754bp+53,  0x1.21b7c4p-21, INEXACT) // -3.772296144884513324768704478629e+01
T(RZ,   -0x1.2dc8a00318781p+5,   0x1.5728764ca754ap+53,  -0x1.ffffeep-1, INEXACT) // -3.772296144884513324768704478629e+01
T(RN,    0x1.e06c309f2e31bp-6,    0x1.001c2d336e6d1p+0,   0x1.ffffccp-2, INEXACT) // 2.932266948912163814777720460825e-02
T(RN,    0x1.7b6c79ba57037p+8,  0x1.5019076c92979p+546,    0x1.fffffp-2, INEXACT) // 3.794237324201998831085802521557e+02
T(RD,    0x1.5f9d864f6c1c9p-4,    0x1.00f19ea413163p+0,  -0x1.ffffeep-1, INEXACT) // 8.584358658732250957346110453727e-02
T(RU,    0x1.5f9d864f6c1c9p-4,    0x1.00f19ea413164p+0,   0x1.16967p-21, INEXACT) // 8.584358658732250957346110453727e-02
T(RZ,    0x1.5f9d864f6c1c9p-4,    0x1.00f19ea413163p+0,  -0x1.ffffeep-1, INEXACT) // 8.584358658732250957346110453727e-02
T(RD,    0x1.82d629224b0ccp+5,   0x1.b1cdcd91c4838p+68, -0x1.e44c64p-21, INEXACT) // 4.835457064429792239934613462538e+01
T(RU,    0x1.82d629224b0ccp+5,   0x1.b1cdcd91c4839p+68,   0x1.ffffe2p-1, INEXACT) // 4.835457064429792239934613462538e+01
T(RZ,    0x1.82d629224b0ccp+5,   0x1.b1cdcd91c4838p+68, -0x1.e44c64p-21, INEXACT) // 4.835457064429792239934613462538e+01
T(RN,   -0x1.bafae44f69419p+6,  0x1.b4efadd4ad1d6p+158,   0x1.ffffe8p-2, INEXACT) // -1.107450115592950083964751684107e+02
T(RD,   -0x1.f9121db2a229ap-9,    0x1.00007c8f19683p+0, -0x1.ff0e08p-21, INEXACT) // -3.853384137361648593966823028723e-03
T(RU,   -0x1.f9121db2a229ap-9,    0x1.00007c8f19684p+0,    0x1.ffffep-1, INEXACT) // -3.853384137361648593966823028723e-03
T(RZ,   -0x1.f9121db2a229ap-9,    0x1.00007c8f19683p+0, -0x1.ff0e08p-21, INEXACT) // -3.853384137361648593966823028723e-03
T(RN,    0x1.c286ba567272fp+8,  0x1.f62b6f6c2646fp+648,   0x1.fffffcp-2, INEXACT) // 4.505262807874123041074199136347e+02
T(RD,   -0x1.c86343e6773fep-8,    0x1.000196d14ff08p+0,  -0x1.fffff2p-1, INEXACT) // -6.963924481593329260387115198228e-03
T(RU,   -0x1.c86343e6773fep-8,    0x1.000196d14ff09p+0,  0x1.b570b8p-22, INEXACT) // -6.963924481593329260387115198228e-03
T(RZ,   -0x1.c86343e6773fep-8,    0x1.000196d14ff08p+0,  -0x1.fffff2p-1, INEXACT) // -6.963924481593329260387115198228e-03
T(RD,    0x1.69ab3da849d9ep+7,  0x1.da132b499295dp+259, -0x1.736e6ap-21, INEXACT) // 1.808344547834539639552531298250e+02
T(RU,    0x1.69ab3da849d9ep+7,  0x1.da132b499295ep+259,   0x1.ffffe8p-1, INEXACT) // 1.808344547834539639552531298250e+02
T(RZ,    0x1.69ab3da849d9ep+7,  0x1.da132b499295dp+259, -0x1.736e6ap-21, INEXACT) // 1.808344547834539639552531298250e+02
T(RN,    0x1.76ea3d9e83ae3p+2,    0x1.5e0aecd41bfe1p+7,   0x1.ffffcap-2, INEXACT) // 5.858046917723842561542824114440e+00
T(RD,    0x1.3202ea92a196bp-5,    0x1.002dbabb90f93p+0,   -0x1.ffffep-1, INEXACT) // 3.735490622516376285622285990939e-02
T(RU,    0x1.3202ea92a196bp-5,    0x1.002dbabb90f94p+0,  0x1.fe9082p-21, INEXACT) // 3.735490622516376285622285990939e-02
T(RZ,    0x1.3202ea92a196bp-5,    0x1.002dbabb90f93p+0,   -0x1.ffffep-1, INEXACT) // 3.735490622516376285622285990939e-02
T(RN,   -0x1.53df5fc597f1dp-3,    0x1.0388856931c3fp+0,   0x1.fffff4p-2, INEXACT) // -1.659533960510025940582323755734e-01
T(RD,    0x1.9de43fbf90762p-9,    0x1.000053a54cb44p+0,  -0x1.fffffcp-1, INEXACT) // 3.157742292189278689173992376027e-03
T(RU,    0x1.9de43fbf90762p-9,    0x1.000053a54cb45p+0,  0x1.023124p-23, INEXACT) // 3.157742292189278689173992376027e-03
T(RZ,    0x1.9de43fbf90762p-9,    0x1.000053a54cb44p+0,  -0x1.fffffcp-1, INEXACT) // 3.157742292189278689173992376027e-03
T(RN,    0x1.d6c6808c972cdp-6,    0x1.001b0e65cdc14p+0,  -0x1.fffffep-2, INEXACT) // 2.873385003691701980454986653513e-02
T(RD,   -0x1.4af22b3eaca11p+8,  0x1.5eb46a06f59c4p+476, -0x1.c0ec24p-23, INEXACT) // -3.309459723636110197730886284262e+02
T(RU,   -0x1.4af22b3eaca11p+8,  0x1.5eb46a06f59c5p+476,   0x1.fffff8p-1, INEXACT) // -3.309459723636110197730886284262e+02
T(RZ,   -0x1.4af22b3eaca11p+8,  0x1.5eb46a06f59c4p+476, -0x1.c0ec24p-23, INEXACT) // -3.309459723636110197730886284262e+02
T(RN,   -0x1.1599126adc5bbp+5,   0x1.0b1552d2d7366p+49,    0x1.fffffp-2, INEXACT) // -3.469974215970020026134079671465e+01
T(RD,   -0x1.53efae01addefp+5,   0x1.3bd69e465ef16p+60,  -0x1.fffff8p-1, INEXACT) // -4.249203110992299770032332162373e+01
T(RU,   -0x1.53efae01addefp+5,   0x1.3bd69e465ef17p+60,  0x1.0d6c68p-22, INEXACT) // -4.249203110992299770032332162373e+01
T(RZ,   -0x1.53efae01addefp+5,   0x1.3bd69e465ef16p+60,  -0x1.fffff8p-1, INEXACT) // -4.249203110992299770032332162373e+01
T(RD,   -0x1.d459ba4faa48ep-5,    0x1.006b227e391d2p+0,  -0x1.ffffeap-1, INEXACT) // -5.717169178871826795695909595452e-02
T(RU,   -0x1.d459ba4faa48ep-5,    0x1.006b227e391d3p+0,  0x1.5ed1cep-21, INEXACT) // -5.717169178871826795695909595452e-02
T(RZ,   -0x1.d459ba4faa48ep-5,    0x1.006b227e391d2p+0,  -0x1.ffffeap-1, INEXACT) // -5.717169178871826795695909595452e-02
T(RN,   -0x1.201b920ae355fp+7,  0x1.c5c18abbc451dp+206,  -0x1.ffffcap-2, INEXACT) // -1.440538485910901442821341333911e+02
T(RD,   -0x1.e4fbc144fd0eap-3,    0x1.07362c4ad643cp+0,  -0x1.fffffcp-1, INEXACT) // -2.368083094767208796049828833929e-01
T(RU,   -0x1.e4fbc144fd0eap-3,    0x1.07362c4ad643dp+0,   0x1.2171ap-23, INEXACT) // -2.368083094767208796049828833929e-01
T(RZ,   -0x1.e4fbc144fd0eap-3,    0x1.07362c4ad643cp+0,  -0x1.fffffcp-1, INEXACT) // -2.368083094767208796049828833929e-01
T(RD,    0x1.6173f702d0b76p+4,   0x1.d3fb00c7b08aep+30, -0x1.7c329cp-21, INEXACT) // 2.209081173991895497010773397051e+01
T(RU,    0x1.6173f702d0b76p+4,   0x1.d3fb00c7b08afp+30,   0x1.ffffe8p-1, INEXACT) // 2.209081173991895497010773397051e+01
T(RZ,    0x1.6173f702d0b76p+4,   0x1.d3fb00c7b08aep+30, -0x1.7c329cp-21, INEXACT) // 2.209081173991895497010773397051e+01
T(RN,    -0x1.8a3638936824p+7,  0x1.4966e23ed1073p+283,   0x1.fffff2p-2, INEXACT) // -1.971059003891587053658440709114e+02
T(RD,   -0x1.320d1f00c06f6p+0,    0x1.cdcc6a6d581abp+0, -0x1.03d53ap-24, INEXACT) // -1.195512712176819203335753627471e+00
T(RU,   -0x1.320d1f00c06f6p+0,    0x1.cdcc6a6d581acp+0,   0x1.fffffep-1, INEXACT) // -1.195512712176819203335753627471e+00
T(RZ,   -0x1.320d1f00c06f6p+0,    0x1.cdcc6a6d581abp+0, -0x1.03d53ap-24, INEXACT) // -1.195512712176819203335753627471e+00
T(RN,    0x1.5734237bb643bp-6,    0x1.000e610882b9cp+0,   0x1.ffffdap-2, INEXACT) // 2.094748940621491903324447036994e-02
T(RD,    0x1.0f0e7d7f071d8p-4,    0x1.008f8d3fc5c58p+0,  -0x1.01f6dp-21, INEXACT) // 6.617592832521468348971893647104e-02
T(RU,    0x1.0f0e7d7f071d8p-4,    0x1.008f8d3fc5c59p+0,    0x1.fffffp-1, INEXACT) // 6.617592832521468348971893647104e-02
T(RZ,    0x1.0f0e7d7f071d8p-4,    0x1.008f8d3fc5c58p+0,  -0x1.01f6dp-21, INEXACT) // 6.617592832521468348971893647104e-02
T(RD,    0x1.9e91124de3e1dp+7,  0x1.0869caf6fb969p+298, -0x1.6da406p-21, INEXACT) // 2.072833427754093520434253150597e+02
T(RU,    0x1.9e91124de3e1dp+7,  0x1.0869caf6fb96ap+298,   0x1.ffffeap-1, INEXACT) // 2.072833427754093520434253150597e+02
T(RZ,    0x1.9e91124de3e1dp+7,  0x1.0869caf6fb969p+298, -0x1.6da406p-21, INEXACT) // 2.072833427754093520434253150597e+02
T(RN,   -0x1.a7e12769eb299p+6,  0x1.d7dc3af4ca13bp+151,   0x1.ffffc6p-2, INEXACT) // -1.059698769140035352620543562807e+02
T(RD,   -0x1.59f5bc17b8e13p-3,    0x1.03a94a48a5496p+0,  -0x1.ffffe6p-1, INEXACT) // -1.689257330645977661642831435529e-01
T(RU,   -0x1.59f5bc17b8e13p-3,    0x1.03a94a48a5497p+0,  0x1.ae65e2p-21, INEXACT) // -1.689257330645977661642831435529e-01
T(RZ,   -0x1.59f5bc17b8e13p-3,    0x1.03a94a48a5496p+0,  -0x1.ffffe6p-1, INEXACT) // -1.689257330645977661642831435529e-01
T(RN,    0x1.2d003199668a5p-3,    0x1.02c51953dbc75p+0,  -0x1.fffff2p-2, INEXACT) // 1.469730257929927896842769996510e-01
T(RD,    0x1.1bd8dfebda824p+9,  0x1.01beadced464ap+818,  -0x1.ffffe8p-1, INEXACT) // 5.676943335358560034364927560091e+02
T(RU,    0x1.1bd8dfebda824p+9,  0x1.01beadced464bp+818,   0x1.7093bp-21, INEXACT) // 5.676943335358560034364927560091e+02
T(RZ,    0x1.1bd8dfebda824p+9,  0x1.01beadced464ap+818,  -0x1.ffffe8p-1, INEXACT) // 5.676943335358560034364927560091e+02
T(RN,   -0x1.dde5c87a0a7fdp+7,  0x1.a8aeca2fdb8a6p+343,   0x1.fffffep-2, INEXACT) // -2.389487951410118569128826493397e+02
T(RN,   -0x1.1bcd03f055c53p-2,    0x1.09e51e575f8dap+0,   0x1.fffffap-2, INEXACT) // -2.771492591322772258699558278749e-01
T(RN,    0x1.aebab8f865c73p+4,   0x1.c9ae2f33e3396p+37,  -0x1.ffffc2p-2, INEXACT) // 2.692058655767727870511407672893e+01
T(RD,    0x1.9c895c0f0b6d3p+7,   0x1.7f45ab3c3317p+296,  -0x1.ffffeap-1, INEXACT) // 2.062682804776619320819008862600e+02
T(RU,    0x1.9c895c0f0b6d3p+7,  0x1.7f45ab3c33171p+296,  0x1.503c0ap-21, INEXACT) // 2.062682804776619320819008862600e+02
T(RZ,    0x1.9c895c0f0b6d3p+7,   0x1.7f45ab3c3317p+296,  -0x1.ffffeap-1, INEXACT) // 2.062682804776619320819008862600e+02
T(RD,   -0x1.df084f1a74dd3p+1,    0x1.51cbee865cee7p+4,  -0x1.ffffecp-1, INEXACT) // -3.742441070478642384244949425920e+00
T(RU,   -0x1.df084f1a74dd3p+1,    0x1.51cbee865cee8p+4,  0x1.411866p-21, INEXACT) // -3.742441070478642384244949425920e+00
T(RZ,   -0x1.df084f1a74dd3p+1,    0x1.51cbee865cee7p+4,  -0x1.ffffecp-1, INEXACT) // -3.742441070478642384244949425920e+00
T(RD,   -0x1.ee8afb7040c6fp+1,    0x1.7d4436dab429cp+4,  -0x1.ffffe4p-1, INEXACT) // -3.863616399584820282342434438760e+00
T(RU,   -0x1.ee8afb7040c6fp+1,    0x1.7d4436dab429dp+4,  0x1.cd4572p-21, INEXACT) // -3.863616399584820282342434438760e+00
T(RZ,   -0x1.ee8afb7040c6fp+1,    0x1.7d4436dab429cp+4,  -0x1.ffffe4p-1, INEXACT) // -3.863616399584820282342434438760e+00
T(RN,    0x1.f7f2ecbafdc0bp-2,     0x1.1fa1df5ad6b7p+0,   0x1.ffffe6p-2, INEXACT) // 4.921376217966446087181964230695e-01
T(RD,   -0x1.28aab568a8aeep+0,    0x1.c0042ef16de67p+0,  -0x1.97a37p-22, INEXACT) // -1.158854806949132676407998587820e+00
T(RU,   -0x1.28aab568a8aeep+0,    0x1.c0042ef16de68p+0,   0x1.fffff4p-1, INEXACT) // -1.158854806949132676407998587820e+00
T(RZ,   -0x1.28aab568a8aeep+0,    0x1.c0042ef16de67p+0,  -0x1.97a37p-22, INEXACT) // -1.158854806949132676407998587820e+00
T(RD,   -0x1.c75889c906034p+5,   0x1.155ddb3efb1f5p+81,  -0x1.fffff4p-1, INEXACT) // -5.691823155450438775915245059878e+01
T(RU,   -0x1.c75889c906034p+5,   0x1.155ddb3efb1f6p+81,  0x1.929e24p-22, INEXACT) // -5.691823155450438775915245059878e+01
T(RZ,   -0x1.c75889c906034p+5,   0x1.155ddb3efb1f5p+81,  -0x1.fffff4p-1, INEXACT) // -5.691823155450438775915245059878e+01
T(RD,   -0x1.c870b67f2da4fp-2,    0x1.19db1130ce8fcp+0, -0x1.cb5382p-21, INEXACT) // -4.457424655078385256068429498555e-01
T(RU,   -0x1.c870b67f2da4fp-2,    0x1.19db1130ce8fdp+0,   0x1.ffffe4p-1, INEXACT) // -4.457424655078385256068429498555e-01
T(RZ,   -0x1.c870b67f2da4fp-2,    0x1.19db1130ce8fcp+0, -0x1.cb5382p-21, INEXACT) // -4.457424655078385256068429498555e-01
T(RN,   -0x1.525661fbf8a97p-8,    0x1.0000df943c7cfp+0,   0x1.ffffc4p-2, INEXACT) // -5.162619516314712574123202415421e-03
T(RN,    0x1.8028ca556ce4p-10,    0x1.00001203d3622p+0,   0x1.ffffccp-2, INEXACT) // 1.465451573818735142573643770447e-03
T(RD,    -0x1.13f6176a6a5fp-1,    0x1.2618067a783b6p+0, -0x1.ac1cfep-22, INEXACT) // -5.389869038964985037409860524349e-01
T(RU,    -0x1.13f6176a6a5fp-1,    0x1.2618067a783b7p+0,   0x1.fffff2p-1, INEXACT) // -5.389869038964985037409860524349e-01
T(RZ,    -0x1.13f6176a6a5fp-1,    0x1.2618067a783b6p+0, -0x1.ac1cfep-22, INEXACT) // -5.389869038964985037409860524349e-01
T(RD,    0x1.d3e56ea6a1957p+7,  0x1.6e05115eb1f8ap+336, -0x1.f44968p-22, INEXACT) // 2.339481098243947769788064761087e+02
T(RU,    0x1.d3e56ea6a1957p+7,  0x1.6e05115eb1f8bp+336,    0x1.fffffp-1, INEXACT) // 2.339481098243947769788064761087e+02
T(RZ,    0x1.d3e56ea6a1957p+7,  0x1.6e05115eb1f8ap+336, -0x1.f44968p-22, INEXACT) // 2.339481098243947769788064761087e+02
T(RN,    0x1.3c01a2d191cbep+2,    0x1.16e27c4e62c5bp+6,    0x1.fffffp-2, INEXACT) // 4.937599854142886712793369952124e+00
T(RD,   -0x1.fbbeadf849dbcp+7,   0x1.32a83be89595p+365, -0x1.458002p-22, INEXACT) // -2.538724210348281076221610419452e+02
T(RU,   -0x1.fbbeadf849dbcp+7,  0x1.32a83be895951p+365,   0x1.fffff6p-1, INEXACT) // -2.538724210348281076221610419452e+02
T(RZ,   -0x1.fbbeadf849dbcp+7,   0x1.32a83be89595p+365, -0x1.458002p-22, INEXACT) // -2.538724210348281076221610419452e+02
T(RN,     0x1.c7d607079802p-1,    0x1.6c56eb2940c93p+0,  -0x1.ffffeep-2, INEXACT) // 8.903047749299766167041525477543e-01
T(RN,   -0x1.5ad08400ffb79p+2,    0x1.c34e1af4b3478p+6,   0x1.fffff8p-2, INEXACT) // -5.418976784682734582077046070481e+00
T(RD,    0x1.bfff13fcae5d8p-8,    0x1.000187fec7048p+0, -0x1.4c6418p-21, INEXACT) // 6.835882548949588632947182986754e-03
T(RU,    0x1.bfff13fcae5d8p-8,    0x1.000187fec7049p+0,   0x1.ffffecp-1, INEXACT) // 6.835882548949588632947182986754e-03
T(RZ,    0x1.bfff13fcae5d8p-8,    0x1.000187fec7048p+0, -0x1.4c6418p-21, INEXACT) // 6.835882548949588632947182986754e-03
T(RN,   -0x1.37be5970724ecp+3,   0x1.09e537b2bf96cp+13,   0x1.fffff4p-2, INEXACT) // -9.741986007330034169626742368564e+00
T(RD,   -0x1.edc7bec89c9e9p-2,    0x1.1e582180927f2p+0,         -0x1p+0, INEXACT) // -4.822072801536295139079868476983e-01
T(RU,   -0x1.edc7bec89c9e9p-2,    0x1.1e582180927f3p+0,  0x1.6533b6p-26, INEXACT) // -4.822072801536295139079868476983e-01
T(RZ,   -0x1.edc7bec89c9e9p-2,    0x1.1e582180927f2p+0,         -0x1p+0, INEXACT) // -4.822072801536295139079868476983e-01
T(RN,   -0x1.46bcacaf48a54p-3,    0x1.0343cf6926c58p+0,   0x1.ffffd6p-2, INEXACT) // -1.595395556442605888847197093128e-01
T(RN,   -0x1.8e23258b26ffbp-4,    0x1.0135d712ca70ep+0,   0x1.fffffep-2, INEXACT) // -9.720148721174830253044518713068e-02
T(RN,   -0x1.f2b20962b1c5bp+8,  0x1.6179615baa769p+718,  -0x1.ffffcep-2, INEXACT) // -4.986954557117475701488729100674e+02
T(RN,    0x1.05c88cb117454p-8,    0x1.000085d951a88p+0,  -0x1.ffffcap-2, INEXACT) // 3.994497631620925331974447658467e-03
T(RD,    0x1.56131e62e537fp-9,    0x1.00003922e4f3cp+0,         -0x1p+0, INEXACT) // 2.609822711244935266455824418586e-03
T(RU,    0x1.56131e62e537fp-9,    0x1.00003922e4f3dp+0,  0x1.4634bap-26, INEXACT) // 2.609822711244935266455824418586e-03
T(RZ,    0x1.56131e62e537fp-9,    0x1.00003922e4f3cp+0,         -0x1p+0, INEXACT) // 2.609822711244935266455824418586e-03
T(RN,    0x1.ed2013deb6c83p-5,     0x1.0076c5c0152fp+0,   0x1.fffff2p-2, INEXACT) // 6.019595986227790213041188849274e-02
T(RN,   -0x1.002af2602959fp+8,  0x1.7c8de1ad3c97ap+368,   0x1.ffffdep-2, INEXACT) // -2.561677608586268775070493575186e+02
T(RN,    0x1.9e3927adf1268p+3,   0x1.98b5aeddd6fd4p+17,  -0x1.ffffd4p-2, INEXACT) // 1.294447692845388075966184260324e+01
T(RN,   -0x1.2f69c4626df8ep+9,  0x1.616f68aee4fb2p+874,   0x1.ffffe4p-2, INEXACT) // -6.068263056790326572809135541320e+02
T(RN,    0x1.986377f55cecep-7,    0x1.000516febb586p+0,   0x1.ffffeep-2, INEXACT) // 1.246302945467139475232976053576e-02
T(RN,   0x1.29e0c5b398516p-10,    0x1.00000ad4da943p+0,  -0x1.fffff2p-2, INEXACT) // 1.136314455742420178457896540181e-03
T(RD,    0x1.506cdde2c0a9ep-5,    0x1.003745bba6dcbp+0,  -0x1.fffffep-1, INEXACT) // 4.106753670750616647122654967461e-02
T(RU,    0x1.506cdde2c0a9ep-5,    0x1.003745bba6dccp+0,  0x1.7f5d8ap-25, INEXACT) // 4.106753670750616647122654967461e-02
T(RZ,    0x1.506cdde2c0a9ep-5,    0x1.003745bba6dcbp+0,  -0x1.fffffep-1, INEXACT) // 4.106753670750616647122654967461e-02
T(RD,   -0x1.2ae8a4a5edfd8p+0,    0x1.c340e32e7ecc9p+0,  -0x1.ffffe4p-1, INEXACT) // -1.167612352857750224188748688903e+00
T(RU,   -0x1.2ae8a4a5edfd8p+0,    0x1.c340e32e7eccap+0,  0x1.bb6a6cp-21, INEXACT) // -1.167612352857750224188748688903e+00
T(RZ,   -0x1.2ae8a4a5edfd8p+0,    0x1.c340e32e7ecc9p+0,  -0x1.ffffe4p-1, INEXACT) // -1.167612352857750224188748688903e+00
T(RD,     0x1.ce894061081cp-5,    0x1.00687d90ae6aep+0, -0x1.fe9582p-24, INEXACT) // 5.646193098096174978195449511986e-02
T(RU,     0x1.ce894061081cp-5,    0x1.00687d90ae6afp+0,   0x1.fffffcp-1, INEXACT) // 5.646193098096174978195449511986e-02
T(RZ,     0x1.ce894061081cp-5,    0x1.00687d90ae6aep+0, -0x1.fe9582p-24, INEXACT) // 5.646193098096174978195449511986e-02
T(RN,    0x1.b4a34fb1f2091p-5,    0x1.005d1d3a73207p+0,   0x1.ffffcep-2, INEXACT) // 5.330052915047745615284568998504e-02
T(RD,    0x1.f35cdaeb93381p-5,     0x1.0079cc0b1615p+0,  -0x1.b0a7bp-22, INEXACT) // 6.095736272673147465583909365705e-02
T(RU,    0x1.f35cdaeb93381p-5,    0x1.0079cc0b16151p+0,   0x1.fffff2p-1, INEXACT) // 6.095736272673147465583909365705e-02
T(RZ,    0x1.f35cdaeb93381p-5,     0x1.0079cc0b1615p+0,  -0x1.b0a7bp-22, INEXACT) // 6.095736272673147465583909365705e-02
T(RD,   -0x1.ad228024775c8p+6,  0x1.b6dec24736a99p+153, -0x1.5b79fap-21, INEXACT) // -1.072836919496395466921967454255e+02
T(RU,   -0x1.ad228024775c8p+6,  0x1.b6dec24736a9ap+153,   0x1.ffffeap-1, INEXACT) // -1.072836919496395466921967454255e+02
T(RZ,   -0x1.ad228024775c8p+6,  0x1.b6dec24736a99p+153, -0x1.5b79fap-21, INEXACT) // -1.072836919496395466921967454255e+02
T(RD,    0x1.e391460425609p+6,   0x1.542ac0a8fe95p+173,  -0x1.ffffeep-1, INEXACT) // 1.208918686530888777497239061631e+02
T(RU,    0x1.e391460425609p+6,  0x1.542ac0a8fe951p+173,  0x1.258338p-21, INEXACT) // 1.208918686530888777497239061631e+02
T(RZ,    0x1.e391460425609p+6,   0x1.542ac0a8fe95p+173,  -0x1.ffffeep-1, INEXACT) // 1.208918686530888777497239061631e+02
T(RN,  -0x1.833e74007c88ep-10,    0x1.0000124e2f479p+0,   0x1.fffffcp-2, INEXACT) // -1.477218465990168521501102461002e-03
T(RN,   -0x1.2e7eb17309b8cp+0,    0x1.c880e83739656p+0,   0x1.fffff4p-2, INEXACT) // -1.181620684228366080503747070907e+00
T(RN,   0x1.f254902b7233bp-10,    0x1.00001e50697fep+0,  -0x1.fffff2p-2, INEXACT) // 1.900979327603204453375762561507e-03
T(RD,   -0x1.c083640d68196p-2,    0x1.18f3865fb598ap+0, -0x1.b5b814p-21, INEXACT) // -4.380012162382852514141973188089e-01
T(RU,   -0x1.c083640d68196p-2,    0x1.18f3865fb598bp+0,   0x1.ffffe4p-1, INEXACT) // -4.380012162382852514141973188089e-01
T(RZ,   -0x1.c083640d68196p-2,    0x1.18f3865fb598ap+0, -0x1.b5b814p-21, INEXACT) // -4.380012162382852514141973188089e-01
T(RN,    0x1.3288573d4ef8fp+9,  0x1.619f8f50d4fb5p+883,  -0x1.ffffdap-2, INEXACT) // 6.130651623378379326823051087558e+02
T(RD,    -0x1.da569ccb9cfdp+7,  0x1.1e93abac98169p+341,  -0x1.3173dp-23, INEXACT) // -2.371691650036941609869245439768e+02
T(RU,    -0x1.da569ccb9cfdp+7,  0x1.1e93abac9816ap+341,   0x1.fffffcp-1, INEXACT) // -2.371691650036941609869245439768e+02
T(RZ,    -0x1.da569ccb9cfdp+7,  0x1.1e93abac98169p+341,  -0x1.3173dp-23, INEXACT) // -2.371691650036941609869245439768e+02
T(RN,    0x1.1547eb271abf6p+7,  0x1.02d6da3daf582p+199,   0x1.fffff2p-2, INEXACT) // 1.386404659481192425118933897465e+02
T(RD,    0x1.48ecc564d0472p+0,    0x1.f207b97ba4f7ep+0,  -0x1.ffffecp-1, INEXACT) // 1.284862839806262702069261649740e+00
T(RU,    0x1.48ecc564d0472p+0,    0x1.f207b97ba4f7fp+0,  0x1.498644p-21, INEXACT) // 1.284862839806262702069261649740e+00
T(RZ,    0x1.48ecc564d0472p+0,    0x1.f207b97ba4f7ep+0,  -0x1.ffffecp-1, INEXACT) // 1.284862839806262702069261649740e+00
T(RD,   -0x1.8160ad8d55edap+2,    0x1.9c359fb6c8ac7p+7,  -0x1.e51e6p-24, INEXACT) // -6.021525753043272644049466180149e+00
T(RU,   -0x1.8160ad8d55edap+2,    0x1.9c359fb6c8ac8p+7,   0x1.fffffcp-1, INEXACT) // -6.021525753043272644049466180149e+00
T(RZ,   -0x1.8160ad8d55edap+2,    0x1.9c359fb6c8ac7p+7,  -0x1.e51e6p-24, INEXACT) // -6.021525753043272644049466180149e+00
T(RN,     0x1.bea9cc746d7bp+8,  0x1.5188f46284316p+643,  -0x1.ffffe4p-2, INEXACT) // 4.466632759825979519519023597240e+02
T(RD,    -0x1.41a39d3f0ebfp-1,    0x1.34325e61df2e2p+0, -0x1.daa8fep-22, INEXACT) // -6.282014026140796403296917560510e-01
T(RU,    -0x1.41a39d3f0ebfp-1,    0x1.34325e61df2e3p+0,   0x1.fffff2p-1, INEXACT) // -6.282014026140796403296917560510e-01
T(RZ,    -0x1.41a39d3f0ebfp-1,    0x1.34325e61df2e2p+0, -0x1.daa8fep-22, INEXACT) // -6.282014026140796403296917560510e-01
T(RN,    0x1.5b9575fc76de9p+0,    0x1.0942539463291p+1,   0x1.ffffc4p-2, INEXACT) // 1.357749342095184497125615052937e+00
T(RD,   -0x1.6cff0491b06b9p-8,    0x1.0001043345983p+0, -0x1.7f2d0ap-22, INEXACT) // -5.569399466993801318948076328752e-03
T(RU,   -0x1.6cff0491b06b9p-8,    0x1.0001043345984p+0,   0x1.fffff4p-1, INEXACT) // -5.569399466993801318948076328752e-03
T(RZ,   -0x1.6cff0491b06b9p-8,    0x1.0001043345983p+0, -0x1.7f2d0ap-22, INEXACT) // -5.569399466993801318948076328752e-03
T(RN,   -0x1.f89278e77c596p-1,    0x1.86b498bf87f63p+0,   0x1.ffffc2p-2, INEXACT) // -9.854924948287357988618850868079e-01
T(RD,    0x1.45b9cb9cc19cbp-3,    0x1.033ea238a043dp+0,  -0x1.ffffe2p-1, INEXACT) // 1.590457827771401821959074140977e-01
T(RU,    0x1.45b9cb9cc19cbp-3,    0x1.033ea238a043ep+0,  0x1.d039f6p-21, INEXACT) // 1.590457827771401821959074140977e-01
T(RZ,    0x1.45b9cb9cc19cbp-3,    0x1.033ea238a043dp+0,  -0x1.ffffe2p-1, INEXACT) // 1.590457827771401821959074140977e-01
T(RN,    0x1.6d3b10ce70d69p-7,    0x1.00041225ba2bbp+0,  -0x1.fffff4p-2, INEXACT) // 1.114595718980267331776889960793e-02
T(RN,   -0x1.24fc1d4dba119p-4,    0x1.00a7ba5b26127p+0,   0x1.ffffd2p-2, INEXACT) // -7.152949759222727854623968823944e-02
T(RN,    0x1.70f4cbfadcf9dp-7,    0x1.0004278449698p+0,  -0x1.ffffe2p-2, INEXACT) // 1.125965080220919269093915460189e-02
T(RN,   -0x1.6e2e28b1987dcp+6,  0x1.0d07f178b66aep+131,  -0x1.ffffdap-2, INEXACT) // -9.154507710927231300956918857992e+01
T(RN,   -0x1.8ba5b9539ed0cp-4,     0x1.0131f94a8646p+0,   0x1.fffffcp-2, INEXACT) // -9.659359353274882264983602908615e-02
T(RN,    0x1.291abead2f2c7p+9,  0x1.330affc4a2b5dp+856,   0x1.ffffc8p-2, INEXACT) // 5.942089439850177541302400641143e+02
T(RD,   -0x1.9b70e284384dfp-3,    0x1.052efb945558fp+0, -0x1.f43716p-21, INEXACT) // -2.008989044761965991892083138737e-01
T(RU,   -0x1.9b70e284384dfp-3,     0x1.052efb945559p+0,    0x1.ffffep-1, INEXACT) // -2.008989044761965991892083138737e-01
T(RZ,   -0x1.9b70e284384dfp-3,    0x1.052efb945558fp+0, -0x1.f43716p-21, INEXACT) // -2.008989044761965991892083138737e-01
T(RN,   -0x1.b3eeff58ccf47p+4,   0x1.3cce135e8e4e5p+38,   0x1.ffffe8p-2, INEXACT) // -2.724584898650871522818306402769e+01
T(RD,    0x1.9440f56ea8547p-5,    0x1.004fcfc832406p+0,  -0x1.ffffeap-1, INEXACT) // 4.934738098132612077462155752983e-02
T(RU,    0x1.9440f56ea8547p-5,    0x1.004fcfc832407p+0,  0x1.6a07c6p-21, INEXACT) // 4.934738098132612077462155752983e-02
T(RZ,    0x1.9440f56ea8547p-5,    0x1.004fcfc832406p+0,  -0x1.ffffeap-1, INEXACT) // 4.934738098132612077462155752983e-02
T(RN,    0x1.4480669025aa2p+6,  0x1.070d194e41f4cp+116,   -0x1.ffffep-2, INEXACT) // 8.112539124708067106439557392150e+01
T(RD,   -0x1.54ac7459f004ep+9,  0x1.f7aed24272657p+981,  -0x1.fffff4p-1, INEXACT) // -6.813473007604568465467309579253e+02
T(RU,   -0x1.54ac7459f004ep+9,  0x1.f7aed24272658p+981,  0x1.84525ep-22, INEXACT) // -6.813473007604568465467309579253e+02
T(RZ,   -0x1.54ac7459f004ep+9,  0x1.f7aed24272657p+981,  -0x1.fffff4p-1, INEXACT) // -6.813473007604568465467309579253e+02
T(RN,   -0x1.b46e168f62236p+3,   0x1.990aed285f7f4p+18,   0x1.fffff2p-2, INEXACT) // -1.363843849186478607293793174904e+01
T(RD,   -0x1.55563c83446bap+0,    0x1.03ab06fa493c2p+1, -0x1.f759a6p-22, INEXACT) // -1.333347112701103842624661410809e+00
T(RU,   -0x1.55563c83446bap+0,    0x1.03ab06fa493c3p+1,    0x1.fffffp-1, INEXACT) // -1.333347112701103842624661410809e+00
T(RZ,   -0x1.55563c83446bap+0,    0x1.03ab06fa493c2p+1, -0x1.f759a6p-22, INEXACT) // -1.333347112701103842624661410809e+00
T(RD,   -0x1.335838c5d9fd4p+9,  0x1.c08b6888d9357p+885, -0x1.fecbeap-21, INEXACT) // -6.146892325701141999161336570978e+02
T(RU,   -0x1.335838c5d9fd4p+9,  0x1.c08b6888d9358p+885,    0x1.ffffep-1, INEXACT) // -6.146892325701141999161336570978e+02
T(RZ,   -0x1.335838c5d9fd4p+9,  0x1.c08b6888d9357p+885, -0x1.fecbeap-21, INEXACT) // -6.146892325701141999161336570978e+02
T(RN,   -0x1.745fbee7cd821p+4,   0x1.7db927d92210cp+32,   0x1.ffffeap-2, INEXACT) // -2.327337542102771195118293690030e+01
T(RN,    0x1.24e7b4284bdd8p+4,   0x1.5454c4b87ae3dp+25,   -0x1.ffffcp-2, INEXACT) // 1.830656829586754952288174536079e+01
T(RN,     0x1.954dad2d1ec1p+3,   0x1.3548b9059495fp+17,   0x1.fffffep-2, INEXACT) // 1.266573199093366497436363715678e+01
T(RN,    0x1.ad4865d561b5fp+0,    0x1.624b0421fbb68p+1,   0x1.ffffc4p-2, INEXACT) // 1.676885952563416770644266762247e+00
T(RD,   -0x1.d145d622638d2p+6,  0x1.c1591fe3bb02bp+166, -0x1.6a3c26p-23, INEXACT) // -1.163181996701489708812005119398e+02
T(RU,   -0x1.d145d622638d2p+6,  0x1.c1591fe3bb02cp+166,   0x1.fffffap-1, INEXACT) // -1.163181996701489708812005119398e+02
T(RZ,   -0x1.d145d622638d2p+6,  0x1.c1591fe3bb02bp+166, -0x1.6a3c26p-23, INEXACT) // -1.163181996701489708812005119398e+02
T(RN,   -0x1.6fbdf2d2dd4aep+5,   0x1.3f01b164f2058p+65,   0x1.fffff6p-2, INEXACT) // -4.596774830568152481191646074876e+01
T(RD,    0x1.fbc604188b2dap+6,  0x1.1a335ee2b0aa6p+182, -0x1.57758ap-22, INEXACT) // 1.269433749995181699432578170672e+02
T(RU,    0x1.fbc604188b2dap+6,  0x1.1a335ee2b0aa7p+182,   0x1.fffff6p-1, INEXACT) // 1.269433749995181699432578170672e+02
T(RZ,    0x1.fbc604188b2dap+6,  0x1.1a335ee2b0aa6p+182, -0x1.57758ap-22, INEXACT) // 1.269433749995181699432578170672e+02
T(RD,   -0x1.d1e31505934e9p+5,   0x1.02f7204bee037p+83,  -0x1.ffffe6p-1, INEXACT) // -5.823587993961138664644749951549e+01
T(RU,   -0x1.d1e31505934e9p+5,   0x1.02f7204bee038p+83,  0x1.99d404p-21, INEXACT) // -5.823587993961138664644749951549e+01
T(RZ,   -0x1.d1e31505934e9p+5,   0x1.02f7204bee037p+83,  -0x1.ffffe6p-1, INEXACT) // -5.823587993961138664644749951549e+01
T(RD,    0x1.027af386a1facp-7,    0x1.000209f8cd318p+0, -0x1.d9591ap-22, INEXACT) // 7.888192090163524683443796448046e-03
T(RU,    0x1.027af386a1facp-7,    0x1.000209f8cd319p+0,   0x1.fffff2p-1, INEXACT) // 7.888192090163524683443796448046e-03
T(RZ,    0x1.027af386a1facp-7,    0x1.000209f8cd318p+0, -0x1.d9591ap-22, INEXACT) // 7.888192090163524683443796448046e-03
T(RN,   0x1.dbfc7846c272fp-10,    0x1.00001ba8177a1p+0,  -0x1.fffff4p-2, INEXACT) // 1.815743294800896889470975814618e-03
T(RN,   -0x1.978329d2756a8p-4,    0x1.01449dac83465p+0,   0x1.ffffe6p-2, INEXACT) // -9.949032150992798140265449546860e-02
T(RN,   -0x1.112db554d5507p-8,    0x1.000091c15048ep+0,    0x1.ffffdp-2, INEXACT) // -4.168373842579293185595101789431e-03
T(RN,    0x1.2efc095a652e6p+7,   0x1.78a9bba9cd3bp+217,  -0x1.fffffap-2, INEXACT) // 1.514922588585388325554959010333e+02
T(RD,   -0x1.868db3b7378fap+4,   0x1.2943a357e2e8dp+34,  -0x1.fffff8p-1, INEXACT) // -2.440959521836428081087433383800e+01
T(RU,   -0x1.868db3b7378fap+4,   0x1.2943a357e2e8ep+34,  0x1.0b785ep-22, INEXACT) // -2.440959521836428081087433383800e+01
T(RZ,   -0x1.868db3b7378fap+4,   0x1.2943a357e2e8dp+34,  -0x1.fffff8p-1, INEXACT) // -2.440959521836428081087433383800e+01
T(RD,    0x1.163b2d25f00a4p+1,    0x1.1cf05aa30c71fp+2,  -0x1.fffff4p-1, INEXACT) // 2.173680919193502703024023503531e+00
T(RU,    0x1.163b2d25f00a4p+1,     0x1.1cf05aa30c72p+2,  0x1.8a24e2p-22, INEXACT) // 2.173680919193502703024023503531e+00
T(RZ,    0x1.163b2d25f00a4p+1,    0x1.1cf05aa30c71fp+2,  -0x1.fffff4p-1, INEXACT) // 2.173680919193502703024023503531e+00
T(RD,   -0x1.cabea19a8d288p-9,     0x1.000066c1dbe6p+0, -0x1.2523e4p-21, INEXACT) // -3.499943949714815621954144830852e-03
T(RU,   -0x1.cabea19a8d288p-9,    0x1.000066c1dbe61p+0,   0x1.ffffeep-1, INEXACT) // -3.499943949714815621954144830852e-03
T(RZ,   -0x1.cabea19a8d288p-9,     0x1.000066c1dbe6p+0, -0x1.2523e4p-21, INEXACT) // -3.499943949714815621954144830852e-03
T(RD,    0x1.50274da03a908p-8,    0x1.0000dcb3b89cdp+0,  -0x1.ffffeap-1, INEXACT) // 5.129295779833016599713602090560e-03
T(RU,    0x1.50274da03a908p-8,    0x1.0000dcb3b89cep+0,  0x1.5a6856p-21, INEXACT) // 5.129295779833016599713602090560e-03
T(RZ,    0x1.50274da03a908p-8,    0x1.0000dcb3b89cdp+0,  -0x1.ffffeap-1, INEXACT) // 5.129295779833016599713602090560e-03
T(RD,    0x1.936ee978ea932p+4,   0x1.4c70713a70707p+35,  -0x1.fffff6p-1, INEXACT) // 2.521457812531406972311742720194e+01
T(RU,    0x1.936ee978ea932p+4,   0x1.4c70713a70708p+35,   0x1.40f74p-22, INEXACT) // 2.521457812531406972311742720194e+01
T(RZ,    0x1.936ee978ea932p+4,   0x1.4c70713a70707p+35,  -0x1.fffff6p-1, INEXACT) // 2.521457812531406972311742720194e+01
T(RD,     0x1.06343873709ep+3,   0x1.c456ec93c9dbfp+10, -0x1.cc35acp-21, INEXACT) // 8.193874574154449419438606128097e+00
T(RU,     0x1.06343873709ep+3,    0x1.c456ec93c9dcp+10,   0x1.ffffe4p-1, INEXACT) // 8.193874574154449419438606128097e+00
T(RZ,     0x1.06343873709ep+3,   0x1.c456ec93c9dbfp+10, -0x1.cc35acp-21, INEXACT) // 8.193874574154449419438606128097e+00
T(RD,    0x1.7c7fe66b7cd38p-3,    0x1.046e59ca1e685p+0, -0x1.53ad74p-24, INEXACT) // 1.857908250382054315963387125521e-01
T(RU,    0x1.7c7fe66b7cd38p-3,    0x1.046e59ca1e686p+0,   0x1.fffffep-1, INEXACT) // 1.857908250382054315963387125521e-01
T(RZ,    0x1.7c7fe66b7cd38p-3,    0x1.046e59ca1e685p+0, -0x1.53ad74p-24, INEXACT) // 1.857908250382054315963387125521e-01
T(RD,   -0x1.ef830fd2bc393p-1,    0x1.818b1e8efcebbp+0, -0x1.cd1098p-21, INEXACT) // -9.677967972512412364594069913437e-01
T(RU,   -0x1.ef830fd2bc393p-1,    0x1.818b1e8efcebcp+0,   0x1.ffffe4p-1, INEXACT) // -9.677967972512412364594069913437e-01
T(RZ,   -0x1.ef830fd2bc393p-1,    0x1.818b1e8efcebbp+0, -0x1.cd1098p-21, INEXACT) // -9.677967972512412364594069913437e-01
T(RN,    0x1.9ac8ecc3c9311p-4,    0x1.0149dad7c7cf2p+0,   -0x1.ffffdp-2, INEXACT) // 1.002892731308515777977063976323e-01
T(RD,    0x1.bda0f06d49bd1p+6,  0x1.a79a42dc3bdf7p+159, -0x1.81f258p-21, INEXACT) // 1.114071671558624672115911380388e+02
T(RU,    0x1.bda0f06d49bd1p+6,  0x1.a79a42dc3bdf8p+159,   0x1.ffffe8p-1, INEXACT) // 1.114071671558624672115911380388e+02
T(RZ,    0x1.bda0f06d49bd1p+6,  0x1.a79a42dc3bdf7p+159, -0x1.81f258p-21, INEXACT) // 1.114071671558624672115911380388e+02
T(RN,   -0x1.b90b52e1ce777p-6,    0x1.0017bf1e19ccfp+0,  -0x1.ffffdcp-2, INEXACT) // -2.691920370055053343683049149604e-02
T(RD,   -0x1.90849413db422p-8,     0x1.0001394f899cp+0,  -0x1.fffff4p-1, INEXACT) // -6.111417915104973633266816079868e-03
T(RU,   -0x1.90849413db422p-8,    0x1.0001394f899c1p+0,  0x1.8bd596p-22, INEXACT) // -6.111417915104973633266816079868e-03
T(RZ,   -0x1.90849413db422p-8,     0x1.0001394f899cp+0,  -0x1.fffff4p-1, INEXACT) // -6.111417915104973633266816079868e-03
T(RD,   -0x1.3a2951975f997p+9,   0x1.649b6424863ap+905,  -0x1.ffffe2p-1, INEXACT) // -6.283228024689477706488105468452e+02
T(RU,   -0x1.3a2951975f997p+9,  0x1.649b6424863a1p+905,  0x1.e2e936p-21, INEXACT) // -6.283228024689477706488105468452e+02
T(RZ,   -0x1.3a2951975f997p+9,   0x1.649b6424863ap+905,  -0x1.ffffe2p-1, INEXACT) // -6.283228024689477706488105468452e+02
T(RD,   -0x1.a62b28e5c5b9bp-9,    0x1.000057064f31cp+0,  -0x1.58341p-21, INEXACT) // -3.220890753151418092053992481283e-03
T(RU,   -0x1.a62b28e5c5b9bp-9,    0x1.000057064f31dp+0,   0x1.ffffeap-1, INEXACT) // -3.220890753151418092053992481283e-03
T(RZ,   -0x1.a62b28e5c5b9bp-9,    0x1.000057064f31cp+0,  -0x1.58341p-21, INEXACT) // -3.220890753151418092053992481283e-03
T(RD,   -0x1.c2a5d78453855p-9,    0x1.00006329750a6p+0,  -0x1.ffffe8p-1, INEXACT) // -3.438170011725675493524656545219e-03
T(RU,   -0x1.c2a5d78453855p-9,    0x1.00006329750a7p+0,  0x1.795ef6p-21, INEXACT) // -3.438170011725675493524656545219e-03
T(RZ,   -0x1.c2a5d78453855p-9,    0x1.00006329750a6p+0,  -0x1.ffffe8p-1, INEXACT) // -3.438170011725675493524656545219e-03
T(RN,   -0x1.94d81555e9fdfp-6,    0x1.001402188519bp+0,   0x1.fffff6p-2, INEXACT) // -2.470972140841342853945228341672e-02
T(RN,   -0x1.c94736c309cc1p+2,    0x1.3cedd3c3531b5p+9,  -0x1.ffffe4p-2, INEXACT) // -7.144971552340565246197456872324e+00
T(RN,     0x1.e9336ee6c2c8p+7,  0x1.d8665060aa74ep+351,  -0x1.ffffcep-2, INEXACT) // 2.446004554856081085745245218277e+02
T(RD,   -0x1.408b528a69842p+2,    0x1.2b5fe0d6669d4p+6,   -0x1.fffffp-1, INEXACT) // -5.008503565948617008984911080915e+00
T(RU,   -0x1.408b528a69842p+2,    0x1.2b5fe0d6669d5p+6,  0x1.e78562p-22, INEXACT) // -5.008503565948617008984911080915e+00
T(RZ,   -0x1.408b528a69842p+2,    0x1.2b5fe0d6669d4p+6,   -0x1.fffffp-1, INEXACT) // -5.008503565948617008984911080915e+00
T(RD,   -0x1.076db416b1002p+7,  0x1.0435026ca23eap+189,  -0x1.fffffep-1, INEXACT) // -1.317142645922722863360831979662e+02
T(RU,   -0x1.076db416b1002p+7,  0x1.0435026ca23ebp+189,  0x1.ed486ep-25, INEXACT) // -1.317142645922722863360831979662e+02
T(RZ,   -0x1.076db416b1002p+7,  0x1.0435026ca23eap+189,  -0x1.fffffep-1, INEXACT) // -1.317142645922722863360831979662e+02
T(RN,    0x1.15ca83257d122p+6,   0x1.246e14037440bp+99,    0x1.fffffp-2, INEXACT) // 6.944776590896483980941411573440e+01
T(RD,    0x1.06d1a432d6abfp+2,    0x1.e606274eb2afcp+4,  -0x1.fffff4p-1, INEXACT) // 4.106545495650322230574147397419e+00
T(RU,    0x1.06d1a432d6abfp+2,    0x1.e606274eb2afdp+4,  0x1.9e9afep-22, INEXACT) // 4.106545495650322230574147397419e+00
T(RZ,    0x1.06d1a432d6abfp+2,    0x1.e606274eb2afcp+4,  -0x1.fffff4p-1, INEXACT) // 4.106545495650322230574147397419e+00
T(RD,    -0x1.fbd9c38a7f21p+7,  0x1.4350d3cea7fd8p+365, -0x1.d90bf2p-21, INEXACT) // -2.539253199844538357865530997515e+02
T(RU,    -0x1.fbd9c38a7f21p+7,  0x1.4350d3cea7fd9p+365,   0x1.ffffe2p-1, INEXACT) // -2.539253199844538357865530997515e+02
T(RZ,    -0x1.fbd9c38a7f21p+7,  0x1.4350d3cea7fd8p+365, -0x1.d90bf2p-21, INEXACT) // -2.539253199844538357865530997515e+02
T(RD,     0x1.f84b962a208bp+1,    0x1.9b6cc816e5083p+4,  -0x1.fffffcp-1, INEXACT) // 3.939806719369776999428722774610e+00
T(RU,     0x1.f84b962a208bp+1,    0x1.9b6cc816e5084p+4,   0x1.b7033p-24, INEXACT) // 3.939806719369776999428722774610e+00
T(RZ,     0x1.f84b962a208bp+1,    0x1.9b6cc816e5083p+4,  -0x1.fffffcp-1, INEXACT) // 3.939806719369776999428722774610e+00
T(RD,    0x1.9ed278f064ef7p-7,    0x1.0005405f7108ep+0,  -0x1.fffffcp-1, INEXACT) // 1.265936761118478630361305903307e-02
T(RU,    0x1.9ed278f064ef7p-7,    0x1.0005405f7108fp+0,  0x1.8ce5dcp-24, INEXACT) // 1.265936761118478630361305903307e-02
T(RZ,    0x1.9ed278f064ef7p-7,    0x1.0005405f7108ep+0,  -0x1.fffffcp-1, INEXACT) // 1.265936761118478630361305903307e-02
T(RD,   -0x1.51e4c77208ba3p-6,    0x1.000df0016c29bp+0,  -0x1.fffff2p-1, INEXACT) // -2.062339284033111105887137171067e-02
T(RU,   -0x1.51e4c77208ba3p-6,    0x1.000df0016c29cp+0,  0x1.a12442p-22, INEXACT) // -2.062339284033111105887137171067e-02
T(RZ,   -0x1.51e4c77208ba3p-6,    0x1.000df0016c29bp+0,  -0x1.fffff2p-1, INEXACT) // -2.062339284033111105887137171067e-02
T(RN,   -0x1.f95a79a603fc2p-4,    0x1.01f36d18c449bp+0,  -0x1.ffffdep-2, INEXACT) // -1.233772994894471175530981099655e-01
T(RD,   -0x1.6e4b60ada8537p-7,    0x1.0004183a089b7p+0,   -0x1.fffffp-1, INEXACT) // -1.117841930983108460206931766834e-02
T(RU,   -0x1.6e4b60ada8537p-7,    0x1.0004183a089b8p+0,  0x1.fece56p-22, INEXACT) // -1.117841930983108460206931766834e-02
T(RZ,   -0x1.6e4b60ada8537p-7,    0x1.0004183a089b7p+0,   -0x1.fffffp-1, INEXACT) // -1.117841930983108460206931766834e-02
T(RN,    0x1.ff9b982e9ad63p-2,    0x1.209f053d05399p+0,  -0x1.ffffdcp-2, INEXACT) // 4.996169832654315245967779901548e-01
T(RN,    0x1.8f90c7a79c03fp+1,    0x1.6ba13979e454dp+3,    0x1.ffffcp-2, INEXACT) // 3.121605831947845910434580218862e+00
T(RD,   -0x1.087b7660f95afp+0,    0x1.953738a6d9cabp+0,  -0x1.fffff2p-1, INEXACT) // -1.033133886981300042506859426794e+00
T(RU,   -0x1.087b7660f95afp+0,    0x1.953738a6d9cacp+0,  0x1.de42e4p-22, INEXACT) // -1.033133886981300042506859426794e+00
T(RZ,   -0x1.087b7660f95afp+0,    0x1.953738a6d9cabp+0,  -0x1.fffff2p-1, INEXACT) // -1.033133886981300042506859426794e+00
T(RN,    -0x1.03420df11d8fp-9,    0x1.000020d1d7dbap+0,   -0x1.ffffdp-2, INEXACT) // -1.977981759917139814586306556521e-03
T(RN,   0x1.10141d2f7dbc3p-10,    0x1.00000909560a7p+0,   0x1.fffffcp-2, INEXACT) // 1.037897378294281398522502790627e-03
T(RD,   0x1.181f72c9e65f8p-10,    0x1.000009942686fp+0,  -0x1.ffffecp-1, INEXACT) // 1.068583851952074545432758156949e-03
T(RU,   0x1.181f72c9e65f8p-10,     0x1.000009942687p+0,   0x1.44f8dp-21, INEXACT) // 1.068583851952074545432758156949e-03
T(RZ,   0x1.181f72c9e65f8p-10,    0x1.000009942686fp+0,  -0x1.ffffecp-1, INEXACT) // 1.068583851952074545432758156949e-03
T(RD,   -0x1.d2554c3f42664p+7,  0x1.4f106ea67264bp+335,  -0x1.ffffeap-1, INEXACT) // -2.331665973442605945820105262101e+02
T(RU,   -0x1.d2554c3f42664p+7,  0x1.4f106ea67264cp+335,  0x1.6bb628p-21, INEXACT) // -2.331665973442605945820105262101e+02
T(RZ,   -0x1.d2554c3f42664p+7,  0x1.4f106ea67264bp+335,  -0x1.ffffeap-1, INEXACT) // -2.331665973442605945820105262101e+02
T(RD,    0x1.cef15961dfdb1p+1,    0x1.29f18567aec91p+4, -0x1.34c39cp-21, INEXACT) // 3.616740391531231058053208471392e+00
T(RU,    0x1.cef15961dfdb1p+1,    0x1.29f18567aec92p+4,   0x1.ffffecp-1, INEXACT) // 3.616740391531231058053208471392e+00
T(RZ,    0x1.cef15961dfdb1p+1,    0x1.29f18567aec91p+4, -0x1.34c39cp-21, INEXACT) // 3.616740391531231058053208471392e+00
T(RN,   -0x1.7ced2d9a61ac5p-4,    0x1.011b9ccc1ec06p+0,  -0x1.ffffd2p-2, INEXACT) // -9.299962819759872989511251262229e-02
T(RN,    0x1.f019794c7e842p+6,  0x1.e7c6a196ca22ep+177,   0x1.fffff2p-2, INEXACT) // 1.240248767807215983793867053464e+02
T(RD,    0x1.12025a9863967p+0,    0x1.a1303bd084b6cp+0,  -0x1.ffffe6p-1, INEXACT) // 1.070348417476987057384008039662e+00
T(RU,    0x1.12025a9863967p+0,    0x1.a1303bd084b6dp+0,  0x1.a5872ap-21, INEXACT) // 1.070348417476987057384008039662e+00
T(RZ,    0x1.12025a9863967p+0,    0x1.a1303bd084b6cp+0,  -0x1.ffffe6p-1, INEXACT) // 1.070348417476987057384008039662e+00
T(RN,    0x1.00b363d2d411dp-9,    0x1.0000202ce957ep+0,   0x1.fffff4p-2, INEXACT) // 1.958471236697913262642112286471e-03
T(RN,    0x1.dd53fc8454ec6p-9,    0x1.00006f404ae13p+0,   0x1.ffffc8p-2, INEXACT) // 3.641724181003033571080163000033e-03
T(RD,   -0x1.38ff30cc14147p-7,    0x1.0002fd5f8806ep+0, -0x1.9a530ap-21, INEXACT) // -9.551905466793754115317760522430e-03
T(RU,   -0x1.38ff30cc14147p-7,    0x1.0002fd5f8806fp+0,   0x1.ffffe6p-1, INEXACT) // -9.551905466793754115317760522430e-03
T(RZ,   -0x1.38ff30cc14147p-7,    0x1.0002fd5f8806ep+0, -0x1.9a530ap-21, INEXACT) // -9.551905466793754115317760522430e-03
T(RN,    0x1.d8a2f0a87d4c4p+8,  0x1.d3fbaaf15af5ep+680,   0x1.ffffd6p-2, INEXACT) // 4.726364846521285016933688893914e+02
T(RD,    0x1.16dbfcec6e933p+9,  0x1.88e0e4fdfa197p+803,  -0x1.fffffcp-1, INEXACT) // 5.577186561145703080910607241094e+02
T(RU,    0x1.16dbfcec6e933p+9,  0x1.88e0e4fdfa198p+803,  0x1.34aac2p-23, INEXACT) // 5.577186561145703080910607241094e+02
T(RZ,    0x1.16dbfcec6e933p+9,  0x1.88e0e4fdfa197p+803,  -0x1.fffffcp-1, INEXACT) // 5.577186561145703080910607241094e+02
T(RN,   -0x1.f75635533c60ep+0,    0x1.d21fa5a08ae73p+1,  -0x1.ffffe6p-2, INEXACT) // -1.966159184285405370218313692021e+00
T(RD,    0x1.8e19c29e1a36bp+4,   0x1.dc6d66b51b0f9p+34,  -0x1.fffff6p-1, INEXACT) // 2.488128911741970838988891046029e+01
T(RU,    0x1.8e19c29e1a36bp+4,   0x1.dc6d66b51b0fap+34,   0x1.25a5cp-22, INEXACT) // 2.488128911741970838988891046029e+01
T(RZ,    0x1.8e19c29e1a36bp+4,   0x1.dc6d66b51b0f9p+34,  -0x1.fffff6p-1, INEXACT) // 2.488128911741970838988891046029e+01
T(RD,   -0x1.40026e9100d4cp+5,   0x1.a2a001fe4a9e3p+56, -0x1.b1ff32p-21, INEXACT) // -4.000118745120798280368035193533e+01
T(RU,   -0x1.40026e9100d4cp+5,   0x1.a2a001fe4a9e4p+56,   0x1.ffffe4p-1, INEXACT) // -4.000118745120798280368035193533e+01
T(RZ,   -0x1.40026e9100d4cp+5,   0x1.a2a001fe4a9e3p+56, -0x1.b1ff32p-21, INEXACT) // -4.000118745120798280368035193533e+01
T(RN,    0x1.796206c79fb8dp+4,   0x1.0505b075a856ap+33,  -0x1.ffffe6p-2, INEXACT) // 2.358643224695292772707944095600e+01
T(RN,   -0x1.9ac7a99160c36p+4,   0x1.0715c781378bbp+36,   0x1.ffffdcp-2, INEXACT) // -2.567374569690965557811068720184e+01
T(RN,   -0x1.2b51669507698p+3,    0x1.68aa58fc14acp+12,   0x1.fffffep-2, INEXACT) // -9.353686610290694147806789260358e+00
T(RD,   -0x1.7384bb7075fd4p-9,    0x1.0000436542783p+0,  -0x1.ffffe6p-1, INEXACT) // -2.834461098455401742435277867571e-03
T(RU,   -0x1.7384bb7075fd4p-9,    0x1.0000436542784p+0,  0x1.9720c6p-21, INEXACT) // -2.834461098455401742435277867571e-03
T(RZ,   -0x1.7384bb7075fd4p-9,    0x1.0000436542783p+0,  -0x1.ffffe6p-1, INEXACT) // -2.834461098455401742435277867571e-03
T(RD,   -0x1.763ec1c59bd99p-3,    0x1.0449433830a6fp+0,  -0x1.fffff4p-1, INEXACT) // -1.827368868284622582809362256739e-01
T(RU,   -0x1.763ec1c59bd99p-3,     0x1.0449433830a7p+0,   0x1.600e5p-22, INEXACT) // -1.827368868284622582809362256739e-01
T(RZ,   -0x1.763ec1c59bd99p-3,    0x1.0449433830a6fp+0,  -0x1.fffff4p-1, INEXACT) // -1.827368868284622582809362256739e-01
T(RN,   0x1.dc63f3baf930dp-10,    0x1.00001bb41f4b1p+0,  -0x1.ffffc4p-2, INEXACT) // 1.817285300370122301874542536382e-03
T(RN,   -0x1.974c6445d2603p-4,    0x1.0144465d6cf24p+0,   0x1.ffffe6p-2, INEXACT) // -9.943808716811734782492493422978e-02
T(RN,    0x1.b1446951c9275p+5,   0x1.18edc7de2aff4p+77,  -0x1.ffffcep-2, INEXACT) // 5.415840400595781289894148358144e+01
T(RN,   -0x1.ec46ccb46133ap+4,   0x1.4ef3a78077c6bp+43,  -0x1.ffffeap-2, INEXACT) // -3.076728506527727091679480508901e+01
T(RD,   -0x1.391308cbfc3c4p+8,  0x1.978b96126f7e1p+450,  -0x1.fffff8p-1, INEXACT) // -3.130743529787835086608538404107e+02
T(RU,   -0x1.391308cbfc3c4p+8,  0x1.978b96126f7e2p+450,  0x1.1f2154p-22, INEXACT) // -3.130743529787835086608538404107e+02
T(RZ,   -0x1.391308cbfc3c4p+8,  0x1.978b96126f7e1p+450,  -0x1.fffff8p-1, INEXACT) // -3.130743529787835086608538404107e+02
T(RN,   -0x1.6706e60c385ffp+1,    0x1.095fdc8305c12p+3,  -0x1.fffff2p-2, INEXACT) // -2.804898029295827210916058902512e+00
T(RN,   -0x1.54a1d9dde0308p-4,    0x1.00e2c09a0edacp+0,  -0x1.ffffdep-2, INEXACT) // -8.316216568165313294258567111683e-02
T(RD,    0x1.198ba82af08f3p-4,    0x1.009ae18d30ba7p+0,  -0x1.f728dp-22, INEXACT) // 6.873670282860526448143190236806e-02
T(RU,    0x1.198ba82af08f3p-4,    0x1.009ae18d30ba8p+0,    0x1.fffffp-1, INEXACT) // 6.873670282860526448143190236806e-02
T(RZ,    0x1.198ba82af08f3p-4,    0x1.009ae18d30ba7p+0,  -0x1.f728dp-22, INEXACT) // 6.873670282860526448143190236806e-02
T(RD,   -0x1.9201f56f0e078p-1,    0x1.530ca98d4a671p+0,   -0x1.fffffp-1, INEXACT) // -7.851711938919967437300329038408e-01
T(RU,   -0x1.9201f56f0e078p-1,    0x1.530ca98d4a672p+0,   0x1.0583fp-21, INEXACT) // -7.851711938919967437300329038408e-01
T(RZ,   -0x1.9201f56f0e078p-1,    0x1.530ca98d4a671p+0,   -0x1.fffffp-1, INEXACT) // -7.851711938919967437300329038408e-01
T(RD,   -0x1.b17e6f346fbc4p-8,    0x1.00016f06d103dp+0, -0x1.d5a346p-21, INEXACT) // -6.614591741196333002372753639975e-03
T(RU,   -0x1.b17e6f346fbc4p-8,    0x1.00016f06d103ep+0,   0x1.ffffe2p-1, INEXACT) // -6.614591741196333002372753639975e-03
T(RZ,   -0x1.b17e6f346fbc4p-8,    0x1.00016f06d103dp+0, -0x1.d5a346p-21, INEXACT) // -6.614591741196333002372753639975e-03
T(RN,   -0x1.f1b178de08d85p+7,  0x1.01be55d2d108dp+358,  -0x1.fffff6p-2, INEXACT) // -2.488466252694890101793134817854e+02
T(RN,   -0x1.ac231025db384p+2,    0x1.92045bf7ccce1p+8,   0x1.fffff6p-2, INEXACT) // -6.689640080422467605103520327248e+00
T(RD,    0x1.d0eea2106579dp-6,    0x1.001a63835bc86p+0, -0x1.10efcap-24, INEXACT) // 2.837720705573297877433169844608e-02
T(RU,    0x1.d0eea2106579dp-6,    0x1.001a63835bc87p+0,   0x1.fffffep-1, INEXACT) // 2.837720705573297877433169844608e-02
T(RZ,    0x1.d0eea2106579dp-6,    0x1.001a63835bc86p+0, -0x1.10efcap-24, INEXACT) // 2.837720705573297877433169844608e-02
T(RN,   -0x1.d417ad0b2e617p+5,   0x1.552afd0b765e2p+83,   0x1.ffffe2p-2, INEXACT) // -5.851156052336971669092235970311e+01
T(RD,     0x1.d3ea0927997fp+1,    0x1.35b9f00934f47p+4,  -0x1.ffffe8p-1, INEXACT) // 3.655579704604853930050012422726e+00
T(RU,     0x1.d3ea0927997fp+1,    0x1.35b9f00934f48p+4,  0x1.7f7748p-21, INEXACT) // 3.655579704604853930050012422726e+00
T(RZ,     0x1.d3ea0927997fp+1,    0x1.35b9f00934f47p+4,  -0x1.ffffe8p-1, INEXACT) // 3.655579704604853930050012422726e+00
T(RN,   -0x1.6919c71f454b1p-7,    0x1.0003fab60ffcap+0,  -0x1.ffffe2p-2, INEXACT) // -1.101991865884097317185297271180e-02
T(RN,   -0x1.85b11bf238b0ep+5,    0x1.35eeab469e82p+69,   0x1.ffffe4p-2, INEXACT) // -4.871147908435351325806550448760e+01
T(RD,   -0x1.61ccf2928c454p+2,    0x1.f75b0bbfa040fp+6,  -0x1.ffffe4p-1, INEXACT) // -5.528134005654539606666730833240e+00
T(RU,   -0x1.61ccf2928c454p+2,     0x1.f75b0bbfa041p+6,  0x1.c5c3eep-21, INEXACT) // -5.528134005654539606666730833240e+00
T(RZ,   -0x1.61ccf2928c454p+2,    0x1.f75b0bbfa040fp+6,  -0x1.ffffe4p-1, INEXACT) // -5.528134005654539606666730833240e+00
T(RN,  -0x1.a67b893999f0ap-10,    0x1.000015c9dc6f5p+0,  -0x1.fffffep-2, INEXACT) // -1.611643076467164040904700428314e-03
T(RN,    0x1.1d4f2c2ee190ap+9,  0x1.2bf0bc6ebd89bp+822,  -0x1.ffffd4p-2, INEXACT) // 5.706185358621016803226666525006e+02
T(RD,    0x1.467e12241e846p+7,  0x1.6db40724b724cp+234,  -0x1.fffff4p-1, INEXACT) // 1.632462321555378252924128901213e+02
T(RU,    0x1.467e12241e846p+7,  0x1.6db40724b724dp+234,  0x1.6c98f4p-22, INEXACT) // 1.632462321555378252924128901213e+02
T(RZ,    0x1.467e12241e846p+7,  0x1.6db40724b724cp+234,  -0x1.fffff4p-1, INEXACT) // 1.632462321555378252924128901213e+02
T(RD,    0x1.7b5d0f9088697p+0,     0x1.2838ab587216p+1,   -0x1.293ap-22, INEXACT) // 1.481888745104162685706228330673e+00
T(RU,    0x1.7b5d0f9088697p+0,    0x1.2838ab5872161p+1,   0x1.fffff6p-1, INEXACT) // 1.481888745104162685706228330673e+00
T(RZ,    0x1.7b5d0f9088697p+0,     0x1.2838ab587216p+1,   -0x1.293ap-22, INEXACT) // 1.481888745104162685706228330673e+00
T(RD,    0x1.7b24c2098dbe4p-1,    0x1.497500eb5877cp+0, -0x1.232ca6p-21, INEXACT) // 7.405148159658634376967256685020e-01
T(RU,    0x1.7b24c2098dbe4p-1,    0x1.497500eb5877dp+0,   0x1.ffffeep-1, INEXACT) // 7.405148159658634376967256685020e-01
T(RZ,    0x1.7b24c2098dbe4p-1,    0x1.497500eb5877cp+0, -0x1.232ca6p-21, INEXACT) // 7.405148159658634376967256685020e-01
T(RD,    0x1.c2f513082d1b6p-9,    0x1.0000634c569c1p+0,         -0x1p+0, INEXACT) // 3.440531323656704880409318292322e-03
T(RU,    0x1.c2f513082d1b6p-9,    0x1.0000634c569c2p+0,  0x1.b741e6p-26, INEXACT) // 3.440531323656704880409318292322e-03
T(RZ,    0x1.c2f513082d1b6p-9,    0x1.0000634c569c1p+0,         -0x1p+0, INEXACT) // 3.440531323656704880409318292322e-03
T(RN,   -0x1.912dff039418bp-5,    0x1.004e9a2989052p+0,  -0x1.ffffdcp-2, INEXACT) // -4.897212798516922122038508291553e-02
T(RD,   -0x1.52bb192304f21p-5,    0x1.0038085e0c251p+0,   -0x1.fffffp-1, INEXACT) // -4.134898099451179281915713659146e-02
T(RU,   -0x1.52bb192304f21p-5,    0x1.0038085e0c252p+0,  0x1.e0bb54p-22, INEXACT) // -4.134898099451179281915713659146e-02
T(RZ,   -0x1.52bb192304f21p-5,    0x1.0038085e0c251p+0,   -0x1.fffffp-1, INEXACT) // -4.134898099451179281915713659146e-02
T(RD,    0x1.fd8ce70dcd6a5p-8,    0x1.0001fb1d7599cp+0,  -0x1.ffffeap-1, INEXACT) // 7.775122079512951540902765401597e-03
T(RU,    0x1.fd8ce70dcd6a5p-8,    0x1.0001fb1d7599dp+0,  0x1.597e2ep-21, INEXACT) // 7.775122079512951540902765401597e-03
T(RZ,    0x1.fd8ce70dcd6a5p-8,    0x1.0001fb1d7599cp+0,  -0x1.ffffeap-1, INEXACT) // 7.775122079512951540902765401597e-03
T(RN,    -0x1.a86b1bb411eap+5,    0x1.73c692d1f574p+75,   0x1.ffffc8p-2, INEXACT) // -5.305229893378896122158039361238e+01
T(RD,   0x1.895acca8fadc8p-10,    0x1.000012e33f801p+0, -0x1.3c04fep-23, INEXACT) // 1.500529042682484728854497291195e-03
T(RU,   0x1.895acca8fadc8p-10,    0x1.000012e33f802p+0,   0x1.fffffcp-1, INEXACT) // 1.500529042682484728854497291195e-03
T(RZ,   0x1.895acca8fadc8p-10,    0x1.000012e33f801p+0, -0x1.3c04fep-23, INEXACT) // 1.500529042682484728854497291195e-03
T(RD,    0x1.9a8a18853e54ap+2,    0x1.315f8149764a8p+8, -0x1.ea71bep-21, INEXACT) // 6.414678697701058140978602750693e+00
T(RU,    0x1.9a8a18853e54ap+2,    0x1.315f8149764a9p+8,   0x1.ffffe2p-1, INEXACT) // 6.414678697701058140978602750693e+00
T(RZ,    0x1.9a8a18853e54ap+2,    0x1.315f8149764a8p+8, -0x1.ea71bep-21, INEXACT) // 6.414678697701058140978602750693e+00
T(RD,   -0x1.6c5d81a1d6181p-8,     0x1.0001034d312cp+0, -0x1.b5b554p-24, INEXACT) // -5.559772633056404324281007944819e-03
T(RU,   -0x1.6c5d81a1d6181p-8,    0x1.0001034d312c1p+0,   0x1.fffffcp-1, INEXACT) // -5.559772633056404324281007944819e-03
T(RZ,   -0x1.6c5d81a1d6181p-8,     0x1.0001034d312cp+0, -0x1.b5b554p-24, INEXACT) // -5.559772633056404324281007944819e-03
T(RN,    0x1.3d094a234d855p-8,    0x1.0000c4501a0ffp+0,  -0x1.fffffcp-2, INEXACT) // 4.837589836190832499884795225853e-03
T(RD,    0x1.d143a60efe06bp+0,    0x1.94627ab0f83dfp+1,   -0x1.fffffp-1, INEXACT) // 1.817438486728884639020975555468e+00
T(RU,    0x1.d143a60efe06bp+0,     0x1.94627ab0f83ep+1,  0x1.03c056p-21, INEXACT) // 1.817438486728884639020975555468e+00
T(RZ,    0x1.d143a60efe06bp+0,    0x1.94627ab0f83dfp+1,   -0x1.fffffp-1, INEXACT) // 1.817438486728884639020975555468e+00
T(RN,    0x1.9e6bf5506501ep-2,    0x1.1540b2e0bc02bp+0,   0x1.ffffc8p-2, INEXACT) // 4.047087030714936473074772038672e-01
T(RD,   -0x1.f55d7be1301f4p-4,    0x1.01eb9084c2997p+0,  -0x1.33c61p-21, INEXACT) // -1.224036063240488414471940359363e-01
T(RU,   -0x1.f55d7be1301f4p-4,    0x1.01eb9084c2998p+0,   0x1.ffffecp-1, INEXACT) // -1.224036063240488414471940359363e-01
T(RZ,   -0x1.f55d7be1301f4p-4,    0x1.01eb9084c2997p+0,  -0x1.33c61p-21, INEXACT) // -1.224036063240488414471940359363e-01
T(RN,   -0x1.0a0b0f1ce14cfp-3,    0x1.0229bd2562b51p+0,   0x1.ffffdcp-2, INEXACT) // -1.299039059341908497469120220558e-01
T(RN,    0x1.fc237482bffb8p+2,   0x1.5ecd5e68e5d9bp+10,   0x1.ffffe8p-2, INEXACT) // 7.939664008794288463377597508952e+00
T(RN,    0x1.5cf406021ea08p-5,     0x1.003b775858b7p+0,   0x1.ffffc2p-2, INEXACT) // 4.259682820789484347656639329216e-02
T(RD,    0x1.2499696909914p-2,    0x1.0a85b38253b99p+0,  -0x1.fffffap-1, INEXACT) // 2.857414694175457459124345405144e-01
T(RU,    0x1.2499696909914p-2,    0x1.0a85b38253b9ap+0,  0x1.68ebbcp-23, INEXACT) // 2.857414694175457459124345405144e-01
T(RZ,    0x1.2499696909914p-2,    0x1.0a85b38253b99p+0,  -0x1.fffffap-1, INEXACT) // 2.857414694175457459124345405144e-01
T(RN,    0x1.4e23734ef081fp-4,    0x1.00da2f39eff62p+0,   0x1.ffffdcp-2, INEXACT) // 8.157677690817920213017799824229e-02
T(RN,   -0x1.a9fbf145be0b5p+5,   0x1.c425ff5f88774p+75,   0x1.fffff8p-2, INEXACT) // -5.324801878439158286937527009286e+01
T(RN,   -0x1.cdd964f01d465p+3,   0x1.c49b0c0aaf11ep+19,  -0x1.ffffd8p-2, INEXACT) // -1.443278738877615730018533213297e+01
T(RN,   -0x1.c626abe3b22ecp-8,     0x1.000192d70168p+0,  -0x1.ffffdap-2, INEXACT) // -6.929795232004858779317757466742e-03
T(RD,   -0x1.c77cc80424208p+8,   0x1.18086716464fp+656,  -0x1.fffff4p-1, INEXACT) // -4.554874270046425408509094268084e+02
T(RU,   -0x1.c77cc80424208p+8,  0x1.18086716464f1p+656,  0x1.83f702p-22, INEXACT) // -4.554874270046425408509094268084e+02
T(RZ,   -0x1.c77cc80424208p+8,   0x1.18086716464fp+656,  -0x1.fffff4p-1, INEXACT) // -4.554874270046425408509094268084e+02
T(RN,     0x1.ccee688bc36ep+5,    0x1.16c407c8ab8ep+82,  -0x1.ffffd2p-2, INEXACT) // 5.761641034307626796362455934286e+01
T(RN,   -0x1.d9608e2732ddfp-8,    0x1.0001b5ab75918p+0,   0x1.ffffcep-2, INEXACT) // -7.223162370063345404103127833650e-03
T(RD,   -0x1.7f65294220148p+7,  0x1.79b6a8e72cd08p+275, -0x1.b548fcp-23, INEXACT) // -1.916975804008636714570457115769e+02
T(RU,   -0x1.7f65294220148p+7,  0x1.79b6a8e72cd09p+275,   0x1.fffffap-1, INEXACT) // -1.916975804008636714570457115769e+02
T(RZ,   -0x1.7f65294220148p+7,  0x1.79b6a8e72cd08p+275, -0x1.b548fcp-23, INEXACT) // -1.916975804008636714570457115769e+02
T(RN,  -0x1.c5ca0015b54d8p-10,    0x1.000019232486dp+0,         -0x1p-1, INEXACT) // -1.731067900825158586974872321207e-03
T(RN,   -0x1.21e05d8b8e893p-3,    0x1.029191717788bp+0,   0x1.fffff8p-2, INEXACT) // -1.415412243093824018469462089342e-01
T(RN,   -0x1.f0c28ac3d0bf5p-6,    0x1.001e202aaa034p+0,  -0x1.fffff4p-2, INEXACT) // -3.031981993923334520180112860999e-02
T(RD,    0x1.73517aaaaedf6p-4,    0x1.010d79db5ec65p+0,  -0x1.fffffap-1, INEXACT) // 9.065387646381126152128615558468e-02
T(RU,    0x1.73517aaaaedf6p-4,    0x1.010d79db5ec66p+0,  0x1.53f228p-23, INEXACT) // 9.065387646381126152128615558468e-02
T(RZ,    0x1.73517aaaaedf6p-4,    0x1.010d79db5ec65p+0,  -0x1.fffffap-1, INEXACT) // 9.065387646381126152128615558468e-02
T(RD,   -0x1.ccc19b31ab1d3p-6,    0x1.0019eab2b081ap+0, -0x1.79db44p-23, INEXACT) // -2.812233119645830489718996147985e-02
T(RU,   -0x1.ccc19b31ab1d3p-6,    0x1.0019eab2b081bp+0,   0x1.fffffap-1, INEXACT) // -2.812233119645830489718996147985e-02
T(RZ,   -0x1.ccc19b31ab1d3p-6,    0x1.0019eab2b081ap+0, -0x1.79db44p-23, INEXACT) // -2.812233119645830489718996147985e-02
T(RD,   -0x1.a154122a1e47cp+4,   0x1.8c22bf0d4db84p+36,  -0x1.fffffep-1, INEXACT) // -2.608302513554052382005465915427e+01
T(RU,   -0x1.a154122a1e47cp+4,   0x1.8c22bf0d4db85p+36,  0x1.a621a8p-25, INEXACT) // -2.608302513554052382005465915427e+01
T(RZ,   -0x1.a154122a1e47cp+4,   0x1.8c22bf0d4db84p+36,  -0x1.fffffep-1, INEXACT) // -2.608302513554052382005465915427e+01
T(RN,    0x1.320ecf6a80607p+3,   0x1.bd38b687ab799p+12,   -0x1.ffffep-2, INEXACT) // 9.564307888041197358575118414592e+00
T(RD,   -0x1.004bac83c3ed6p+6,   0x1.5b12dd269b103p+91,  -0x1.ffffecp-1, INEXACT) // -6.407390027888627059837745036930e+01
T(RU,   -0x1.004bac83c3ed6p+6,   0x1.5b12dd269b104p+91,  0x1.360b7ap-21, INEXACT) // -6.407390027888627059837745036930e+01
T(RZ,   -0x1.004bac83c3ed6p+6,   0x1.5b12dd269b103p+91,  -0x1.ffffecp-1, INEXACT) // -6.407390027888627059837745036930e+01
T(RD,    0x1.01cce3ba74957p-3,    0x1.0207e9a6e8c2bp+0,  -0x1.ffffe4p-1, INEXACT) // 1.258790770794557534184576752523e-01
T(RU,    0x1.01cce3ba74957p-3,    0x1.0207e9a6e8c2cp+0,  0x1.cb721ep-21, INEXACT) // 1.258790770794557534184576752523e-01
T(RZ,    0x1.01cce3ba74957p-3,    0x1.0207e9a6e8c2bp+0,  -0x1.ffffe4p-1, INEXACT) // 1.258790770794557534184576752523e-01
T(RD,   -0x1.205d183ba01f9p-3,    0x1.028ab62164da9p+0, -0x1.dbefb4p-25, INEXACT) // -1.408025639721157962203079705432e-01
T(RU,   -0x1.205d183ba01f9p-3,    0x1.028ab62164daap+0,   0x1.fffffep-1, INEXACT) // -1.408025639721157962203079705432e-01
T(RZ,   -0x1.205d183ba01f9p-3,    0x1.028ab62164da9p+0, -0x1.dbefb4p-25, INEXACT) // -1.408025639721157962203079705432e-01
T(RN,    0x1.4c8666f495aaep+7,  0x1.d29d8fe12a3b9p+238,   0x1.ffffd4p-2, INEXACT) // 1.662625042374324380034522619098e+02
T(RD,  -0x1.315d5a12a2f51p-10,    0x1.00000b61fcaaep+0,  -0x1.fffffep-1, INEXACT) // -1.164873716933596337411160881459e-03
T(RU,  -0x1.315d5a12a2f51p-10,    0x1.00000b61fcaafp+0,   0x1.ddd01p-25, INEXACT) // -1.164873716933596337411160881459e-03
T(RZ,  -0x1.315d5a12a2f51p-10,    0x1.00000b61fcaaep+0,  -0x1.fffffep-1, INEXACT) // -1.164873716933596337411160881459e-03
T(RN,    0x1.5927f7d062796p-4,    0x1.00e8d1a1a4e07p+0,   0x1.ffffdcp-2, INEXACT) // 8.426663210243953705536057441350e-02
T(RN,   -0x1.137022dbe320fp-5,    0x1.00250c28383dbp+0,  -0x1.ffffd2p-2, INEXACT) // -3.362280662904392619649840412421e-02
T(RN,    -0x1.706ed12ab661p-2,    0x1.10bfebf63c3c8p+0,  -0x1.ffffecp-2, INEXACT) // -3.597977335280981847631665004883e-01
T(RN,    0x1.918c3043c8b01p-1,    0x1.52d9903290808p+0,    0x1.fffffp-2, INEXACT) // 7.842726786369383917829622987483e-01
T(RN,   -0x1.b5a8283e0f51ap+1,    0x1.e93d92aae756cp+3,  -0x1.ffffcep-2, INEXACT) // -3.419194250395446665891086013289e+00
T(RN,    0x1.2810407760334p+0,     0x1.bf26ab0135fdp+0,  -0x1.ffffcep-2, INEXACT) // 1.156497983116605787756725476356e+00
T(RN,   -0x1.efce170fcb732p-4,    0x1.01e0b577e4a2dp+0,   0x1.ffffecp-2, INEXACT) // -1.210461521957000574634122358475e-01
T(RD,   -0x1.5696f19a07f81p+6,  0x1.7a38ba4c542b6p+122,  -0x1.ffffe6p-1, INEXACT) // -8.564740601228369598629797110334e+01
T(RU,   -0x1.5696f19a07f81p+6,  0x1.7a38ba4c542b7p+122,  0x1.a2e28ep-21, INEXACT) // -8.564740601228369598629797110334e+01
T(RZ,   -0x1.5696f19a07f81p+6,  0x1.7a38ba4c542b6p+122,  -0x1.ffffe6p-1, INEXACT) // -8.564740601228369598629797110334e+01
T(RN,    0x1.098b75e2e24d8p+1,    0x1.02c66b4d91f52p+2,  -0x1.ffffcep-2, INEXACT) // 2.074568496497345648776899906807e+00
T(RD,    0x1.a140d0ce2949fp+6,  0x1.681afe66cb73ap+149, -0x1.ff48bcp-24, INEXACT) // 1.043132965290737814711974351667e+02
T(RU,    0x1.a140d0ce2949fp+6,  0x1.681afe66cb73bp+149,   0x1.fffffcp-1, INEXACT) // 1.043132965290737814711974351667e+02
T(RZ,    0x1.a140d0ce2949fp+6,  0x1.681afe66cb73ap+149, -0x1.ff48bcp-24, INEXACT) // 1.043132965290737814711974351667e+02
T(RN,   -0x1.7aca1064a40d6p+5,   0x1.3d4ba045f5f49p+67,  -0x1.fffff8p-2, INEXACT) // -4.734866407991073344874166650698e+01
T(RD,     0x1.35eeb93fbf91p+4,   0x1.ed3c2809719b4p+26, -0x1.bbbfe8p-24, INEXACT) // 1.937078213597948206370347179472e+01
T(RU,     0x1.35eeb93fbf91p+4,   0x1.ed3c2809719b5p+26,   0x1.fffffcp-1, INEXACT) // 1.937078213597948206370347179472e+01
T(RZ,     0x1.35eeb93fbf91p+4,   0x1.ed3c2809719b4p+26, -0x1.bbbfe8p-24, INEXACT) // 1.937078213597948206370347179472e+01
T(RD,   -0x1.c4e4923d3f5bfp+8,  0x1.4e98ac6d4c86fp+652, -0x1.f73b84p-22, INEXACT) // -4.528928564338384035181661602110e+02
T(RU,   -0x1.c4e4923d3f5bfp+8,   0x1.4e98ac6d4c87p+652,    0x1.fffffp-1, INEXACT) // -4.528928564338384035181661602110e+02
T(RZ,   -0x1.c4e4923d3f5bfp+8,  0x1.4e98ac6d4c86fp+652, -0x1.f73b84p-22, INEXACT) // -4.528928564338384035181661602110e+02
T(RN,    0x1.7d22c0d6dc493p+2,    0x1.81c642d62444fp+7,   0x1.ffffd4p-2, INEXACT) // 5.955246171784113862202048039762e+00
T(RD,    0x1.e8cff264029cep+1,    0x1.6c96a9d05f6b5p+4, -0x1.eb1066p-21, INEXACT) // 3.818846033890827662560241151368e+00
T(RU,    0x1.e8cff264029cep+1,    0x1.6c96a9d05f6b6p+4,   0x1.ffffe2p-1, INEXACT) // 3.818846033890827662560241151368e+00
T(RZ,    0x1.e8cff264029cep+1,    0x1.6c96a9d05f6b5p+4, -0x1.eb1066p-21, INEXACT) // 3.818846033890827662560241151368e+00
T(RN,   -0x1.e7d5220a788dcp-4,    0x1.01d15b04ec38cp+0,  -0x1.ffffe2p-2, INEXACT) // -1.190997438166365163247917280387e-01
T(RN,    0x1.72a58bb4c1cd4p-1,    0x1.460f897ef4155p+0,  -0x1.ffffe4p-2, INEXACT) // 7.239192636633569044590785779292e-01
T(RN,    0x1.8a0034d375a2ap+6,  0x1.13785c94798f4p+141,  -0x1.ffffdcp-2, INEXACT) // 9.850020151525009737270011100918e+01
T(RD,   -0x1.9582d42bd18ccp+0,    0x1.4519bd133fffcp+1,  -0x1.ffffe2p-1, INEXACT) // -1.584027538965119497049727215199e+00
T(RU,   -0x1.9582d42bd18ccp+0,    0x1.4519bd133fffdp+1,  0x1.e7ca66p-21, INEXACT) // -1.584027538965119497049727215199e+00
T(RZ,   -0x1.9582d42bd18ccp+0,    0x1.4519bd133fffcp+1,  -0x1.ffffe2p-1, INEXACT) // -1.584027538965119497049727215199e+00
T(RN,    0x1.c3a705ecd02dbp+0,    0x1.808d00f5134f1p+1,   0x1.ffffdep-2, INEXACT) // 1.764267320934030491841326693248e+00
T(RD,    0x1.245947eb46a4bp-3,     0x1.029cda0c9786p+0, -0x1.479fb2p-21, INEXACT) // 1.427484148669740660064775283900e-01
T(RU,    0x1.245947eb46a4bp-3,    0x1.029cda0c97861p+0,   0x1.ffffecp-1, INEXACT) // 1.427484148669740660064775283900e-01
T(RZ,    0x1.245947eb46a4bp-3,     0x1.029cda0c9786p+0, -0x1.479fb2p-21, INEXACT) // 1.427484148669740660064775283900e-01
T(RN,   -0x1.42e7ded72cf1dp-3,    0x1.0330489af6e76p+0,   0x1.ffffccp-2, INEXACT) // -1.576688203255053599693980004304e-01
T(RN,   -0x1.376630cbe8145p+8,  0x1.314b479ffdb8ap+448,  -0x1.fffff4p-2, INEXACT) // -3.113991820756530728431243915111e+02
T(RN,    0x1.9f3c16d3f71edp+5,   0x1.d7d56a74be751p+73,  -0x1.fffffep-2, INEXACT) // 5.190434041593457692442825646140e+01
T(RN,   -0x1.752b881f81f53p+0,    0x1.21d82f7caabe4p+1,  -0x1.ffffd2p-2, INEXACT) // -1.457695491497322803908787136606e+00
T(RD,    0x1.2cc7fad613d23p-7,    0x1.0002c2cbe5769p+0,  -0x1.fffffcp-1, INEXACT) // 9.179112890847001757221867990211e-03
T(RU,    0x1.2cc7fad613d23p-7,    0x1.0002c2cbe576ap+0,  0x1.0a94c2p-23, INEXACT) // 9.179112890847001757221867990211e-03
T(RZ,    0x1.2cc7fad613d23p-7,    0x1.0002c2cbe5769p+0,  -0x1.fffffcp-1, INEXACT) // 9.179112890847001757221867990211e-03
T(RD,    0x1.54d07a2d0abaap+7,  0x1.cc08b24b4380fp+244,  -0x1.ffffecp-1, INEXACT) // 1.704071821284863403889175970107e+02
T(RU,    0x1.54d07a2d0abaap+7,   0x1.cc08b24b4381p+244,  0x1.37ea94p-21, INEXACT) // 1.704071821284863403889175970107e+02
T(RZ,    0x1.54d07a2d0abaap+7,  0x1.cc08b24b4380fp+244,  -0x1.ffffecp-1, INEXACT) // 1.704071821284863403889175970107e+02
T(RD,   0x1.2c053f3600225p-10,    0x1.00000afce2762p+0,  -0x1.fffff2p-1, INEXACT) // 1.144487364854404306060975393677e-03
T(RU,   0x1.2c053f3600225p-10,    0x1.00000afce2763p+0,  0x1.caaf66p-22, INEXACT) // 1.144487364854404306060975393677e-03
T(RZ,   0x1.2c053f3600225p-10,    0x1.00000afce2762p+0,  -0x1.fffff2p-1, INEXACT) // 1.144487364854404306060975393677e-03
T(RN,   -0x1.88c586d0ea4bfp+5,   0x1.c7778fe56c5a1p+69,   0x1.fffffep-2, INEXACT) // -4.909644854750649045627142186277e+01
T(RD,  -0x1.be24b1e6ffe07p-10,    0x1.0000184c1f6b7p+0,  -0x1.fffff4p-1, INEXACT) // -1.701901777550919722323263805208e-03
T(RU,  -0x1.be24b1e6ffe07p-10,    0x1.0000184c1f6b8p+0,  0x1.8113b2p-22, INEXACT) // -1.701901777550919722323263805208e-03
T(RZ,  -0x1.be24b1e6ffe07p-10,    0x1.0000184c1f6b7p+0,  -0x1.fffff4p-1, INEXACT) // -1.701901777550919722323263805208e-03
T(RN,   -0x1.ef200c1eacd02p+7,  0x1.1d7edc8988ebfp+356,   0x1.ffffe6p-2, INEXACT) // -2.475625924669221262774954084307e+02
T(RD,    0x1.f9ddb069e0818p+2,   0x1.52907eb7798a1p+10,  -0x1.ffffe2p-1, INEXACT) // 7.904155829806789768099406501278e+00
T(RU,    0x1.f9ddb069e0818p+2,   0x1.52907eb7798a2p+10,  0x1.e024bcp-21, INEXACT) // 7.904155829806789768099406501278e+00
T(RZ,    0x1.f9ddb069e0818p+2,   0x1.52907eb7798a1p+10,  -0x1.ffffe2p-1, INEXACT) // 7.904155829806789768099406501278e+00
T(RD,    0x1.509a17937bea7p+2,    0x1.80be91863e495p+6, -0x1.9fd984p-21, INEXACT) // 5.259405035045040754937417659676e+00
T(RU,    0x1.509a17937bea7p+2,    0x1.80be91863e496p+6,   0x1.ffffe6p-1, INEXACT) // 5.259405035045040754937417659676e+00
T(RZ,    0x1.509a17937bea7p+2,    0x1.80be91863e495p+6, -0x1.9fd984p-21, INEXACT) // 5.259405035045040754937417659676e+00
T(RN,    0x1.67a424d4f660ap+2,    0x1.13b9ca8be0ddbp+7,   0x1.ffffccp-2, INEXACT) // 5.619393547030549385112863092218e+00
T(RN,    0x1.933775851986dp-5,    0x1.004f670f7538ep+0,   0x1.ffffeap-2, INEXACT) // 4.922078087911150451327912946908e-02
T(RD,    0x1.ee001b89b6fb6p+7,   0x1.456113126fbbp+355,  -0x1.ffffeap-1, INEXACT) // 2.470002100978724115520890336484e+02
T(RU,    0x1.ee001b89b6fb6p+7,  0x1.456113126fbb1p+355,  0x1.5201aep-21, INEXACT) // 2.470002100978724115520890336484e+02
T(RZ,    0x1.ee001b89b6fb6p+7,   0x1.456113126fbbp+355,  -0x1.ffffeap-1, INEXACT) // 2.470002100978724115520890336484e+02
T(RD,    0x1.eddf2c34b4925p-3,    0x1.077acb3967993p+0,  -0x1.ffffe6p-1, INEXACT) // 2.411483243545912424909971605302e-01
T(RU,    0x1.eddf2c34b4925p-3,    0x1.077acb3967994p+0,   0x1.9a849p-21, INEXACT) // 2.411483243545912424909971605302e-01
T(RZ,    0x1.eddf2c34b4925p-3,    0x1.077acb3967993p+0,  -0x1.ffffe6p-1, INEXACT) // 2.411483243545912424909971605302e-01
T(RN,    0x1.366c29578eabfp-4,     0x1.00bc4c21b4d6p+0,   0x1.ffffd8p-2, INEXACT) // 7.578674458720068007888670535976e-02
T(RN,    0x1.6219b9fbdb5b5p+4,   0x1.e74ec4c708f2bp+30,  -0x1.ffffd8p-2, INEXACT) // 2.213128088361346001988749776501e+01
T(RN,   -0x1.79cde4f172971p-3,    0x1.045e4aa1e1898p+0,   0x1.fffff6p-2, INEXACT) // -1.844747434791531859321622732750e-01
T(RN,    0x1.30b9ea977129ep-8,    0x1.0000b55d1f807p+0,   0x1.ffffdap-2, INEXACT) // 4.649753354389800016899236823065e-03
T(RN,   -0x1.7acec300862e7p-2,    0x1.11b7992905819p+0,  -0x1.ffffc8p-2, INEXACT) // -3.699293583936608675877266705356e-01
T(RD,    0x1.2d2c8ec6b53c9p-5,    0x1.002c4b80e2c2ap+0, -0x1.b7e9c8p-22, INEXACT) // 3.676441083886278909931277780743e-02
T(RU,    0x1.2d2c8ec6b53c9p-5,    0x1.002c4b80e2c2bp+0,   0x1.fffff2p-1, INEXACT) // 3.676441083886278909931277780743e-02
T(RZ,    0x1.2d2c8ec6b53c9p-5,    0x1.002c4b80e2c2ap+0, -0x1.b7e9c8p-22, INEXACT) // 3.676441083886278909931277780743e-02
T(RN,    0x1.cc1dbf80563cfp-5,    0x1.00676652a0013p+0,   0x1.ffffd6p-2, INEXACT) // 5.616652872658500078584253856206e-02
T(RN,     0x1.61424247b725p+7,  0x1.c4b066e01239fp+253,   0x1.ffffc4p-2, INEXACT) // 1.766294119273247815726790577173e+02
T(RD,    0x1.e04bb2a5f36a3p+8,  0x1.e474502e73fc4p+691,  -0x1.ffffeep-1, INEXACT) // 4.802956947058939363159879576415e+02
T(RU,    0x1.e04bb2a5f36a3p+8,  0x1.e474502e73fc5p+691,  0x1.153b96p-21, INEXACT) // 4.802956947058939363159879576415e+02
T(RZ,    0x1.e04bb2a5f36a3p+8,  0x1.e474502e73fc4p+691,  -0x1.ffffeep-1, INEXACT) // 4.802956947058939363159879576415e+02
T(RN,   -0x1.06551d93be75cp+6,   0x1.88789f5d429ecp+93,   0x1.ffffd6p-2, INEXACT) // -6.558312064027762744444771669805e+01
T(RN,   -0x1.f07c1f27522cfp-2,    0x1.1eaf205b8d8f4p+0,  -0x1.ffffdep-2, INEXACT) // -4.848484866857178388066529350908e-01
T(RN,   -0x1.aa7ef3a7afeccp+7,  0x1.9232cfb6360bep+306,    0x1.ffffdp-2, INEXACT) // -2.132479526903392752501531504095e+02
T(RN,    0x1.7ceffb441bba5p-7,    0x1.00046db5ea977p+0,   0x1.ffffccp-2, INEXACT) // 1.162528771257404815175906520608e-02
T(RD,    0x1.71c8ef4ad94c5p-9,    0x1.000042c49ed89p+0, -0x1.b2fc04p-23, INEXACT) // 2.821234903808008624009895370932e-03
T(RU,    0x1.71c8ef4ad94c5p-9,    0x1.000042c49ed8ap+0,   0x1.fffffap-1, INEXACT) // 2.821234903808008624009895370932e-03
T(RZ,    0x1.71c8ef4ad94c5p-9,    0x1.000042c49ed89p+0, -0x1.b2fc04p-23, INEXACT) // 2.821234903808008624009895370932e-03
T(RN,    0x1.26b3c5708a835p+2,    0x1.8fdc65ea97646p+5,  -0x1.fffffcp-2, INEXACT) // 4.604722366240868502984540100442e+00
T(RD,   -0x1.3549aaf0150d5p-5,    0x1.002eb6c91cc02p+0,  -0x1.e806bp-21, INEXACT) // -3.775485407155235867415754569265e-02
T(RU,   -0x1.3549aaf0150d5p-5,    0x1.002eb6c91cc03p+0,   0x1.ffffe2p-1, INEXACT) // -3.775485407155235867415754569265e-02
T(RZ,   -0x1.3549aaf0150d5p-5,    0x1.002eb6c91cc02p+0,  -0x1.e806bp-21, INEXACT) // -3.775485407155235867415754569265e-02
T(RN,     0x1.c5ed50ccaef5p-1,    0x1.6b601d42812f2p+0,  -0x1.ffffe4p-2, INEXACT) // 8.865761995179841647995999665000e-01
T(RD,    0x1.13faa2e60969ep-7,    0x1.00025309c53cbp+0,  -0x1.ffffe2p-1, INEXACT) // 8.422212162325689449593468793864e-03
T(RU,    0x1.13faa2e60969ep-7,    0x1.00025309c53ccp+0,  0x1.dc4a3ep-21, INEXACT) // 8.422212162325689449593468793864e-03
T(RZ,    0x1.13faa2e60969ep-7,    0x1.00025309c53cbp+0,  -0x1.ffffe2p-1, INEXACT) // 8.422212162325689449593468793864e-03
T(RN,   -0x1.bcf0a2fd32508p+4,   0x1.161dc68c490a8p+39,  -0x1.fffffcp-2, INEXACT) // -2.780874918846987498000089544803e+01
T(RN,   -0x1.2a845a0f6714dp-5,    0x1.002b844852e96p+0,  -0x1.ffffdep-2, INEXACT) // -3.644006338001535422188581492264e-02
T(RN,   -0x1.f14f1f730ceacp+8,  0x1.6171715fcdb73p+716,  -0x1.ffffecp-2, INEXACT) // -4.973090736300025582750095054507e+02
T(RD,   -0x1.524049fd83ae4p-5,    0x1.0037dfc2a4132p+0,         -0x1p+0, INEXACT) // -4.129042102078075981985705311672e-02
T(RU,   -0x1.524049fd83ae4p-5,    0x1.0037dfc2a4133p+0,  0x1.5204f6p-26, INEXACT) // -4.129042102078075981985705311672e-02
T(RZ,   -0x1.524049fd83ae4p-5,    0x1.0037dfc2a4132p+0,         -0x1p+0, INEXACT) // -4.129042102078075981985705311672e-02
T(RD,   -0x1.7f82d1099d639p+4,   0x1.7ed66e82cca65p+33,  -0x1.fffffap-1, INEXACT) // -2.396943763500005175615115149412e+01
T(RU,   -0x1.7f82d1099d639p+4,   0x1.7ed66e82cca66p+33,  0x1.bcfd8ap-23, INEXACT) // -2.396943763500005175615115149412e+01
T(RZ,   -0x1.7f82d1099d639p+4,   0x1.7ed66e82cca65p+33,  -0x1.fffffap-1, INEXACT) // -2.396943763500005175615115149412e+01
T(RD,    0x1.90a7d721dc4f2p-7,    0x1.0004e61ddc99fp+0, -0x1.1a920cp-21, INEXACT) // 1.222703938012379212829650043659e-02
T(RU,    0x1.90a7d721dc4f2p-7,     0x1.0004e61ddc9ap+0,   0x1.ffffeep-1, INEXACT) // 1.222703938012379212829650043659e-02
T(RZ,    0x1.90a7d721dc4f2p-7,    0x1.0004e61ddc99fp+0, -0x1.1a920cp-21, INEXACT) // 1.222703938012379212829650043659e-02
T(RD,    0x1.5b4325b6b8dfcp-5,    0x1.003ae4251f2bfp+0,  -0x1.ffffe2p-1, INEXACT) // 4.239041677444885247716399589990e-02
T(RU,    0x1.5b4325b6b8dfcp-5,     0x1.003ae4251f2cp+0,  0x1.ddd4e6p-21, INEXACT) // 4.239041677444885247716399589990e-02
T(RZ,    0x1.5b4325b6b8dfcp-5,    0x1.003ae4251f2bfp+0,  -0x1.ffffe2p-1, INEXACT) // 4.239041677444885247716399589990e-02
T(RN,    0x1.4ca2af8cbee2ap-2,    0x1.0da036097d98fp+0,   0x1.ffffe4p-2, INEXACT) // 3.248393468527149829938593939005e-01
T(RN,    0x1.1420044f8a0e3p-2,    0x1.095d21631b352p+0,   0x1.ffffc8p-2, INEXACT) // 2.696533845469401557970456906332e-01
T(RD,    0x1.954db829382e7p+5,   0x1.10b3e3f03cacbp+72,  -0x1.fffffap-1, INEXACT) // 5.066294891550733581198073807172e+01
T(RU,    0x1.954db829382e7p+5,   0x1.10b3e3f03caccp+72,  0x1.5e5d64p-23, INEXACT) // 5.066294891550733581198073807172e+01
T(RZ,    0x1.954db829382e7p+5,   0x1.10b3e3f03cacbp+72,  -0x1.fffffap-1, INEXACT) // 5.066294891550733581198073807172e+01
T(RN,    0x1.0894f158fccddp+4,   0x1.cfa967974f1c6p+22,  -0x1.ffffe8p-2, INEXACT) // 1.653636297951458189459117420483e+01
T(RN,   -0x1.c433a16a2002fp-7,    0x1.00063d9336647p+0,  -0x1.ffffd8p-2, INEXACT) // -1.380010015077467837307789721990e-02
T(RD,    0x1.e680f49125369p-4,    0x1.01ced2223730ap+0, -0x1.2ec2bep-21, INEXACT) // 1.187753251454758546268308805338e-01
T(RU,    0x1.e680f49125369p-4,    0x1.01ced2223730bp+0,   0x1.ffffeep-1, INEXACT) // 1.187753251454758546268308805338e-01
T(RZ,    0x1.e680f49125369p-4,    0x1.01ced2223730ap+0, -0x1.2ec2bep-21, INEXACT) // 1.187753251454758546268308805338e-01
T(RN,    0x1.f2d55bce2e006p+4,   0x1.f89cd35417001p+43,   0x1.fffff6p-2, INEXACT) // 3.117708950556700386869124486111e+01
T(RD,   -0x1.c2f51966dd492p-5,    0x1.006352be83e59p+0, -0x1.2f0a78p-21, INEXACT) // -5.504851304332548933562208048897e-02
T(RU,   -0x1.c2f51966dd492p-5,    0x1.006352be83e5ap+0,   0x1.ffffeep-1, INEXACT) // -5.504851304332548933562208048897e-02
T(RZ,   -0x1.c2f51966dd492p-5,    0x1.006352be83e59p+0, -0x1.2f0a78p-21, INEXACT) // -5.504851304332548933562208048897e-02
T(RN,   -0x1.5cc8ab3ce12c7p+7,  0x1.82836edf211c8p+250,   0x1.ffffc4p-2, INEXACT) // -1.743919314408178422581841005012e+02
T(RN,    0x1.c3a0101823e2dp-2,    0x1.194de8bfeebbep+0,  -0x1.ffffecp-2, INEXACT) // 4.410402788862224920940491301735e-01
T(RN,   -0x1.05447f5b8504cp+1,    0x1.f5143a00db471p+1,   -0x1.ffffep-2, INEXACT) // -2.041152877509409435674569976982e+00
T(RD,   -0x1.2b11153e1ae73p-2,    0x1.0afef3d05f2e6p+0,  -0x1.ffffeap-1, INEXACT) // -2.920573538928927237456889542955e-01
T(RU,   -0x1.2b11153e1ae73p-2,    0x1.0afef3d05f2e7p+0,  0x1.5a2d2ep-21, INEXACT) // -2.920573538928927237456889542955e-01
T(RZ,   -0x1.2b11153e1ae73p-2,    0x1.0afef3d05f2e6p+0,  -0x1.ffffeap-1, INEXACT) // -2.920573538928927237456889542955e-01
T(RN,    0x1.e07454f5e352ap+1,    0x1.5590e0fcb1eebp+4,  -0x1.ffffc8p-2, INEXACT) // 3.753550167143335336561449366855e+00
T(RD,   -0x1.95c2cd63cda65p+1,    0x1.7d9838f3fb7e6p+3, -0x1.25194ep-22, INEXACT) // -3.170007394535149902736748117604e+00
T(RU,   -0x1.95c2cd63cda65p+1,    0x1.7d9838f3fb7e7p+3,   0x1.fffff6p-1, INEXACT) // -3.170007394535149902736748117604e+00
T(RZ,   -0x1.95c2cd63cda65p+1,    0x1.7d9838f3fb7e6p+3, -0x1.25194ep-22, INEXACT) // -3.170007394535149902736748117604e+00
T(RD,    0x1.eb600fd1720f3p+4,   0x1.3c9acf8a916dbp+43, -0x1.22a808p-21, INEXACT) // 3.071095258536020011774780869018e+01
T(RU,    0x1.eb600fd1720f3p+4,   0x1.3c9acf8a916dcp+43,   0x1.ffffeep-1, INEXACT) // 3.071095258536020011774780869018e+01
T(RZ,    0x1.eb600fd1720f3p+4,   0x1.3c9acf8a916dbp+43, -0x1.22a808p-21, INEXACT) // 3.071095258536020011774780869018e+01
T(RD,    0x1.a23b86553613ep+7,  0x1.9d48bd7805fbcp+300, -0x1.93673ap-21, INEXACT) // 2.091162592533600559363549109548e+02
T(RU,    0x1.a23b86553613ep+7,  0x1.9d48bd7805fbdp+300,   0x1.ffffe6p-1, INEXACT) // 2.091162592533600559363549109548e+02
T(RZ,    0x1.a23b86553613ep+7,  0x1.9d48bd7805fbcp+300, -0x1.93673ap-21, INEXACT) // 2.091162592533600559363549109548e+02
T(RD,   -0x1.fc4f4b99b2ff6p+8,   0x1.43202def3d05p+732,   -0x1.fffffp-1, INEXACT) // -5.083097473203664549146196804941e+02
T(RU,   -0x1.fc4f4b99b2ff6p+8,  0x1.43202def3d051p+732,   0x1.0ca3ap-21, INEXACT) // -5.083097473203664549146196804941e+02
T(RZ,   -0x1.fc4f4b99b2ff6p+8,   0x1.43202def3d05p+732,   -0x1.fffffp-1, INEXACT) // -5.083097473203664549146196804941e+02
T(RN,    0x1.6999a22f0e379p+0,    0x1.166233adf04eep+1,  -0x1.ffffecp-2, INEXACT) // 1.412500511634986688491721906757e+00
T(RN,    0x1.eef7e8582d014p-8,    0x1.0001de816f744p+0,   0x1.fffffap-2, INEXACT) // 7.552618241039272400927373496415e-03
T(RD,   -0x1.e283786c17f63p+4,   0x1.6beca0853629fp+42, -0x1.b45a38p-21, INEXACT) // -3.015709726547300917331995151471e+01
T(RU,   -0x1.e283786c17f63p+4,    0x1.6beca085362ap+42,   0x1.ffffe4p-1, INEXACT) // -3.015709726547300917331995151471e+01
T(RZ,   -0x1.e283786c17f63p+4,   0x1.6beca0853629fp+42, -0x1.b45a38p-21, INEXACT) // -3.015709726547300917331995151471e+01
T(RD,   -0x1.9c76f9edb1a9dp-5,    0x1.00531663aaf16p+0,  -0x1.fffffep-1, INEXACT) // -5.034970106276157736369114559238e-02
T(RU,   -0x1.9c76f9edb1a9dp-5,    0x1.00531663aaf17p+0,  0x1.702ee4p-24, INEXACT) // -5.034970106276157736369114559238e-02
T(RZ,   -0x1.9c76f9edb1a9dp-5,    0x1.00531663aaf16p+0,  -0x1.fffffep-1, INEXACT) // -5.034970106276157736369114559238e-02
T(RD,     0x1.af2e74e7ab2dp+8,  0x1.0b7ed43020539p+621,  -0x1.ffffeep-1, INEXACT) // 4.311814713280591604416258633137e+02
T(RU,     0x1.af2e74e7ab2dp+8,  0x1.0b7ed4302053ap+621,    0x1.24d9p-21, INEXACT) // 4.311814713280591604416258633137e+02
T(RZ,     0x1.af2e74e7ab2dp+8,  0x1.0b7ed43020539p+621,  -0x1.ffffeep-1, INEXACT) // 4.311814713280591604416258633137e+02
T(RD,    0x1.571c5ae29cdcap+8,  0x1.00bed168aaa79p+494,  -0x1.ffffecp-1, INEXACT) // 3.431107617981875819168635644019e+02
T(RU,    0x1.571c5ae29cdcap+8,  0x1.00bed168aaa7ap+494,   0x1.3a913p-21, INEXACT) // 3.431107617981875819168635644019e+02
T(RZ,    0x1.571c5ae29cdcap+8,  0x1.00bed168aaa79p+494,  -0x1.ffffecp-1, INEXACT) // 3.431107617981875819168635644019e+02
T(RN,    -0x1.cd3d0a4e992cp+5,   0x1.21ad4b6539e6ap+82,   0x1.fffff6p-2, INEXACT) // -5.765480481533950296579860150814e+01
T(RN,    0x1.c720d4ebc58efp-7,    0x1.000652521b2a7p+0,  -0x1.ffffd8p-2, INEXACT) // 1.388941189319978057603588439406e-02
T(RN,   -0x1.a01e7e4911251p+4,   0x1.6f4c8fc6827cdp+36,  -0x1.ffffeep-2, INEXACT) // -2.600744465390954829331349174026e+01
T(RD,    0x1.ba62aa6b78c7bp+4,   0x1.da26a3f98e585p+38, -0x1.dc5dc8p-23, INEXACT) // 2.764908830624743174553259450477e+01
T(RU,    0x1.ba62aa6b78c7bp+4,   0x1.da26a3f98e586p+38,   0x1.fffff8p-1, INEXACT) // 2.764908830624743174553259450477e+01
T(RZ,    0x1.ba62aa6b78c7bp+4,   0x1.da26a3f98e585p+38, -0x1.dc5dc8p-23, INEXACT) // 2.764908830624743174553259450477e+01
T(RN,    -0x1.9e5ac4ea0695p+7,  0x1.db9c877da4949p+297,   0x1.ffffd6p-2, INEXACT) // -2.071772835858378130069468170404e+02
T(RD,    0x1.83987f1deb3c6p+3,   0x1.63aeeb8b8d60cp+16,  -0x1.fffffep-1, INEXACT) // 1.211236530154736712461271963548e+01
T(RU,    0x1.83987f1deb3c6p+3,   0x1.63aeeb8b8d60dp+16,  0x1.382906p-25, INEXACT) // 1.211236530154736712461271963548e+01
T(RZ,    0x1.83987f1deb3c6p+3,   0x1.63aeeb8b8d60cp+16,  -0x1.fffffep-1, INEXACT) // 1.211236530154736712461271963548e+01
T(RD,    0x1.d980a03281dcdp+2,    0x1.985f909ac6559p+9, -0x1.fdeaf4p-22, INEXACT) // 7.398475694011222181245557294460e+00
T(RU,    0x1.d980a03281dcdp+2,    0x1.985f909ac655ap+9,    0x1.fffffp-1, INEXACT) // 7.398475694011222181245557294460e+00
T(RZ,    0x1.d980a03281dcdp+2,    0x1.985f909ac6559p+9, -0x1.fdeaf4p-22, INEXACT) // 7.398475694011222181245557294460e+00
T(RN,    0x1.da49321f8699fp+1,    0x1.4583885430136p+4,  -0x1.ffffd8p-2, INEXACT) // 3.705358758347940817401422464172e+00
T(RN,   0x1.7ccc4309c5968p-10,    0x1.000011b378844p+0,   0x1.fffff2p-2, INEXACT) // 1.452628699956182503627566404703e-03
T(RN,    0x1.a998b4a5d6ce9p+3,   0x1.23914d6ebf5ebp+18,  -0x1.fffffcp-2, INEXACT) // 1.329989082708785197439738112735e+01
T(RD,   0x1.6379ac46ecd53p-10,    0x1.00000f6cd594ap+0,  -0x1.ffffe4p-1, INEXACT) // 1.356030597645514713597836298220e-03
T(RU,   0x1.6379ac46ecd53p-10,    0x1.00000f6cd594bp+0,   0x1.bd01ep-21, INEXACT) // 1.356030597645514713597836298220e-03
T(RZ,   0x1.6379ac46ecd53p-10,    0x1.00000f6cd594ap+0,  -0x1.ffffe4p-1, INEXACT) // 1.356030597645514713597836298220e-03
T(RD,    0x1.db0f7dccf4b1ep+1,    0x1.477cbb9a7857cp+4,  -0x1.ffffeep-1, INEXACT) // 3.711410260273068750791480852058e+00
T(RU,    0x1.db0f7dccf4b1ep+1,    0x1.477cbb9a7857dp+4,  0x1.2faf2ap-21, INEXACT) // 3.711410260273068750791480852058e+00
T(RZ,    0x1.db0f7dccf4b1ep+1,    0x1.477cbb9a7857cp+4,  -0x1.ffffeep-1, INEXACT) // 3.711410260273068750791480852058e+00
T(RN,   -0x1.867eeb3dc8849p+1,    0x1.52db0716b6735p+3,   0x1.ffffecp-2, INEXACT) // -3.050748257796872753289108004537e+00
T(RN,    0x1.0a4134dc5233ep+8,  0x1.170b831979213p+383,   0x1.ffffd6p-2, INEXACT) // 2.662547128391923934032092802227e+02
T(RN,    0x1.638c6f1568969p-2,    0x1.0f964f75192d3p+0,  -0x1.ffffe2p-2, INEXACT) // 3.472154003922214848820715360489e-01
T(RD,   -0x1.660207b1c7849p-9,    0x1.00003e95383dfp+0, -0x1.8432fep-23, INEXACT) // -2.731383742584224134236636771789e-03
T(RU,   -0x1.660207b1c7849p-9,     0x1.00003e95383ep+0,   0x1.fffffap-1, INEXACT) // -2.731383742584224134236636771789e-03
T(RZ,   -0x1.660207b1c7849p-9,    0x1.00003e95383dfp+0, -0x1.8432fep-23, INEXACT) // -2.731383742584224134236636771789e-03
T(RD,    0x1.b261b496c2736p+3,   0x1.7fadfd30f5352p+18,  -0x1.ffffe8p-1, INEXACT) // 1.357442693181256387902067217510e+01
T(RU,    0x1.b261b496c2736p+3,   0x1.7fadfd30f5353p+18,  0x1.702038p-21, INEXACT) // 1.357442693181256387902067217510e+01
T(RZ,    0x1.b261b496c2736p+3,   0x1.7fadfd30f5352p+18,  -0x1.ffffe8p-1, INEXACT) // 1.357442693181256387902067217510e+01
T(RD,   -0x1.76f8ef8011aacp-4,    0x1.0112cf439813fp+0,  -0x1.ffffecp-1, INEXACT) // -9.154599718849948386534265409864e-02
T(RU,   -0x1.76f8ef8011aacp-4,     0x1.0112cf439814p+0,   0x1.46352p-21, INEXACT) // -9.154599718849948386534265409864e-02
T(RZ,   -0x1.76f8ef8011aacp-4,    0x1.0112cf439813fp+0,  -0x1.ffffecp-1, INEXACT) // -9.154599718849948386534265409864e-02
T(RD,     0x1.fe257236103fp-1,    0x1.89f125847e3c6p+0,  -0x1.fffff4p-1, INEXACT) // 9.963794413562236940151706221513e-01
T(RU,     0x1.fe257236103fp-1,    0x1.89f125847e3c7p+0,   0x1.7140cp-22, INEXACT) // 9.963794413562236940151706221513e-01
T(RZ,     0x1.fe257236103fp-1,    0x1.89f125847e3c6p+0,  -0x1.fffff4p-1, INEXACT) // 9.963794413562236940151706221513e-01
T(RD,    0x1.75a7c6d372535p+7,  0x1.7306e57193697p+268,   -0x1.fffffp-1, INEXACT) // 1.868276887967164441306522348896e+02
T(RU,    0x1.75a7c6d372535p+7,  0x1.7306e57193698p+268,  0x1.0f6f58p-21, INEXACT) // 1.868276887967164441306522348896e+02
T(RZ,    0x1.75a7c6d372535p+7,  0x1.7306e57193697p+268,   -0x1.fffffp-1, INEXACT) // 1.868276887967164441306522348896e+02
T(RN,   -0x1.b5cdb51447e44p+6,  0x1.df1f57f0ebab3p+156,  -0x1.ffffdep-2, INEXACT) // -1.094508860749129439682292286307e+02
T(RD,    0x1.a46ed3ffd9f14p-2,    0x1.15e1e806dbb03p+0, -0x1.4c3434p-22, INEXACT) // 4.105790257367385454045916048926e-01
T(RU,    0x1.a46ed3ffd9f14p-2,    0x1.15e1e806dbb04p+0,   0x1.fffff6p-1, INEXACT) // 4.105790257367385454045916048926e-01
T(RZ,    0x1.a46ed3ffd9f14p-2,    0x1.15e1e806dbb03p+0, -0x1.4c3434p-22, INEXACT) // 4.105790257367385454045916048926e-01
T(RD,   -0x1.f5558e8049c83p+2,   0x1.3b6b8f579933dp+10,  -0x1.ffffecp-1, INEXACT) // -7.833346963197189261052244546590e+00
T(RU,   -0x1.f5558e8049c83p+2,   0x1.3b6b8f579933ep+10,  0x1.3b3b2ap-21, INEXACT) // -7.833346963197189261052244546590e+00
T(RZ,   -0x1.f5558e8049c83p+2,   0x1.3b6b8f579933dp+10,  -0x1.ffffecp-1, INEXACT) // -7.833346963197189261052244546590e+00
T(RD,    0x1.821340cf733eap+2,    0x1.a0ba104e4a0dep+7,  -0x1.ffffeap-1, INEXACT) // 6.032425119960842962996139249299e+00
T(RU,    0x1.821340cf733eap+2,    0x1.a0ba104e4a0dfp+7,  0x1.6818e6p-21, INEXACT) // 6.032425119960842962996139249299e+00
T(RZ,    0x1.821340cf733eap+2,    0x1.a0ba104e4a0dep+7,  -0x1.ffffeap-1, INEXACT) // 6.032425119960842962996139249299e+00
T(RN,   -0x1.a39fdd321e3d9p+7,  0x1.9e745f116739ap+301,    0x1.ffffdp-2, INEXACT) // -2.098122344648279806733626173809e+02
T(RD,    0x1.85e481f7865cdp+3,   0x1.7e27011d9e008p+16,  -0x1.fffff2p-1, INEXACT) // 1.218414400429437627337847516173e+01
T(RU,    0x1.85e481f7865cdp+3,   0x1.7e27011d9e009p+16,  0x1.de26b8p-22, INEXACT) // 1.218414400429437627337847516173e+01
T(RZ,    0x1.85e481f7865cdp+3,   0x1.7e27011d9e008p+16,  -0x1.fffff2p-1, INEXACT) // 1.218414400429437627337847516173e+01
T(RD,  -0x1.4ac2f115ea90ap-10,    0x1.00000d5ad96dbp+0,  -0x1.f849cp-23, INEXACT) // -1.261754955957319294240770446436e-03
T(RU,  -0x1.4ac2f115ea90ap-10,    0x1.00000d5ad96dcp+0,   0x1.fffff8p-1, INEXACT) // -1.261754955957319294240770446436e-03
T(RZ,  -0x1.4ac2f115ea90ap-10,    0x1.00000d5ad96dbp+0,  -0x1.f849cp-23, INEXACT) // -1.261754955957319294240770446436e-03
T(RD,    0x1.61ae0c19d6238p-5,    0x1.003d169c45a46p+0, -0x1.8ae3b8p-21, INEXACT) // 4.317381251775426198591389947978e-02
T(RU,    0x1.61ae0c19d6238p-5,    0x1.003d169c45a47p+0,   0x1.ffffe8p-1, INEXACT) // 4.317381251775426198591389947978e-02
T(RZ,    0x1.61ae0c19d6238p-5,    0x1.003d169c45a46p+0, -0x1.8ae3b8p-21, INEXACT) // 4.317381251775426198591389947978e-02
T(RD,   -0x1.9104b218ef088p+5,   0x1.3f37ba187e845p+71,  -0x1.ffffeap-1, INEXACT) // -5.012729281882735676845186389983e+01
T(RU,   -0x1.9104b218ef088p+5,   0x1.3f37ba187e846p+71,  0x1.5177d6p-21, INEXACT) // -5.012729281882735676845186389983e+01
T(RZ,   -0x1.9104b218ef088p+5,   0x1.3f37ba187e845p+71,  -0x1.ffffeap-1, INEXACT) // -5.012729281882735676845186389983e+01
T(RD,    0x1.2bdd448fdae35p+5,   0x1.0df58a563c958p+53,  -0x1.fffffcp-1, INEXACT) // 3.748304092776053408897496410646e+01
T(RU,    0x1.2bdd448fdae35p+5,   0x1.0df58a563c959p+53,  0x1.f62d64p-24, INEXACT) // 3.748304092776053408897496410646e+01
T(RZ,    0x1.2bdd448fdae35p+5,   0x1.0df58a563c958p+53,  -0x1.fffffcp-1, INEXACT) // 3.748304092776053408897496410646e+01
T(RN,   -0x1.cce186a7b3021p-6,    0x1.0019ee4a231fdp+0,   0x1.fffff8p-2, INEXACT) // -2.812994146260916830670772981193e-02
T(RN,   -0x1.e85e98872700cp-9,    0x1.0000747521e35p+0,  -0x1.ffffd4p-2, INEXACT) // -3.725963706143536544046490632809e-03
T(RN,   -0x1.f9b95fc373ba8p+4,   0x1.841e6e59cf19ap+44,  -0x1.ffffc8p-2, INEXACT) // -3.160775734280073834270297084004e+01
T(RD,    0x1.03c1b2044438dp+8,  0x1.ae6abfe15e413p+373, -0x1.acbb0ap-21, INEXACT) // 2.597566225687558585377701092511e+02
T(RU,    0x1.03c1b2044438dp+8,  0x1.ae6abfe15e414p+373,   0x1.ffffe6p-1, INEXACT) // 2.597566225687558585377701092511e+02
T(RZ,    0x1.03c1b2044438dp+8,  0x1.ae6abfe15e413p+373, -0x1.acbb0ap-21, INEXACT) // 2.597566225687558585377701092511e+02
T(RN,    0x1.19ee7ebed31fep-9,    0x1.000026cfaf08ep+0,  -0x1.ffffc4p-2, INEXACT) // 2.150967571117100816946443586630e-03
T(RD,    0x1.9be7b77891b29p+1,     0x1.904b402fbf35p+3,  -0x1.fffffcp-1, INEXACT) // 3.218008931991239496284151755390e+00
T(RU,    0x1.9be7b77891b29p+1,    0x1.904b402fbf351p+3,  0x1.003d5ap-23, INEXACT) // 3.218008931991239496284151755390e+00
T(RZ,    0x1.9be7b77891b29p+1,     0x1.904b402fbf35p+3,  -0x1.fffffcp-1, INEXACT) // 3.218008931991239496284151755390e+00
T(RD,   -0x1.7bc1af41bd062p-4,    0x1.0119df3285befp+0,  -0x1.ffffe2p-1, INEXACT) // -9.271400890048789311670418555877e-02
T(RU,   -0x1.7bc1af41bd062p-4,     0x1.0119df3285bfp+0,  0x1.e74208p-21, INEXACT) // -9.271400890048789311670418555877e-02
T(RZ,   -0x1.7bc1af41bd062p-4,    0x1.0119df3285befp+0,  -0x1.ffffe2p-1, INEXACT) // -9.271400890048789311670418555877e-02
T(RN,    0x1.756bbde2eb959p-9,    0x1.00004416679aap+0,   0x1.ffffe2p-2, INEXACT) // 2.848975114338941645036884509068e-03
T(RN,   -0x1.75f2787b82ad7p-7,    0x1.0004447bfa84cp+0,   0x1.ffffe2p-2, INEXACT) // -1.141196139271498204148524990842e-02
T(RD,    0x1.d9ec4300ec209p+2,    0x1.9b10a1e461d55p+9,  -0x1.ffffe6p-1, INEXACT) // 7.405045271778825544117808021838e+00
T(RU,    0x1.d9ec4300ec209p+2,    0x1.9b10a1e461d56p+9,  0x1.9b0a1ap-21, INEXACT) // 7.405045271778825544117808021838e+00
T(RZ,    0x1.d9ec4300ec209p+2,    0x1.9b10a1e461d55p+9,  -0x1.ffffe6p-1, INEXACT) // 7.405045271778825544117808021838e+00
T(RN,  -0x1.e16c2ad09876fp-10,    0x1.00001c4abdba2p+0,  -0x1.fffffap-2, INEXACT) // -1.836481202325459171839638905510e-03
T(RN,   -0x1.d3273888e5c0cp+2,     0x1.71cdfed1c523p+9,  -0x1.fffff4p-2, INEXACT) // -7.299268850029886124275435577147e+00
T(RN,    0x1.900dc985dc872p-8,    0x1.00013895cadd1p+0,   0x1.ffffc8p-2, INEXACT) // 6.104337406087722087133506931877e-03
T(RD,    0x1.b42c07a2d14e6p+4,   0x1.418f958027eb7p+38, -0x1.76172ep-21, INEXACT) // 2.726074946976304858026196598075e+01
T(RU,    0x1.b42c07a2d14e6p+4,   0x1.418f958027eb8p+38,   0x1.ffffe8p-1, INEXACT) // 2.726074946976304858026196598075e+01
T(RZ,    0x1.b42c07a2d14e6p+4,   0x1.418f958027eb7p+38, -0x1.76172ep-21, INEXACT) // 2.726074946976304858026196598075e+01
T(RD,    0x1.7244d3338a688p-9,    0x1.000042f1638b2p+0, -0x1.5f75f4p-21, INEXACT) // 2.824927121555746017955712545699e-03
T(RU,    0x1.7244d3338a688p-9,    0x1.000042f1638b3p+0,   0x1.ffffeap-1, INEXACT) // 2.824927121555746017955712545699e-03
T(RZ,    0x1.7244d3338a688p-9,    0x1.000042f1638b2p+0, -0x1.5f75f4p-21, INEXACT) // 2.824927121555746017955712545699e-03
T(RN,   -0x1.2a18f627414dfp+0,    0x1.c213ff1021312p+0,  -0x1.ffffdap-2, INEXACT) // -1.164443382819903893832247376849e+00
T(RN,    -0x1.99279747a251p+5,   0x1.b9514d9966287p+72,    0x1.ffffdp-2, INEXACT) // -5.114433151210880623693810775876e+01
T(RD,    0x1.3b7fda226216fp-9,     0x1.0000309a7ddfp+0,  -0x1.fffff2p-1, INEXACT) // 2.407069566462797637756976243395e-03
T(RU,    0x1.3b7fda226216fp-9,    0x1.0000309a7ddf1p+0,  0x1.aa7eecp-22, INEXACT) // 2.407069566462797637756976243395e-03
T(RZ,    0x1.3b7fda226216fp-9,     0x1.0000309a7ddfp+0,  -0x1.fffff2p-1, INEXACT) // 2.407069566462797637756976243395e-03
T(RN,    0x1.2227b163fd146p+8,  0x1.85704f0176a96p+417,  -0x1.fffff6p-2, INEXACT) // 2.901550505154485790626495145261e+02
T(RD,   -0x1.b51d3c92e008ap+4,   0x1.5510d46ba5d27p+38,  -0x1.433d3p-21, INEXACT) // -2.731963784573648723608130239882e+01
T(RU,   -0x1.b51d3c92e008ap+4,   0x1.5510d46ba5d28p+38,   0x1.ffffecp-1, INEXACT) // -2.731963784573648723608130239882e+01
T(RZ,   -0x1.b51d3c92e008ap+4,   0x1.5510d46ba5d27p+38,  -0x1.433d3p-21, INEXACT) // -2.731963784573648723608130239882e+01
T(RD,   -0x1.3c905d7439636p+2,    0x1.195317425fd81p+6,  -0x1.fffff6p-1, INEXACT) // -4.946311343670052096399558649864e+00
T(RU,   -0x1.3c905d7439636p+2,    0x1.195317425fd82p+6,  0x1.44fd7cp-22, INEXACT) // -4.946311343670052096399558649864e+00
T(RZ,   -0x1.3c905d7439636p+2,    0x1.195317425fd81p+6,  -0x1.fffff6p-1, INEXACT) // -4.946311343670052096399558649864e+00
T(RD,   -0x1.3c10bdc77159dp-4,    0x1.00c33574d8a46p+0, -0x1.815e76p-22, INEXACT) // -7.716440327120328845911245707612e-02
T(RU,   -0x1.3c10bdc77159dp-4,    0x1.00c33574d8a47p+0,   0x1.fffff4p-1, INEXACT) // -7.716440327120328845911245707612e-02
T(RZ,   -0x1.3c10bdc77159dp-4,    0x1.00c33574d8a46p+0, -0x1.815e76p-22, INEXACT) // -7.716440327120328845911245707612e-02
T(RN,   -0x1.4f6b8762a13a4p+8,  0x1.e0a47c6afb1f7p+482,  -0x1.ffffdep-2, INEXACT) // -3.354200345653173371829325333238e+02
T(RN,    0x1.1fa7dbee6e2f8p+3,   0x1.f505e000d3723p+11,   -0x1.ffffep-2, INEXACT) // 8.989240613636397370100894477218e+00
T(RN,   -0x1.6be2632ab5b33p+5,   0x1.89ebe15e5ed49p+64,  -0x1.ffffc8p-2, INEXACT) // -4.548554070822719808120382367633e+01
T(RD,    0x1.41fccdc6b00cbp-5,     0x1.0032a129d95dp+0,         -0x1p+0, INEXACT) // 3.930511656426601690972333358332e-02
T(RU,    0x1.41fccdc6b00cbp-5,    0x1.0032a129d95d1p+0,  0x1.8ea266p-26, INEXACT) // 3.930511656426601690972333358332e-02
T(RZ,    0x1.41fccdc6b00cbp-5,     0x1.0032a129d95dp+0,         -0x1p+0, INEXACT) // 3.930511656426601690972333358332e-02
T(RN,     0x1.6ca75b52476fp+1,    0x1.153716849b468p+3,   0x1.ffffe6p-2, INEXACT) // 2.848857321906386630416818661615e+00
T(RN,   -0x1.c0fa9c175f302p-3,    0x1.062d2d7a2649cp+0,   0x1.fffff8p-2, INEXACT) // -2.192280001289859669988402401941e-01
T(RN,    0x1.6a376007682bap+5,   0x1.3fc8ff08a2794p+64,  -0x1.ffffe6p-2, INEXACT) // 4.527703862940457213426270755008e+01
T(RD,    -0x1.6f716885f721p+5,   0x1.334dead1c5467p+65,   -0x1.fffffp-1, INEXACT) // -4.593037514362742967932717874646e+01
T(RU,    -0x1.6f716885f721p+5,   0x1.334dead1c5468p+65,  0x1.08dc74p-21, INEXACT) // -4.593037514362742967932717874646e+01
T(RZ,    -0x1.6f716885f721p+5,   0x1.334dead1c5467p+65,   -0x1.fffffp-1, INEXACT) // -4.593037514362742967932717874646e+01
T(RN,   -0x1.6a9fc2c830c67p-8,    0x1.000100d4463a5p+0,  -0x1.ffffd8p-2, INEXACT) // -5.533204130361380444769192621379e-03
T(RD,    0x1.b360a63f60652p+0,    0x1.6a426268ee26fp+1,   -0x1.fffffp-1, INEXACT) // 1.700693502877034024578506432590e+00
T(RU,    0x1.b360a63f60652p+0,     0x1.6a426268ee27p+1,  0x1.fcf462p-22, INEXACT) // 1.700693502877034024578506432590e+00
T(RZ,    0x1.b360a63f60652p+0,    0x1.6a426268ee26fp+1,   -0x1.fffffp-1, INEXACT) // 1.700693502877034024578506432590e+00
T(RD,   -0x1.e484f7f127c3fp+1,    0x1.60935123471a2p+4,  -0x1.af68ap-22, INEXACT) // -3.785307877303722090545079481672e+00
T(RU,   -0x1.e484f7f127c3fp+1,    0x1.60935123471a3p+4,   0x1.fffff2p-1, INEXACT) // -3.785307877303722090545079481672e+00
T(RZ,   -0x1.e484f7f127c3fp+1,    0x1.60935123471a2p+4,  -0x1.af68ap-22, INEXACT) // -3.785307877303722090545079481672e+00
T(RD,    0x1.d1a5dce8e875fp+5,   0x1.f6ad7dfa412d5p+82,  -0x1.fffff8p-1, INEXACT) // 5.820598775824941384371413732879e+01
T(RU,    0x1.d1a5dce8e875fp+5,   0x1.f6ad7dfa412d6p+82,  0x1.d0224ap-23, INEXACT) // 5.820598775824941384371413732879e+01
T(RZ,    0x1.d1a5dce8e875fp+5,   0x1.f6ad7dfa412d5p+82,  -0x1.fffff8p-1, INEXACT) // 5.820598775824941384371413732879e+01
T(RN,  -0x1.d0d8468ead148p-10,    0x1.00001a608627ep+0,   0x1.fffff6p-2, INEXACT) // -1.773242289044922939678095019644e-03
T(RN,   -0x1.665afa605a7c1p+1,    0x1.07fef69d91113p+3,   0x1.ffffeep-2, INEXACT) // -2.799651429221711840256148207118e+00
T(RD,   -0x1.554c24b821892p-8,    0x1.0000e38219eedp+0, -0x1.6fa76ap-21, INEXACT) // -5.207785572684768896078999489418e-03
T(RU,   -0x1.554c24b821892p-8,    0x1.0000e38219eeep+0,   0x1.ffffeap-1, INEXACT) // -5.207785572684768896078999489418e-03
T(RZ,   -0x1.554c24b821892p-8,    0x1.0000e38219eedp+0, -0x1.6fa76ap-21, INEXACT) // -5.207785572684768896078999489418e-03
T(RD,   0x1.2a4f276513f74p-10,    0x1.00000adce3153p+0, -0x1.111b42p-21, INEXACT) // 1.137959269971814020572242753815e-03
T(RU,   0x1.2a4f276513f74p-10,    0x1.00000adce3154p+0,   0x1.ffffeep-1, INEXACT) // 1.137959269971814020572242753815e-03
T(RZ,   0x1.2a4f276513f74p-10,    0x1.00000adce3153p+0, -0x1.111b42p-21, INEXACT) // 1.137959269971814020572242753815e-03
T(RN,     0x1.4cc0cf55b9bap+0,    0x1.f879792ff7043p+0,   0x1.ffffeap-2, INEXACT) // 1.299817045620990541010542074218e+00
T(RN,   -0x1.883aca6dcd377p-5,    0x1.004b222fbbe48p+0,  -0x1.fffffep-2, INEXACT) // -4.787959610840791108143932319763e-02
T(RN,   -0x1.6893d7e8cba5cp+8,  0x1.26c2359664a3ep+519,  -0x1.ffffc8p-2, INEXACT) // -3.605775132653413947991793975234e+02
T(RD,   -0x1.8698910e10fc7p+5,   0x1.5b040980ea401p+69,  -0x1.ffffeap-1, INEXACT) // -4.882449542035424627783868345432e+01
T(RU,   -0x1.8698910e10fc7p+5,   0x1.5b040980ea402p+69,  0x1.643f78p-21, INEXACT) // -4.882449542035424627783868345432e+01
T(RZ,   -0x1.8698910e10fc7p+5,   0x1.5b040980ea401p+69,  -0x1.ffffeap-1, INEXACT) // -4.882449542035424627783868345432e+01
T(RN,    0x1.135e372f831cbp-2,    0x1.094fecdf5c66dp+0,  -0x1.ffffc6p-2, INEXACT) // 2.689140913724059056555404367828e-01
T(RN,    0x1.0b4632392f18dp+2,    0x1.0485c92d75ff7p+5,   0x1.ffffecp-2, INEXACT) // 4.176159435123179441973206849070e+00
T(RD,   -0x1.29c4508d1720cp+2,    0x1.a3785caf92de8p+5,  -0x1.ffffe6p-1, INEXACT) // -4.652607095511950063837502966635e+00
T(RU,   -0x1.29c4508d1720cp+2,    0x1.a3785caf92de9p+5,  0x1.9cbbb6p-21, INEXACT) // -4.652607095511950063837502966635e+00
T(RZ,   -0x1.29c4508d1720cp+2,    0x1.a3785caf92de8p+5,  -0x1.ffffe6p-1, INEXACT) // -4.652607095511950063837502966635e+00
T(RN,   -0x1.6cd2394ddb904p+7,  0x1.1e97c1ee222cap+262,  -0x1.ffffe4p-2, INEXACT) // -1.824105934458276578880031593144e+02
T(RD,   -0x1.7a4d0847f7fedp+5,   0x1.2a80f825f609dp+67,  -0x1.fffffep-1, INEXACT) // -4.728761345124789983174196095206e+01
T(RU,   -0x1.7a4d0847f7fedp+5,   0x1.2a80f825f609ep+67,  0x1.32531ep-24, INEXACT) // -4.728761345124789983174196095206e+01
T(RZ,   -0x1.7a4d0847f7fedp+5,   0x1.2a80f825f609dp+67,  -0x1.fffffep-1, INEXACT) // -4.728761345124789983174196095206e+01
T(RN,   -0x1.e501f9da45d5fp-8,    0x1.0001cb70c7c92p+0,  -0x1.ffffc2p-2, INEXACT) // -7.400630473305496413727322391196e-03
T(RD,    0x1.8ac53d17fa757p-7,    0x1.0004c18b3521cp+0,  -0x1.fffffap-1, INEXACT) // 1.204743846024640234471103639180e-02
T(RU,    0x1.8ac53d17fa757p-7,    0x1.0004c18b3521dp+0,  0x1.a75182p-23, INEXACT) // 1.204743846024640234471103639180e-02
T(RZ,    0x1.8ac53d17fa757p-7,    0x1.0004c18b3521cp+0,  -0x1.fffffap-1, INEXACT) // 1.204743846024640234471103639180e-02
T(RN,    0x1.45225e89def6dp+7,  0x1.72dff72c17558p+233,   0x1.ffffe2p-2, INEXACT) // 1.625671275219605433903780067340e+02
T(RN,    0x1.6c380b41fbafdp+4,   0x1.ca964d4aff13bp+31,          0x1p-1, INEXACT) // 2.276368261122387437467295967508e+01
T(RN,   -0x1.d53fb7b4f333cp-6,    0x1.001ae18ca2f4ap+0,  -0x1.ffffc8p-2, INEXACT) // -2.864067974205684874444699516971e-02
T(RD,   -0x1.ac37f4c527052p-8,    0x1.00016625e6d95p+0,  -0x1.ffffe8p-1, INEXACT) // -6.534096964198781234967050579598e-03
T(RU,   -0x1.ac37f4c527052p-8,    0x1.00016625e6d96p+0,   0x1.7c9aep-21, INEXACT) // -6.534096964198781234967050579598e-03
T(RZ,   -0x1.ac37f4c527052p-8,    0x1.00016625e6d95p+0,  -0x1.ffffe8p-1, INEXACT) // -6.534096964198781234967050579598e-03
T(RN,    0x1.62d0dce38d2b2p-1,    0x1.3ff8c115d0713p+0,  -0x1.ffffc2p-2, INEXACT) // 6.929997470638993295466434574337e-01
T(RD,    0x1.adf6e5140de3cp+5,   0x1.73d0da7b0485ep+76,  -0x1.fffff4p-1, INEXACT) // 5.374555411975276797420519869775e+01
T(RU,    0x1.adf6e5140de3cp+5,   0x1.73d0da7b0485fp+76,  0x1.6420dap-22, INEXACT) // 5.374555411975276797420519869775e+01
T(RZ,    0x1.adf6e5140de3cp+5,   0x1.73d0da7b0485ep+76,  -0x1.fffff4p-1, INEXACT) // 5.374555411975276797420519869775e+01
T(RD,   -0x1.5cb151f6a494bp+6,   0x1.b2d340107f3ap+124, -0x1.2cbb4ep-21, INEXACT) // -8.717316422824403332469955785200e+01
T(RU,   -0x1.5cb151f6a494bp+6,  0x1.b2d340107f3a1p+124,   0x1.ffffeep-1, INEXACT) // -8.717316422824403332469955785200e+01
T(RZ,   -0x1.5cb151f6a494bp+6,   0x1.b2d340107f3ap+124, -0x1.2cbb4ep-21, INEXACT) // -8.717316422824403332469955785200e+01
T(RN,    0x1.745b211b0cb78p-1,    0x1.46bc975fd1beep+0,  -0x1.ffffcep-2, INEXACT) // 7.272577615279791629632200056221e-01
T(RN,    0x1.598307e96c42fp+6,  0x1.88a336874b45bp+123,   0x1.ffffc4p-2, INEXACT) // 8.637795986865306474555836757645e+01
T(RD,    0x1.c027e6ce82d1ap-4,    0x1.0188aa0f957ffp+0,  -0x1.ffffe8p-1, INEXACT) // 1.094130531202392175860182987890e-01
T(RU,    0x1.c027e6ce82d1ap-4,      0x1.0188aa0f958p+0,  0x1.7d8a6ep-21, INEXACT) // 1.094130531202392175860182987890e-01
T(RZ,    0x1.c027e6ce82d1ap-4,    0x1.0188aa0f957ffp+0,  -0x1.ffffe8p-1, INEXACT) // 1.094130531202392175860182987890e-01
T(RD,    0x1.db60215ef9d4p-10,    0x1.00001b95ef7e5p+0, -0x1.957934p-22, INEXACT) // 1.813413655094311960347397416626e-03
T(RU,    0x1.db60215ef9d4p-10,    0x1.00001b95ef7e6p+0,   0x1.fffff4p-1, INEXACT) // 1.813413655094311960347397416626e-03
T(RZ,    0x1.db60215ef9d4p-10,    0x1.00001b95ef7e5p+0, -0x1.957934p-22, INEXACT) // 1.813413655094311960347397416626e-03
T(RD,     -0x1.eb2e38b304cp+5,   0x1.7e24957c279fap+87, -0x1.6ea68ep-21, INEXACT) // -6.139756908281560754403471946716e+01
T(RU,     -0x1.eb2e38b304cp+5,   0x1.7e24957c279fbp+87,   0x1.ffffeap-1, INEXACT) // -6.139756908281560754403471946716e+01
T(RZ,     -0x1.eb2e38b304cp+5,   0x1.7e24957c279fap+87, -0x1.6ea68ep-21, INEXACT) // -6.139756908281560754403471946716e+01
T(RD,    -0x1.cef1bc700284p-9,    0x1.000068a5b42e4p+0, -0x1.639c54p-24, INEXACT) // -3.531984570149609981015714765817e-03
T(RU,    -0x1.cef1bc700284p-9,    0x1.000068a5b42e5p+0,   0x1.fffffep-1, INEXACT) // -3.531984570149609981015714765817e-03
T(RZ,    -0x1.cef1bc700284p-9,    0x1.000068a5b42e4p+0, -0x1.639c54p-24, INEXACT) // -3.531984570149609981015714765817e-03
T(RN,    0x1.0232e4b147cfcp-5,    0x1.00208e047f187p+0,   0x1.ffffdep-2, INEXACT) // 3.151840845588968487156478204270e-02
T(RN,    0x1.c62380e08d8dap+5,   0x1.dd092830a57c8p+80,  -0x1.ffffe4p-2, INEXACT) // 5.676733565742479470372927607968e+01
T(RN,    0x1.5c6a79f027b8dp+6,  0x1.95c26f92b50ccp+124,  -0x1.fffff2p-2, INEXACT) // 8.710398078195994742145558120683e+01
T(RD,   -0x1.3fc90d10f973dp-4,    0x1.00c7d55060f7fp+0,  -0x1.ffffe2p-1, INEXACT) // -7.807259658838190674590151729717e-02
T(RU,   -0x1.3fc90d10f973dp-4,     0x1.00c7d55060f8p+0,  0x1.db99e4p-21, INEXACT) // -7.807259658838190674590151729717e-02
T(RZ,   -0x1.3fc90d10f973dp-4,    0x1.00c7d55060f7fp+0,  -0x1.ffffe2p-1, INEXACT) // -7.807259658838190674590151729717e-02
T(RN,    0x1.4304e606cc48cp+3,   0x1.7a373d7e8b34bp+13,   0x1.ffffd6p-2, INEXACT) // 1.009434796645862064679022296332e+01
T(RN,    0x1.58cc8b1e7ca0fp+8,  0x1.5b3e5b4c10553p+496,   0x1.ffffe2p-2, INEXACT) // 3.447989977888364023783651646227e+02
T(RD,    0x1.133cedf7b77a7p+8,  0x1.0f7174ae661f8p+396,  -0x1.fffffcp-1, INEXACT) // 2.752380060980744360676908399910e+02
T(RU,    0x1.133cedf7b77a7p+8,  0x1.0f7174ae661f9p+396,  0x1.25ff2cp-23, INEXACT) // 2.752380060980744360676908399910e+02
T(RZ,    0x1.133cedf7b77a7p+8,  0x1.0f7174ae661f8p+396,  -0x1.fffffcp-1, INEXACT) // 2.752380060980744360676908399910e+02
T(RD,  -0x1.552e24faaf79fp-10,    0x1.00000e359fd85p+0, -0x1.68c362p-23, INEXACT) // -1.301499373468108016957400785429e-03
T(RU,  -0x1.552e24faaf79fp-10,    0x1.00000e359fd86p+0,   0x1.fffffap-1, INEXACT) // -1.301499373468108016957400785429e-03
T(RZ,  -0x1.552e24faaf79fp-10,    0x1.00000e359fd85p+0, -0x1.68c362p-23, INEXACT) // -1.301499373468108016957400785429e-03
T(RN,    0x1.8ccef8a0dc5a4p-2,    0x1.137669a67e0c3p+0,  -0x1.ffffc8p-2, INEXACT) // 3.875082824880229370734241456375e-01
T(RD,    0x1.d038ba4047b09p+7,  0x1.d24b1e6d0b025p+333,  -0x1.fffffap-1, INEXACT) // 2.321107959830772244913532631472e+02
T(RU,    0x1.d038ba4047b09p+7,  0x1.d24b1e6d0b026p+333,   0x1.6c276p-23, INEXACT) // 2.321107959830772244913532631472e+02
T(RZ,    0x1.d038ba4047b09p+7,  0x1.d24b1e6d0b025p+333,  -0x1.fffffap-1, INEXACT) // 2.321107959830772244913532631472e+02
T(RD,   -0x1.5dcabe2f71037p+3,   0x1.b49424d3e64eep+14, -0x1.353beap-21, INEXACT) // -1.093099889055166151763387460960e+01
T(RU,   -0x1.5dcabe2f71037p+3,   0x1.b49424d3e64efp+14,   0x1.ffffecp-1, INEXACT) // -1.093099889055166151763387460960e+01
T(RZ,   -0x1.5dcabe2f71037p+3,   0x1.b49424d3e64eep+14, -0x1.353beap-21, INEXACT) // -1.093099889055166151763387460960e+01
T(RD,   -0x1.c4627cde52333p+2,     0x1.25998bd013dbp+9,  -0x1.fffffap-1, INEXACT) // -7.068511216268961838693485333351e+00
T(RU,   -0x1.c4627cde52333p+2,    0x1.25998bd013db1p+9,  0x1.bb46cep-23, INEXACT) // -7.068511216268961838693485333351e+00
T(RZ,   -0x1.c4627cde52333p+2,     0x1.25998bd013dbp+9,  -0x1.fffffap-1, INEXACT) // -7.068511216268961838693485333351e+00
T(RD,    0x1.9674a2331475bp+4,   0x1.918f0cb29c222p+35,  -0x1.fffffcp-1, INEXACT) // 2.540347499802679109848213556688e+01
T(RU,    0x1.9674a2331475bp+4,   0x1.918f0cb29c223p+35,  0x1.36ef86p-23, INEXACT) // 2.540347499802679109848213556688e+01
T(RZ,    0x1.9674a2331475bp+4,   0x1.918f0cb29c222p+35,  -0x1.fffffcp-1, INEXACT) // 2.540347499802679109848213556688e+01
T(RD,    0x1.1cd8fcad71442p-9,    0x1.0000279e46172p+0, -0x1.e304f8p-21, INEXACT) // 2.173214764044335313430966749593e-03
T(RU,    0x1.1cd8fcad71442p-9,    0x1.0000279e46173p+0,   0x1.ffffe2p-1, INEXACT) // 2.173214764044335313430966749593e-03
T(RZ,    0x1.1cd8fcad71442p-9,    0x1.0000279e46172p+0, -0x1.e304f8p-21, INEXACT) // 2.173214764044335313430966749593e-03
T(RN,   -0x1.e79ce5bf4d424p+7,  0x1.ab12f477f2d3cp+350,   0x1.ffffd6p-2, INEXACT) // -2.438064403325853390924748964608e+02
T(RN,   -0x1.5fa339e97e5d2p+1,    0x1.f533542dffc45p+2,  -0x1.fffffcp-2, INEXACT) // -2.747168768892813695003951579565e+00
T(RD,    0x1.d7f581c450389p-1,    0x1.74af66d2cb772p+0,  -0x1.fffffap-1, INEXACT) // 9.217949440136276040291818389960e-01
T(RU,    0x1.d7f581c450389p-1,    0x1.74af66d2cb773p+0,  0x1.8c516cp-23, INEXACT) // 9.217949440136276040291818389960e-01
T(RZ,    0x1.d7f581c450389p-1,    0x1.74af66d2cb772p+0,  -0x1.fffffap-1, INEXACT) // 9.217949440136276040291818389960e-01
T(RN,    0x1.fa5a0049cf933p+2,   0x1.55249d7670fd1p+10,   0x1.ffffdep-2, INEXACT) // 7.911743232804201220176310016541e+00
T(RN,   -0x1.76440c94068e8p+5,   0x1.6884c0e7b732cp+66,  -0x1.ffffd2p-2, INEXACT) // -4.678322711606034545184229500592e+01
T(RD,    0x1.c25b3f8896632p+4,   0x1.862a074d00bbdp+39,  -0x1.ffffe6p-1, INEXACT) // 2.814727738718483607271991786547e+01
T(RU,    0x1.c25b3f8896632p+4,   0x1.862a074d00bbep+39,  0x1.9fa684p-21, INEXACT) // 2.814727738718483607271991786547e+01
T(RZ,    0x1.c25b3f8896632p+4,   0x1.862a074d00bbdp+39,  -0x1.ffffe6p-1, INEXACT) // 2.814727738718483607271991786547e+01
T(RN,   -0x1.84cc43aa20617p-5,    0x1.0049d30613b19p+0,  -0x1.fffff4p-2, INEXACT) // -4.746068206533154282267261692141e-02
T(RD,    0x1.e57e0e0e20bcfp-4,    0x1.01cce579a992bp+0,  -0x1.ffffe2p-1, INEXACT) // 1.185284184485191211200216798716e-01
T(RU,    0x1.e57e0e0e20bcfp-4,    0x1.01cce579a992cp+0,  0x1.ed4ea8p-21, INEXACT) // 1.185284184485191211200216798716e-01
T(RZ,    0x1.e57e0e0e20bcfp-4,    0x1.01cce579a992bp+0,  -0x1.ffffe2p-1, INEXACT) // 1.185284184485191211200216798716e-01
T(RD,     0x1.d57cb3b7a5d9p-2,    0x1.1b61937489781p+0,  -0x1.ffffe8p-1, INEXACT) // 4.584835129585025370602124894504e-01
T(RU,     0x1.d57cb3b7a5d9p-2,    0x1.1b61937489782p+0,  0x1.717872p-21, INEXACT) // 4.584835129585025370602124894504e-01
T(RZ,     0x1.d57cb3b7a5d9p-2,    0x1.1b61937489781p+0,  -0x1.ffffe8p-1, INEXACT) // 4.584835129585025370602124894504e-01
T(RN,    0x1.346d30a39c83ap+0,    0x1.d162715a0e469p+0,  -0x1.fffffap-2, INEXACT) // 1.204791107124505433745298432768e+00
T(RD,    0x1.36d5357b8791fp+8,  0x1.5a92311c6f003p+447, -0x1.f5c456p-22, INEXACT) // 3.108328473287564861493592616171e+02
T(RU,    0x1.36d5357b8791fp+8,  0x1.5a92311c6f004p+447,    0x1.fffffp-1, INEXACT) // 3.108328473287564861493592616171e+02
T(RZ,    0x1.36d5357b8791fp+8,  0x1.5a92311c6f003p+447, -0x1.f5c456p-22, INEXACT) // 3.108328473287564861493592616171e+02
T(RD,    0x1.c72c71f02661bp-5,    0x1.0065308a71fe6p+0, -0x1.54631cp-22, INEXACT) // 5.556318524868349845169390732735e-02
T(RU,    0x1.c72c71f02661bp-5,    0x1.0065308a71fe7p+0,   0x1.fffff6p-1, INEXACT) // 5.556318524868349845169390732735e-02
T(RZ,    0x1.c72c71f02661bp-5,    0x1.0065308a71fe6p+0, -0x1.54631cp-22, INEXACT) // 5.556318524868349845169390732735e-02
T(RD,   -0x1.03f7aa60e8875p-7,    0x1.00020ffeda336p+0,  -0x1.fffffap-1, INEXACT) // -7.933576767588082848114972023268e-03
T(RU,   -0x1.03f7aa60e8875p-7,    0x1.00020ffeda337p+0,  0x1.905478p-23, INEXACT) // -7.933576767588082848114972023268e-03
T(RZ,   -0x1.03f7aa60e8875p-7,    0x1.00020ffeda336p+0,  -0x1.fffffap-1, INEXACT) // -7.933576767588082848114972023268e-03
T(RD,   -0x1.0aa9b2f8f36d2p-4,    0x1.008aef1b8075dp+0,  -0x1.ffffe2p-1, INEXACT) // -6.510324393385794050637116470170e-02
T(RU,   -0x1.0aa9b2f8f36d2p-4,    0x1.008aef1b8075ep+0,  0x1.e61ca6p-21, INEXACT) // -6.510324393385794050637116470170e-02
T(RZ,   -0x1.0aa9b2f8f36d2p-4,    0x1.008aef1b8075dp+0,  -0x1.ffffe2p-1, INEXACT) // -6.510324393385794050637116470170e-02
T(RN,    0x1.6fbe8e9026427p-6,    0x1.0010824cc0a8fp+0,    0x1.ffffdp-2, INEXACT) // 2.244533464599754099544348662221e-02
T(RD,   -0x1.5dd9285499e72p-5,    0x1.003bc58d51b5ep+0, -0x1.91442ep-21, INEXACT) // -4.270608784719066852719748794698e-02
T(RU,   -0x1.5dd9285499e72p-5,    0x1.003bc58d51b5fp+0,   0x1.ffffe6p-1, INEXACT) // -4.270608784719066852719748794698e-02
T(RZ,   -0x1.5dd9285499e72p-5,    0x1.003bc58d51b5ep+0, -0x1.91442ep-21, INEXACT) // -4.270608784719066852719748794698e-02
T(RD,   -0x1.a79f1d419b3afp-4,    0x1.015ecf9cf3c56p+0, -0x1.e4295cp-23, INEXACT) // -1.034232275794255556666811912692e-01
T(RU,   -0x1.a79f1d419b3afp-4,    0x1.015ecf9cf3c57p+0,   0x1.fffff8p-1, INEXACT) // -1.034232275794255556666811912692e-01
T(RZ,   -0x1.a79f1d419b3afp-4,    0x1.015ecf9cf3c56p+0, -0x1.e4295cp-23, INEXACT) // -1.034232275794255556666811912692e-01
T(RN,   -0x1.0016e6be1798bp+1,    0x1.e1e2b7ee15b12p+1,   0x1.ffffccp-2, INEXACT) // -2.000698893373912934379177386290e+00
T(RN,    0x1.9305105bf43f5p-2,    0x1.1415a38837bb5p+0,  -0x1.fffff8p-2, INEXACT) // 3.935740047573397792923799443088e-01
T(RN,    0x1.8c9df391aff74p-3,    0x1.04d0ca96caaa2p+0,   0x1.ffffcep-2, INEXACT) // 1.936606434664970288750396321120e-01
T(RN,   -0x1.4649673fe94b1p+3,   0x1.a2e082110cb87p+13,   -0x1.ffffep-2, INEXACT) // -1.019646036608387085209415090503e+01
T(RN,   -0x1.9a7a47ee14e3ep+1,    0x1.8bde6e7228a82p+3,    0x1.ffffdp-2, INEXACT) // -3.206856719256193422040723817190e+00
T(RD,    0x1.9bcde9f974d55p+1,     0x1.8ffad915750dp+3,  -0x1.fffff4p-1, INEXACT) // 3.217221495442269318942862810218e+00
T(RU,    0x1.9bcde9f974d55p+1,    0x1.8ffad915750d1p+3,  0x1.682466p-22, INEXACT) // 3.217221495442269318942862810218e+00
T(RZ,    0x1.9bcde9f974d55p+1,     0x1.8ffad915750dp+3,  -0x1.fffff4p-1, INEXACT) // 3.217221495442269318942862810218e+00
T(RN,    0x1.c0e4dda2f8e35p+2,    0x1.1603db589b08cp+9,    0x1.fffffp-2, INEXACT) // 7.013968857910687582091213698732e+00
T(RD,    0x1.e0d2f6c49f592p+4,   0x1.4774b9437c27fp+42,  -0x1.ffffeep-1, INEXACT) // 3.005150486760755512705145520158e+01
T(RU,    0x1.e0d2f6c49f592p+4,    0x1.4774b9437c28p+42,  0x1.11c73cp-21, INEXACT) // 3.005150486760755512705145520158e+01
T(RZ,    0x1.e0d2f6c49f592p+4,   0x1.4774b9437c27fp+42,  -0x1.ffffeep-1, INEXACT) // 3.005150486760755512705145520158e+01
T(RN,    0x1.b0b5c0b195bf2p+8,  0x1.345f58b7ab718p+623,  -0x1.ffffe8p-2, INEXACT) // 4.327099715223877183234435506165e+02
T(RD,   -0x1.cd190d871c408p-5,    0x1.0067d76c1045ap+0,  -0x1.ffffe2p-1, INEXACT) // -5.628636018889926484476404766610e-02
T(RU,   -0x1.cd190d871c408p-5,    0x1.0067d76c1045bp+0,  0x1.dd30f2p-21, INEXACT) // -5.628636018889926484476404766610e-02
T(RZ,   -0x1.cd190d871c408p-5,    0x1.0067d76c1045ap+0,  -0x1.ffffe2p-1, INEXACT) // -5.628636018889926484476404766610e-02
T(RN,    -0x1.7661503b2fdap+0,    0x1.2313b29cd1dc5p+1,   -0x1.fffffp-2, INEXACT) // -1.462422384691173249393614241853e+00
T(RD,   -0x1.524e19b6d1f27p-2,    0x1.0e1939046e964p+0, -0x1.384664p-23, INEXACT) // -3.303760545572793083657359147765e-01
T(RU,   -0x1.524e19b6d1f27p-2,    0x1.0e1939046e965p+0,   0x1.fffffcp-1, INEXACT) // -3.303760545572793083657359147765e-01
T(RZ,   -0x1.524e19b6d1f27p-2,    0x1.0e1939046e964p+0, -0x1.384664p-23, INEXACT) // -3.303760545572793083657359147765e-01
T(RN,    0x1.0fe7a901ba2a1p-4,     0x1.009073b86a6bp+0,   0x1.ffffecp-2, INEXACT) // 6.638303774128441470114836420180e-02
T(RN,    0x1.7b2865e62c41ap-6,    0x1.00118cb874c5bp+0,   0x1.ffffd2p-2, INEXACT) // 2.314195586285814482119249646530e-02
T(RD,   -0x1.7b5559e3046f5p+0,    0x1.28309fed11cd9p+1, -0x1.d6ca24p-21, INEXACT) // -1.481771104740287059442493955430e+00
T(RU,   -0x1.7b5559e3046f5p+0,    0x1.28309fed11cdap+1,   0x1.ffffe2p-1, INEXACT) // -1.481771104740287059442493955430e+00
T(RZ,   -0x1.7b5559e3046f5p+0,    0x1.28309fed11cd9p+1, -0x1.d6ca24p-21, INEXACT) // -1.481771104740287059442493955430e+00
T(RD,   -0x1.b11cce0e0b133p+5,   0x1.138c512bc1da8p+77,  -0x1.fffff4p-1, INEXACT) // -5.413906489344881123315644799732e+01
T(RU,   -0x1.b11cce0e0b133p+5,   0x1.138c512bc1da9p+77,  0x1.6f7a9ap-22, INEXACT) // -5.413906489344881123315644799732e+01
T(RZ,   -0x1.b11cce0e0b133p+5,   0x1.138c512bc1da8p+77,  -0x1.fffff4p-1, INEXACT) // -5.413906489344881123315644799732e+01
T(RD,   -0x1.b65c9e733b3d1p-9,    0x1.00005dd427b1ep+0, -0x1.0234c6p-21, INEXACT) // -3.344435064369190736127679386414e-03
T(RU,   -0x1.b65c9e733b3d1p-9,    0x1.00005dd427b1fp+0,    0x1.fffffp-1, INEXACT) // -3.344435064369190736127679386414e-03
T(RZ,   -0x1.b65c9e733b3d1p-9,    0x1.00005dd427b1ep+0, -0x1.0234c6p-21, INEXACT) // -3.344435064369190736127679386414e-03
T(RD,   -0x1.137325da9e1b2p-4,    0x1.00943e98175bap+0, -0x1.b0d6e6p-23, INEXACT) // -6.724848543843256476471026417130e-02
T(RU,   -0x1.137325da9e1b2p-4,    0x1.00943e98175bbp+0,   0x1.fffffap-1, INEXACT) // -6.724848543843256476471026417130e-02
T(RZ,   -0x1.137325da9e1b2p-4,    0x1.00943e98175bap+0, -0x1.b0d6e6p-23, INEXACT) // -6.724848543843256476471026417130e-02
T(RD,    0x1.f5b74cce33c7fp+1,    0x1.93394bd90fca2p+4, -0x1.8fd316p-21, INEXACT) // 3.919656372723295145732436139951e+00
T(RU,    0x1.f5b74cce33c7fp+1,    0x1.93394bd90fca3p+4,   0x1.ffffe8p-1, INEXACT) // 3.919656372723295145732436139951e+00
T(RZ,    0x1.f5b74cce33c7fp+1,    0x1.93394bd90fca2p+4, -0x1.8fd316p-21, INEXACT) // 3.919656372723295145732436139951e+00
T(RD,   -0x1.061aaaf4fc4d7p+2,    0x1.e0a11cc55310dp+4, -0x1.ab969ep-23, INEXACT) // -4.095377673381526584250877931481e+00
T(RU,   -0x1.061aaaf4fc4d7p+2,    0x1.e0a11cc55310ep+4,   0x1.fffffap-1, INEXACT) // -4.095377673381526584250877931481e+00
T(RZ,   -0x1.061aaaf4fc4d7p+2,    0x1.e0a11cc55310dp+4, -0x1.ab969ep-23, INEXACT) // -4.095377673381526584250877931481e+00
T(RN,    0x1.8d738300d899dp+0,     0x1.3bd9fa4ef9d6p+1,    0x1.fffffp-2, INEXACT) // 1.552543819147650383527548001439e+00
T(RD,   -0x1.bf277543b8674p-6,    0x1.001868b9d727dp+0, -0x1.89a06ap-21, INEXACT) // -2.729212237944129981759289194088e-02
T(RU,   -0x1.bf277543b8674p-6,    0x1.001868b9d727ep+0,   0x1.ffffe8p-1, INEXACT) // -2.729212237944129981759289194088e-02
T(RZ,   -0x1.bf277543b8674p-6,    0x1.001868b9d727dp+0, -0x1.89a06ap-21, INEXACT) // -2.729212237944129981759289194088e-02
T(RD,    0x1.2744b7b2b0529p-2,    0x1.0ab7698692cfap+0,  -0x1.ffffecp-1, INEXACT) // 2.883480742276157138270775703859e-01
T(RU,    0x1.2744b7b2b0529p-2,    0x1.0ab7698692cfbp+0,  0x1.3a6da8p-21, INEXACT) // 2.883480742276157138270775703859e-01
T(RZ,    0x1.2744b7b2b0529p-2,    0x1.0ab7698692cfap+0,  -0x1.ffffecp-1, INEXACT) // 2.883480742276157138270775703859e-01
T(RD,     0x1.b2abde5b0aa8p-2,    0x1.17698a7cd1f8cp+0, -0x1.462d92p-23, INEXACT) // 4.244837515895270030341634992510e-01
T(RU,     0x1.b2abde5b0aa8p-2,    0x1.17698a7cd1f8dp+0,   0x1.fffffap-1, INEXACT) // 4.244837515895270030341634992510e-01
T(RZ,     0x1.b2abde5b0aa8p-2,    0x1.17698a7cd1f8cp+0, -0x1.462d92p-23, INEXACT) // 4.244837515895270030341634992510e-01
T(RD,   -0x1.12e2ea94702ebp-3,    0x1.024f38137cbc7p+0, -0x1.2d9ee8p-21, INEXACT) // -1.342218710469958720121752548948e-01
T(RU,   -0x1.12e2ea94702ebp-3,    0x1.024f38137cbc8p+0,   0x1.ffffeep-1, INEXACT) // -1.342218710469958720121752548948e-01
T(RZ,   -0x1.12e2ea94702ebp-3,    0x1.024f38137cbc7p+0, -0x1.2d9ee8p-21, INEXACT) // -1.342218710469958720121752548948e-01
T(RN,   0x1.7185edf4ef05dp-10,    0x1.000010ab1b1ebp+0,  -0x1.ffffd4p-2, INEXACT) // 1.409618996361514846674123369041e-03
T(RD,    0x1.67d9de72a0873p+7,  0x1.7e0fe0693d7c1p+258,  -0x1.ffffeap-1, INEXACT) // 1.799255252667386173470731591806e+02
T(RU,    0x1.67d9de72a0873p+7,  0x1.7e0fe0693d7c2p+258,  0x1.6e83eep-21, INEXACT) // 1.799255252667386173470731591806e+02
T(RZ,    0x1.67d9de72a0873p+7,  0x1.7e0fe0693d7c1p+258,  -0x1.ffffeap-1, INEXACT) // 1.799255252667386173470731591806e+02
T(RD,    0x1.57bb5e6bedd01p-9,    0x1.000039b0f62fbp+0,  -0x1.fffff2p-1, INEXACT) // 2.622466350625907594712460380038e-03
T(RU,    0x1.57bb5e6bedd01p-9,    0x1.000039b0f62fcp+0,  0x1.cad6bap-22, INEXACT) // 2.622466350625907594712460380038e-03
T(RZ,    0x1.57bb5e6bedd01p-9,    0x1.000039b0f62fbp+0,  -0x1.fffff2p-1, INEXACT) // 2.622466350625907594712460380038e-03
T(RD,    0x1.cd64d6adc430fp+1,    0x1.265d76b09f95cp+4,  -0x1.ffffe2p-1, INEXACT) // 3.604639849516736216372692069854e+00
T(RU,    0x1.cd64d6adc430fp+1,    0x1.265d76b09f95dp+4,  0x1.d52676p-21, INEXACT) // 3.604639849516736216372692069854e+00
T(RZ,    0x1.cd64d6adc430fp+1,    0x1.265d76b09f95cp+4,  -0x1.ffffe2p-1, INEXACT) // 3.604639849516736216372692069854e+00
T(RD,    0x1.dd861ee0ce024p+5,   0x1.15464ee187e2fp+85, -0x1.945358p-24, INEXACT) // 5.969048858288468295540951658040e+01
T(RU,    0x1.dd861ee0ce024p+5,    0x1.15464ee187e3p+85,   0x1.fffffcp-1, INEXACT) // 5.969048858288468295540951658040e+01
T(RZ,    0x1.dd861ee0ce024p+5,   0x1.15464ee187e2fp+85, -0x1.945358p-24, INEXACT) // 5.969048858288468295540951658040e+01
T(RD,   -0x1.bd62564c38d45p+3,   0x1.0e8ef192681cep+19,  -0x1.ffffe8p-1, INEXACT) // -1.391825404059512472088044887641e+01
T(RU,   -0x1.bd62564c38d45p+3,   0x1.0e8ef192681cfp+19,  0x1.710a38p-21, INEXACT) // -1.391825404059512472088044887641e+01
T(RZ,   -0x1.bd62564c38d45p+3,   0x1.0e8ef192681cep+19,  -0x1.ffffe8p-1, INEXACT) // -1.391825404059512472088044887641e+01
T(RD,   -0x1.2073b31a02cc2p+1,    0x1.340ad606e1c75p+2,   -0x1.ffffep-1, INEXACT) // -2.253530872059486434011432720581e+00
T(RU,   -0x1.2073b31a02cc2p+1,    0x1.340ad606e1c76p+2,  0x1.f5f372p-21, INEXACT) // -2.253530872059486434011432720581e+00
T(RZ,   -0x1.2073b31a02cc2p+1,    0x1.340ad606e1c75p+2,   -0x1.ffffep-1, INEXACT) // -2.253530872059486434011432720581e+00
T(RD,    0x1.d4b1ed0ee1b5fp+5,   0x1.6fdb3294d9a6ap+83,  -0x1.ffffe8p-1, INEXACT) // 5.858687793375315067123665357940e+01
T(RU,    0x1.d4b1ed0ee1b5fp+5,   0x1.6fdb3294d9a6bp+83,  0x1.7eb608p-21, INEXACT) // 5.858687793375315067123665357940e+01
T(RZ,    0x1.d4b1ed0ee1b5fp+5,   0x1.6fdb3294d9a6ap+83,  -0x1.ffffe8p-1, INEXACT) // 5.858687793375315067123665357940e+01
T(RD,   -0x1.51746a06780c4p+0,     0x1.00458ebef128p+1,  -0x1.952ccp-21, INEXACT) // -1.318182589129762938284784468124e+00
T(RU,   -0x1.51746a06780c4p+0,    0x1.00458ebef1281p+1,   0x1.ffffe6p-1, INEXACT) // -1.318182589129762938284784468124e+00
T(RZ,   -0x1.51746a06780c4p+0,     0x1.00458ebef128p+1,  -0x1.952ccp-21, INEXACT) // -1.318182589129762938284784468124e+00
T(RN,   -0x1.c216eb6eee09cp-2,    0x1.1921391d333c6p+0,   0x1.ffffd8p-2, INEXACT) // -4.395405565696905991757148512988e-01
T(RN,    0x1.2caa415a5c128p+9,  0x1.732e7a7b30d69p+866,   -0x1.ffffdp-2, INEXACT) // 6.013301194142886743065901100636e+02
T(RN,   -0x1.de32d53874409p-3,    0x1.0702a5676675fp+0,  -0x1.ffffeap-2, INEXACT) // -2.334953935483386200377964314612e-01
T(RN,    0x1.e06ddac78ab3cp-9,     0x1.000070b38cb7p+0,   0x1.ffffc4p-2, INEXACT) // 3.665383297421524397274872342223e-03
T(RD,    0x1.54a12570dca9bp-8,    0x1.0000e29e59e13p+0,  -0x1.fffffcp-1, INEXACT) // 5.197593346440011578823980897823e-03
T(RU,    0x1.54a12570dca9bp-8,    0x1.0000e29e59e14p+0,  0x1.15e84ep-23, INEXACT) // 5.197593346440011578823980897823e-03
T(RZ,    0x1.54a12570dca9bp-8,    0x1.0000e29e59e13p+0,  -0x1.fffffcp-1, INEXACT) // 5.197593346440011578823980897823e-03
T(RN,   -0x1.bf790dc8def1cp-4,    0x1.018777982cba6p+0,   0x1.ffffeep-2, INEXACT) // -1.092463053191150001985931794479e-01
T(RD,    0x1.abb5623f91e93p+5,   0x1.18744dfaf5645p+76,  -0x1.fffffep-1, INEXACT) // 5.346356630004915899689876823686e+01
T(RU,    0x1.abb5623f91e93p+5,   0x1.18744dfaf5646p+76,  0x1.f39fb2p-25, INEXACT) // 5.346356630004915899689876823686e+01
T(RZ,    0x1.abb5623f91e93p+5,   0x1.18744dfaf5645p+76,  -0x1.fffffep-1, INEXACT) // 5.346356630004915899689876823686e+01
T(RD,   -0x1.0a0048ec04a7bp-1,    0x1.2355501361feap+0, -0x1.474de4p-21, INEXACT) // -5.195334232433447274601689969131e-01
T(RU,   -0x1.0a0048ec04a7bp-1,    0x1.2355501361febp+0,   0x1.ffffecp-1, INEXACT) // -5.195334232433447274601689969131e-01
T(RZ,   -0x1.0a0048ec04a7bp-1,    0x1.2355501361feap+0, -0x1.474de4p-21, INEXACT) // -5.195334232433447274601689969131e-01
T(RD,    0x1.99ecfacd23d73p+1,    0x1.8a2bcbdae4856p+3, -0x1.98925ap-22, INEXACT) // 3.202544546285645221672666593804e+00
T(RU,    0x1.99ecfacd23d73p+1,    0x1.8a2bcbdae4857p+3,   0x1.fffff4p-1, INEXACT) // 3.202544546285645221672666593804e+00
T(RZ,    0x1.99ecfacd23d73p+1,    0x1.8a2bcbdae4856p+3, -0x1.98925ap-22, INEXACT) // 3.202544546285645221672666593804e+00
T(RN,   -0x1.eea2e6ed59a2fp+2,   0x1.1c142765f6ccbp+10,   0x1.ffffe2p-2, INEXACT) // -7.728692752635239138214728882303e+00
T(RD,   -0x1.5c426ea7281c9p-2,    0x1.0ef2d1ec1197bp+0, -0x1.884524p-21, INEXACT) // -3.400971688770622614050864740420e-01
T(RU,   -0x1.5c426ea7281c9p-2,    0x1.0ef2d1ec1197cp+0,   0x1.ffffe8p-1, INEXACT) // -3.400971688770622614050864740420e-01
T(RZ,   -0x1.5c426ea7281c9p-2,    0x1.0ef2d1ec1197bp+0, -0x1.884524p-21, INEXACT) // -3.400971688770622614050864740420e-01
T(RD,   -0x1.025d7a982cf92p+2,    0x1.c55eb7dd9bc9fp+4, -0x1.2275e8p-22, INEXACT) // -4.036955498322543078870694444049e+00
T(RU,   -0x1.025d7a982cf92p+2,     0x1.c55eb7dd9bcap+4,   0x1.fffff6p-1, INEXACT) // -4.036955498322543078870694444049e+00
T(RZ,   -0x1.025d7a982cf92p+2,    0x1.c55eb7dd9bc9fp+4, -0x1.2275e8p-22, INEXACT) // -4.036955498322543078870694444049e+00
T(RN,    0x1.5be432c1edf38p+4,   0x1.4a92abde84f19p+30,  -0x1.ffffdap-2, INEXACT) // 2.174321246865949319726496469229e+01
T(RN,   -0x1.a8d352f3d5858p+1,    0x1.baae0842728b8p+3,   0x1.fffffep-2, INEXACT) // -3.318949097690204297350646811537e+00
T(RD,    -0x1.f8084ef9d2b1p-2,     0x1.1fa49c74fac1p+0, -0x1.39a3cep-21, INEXACT) // -4.922191944103113669939375540707e-01
T(RU,    -0x1.f8084ef9d2b1p-2,    0x1.1fa49c74fac11p+0,   0x1.ffffecp-1, INEXACT) // -4.922191944103113669939375540707e-01
T(RZ,    -0x1.f8084ef9d2b1p-2,     0x1.1fa49c74fac1p+0, -0x1.39a3cep-21, INEXACT) // -4.922191944103113669939375540707e-01
T(RN,   -0x1.10ee88ff8a935p+5,   0x1.2a1a463f32084p+48,   0x1.fffff6p-2, INEXACT) // -3.411647224084519081088728853501e+01
T(RD,    0x1.9158229de4308p+5,   0x1.4c7de71702c89p+71,  -0x1.fffff6p-1, INEXACT) // 5.016803477623585649780579842627e+01
T(RU,    0x1.9158229de4308p+5,   0x1.4c7de71702c8ap+71,  0x1.2cc524p-22, INEXACT) // 5.016803477623585649780579842627e+01
T(RZ,    0x1.9158229de4308p+5,   0x1.4c7de71702c89p+71,  -0x1.fffff6p-1, INEXACT) // 5.016803477623585649780579842627e+01
T(RN,   -0x1.f9aa4b09beef3p-5,    0x1.007ce450020c5p+0,   0x1.ffffd2p-2, INEXACT) // -6.172670989869102203817519125550e-02
T(RD,   0x1.42e29b01a6b79p-10,    0x1.00000cb9f6cf3p+0, -0x1.c77cfcp-22, INEXACT) // 1.231709204523949311230190950539e-03
T(RU,   0x1.42e29b01a6b79p-10,    0x1.00000cb9f6cf4p+0,   0x1.fffff2p-1, INEXACT) // 1.231709204523949311230190950539e-03
T(RZ,   0x1.42e29b01a6b79p-10,    0x1.00000cb9f6cf3p+0, -0x1.c77cfcp-22, INEXACT) // 1.231709204523949311230190950539e-03
T(RD,    0x1.8aa7fa9111781p+0,    0x1.38b7b3dddd46dp+1, -0x1.992718p-24, INEXACT) // 1.541625652710962635083546956594e+00
T(RU,    0x1.8aa7fa9111781p+0,    0x1.38b7b3dddd46ep+1,   0x1.fffffcp-1, INEXACT) // 1.541625652710962635083546956594e+00
T(RZ,    0x1.8aa7fa9111781p+0,    0x1.38b7b3dddd46dp+1, -0x1.992718p-24, INEXACT) // 1.541625652710962635083546956594e+00
T(RN,   -0x1.fee9e0ea4a534p-3,    0x1.0801ea9368c49p+0,  -0x1.ffffd2p-2, INEXACT) // -2.494695254802451467313062494213e-01
T(RD,   -0x1.dad0512a039dbp-9,    0x1.00006e150aa62p+0, -0x1.6c1258p-21, INEXACT) // -3.622541339616020591302136821810e-03
T(RU,   -0x1.dad0512a039dbp-9,    0x1.00006e150aa63p+0,   0x1.ffffeap-1, INEXACT) // -3.622541339616020591302136821810e-03
T(RZ,   -0x1.dad0512a039dbp-9,    0x1.00006e150aa62p+0, -0x1.6c1258p-21, INEXACT) // -3.622541339616020591302136821810e-03
T(RN,   -0x1.a1d2f147523f6p+6,  0x1.9f57311ec7fa4p+149,          0x1p-1, INEXACT) // -1.044559985298108983897691359743e+02
T(RD,    0x1.b1878c084af76p-1,    0x1.61631eaf1b66cp+0,   -0x1.fffffp-1, INEXACT) // 8.467372665522663321979734973866e-01
T(RU,    0x1.b1878c084af76p-1,    0x1.61631eaf1b66dp+0,  0x1.fac32ep-22, INEXACT) // 8.467372665522663321979734973866e-01
T(RZ,    0x1.b1878c084af76p-1,    0x1.61631eaf1b66cp+0,   -0x1.fffffp-1, INEXACT) // 8.467372665522663321979734973866e-01
T(RD,    0x1.1e14d5fccfe1cp+1,    0x1.2e83ae50fe8a4p+2, -0x1.a821f2p-21, INEXACT) // 2.235010860865953574716513685416e+00
T(RU,    0x1.1e14d5fccfe1cp+1,    0x1.2e83ae50fe8a5p+2,   0x1.ffffe6p-1, INEXACT) // 2.235010860865953574716513685416e+00
T(RZ,    0x1.1e14d5fccfe1cp+1,    0x1.2e83ae50fe8a4p+2, -0x1.a821f2p-21, INEXACT) // 2.235010860865953574716513685416e+00
T(RD,    0x1.7d616b5a6fe2cp+8,  0x1.294f23b1378f2p+549, -0x1.97e2a8p-24, INEXACT) // 3.813805443308981466543627902865e+02
T(RU,    0x1.7d616b5a6fe2cp+8,  0x1.294f23b1378f3p+549,   0x1.fffffcp-1, INEXACT) // 3.813805443308981466543627902865e+02
T(RZ,    0x1.7d616b5a6fe2cp+8,  0x1.294f23b1378f2p+549, -0x1.97e2a8p-24, INEXACT) // 3.813805443308981466543627902865e+02
T(RN,    0x1.0f76a192d17dap+7,  0x1.c3c5c1570de3ap+194,   0x1.ffffd4p-2, INEXACT) // 1.357317014580465297513001132756e+02
T(RD,    0x1.9bc5e49a5a77fp-9,    0x1.000052caa5169p+0, -0x1.ccfe86p-23, INEXACT) // 3.141578822739298903349292046983e-03
T(RU,    0x1.9bc5e49a5a77fp-9,    0x1.000052caa516ap+0,   0x1.fffff8p-1, INEXACT) // 3.141578822739298903349292046983e-03
T(RZ,    0x1.9bc5e49a5a77fp-9,    0x1.000052caa5169p+0, -0x1.ccfe86p-23, INEXACT) // 3.141578822739298903349292046983e-03
T(RD,    0x1.7631136c87794p+8,  0x1.cbb055ca5abbbp+538,  -0x1.fffffcp-1, INEXACT) // 3.741917026358362363680498674512e+02
T(RU,    0x1.7631136c87794p+8,  0x1.cbb055ca5abbcp+538,  0x1.34fafap-23, INEXACT) // 3.741917026358362363680498674512e+02
T(RZ,    0x1.7631136c87794p+8,  0x1.cbb055ca5abbbp+538,  -0x1.fffffcp-1, INEXACT) // 3.741917026358362363680498674512e+02
T(RN,    0x1.8ecc389654074p+5,   0x1.e3b0bad78e445p+70,   0x1.ffffe6p-2, INEXACT) // 4.984971730655607302651333156973e+01
T(RD,    0x1.5e54f6e267f4fp+0,    0x1.0bc4b70b236d7p+1, -0x1.16ed86p-24, INEXACT) // 1.368483953738138358957598939014e+00
T(RU,    0x1.5e54f6e267f4fp+0,    0x1.0bc4b70b236d8p+1,   0x1.fffffep-1, INEXACT) // 1.368483953738138358957598939014e+00
T(RZ,    0x1.5e54f6e267f4fp+0,    0x1.0bc4b70b236d7p+1, -0x1.16ed86p-24, INEXACT) // 1.368483953738138358957598939014e+00
T(RN,   -0x1.ca6e3d14af151p-3,    0x1.0670bb39863cfp+0,  -0x1.ffffccp-2, INEXACT) // -2.238430759370069467184549694139e-01
T(RN,   -0x1.d2a3ac7add051p+1,    0x1.32a933976754dp+4,  -0x1.ffffd8p-2, INEXACT) // -3.645619926444887415328821589355e+00
T(RN,   -0x1.14d12ba68ca19p-8,    0x1.000095a9e718fp+0,   0x1.ffffeap-2, INEXACT) // -4.223893315201476296449900615926e-03
T(RD,   -0x1.c08f9c2d8e494p-6,    0x1.0018901c254e4p+0,   -0x1.6669p-22, INEXACT) // -2.737798930886421733266189448841e-02
T(RU,   -0x1.c08f9c2d8e494p-6,    0x1.0018901c254e5p+0,   0x1.fffff4p-1, INEXACT) // -2.737798930886421733266189448841e-02
T(RZ,   -0x1.c08f9c2d8e494p-6,    0x1.0018901c254e4p+0,   -0x1.6669p-22, INEXACT) // -2.737798930886421733266189448841e-02
T(RN,    0x1.00ef2fbd13341p+0,    0x1.8c21194f42e22p+0,  -0x1.fffffep-2, INEXACT) // 1.003649696026698956430323050881e+00
T(RN,    0x1.4bbc8b1017e9ap+7,  0x1.3a9564ad31c22p+238,  -0x1.fffff8p-2, INEXACT) // 1.658682484654607947049953509122e+02
T(RD,    0x1.2655a4dca91afp+8,    0x1.8d8cb33a853p+423,  -0x1.fffff8p-1, INEXACT) // 2.943345468438009788769704755396e+02
T(RU,    0x1.2655a4dca91afp+8,  0x1.8d8cb33a85301p+423,  0x1.10d168p-22, INEXACT) // 2.943345468438009788769704755396e+02
T(RZ,    0x1.2655a4dca91afp+8,    0x1.8d8cb33a853p+423,  -0x1.fffff8p-1, INEXACT) // 2.943345468438009788769704755396e+02
T(RD,    0x1.df663f3d8c33cp+4,   0x1.2b8f197b18b6cp+42, -0x1.5f297ep-22, INEXACT) // 2.996246265451485157882416388020e+01
T(RU,    0x1.df663f3d8c33cp+4,   0x1.2b8f197b18b6dp+42,   0x1.fffff6p-1, INEXACT) // 2.996246265451485157882416388020e+01
T(RZ,    0x1.df663f3d8c33cp+4,   0x1.2b8f197b18b6cp+42, -0x1.5f297ep-22, INEXACT) // 2.996246265451485157882416388020e+01
T(RD,    0x1.1aade79e607cap+3,   0x1.acdd30a7084afp+11, -0x1.b1535ep-22, INEXACT) // 8.833728608446012486865583923645e+00
T(RU,    0x1.1aade79e607cap+3,    0x1.acdd30a7084bp+11,   0x1.fffff2p-1, INEXACT) // 8.833728608446012486865583923645e+00
T(RZ,    0x1.1aade79e607cap+3,   0x1.acdd30a7084afp+11, -0x1.b1535ep-22, INEXACT) // 8.833728608446012486865583923645e+00
T(RD,  -0x1.00b6b881fd218p-10,    0x1.0000080b6fa64p+0, -0x1.4f7498p-21, INEXACT) // -9.792852511029178502743874901171e-04
T(RU,  -0x1.00b6b881fd218p-10,    0x1.0000080b6fa65p+0,   0x1.ffffecp-1, INEXACT) // -9.792852511029178502743874901171e-04
T(RZ,  -0x1.00b6b881fd218p-10,    0x1.0000080b6fa64p+0, -0x1.4f7498p-21, INEXACT) // -9.792852511029178502743874901171e-04
T(RD,  -0x1.61b5eacf76ebdp-10,    0x1.00000f45b9bd8p+0,  -0x1.ffffeap-1, INEXACT) // -1.349298912706339186387549666790e-03
T(RU,  -0x1.61b5eacf76ebdp-10,    0x1.00000f45b9bd9p+0,  0x1.5e6b24p-21, INEXACT) // -1.349298912706339186387549666790e-03
T(RZ,  -0x1.61b5eacf76ebdp-10,    0x1.00000f45b9bd8p+0,  -0x1.ffffeap-1, INEXACT) // -1.349298912706339186387549666790e-03
T(RD,    0x1.bdba026fb99e6p+3,   0x1.117830b3cae2cp+19,  -0x1.ffffe8p-1, INEXACT) // 1.392895623990348141774120449554e+01
T(RU,    0x1.bdba026fb99e6p+3,   0x1.117830b3cae2dp+19,  0x1.862e2ep-21, INEXACT) // 1.392895623990348141774120449554e+01
T(RZ,    0x1.bdba026fb99e6p+3,   0x1.117830b3cae2cp+19,  -0x1.ffffe8p-1, INEXACT) // 1.392895623990348141774120449554e+01
T(RN,   -0x1.72c5117fb2b8cp-6,    0x1.0010c820e18e6p+0,  -0x1.ffffe6p-2, INEXACT) // -2.262999256962987260077824203108e-02
T(RN,   -0x1.78dde62bc1835p+2,    0x1.68e1d19be48abp+7,  -0x1.ffffccp-2, INEXACT) // -5.888543646555310040469066734659e+00
T(RD,    0x1.1d8393d6ceaf4p+4,   0x1.acdb26e041b1dp+24,  -0x1.610a3p-21, INEXACT) // 1.784462341221929193579853745177e+01
T(RU,    0x1.1d8393d6ceaf4p+4,   0x1.acdb26e041b1ep+24,   0x1.ffffeap-1, INEXACT) // 1.784462341221929193579853745177e+01
T(RZ,    0x1.1d8393d6ceaf4p+4,   0x1.acdb26e041b1dp+24,  -0x1.610a3p-21, INEXACT) // 1.784462341221929193579853745177e+01
T(RN,   -0x1.a779ee9d8df8cp+2,    0x1.75c818fb738cdp+8,   0x1.ffffcep-2, INEXACT) // -6.616817144262210348415464977734e+00
T(RN,    0x1.591dbd170008cp+0,    0x1.07082757c5c4fp+1,   0x1.ffffc2p-2, INEXACT) // 1.348110025515810939111815969227e+00
T(RD,    0x1.9a9e2812b7e3ep-1,    0x1.56d602c46f49ep+0,  -0x1.fffff2p-1, INEXACT) // 8.019878886079323532243279260001e-01
T(RU,    0x1.9a9e2812b7e3ep-1,    0x1.56d602c46f49fp+0,  0x1.c86e9ep-22, INEXACT) // 8.019878886079323532243279260001e-01
T(RZ,    0x1.9a9e2812b7e3ep-1,    0x1.56d602c46f49ep+0,  -0x1.fffff2p-1, INEXACT) // 8.019878886079323532243279260001e-01
T(RD,   -0x1.ecb3430ef81cap-7,    0x1.0007688c3438ep+0, -0x1.1af832p-21, INEXACT) // -1.503601812686463159995930993773e-02
T(RU,   -0x1.ecb3430ef81cap-7,    0x1.0007688c3438fp+0,   0x1.ffffeep-1, INEXACT) // -1.503601812686463159995930993773e-02
T(RZ,   -0x1.ecb3430ef81cap-7,    0x1.0007688c3438ep+0, -0x1.1af832p-21, INEXACT) // -1.503601812686463159995930993773e-02
T(RD,    0x1.d1ccbb6f90ea9p+6,  0x1.004f2d7e92da3p+167, -0x1.bf4516p-22, INEXACT) // 1.164499337608528009013753035106e+02
T(RU,    0x1.d1ccbb6f90ea9p+6,  0x1.004f2d7e92da4p+167,   0x1.fffff2p-1, INEXACT) // 1.164499337608528009013753035106e+02
T(RZ,    0x1.d1ccbb6f90ea9p+6,  0x1.004f2d7e92da3p+167, -0x1.bf4516p-22, INEXACT) // 1.164499337608528009013753035106e+02
T(RN,   -0x1.a1f7b45e18808p-2,    0x1.159f7ed50b4a2p+0,   -0x1.ffffdp-2, INEXACT) // -4.081714804107154925816303148167e-01
T(RN,    -0x1.771db4afcc6ap-6,    0x1.00112d7183109p+0,  -0x1.ffffeep-2, INEXACT) // -2.289526601015856588361430112855e-02
T(RN,  -0x1.b679f3c09562ap-10,    0x1.000017782c9d5p+0,   0x1.fffff8p-2, INEXACT) // -1.672654631098233982827716559427e-03
T(RD,   -0x1.b6de8b866f305p-8,    0x1.0001782f7f94ep+0,  -0x1.fffffap-1, INEXACT) // -6.696614326241916333171122488466e-03
T(RU,   -0x1.b6de8b866f305p-8,    0x1.0001782f7f94fp+0,  0x1.8f802cp-23, INEXACT) // -6.696614326241916333171122488466e-03
T(RZ,   -0x1.b6de8b866f305p-8,    0x1.0001782f7f94ep+0,  -0x1.fffffap-1, INEXACT) // -6.696614326241916333171122488466e-03
T(RD,   -0x1.abda545ea8b73p+8,  0x1.32ce700590a2cp+616,  -0x1.fffffep-1, INEXACT) // -4.278528498804000150812498759478e+02
T(RU,   -0x1.abda545ea8b73p+8,  0x1.32ce700590a2dp+616,  0x1.ec78bcp-25, INEXACT) // -4.278528498804000150812498759478e+02
T(RZ,   -0x1.abda545ea8b73p+8,  0x1.32ce700590a2cp+616,  -0x1.fffffep-1, INEXACT) // -4.278528498804000150812498759478e+02
T(RD,    0x1.48d96880e1716p-8,    0x1.0000d33707419p+0, -0x1.8c8a9ap-21, INEXACT) // 5.017841352019455566924044376265e-03
T(RU,    0x1.48d96880e1716p-8,    0x1.0000d3370741ap+0,   0x1.ffffe8p-1, INEXACT) // 5.017841352019455566924044376265e-03
T(RZ,    0x1.48d96880e1716p-8,    0x1.0000d33707419p+0, -0x1.8c8a9ap-21, INEXACT) // 5.017841352019455566924044376265e-03
T(RD,    -0x1.80d824ec987ep+8,  0x1.28b9970a570aep+554,   -0x1.fffffp-1, INEXACT) // -3.848443134186072711599990725517e+02
T(RU,    -0x1.80d824ec987ep+8,  0x1.28b9970a570afp+554,  0x1.0a6e7ep-21, INEXACT) // -3.848443134186072711599990725517e+02
T(RZ,    -0x1.80d824ec987ep+8,  0x1.28b9970a570aep+554,   -0x1.fffffp-1, INEXACT) // -3.848443134186072711599990725517e+02
T(RN,   -0x1.0819cb1063338p-5,    0x1.00220f67fff3fp+0,   0x1.fffff2p-2, INEXACT) // -3.223886166515516071839897449536e-02
T(RN,    0x1.23a0065bfff92p+4,   0x1.3a2a51cdf7c7ap+25,   -0x1.fffffp-2, INEXACT) // 1.822656856477221509749142569490e+01
T(RD,    0x1.73f84fb277397p+1,    0x1.256a76b0a3725p+3,  -0x1.fffff4p-1, INEXACT) // 2.906015360013451509502147018793e+00
T(RU,    0x1.73f84fb277397p+1,    0x1.256a76b0a3726p+3,  0x1.8167b8p-22, INEXACT) // 2.906015360013451509502147018793e+00
T(RZ,    0x1.73f84fb277397p+1,    0x1.256a76b0a3725p+3,  -0x1.fffff4p-1, INEXACT) // 2.906015360013451509502147018793e+00
T(RN,    0x1.dd603c26704ebp+4,   0x1.07f8ddc3ef48fp+42,   0x1.ffffccp-2, INEXACT) // 2.983599486365430308865143160801e+01
T(RD,   -0x1.6c8fd94235604p+2,    0x1.29c2cffd6d484p+7, -0x1.38974cp-23, INEXACT) // -5.696279825836885635226281010546e+00
T(RU,   -0x1.6c8fd94235604p+2,    0x1.29c2cffd6d485p+7,   0x1.fffffcp-1, INEXACT) // -5.696279825836885635226281010546e+00
T(RZ,   -0x1.6c8fd94235604p+2,    0x1.29c2cffd6d484p+7, -0x1.38974cp-23, INEXACT) // -5.696279825836885635226281010546e+00
T(RD,   -0x1.80783ab7f4542p-7,     0x1.000482d5357bp+0, -0x1.3679f8p-24, INEXACT) // -1.173308245771187766082199743778e-02
T(RU,   -0x1.80783ab7f4542p-7,    0x1.000482d5357b1p+0,   0x1.fffffep-1, INEXACT) // -1.173308245771187766082199743778e-02
T(RZ,   -0x1.80783ab7f4542p-7,     0x1.000482d5357bp+0, -0x1.3679f8p-24, INEXACT) // -1.173308245771187766082199743778e-02
T(RD,    -0x1.9bc4e329521cp+5,   0x1.31f3431f81272p+73, -0x1.3d98f2p-22, INEXACT) // -5.147113640100315024028532207012e+01
T(RU,    -0x1.9bc4e329521cp+5,   0x1.31f3431f81273p+73,   0x1.fffff6p-1, INEXACT) // -5.147113640100315024028532207012e+01
T(RZ,    -0x1.9bc4e329521cp+5,   0x1.31f3431f81272p+73, -0x1.3d98f2p-22, INEXACT) // -5.147113640100315024028532207012e+01
T(RN,    0x1.339c3617ddf12p+4,   0x1.aa98f9e913e8fp+26,  -0x1.ffffc2p-2, INEXACT) // 1.922563752482444243696591001935e+01
T(RN,    0x1.31b5f233131c2p-5,    0x1.002da3bca6c47p+0,  -0x1.ffffe6p-2, INEXACT) // 3.731820396987785282139071796337e-02
T(RN,    0x1.51a1347ce1409p+7,  0x1.7660c891b1b14p+242,   0x1.ffffd8p-2, INEXACT) // 1.688148535752264081111206905916e+02
T(RD,   -0x1.a686227f54dadp+2,    0x1.7042c8ff62eb7p+8,  -0x1.fffff4p-1, INEXACT) // -6.601936935755856161733845510753e+00
T(RU,   -0x1.a686227f54dadp+2,    0x1.7042c8ff62eb8p+8,  0x1.62eee6p-22, INEXACT) // -6.601936935755856161733845510753e+00
T(RZ,   -0x1.a686227f54dadp+2,    0x1.7042c8ff62eb7p+8,  -0x1.fffff4p-1, INEXACT) // -6.601936935755856161733845510753e+00
T(RD,   -0x1.f33b89eaac08bp+0,    0x1.caff64853ffd9p+1, -0x1.b89eeep-21, INEXACT) // -1.950127239029856296426146400336e+00
T(RU,   -0x1.f33b89eaac08bp+0,    0x1.caff64853ffdap+1,   0x1.ffffe4p-1, INEXACT) // -1.950127239029856296426146400336e+00
T(RZ,   -0x1.f33b89eaac08bp+0,    0x1.caff64853ffd9p+1, -0x1.b89eeep-21, INEXACT) // -1.950127239029856296426146400336e+00
T(RN,    0x1.744d20975d282p-6,    0x1.0010ebb1a6aafp+0,  -0x1.ffffdcp-2, INEXACT) // 2.272346670857184475211809626671e-02
T(RD,   -0x1.c859e77139abap+5,    0x1.3a81dac70563p+81, -0x1.aefd28p-21, INEXACT) // -5.704389847237821697945037158206e+01
T(RU,   -0x1.c859e77139abap+5,   0x1.3a81dac705631p+81,   0x1.ffffe6p-1, INEXACT) // -5.704389847237821697945037158206e+01
T(RZ,   -0x1.c859e77139abap+5,    0x1.3a81dac70563p+81, -0x1.aefd28p-21, INEXACT) // -5.704389847237821697945037158206e+01
T(RD,   -0x1.98763e172fb6bp-8,    0x1.000145dcd3654p+0, -0x1.621c2cp-24, INEXACT) // -6.232633742171293615708105306794e-03
T(RU,   -0x1.98763e172fb6bp-8,    0x1.000145dcd3655p+0,   0x1.fffffep-1, INEXACT) // -6.232633742171293615708105306794e-03
T(RZ,   -0x1.98763e172fb6bp-8,    0x1.000145dcd3654p+0, -0x1.621c2cp-24, INEXACT) // -6.232633742171293615708105306794e-03
T(RN,    0x1.6ad780d60c86dp+7,  0x1.aa18f4218f0fep+260,   0x1.ffffc6p-2, INEXACT) // 1.814209048166552804559614742175e+02
T(RD,   -0x1.1e9d2deec3e1fp+7,  0x1.ae070e89bfe7ap+205,  -0x1.ffffe2p-1, INEXACT) // -1.433069910635103667573275743052e+02
T(RU,   -0x1.1e9d2deec3e1fp+7,  0x1.ae070e89bfe7bp+205,  0x1.ded522p-21, INEXACT) // -1.433069910635103667573275743052e+02
T(RZ,   -0x1.1e9d2deec3e1fp+7,  0x1.ae070e89bfe7ap+205,  -0x1.ffffe2p-1, INEXACT) // -1.433069910635103667573275743052e+02
T(RD,   -0x1.46c18cf57d6cdp+5,   0x1.e674f131ab2e8p+57,  -0x1.e8a76p-23, INEXACT) // -4.084450713910118935245918692090e+01
T(RU,   -0x1.46c18cf57d6cdp+5,   0x1.e674f131ab2e9p+57,   0x1.fffff8p-1, INEXACT) // -4.084450713910118935245918692090e+01
T(RZ,   -0x1.46c18cf57d6cdp+5,   0x1.e674f131ab2e8p+57,  -0x1.e8a76p-23, INEXACT) // -4.084450713910118935245918692090e+01
T(RD,    0x1.72cd53a9fcf69p+5,   0x1.d3a67903813d2p+65, -0x1.96e7a4p-21, INEXACT) // 4.635025723269684050364958238788e+01
T(RU,    0x1.72cd53a9fcf69p+5,   0x1.d3a67903813d3p+65,   0x1.ffffe6p-1, INEXACT) // 4.635025723269684050364958238788e+01
T(RZ,    0x1.72cd53a9fcf69p+5,   0x1.d3a67903813d2p+65, -0x1.96e7a4p-21, INEXACT) // 4.635025723269684050364958238788e+01
T(RN,    0x1.5db70a3aa5da8p-3,    0x1.03bdcc185c559p+0,  -0x1.ffffdep-2, INEXACT) // 1.707592772624881849452549431589e-01
T(RD,    0x1.157e657075c36p+0,    0x1.a5b6004e21e2bp+0,  -0x1.fffff6p-1, INEXACT) // 1.083959903675134395228951689205e+00
T(RU,    0x1.157e657075c36p+0,    0x1.a5b6004e21e2cp+0,  0x1.380f48p-22, INEXACT) // 1.083959903675134395228951689205e+00
T(RZ,    0x1.157e657075c36p+0,    0x1.a5b6004e21e2bp+0,  -0x1.fffff6p-1, INEXACT) // 1.083959903675134395228951689205e+00
T(RN,   -0x1.2c6bb60a5d2dep-2,    0x1.0b18aeac40ff4p+0,   0x1.ffffc4p-2, INEXACT) // -2.933796352220222614093358970422e-01
T(RN,   -0x1.408254346ed17p+1,    0x1.8a027c213f59ap+2,  -0x1.ffffccp-2, INEXACT) // -2.503977323152536182959693178418e+00
T(RN,   -0x1.48d7c13294ca2p+6,  0x1.855c8763fcd65p+117,   0x1.ffffccp-2, INEXACT) // -8.221069792779101703672495204955e+01
T(RD,   -0x1.8ef0c8536633ep-7,     0x1.0004db67113dp+0, -0x1.260c48p-24, INEXACT) // -1.217469960720196295311801293337e-02
T(RU,   -0x1.8ef0c8536633ep-7,    0x1.0004db67113d1p+0,   0x1.fffffep-1, INEXACT) // -1.217469960720196295311801293337e-02
T(RZ,   -0x1.8ef0c8536633ep-7,     0x1.0004db67113dp+0, -0x1.260c48p-24, INEXACT) // -1.217469960720196295311801293337e-02
T(RN,    0x1.455faaeac1c43p+5,   0x1.9942e0d937d9bp+57,  -0x1.ffffc4p-2, INEXACT) // 4.067171271709278101980089559220e+01
T(RD,    0x1.3a034dfd784c9p-9,    0x1.0000302584edep+0,  -0x1.ffffeap-1, INEXACT) // 2.395728369024217613986182939811e-03
T(RU,    0x1.3a034dfd784c9p-9,    0x1.0000302584edfp+0,  0x1.59b312p-21, INEXACT) // 2.395728369024217613986182939811e-03
T(RZ,    0x1.3a034dfd784c9p-9,    0x1.0000302584edep+0,  -0x1.ffffeap-1, INEXACT) // 2.395728369024217613986182939811e-03
T(RD,   -0x1.de9504e67c539p+3,   0x1.7dc120426b36ep+20,  -0x1.ffffe8p-1, INEXACT) // -1.495569081322411086887314013438e+01
T(RU,   -0x1.de9504e67c539p+3,   0x1.7dc120426b36fp+20,  0x1.758afap-21, INEXACT) // -1.495569081322411086887314013438e+01
T(RZ,   -0x1.de9504e67c539p+3,   0x1.7dc120426b36ep+20,  -0x1.ffffe8p-1, INEXACT) // -1.495569081322411086887314013438e+01
T(RN,    0x1.287dcebbbd77ep-9,    0x1.00002aec66afcp+0,  -0x1.ffffcap-2, INEXACT) // 2.262050138479076120956445805632e-03
T(RN,    0x1.17ba1a9c6f18ep+2,    0x1.3c750c0cafbf6p+5,   0x1.ffffcap-2, INEXACT) // 4.370733883636047423237869224977e+00
T(RN,    0x1.ab5b54cfbd298p+7,  0x1.35461dcee4e9dp+307,  -0x1.ffffd8p-2, INEXACT) // 2.136783814352427270932821556926e+02
T(RN,   -0x1.8123ff61cf2e9p+1,    0x1.4508debf93d44p+3,  -0x1.ffffeep-2, INEXACT) // -3.008911059149216971064788594958e+00
T(RN,   -0x1.9ed6524a44c0fp+3,   0x1.a0a06bad4fdf3p+17,   0x1.ffffe8p-2, INEXACT) // -1.296366228585796243066852184711e+01
T(RN,   -0x1.4e03a7458f7ebp-1,     0x1.386f5b15d7f1p+0,  -0x1.ffffdap-2, INEXACT) // -6.523716232693436145595455855073e-01
T(RN,    -0x1.c5d5cde231a6p+4,   0x1.e4ec170f27558p+39,   0x1.ffffeap-2, INEXACT) // -2.836469829899795058736344799399e+01
T(RD,   -0x1.e98694cc180d2p+0,    0x1.ba9c2b274d4f7p+1, -0x1.7f0214p-23, INEXACT) // -1.912209796741127565411488831160e+00
T(RU,   -0x1.e98694cc180d2p+0,    0x1.ba9c2b274d4f8p+1,   0x1.fffffap-1, INEXACT) // -1.912209796741127565411488831160e+00
T(RZ,   -0x1.e98694cc180d2p+0,    0x1.ba9c2b274d4f7p+1, -0x1.7f0214p-23, INEXACT) // -1.912209796741127565411488831160e+00
T(RD,   -0x1.37e9f654a4f22p+7,  0x1.ff684984c6f82p+223,  -0x1.fffff6p-1, INEXACT) // -1.559569574786519865483569446951e+02
T(RU,   -0x1.37e9f654a4f22p+7,  0x1.ff684984c6f83p+223,  0x1.254606p-22, INEXACT) // -1.559569574786519865483569446951e+02
T(RZ,   -0x1.37e9f654a4f22p+7,  0x1.ff684984c6f82p+223,  -0x1.fffff6p-1, INEXACT) // -1.559569574786519865483569446951e+02
T(RD,    0x1.ee8278fee1e36p-4,    0x1.01de327cd806bp+0, -0x1.21523ap-21, INEXACT) // 1.207298971549953525705944912261e-01
T(RU,    0x1.ee8278fee1e36p-4,    0x1.01de327cd806cp+0,   0x1.ffffeep-1, INEXACT) // 1.207298971549953525705944912261e-01
T(RZ,    0x1.ee8278fee1e36p-4,    0x1.01de327cd806bp+0, -0x1.21523ap-21, INEXACT) // 1.207298971549953525705944912261e-01
T(RN,   -0x1.5ff66d1615fdfp+2,    0x1.e91b2d2e867ccp+6,  -0x1.ffffdep-2, INEXACT) // -5.499415656631724935721194924554e+00
T(RD,    0x1.80720b1ae9427p+4,   0x1.95dcf4911cb5dp+33, -0x1.ca723cp-22, INEXACT) // 2.402784262191940101160980702844e+01
T(RU,    0x1.80720b1ae9427p+4,   0x1.95dcf4911cb5ep+33,   0x1.fffff2p-1, INEXACT) // 2.402784262191940101160980702844e+01
T(RZ,    0x1.80720b1ae9427p+4,   0x1.95dcf4911cb5dp+33, -0x1.ca723cp-22, INEXACT) // 2.402784262191940101160980702844e+01
T(RD,   -0x1.c21b3ce3b790ap+5,   0x1.202be2eafbef3p+80, -0x1.68426ep-21, INEXACT) // -5.626329973129220718419674085453e+01
T(RU,   -0x1.c21b3ce3b790ap+5,   0x1.202be2eafbef4p+80,   0x1.ffffeap-1, INEXACT) // -5.626329973129220718419674085453e+01
T(RZ,   -0x1.c21b3ce3b790ap+5,   0x1.202be2eafbef3p+80, -0x1.68426ep-21, INEXACT) // -5.626329973129220718419674085453e+01
T(RD,    -0x1.c012250a849dp-7,    0x1.00062085478cbp+0, -0x1.3517d6p-21, INEXACT) // -1.367403801581171252088608980557e-02
T(RU,    -0x1.c012250a849dp-7,    0x1.00062085478ccp+0,   0x1.ffffecp-1, INEXACT) // -1.367403801581171252088608980557e-02
T(RZ,    -0x1.c012250a849dp-7,    0x1.00062085478cbp+0, -0x1.3517d6p-21, INEXACT) // -1.367403801581171252088608980557e-02
T(RN,   -0x1.a4345ef9d2e3cp+5,   0x1.b717bed809063p+74,  -0x1.fffff4p-2, INEXACT) // -5.252557177710374958223837893456e+01
T(RN,    0x1.f65baf14166c8p+4,   0x1.3a7c4c1309ad3p+44,  -0x1.ffffd8p-2, INEXACT) // 3.139738376471248670895874965936e+01
T(RN,   -0x1.371556459a2f6p+1,    0x1.6e6c6ee987966p+2,   0x1.fffffep-2, INEXACT) // -2.430338653550616179188637033803e+00
T(RD,   0x1.e4a51b95f2db2p-10,    0x1.00001cac065f5p+0,  -0x1.ffffecp-1, INEXACT) // 1.848773773860706588073599121458e-03
T(RU,   0x1.e4a51b95f2db2p-10,    0x1.00001cac065f6p+0,  0x1.336feap-21, INEXACT) // 1.848773773860706588073599121458e-03
T(RZ,   0x1.e4a51b95f2db2p-10,    0x1.00001cac065f5p+0,  -0x1.ffffecp-1, INEXACT) // 1.848773773860706588073599121458e-03
T(RN,    0x1.4abe319eb72ddp+0,     0x1.f5139ddd8875p+0,  -0x1.ffffd8p-2, INEXACT) // 1.291964627503310980571882282675e+00
T(RN,    0x1.0674ac3f28f5fp-6,    0x1.000868a3f6aa6p+0,  -0x1.ffffc8p-2, INEXACT) // 1.601902790993336642144662107512e-02
T(RD,    0x1.154c479c7a403p-7,    0x1.000258bd3e59dp+0, -0x1.bcf762p-27, INEXACT) // 8.462462393213248876278065324641e-03
T(RU,    0x1.154c479c7a403p-7,    0x1.000258bd3e59ep+0,          0x1p+0, INEXACT) // 8.462462393213248876278065324641e-03
T(RZ,    0x1.154c479c7a403p-7,    0x1.000258bd3e59dp+0, -0x1.bcf762p-27, INEXACT) // 8.462462393213248876278065324641e-03
T(RD,    0x1.41440ee8ad037p+0,    0x1.e578609cf8c17p+0,  -0x1.ffffecp-1, INEXACT) // 1.254944736295340979026491368131e+00
T(RU,    0x1.41440ee8ad037p+0,    0x1.e578609cf8c18p+0,  0x1.47541ep-21, INEXACT) // 1.254944736295340979026491368131e+00
T(RZ,    0x1.41440ee8ad037p+0,    0x1.e578609cf8c17p+0,  -0x1.ffffecp-1, INEXACT) // 1.254944736295340979026491368131e+00
T(RN,   -0x1.07e68178d9725p-2,    0x1.088c6df01a3cep+0,   0x1.ffffe8p-2, INEXACT) // -2.577152471552486834305284446600e-01
T(RD,   -0x1.77f923cf9c741p-1,    0x1.482de2260d4b3p+0, -0x1.c80792p-21, INEXACT) // -7.343226614886831926654053859238e-01
T(RU,   -0x1.77f923cf9c741p-1,    0x1.482de2260d4b4p+0,   0x1.ffffe4p-1, INEXACT) // -7.343226614886831926654053859238e-01
T(RZ,   -0x1.77f923cf9c741p-1,    0x1.482de2260d4b3p+0, -0x1.c80792p-21, INEXACT) // -7.343226614886831926654053859238e-01
T(RD,   -0x1.1a179629d6f12p-9,    0x1.000026db001bap+0,  -0x1.ffffe4p-1, INEXACT) // -2.152192192552145923178930075892e-03
T(RU,   -0x1.1a179629d6f12p-9,    0x1.000026db001bbp+0,  0x1.b6ba0ep-21, INEXACT) // -2.152192192552145923178930075892e-03
T(RZ,   -0x1.1a179629d6f12p-9,    0x1.000026db001bap+0,  -0x1.ffffe4p-1, INEXACT) // -2.152192192552145923178930075892e-03
T(RN,   -0x1.cbfbafc3da714p+7,  0x1.c01bd99514a0ep+330,   0x1.ffffc8p-2, INEXACT) // -2.299915753559258746463456191123e+02
T(RN,    -0x1.e557290e3891p+6,  0x1.08f303ca043ecp+174,  -0x1.fffffep-2, INEXACT) // -1.213351175519967455329606309533e+02
T(RN,     0x1.3590fd333455p+4,   0x1.e213654f76367p+26,   0x1.ffffd4p-2, INEXACT) // 1.934789772035338728528586216271e+01
T(RN,   -0x1.0418d92ae03e6p-3,    0x1.02113aeb8ff29p+0,  -0x1.fffff4p-2, INEXACT) // -1.270005193910314633676250650751e-01
T(RN,    0x1.8d7c28d154a8ep-5,    0x1.004d292a56b96p+0,   0x1.fffff2p-2, INEXACT) // 4.852111789900447058609955774955e-02
T(RD,    0x1.aec5ecc8d23fep-1,    0x1.6014b117245d1p+0,  -0x1.fffff2p-1, INEXACT) // 8.413537974494145199599870466045e-01
T(RU,    0x1.aec5ecc8d23fep-1,    0x1.6014b117245d2p+0,  0x1.b3648ep-22, INEXACT) // 8.413537974494145199599870466045e-01
T(RZ,    0x1.aec5ecc8d23fep-1,    0x1.6014b117245d1p+0,  -0x1.fffff2p-1, INEXACT) // 8.413537974494145199599870466045e-01
T(RD,   0x1.fcdc75e8f16e6p-10,    0x1.00001f9bde34fp+0,   -0x1.ffffep-1, INEXACT) // 1.941151329661600002246535368045e-03
T(RU,   0x1.fcdc75e8f16e6p-10,     0x1.00001f9bde35p+0,  0x1.f97232p-21, INEXACT) // 1.941151329661600002246535368045e-03
T(RZ,   0x1.fcdc75e8f16e6p-10,    0x1.00001f9bde34fp+0,   -0x1.ffffep-1, INEXACT) // 1.941151329661600002246535368045e-03
T(RD,    0x1.c253afcaa4c17p-6,    0x1.0018c1b8ae90ep+0, -0x1.ac4aeep-21, INEXACT) // 2.748577277322902454037567565592e-02
T(RU,    0x1.c253afcaa4c17p-6,    0x1.0018c1b8ae90fp+0,   0x1.ffffe6p-1, INEXACT) // 2.748577277322902454037567565592e-02
T(RZ,    0x1.c253afcaa4c17p-6,    0x1.0018c1b8ae90ep+0, -0x1.ac4aeep-21, INEXACT) // 2.748577277322902454037567565592e-02
T(RN,    0x1.d39fc518c038fp+7,  0x1.3f757182f9f36p+336,   0x1.ffffccp-2, INEXACT) // 2.338120506033560275227500824258e+02
T(RD,    0x1.e930f4c529c12p+5,   0x1.2a02c77ed918ap+87,  -0x1.fffffap-1, INEXACT) // 6.114890436204599666325520956889e+01
T(RU,    0x1.e930f4c529c12p+5,   0x1.2a02c77ed918bp+87,  0x1.ac9b6ap-23, INEXACT) // 6.114890436204599666325520956889e+01
T(RZ,    0x1.e930f4c529c12p+5,   0x1.2a02c77ed918ap+87,  -0x1.fffffap-1, INEXACT) // 6.114890436204599666325520956889e+01
T(RN,    0x1.05d026684da91p-9,    0x1.0000217843ac9p+0,  -0x1.fffffep-2, INEXACT) // 1.997475326926797124099666191910e-03
T(RN,    0x1.42028dafd918bp+3,   0x1.6e79711e5c6d5p+13,   0x1.ffffcap-2, INEXACT) // 1.006281170220679221927184698870e+01
T(RD,    0x1.011adb8fed5f1p+1,    0x1.e5961e94453dfp+1, -0x1.163f18p-21, INEXACT) // 2.008632130887001654429013797198e+00
T(RU,    0x1.011adb8fed5f1p+1,     0x1.e5961e94453ep+1,   0x1.ffffeep-1, INEXACT) // 2.008632130887001654429013797198e+00
T(RZ,    0x1.011adb8fed5f1p+1,    0x1.e5961e94453dfp+1, -0x1.163f18p-21, INEXACT) // 2.008632130887001654429013797198e+00
T(RD,   -0x1.6c7cd1db16155p+0,    0x1.19308f3f08579p+1,   -0x1.ffffep-1, INEXACT) // -1.423779598224503617487357587379e+00
T(RU,   -0x1.6c7cd1db16155p+0,    0x1.19308f3f0857ap+1,    0x1.fd03p-21, INEXACT) // -1.423779598224503617487357587379e+00
T(RZ,   -0x1.6c7cd1db16155p+0,    0x1.19308f3f08579p+1,   -0x1.ffffep-1, INEXACT) // -1.423779598224503617487357587379e+00
T(RN,   -0x1.7e078fbd7063dp-9,    0x1.000047435574cp+0,   0x1.ffffe4p-2, INEXACT) // -2.914654060732128990768297072123e-03
T(RD,    0x1.25f20d15b9fd3p+5,   0x1.01a4037f7c14dp+52,  -0x1.fffffap-1, INEXACT) // 3.674318901990741181862176745199e+01
T(RU,    0x1.25f20d15b9fd3p+5,   0x1.01a4037f7c14ep+52,  0x1.8cac6ep-23, INEXACT) // 3.674318901990741181862176745199e+01
T(RZ,    0x1.25f20d15b9fd3p+5,   0x1.01a4037f7c14dp+52,  -0x1.fffffap-1, INEXACT) // 3.674318901990741181862176745199e+01
T(RD,    0x1.2c5156978338fp+0,    0x1.c54e3986eac5cp+0,  -0x1.fffff6p-1, INEXACT) // 1.173116123190286463895404267532e+00
T(RU,    0x1.2c5156978338fp+0,    0x1.c54e3986eac5dp+0,  0x1.472b26p-22, INEXACT) // 1.173116123190286463895404267532e+00
T(RZ,    0x1.2c5156978338fp+0,    0x1.c54e3986eac5cp+0,  -0x1.fffff6p-1, INEXACT) // 1.173116123190286463895404267532e+00
T(RD,    0x1.8677b8518923cp+5,   0x1.557e9d601e774p+69, -0x1.869c66p-22, INEXACT) // 4.880845702838675492785114329308e+01
T(RU,    0x1.8677b8518923cp+5,   0x1.557e9d601e775p+69,   0x1.fffff4p-1, INEXACT) // 4.880845702838675492785114329308e+01
T(RZ,    0x1.8677b8518923cp+5,   0x1.557e9d601e774p+69, -0x1.869c66p-22, INEXACT) // 4.880845702838675492785114329308e+01
T(RD,    0x1.379aa922b7536p+1,    0x1.6fe501f34dee4p+2, -0x1.f46484p-21, INEXACT) // 2.434407369567135326349216484232e+00
T(RU,    0x1.379aa922b7536p+1,    0x1.6fe501f34dee5p+2,    0x1.ffffep-1, INEXACT) // 2.434407369567135326349216484232e+00
T(RZ,    0x1.379aa922b7536p+1,    0x1.6fe501f34dee4p+2, -0x1.f46484p-21, INEXACT) // 2.434407369567135326349216484232e+00
T(RD,    0x1.fd98fdaf006adp-8,    0x1.0001fb3585989p+0, -0x1.ba0df8p-21, INEXACT) // 7.775842604134258935488777098044e-03
T(RU,    0x1.fd98fdaf006adp-8,    0x1.0001fb358598ap+0,   0x1.ffffe4p-1, INEXACT) // 7.775842604134258935488777098044e-03
T(RZ,    0x1.fd98fdaf006adp-8,    0x1.0001fb3585989p+0, -0x1.ba0df8p-21, INEXACT) // 7.775842604134258935488777098044e-03
T(RD,   -0x1.3fd9043ac3fa9p+2,    0x1.28226894e91a9p+6,  -0x1.ffffecp-1, INEXACT) // -4.997620637310242308615215733880e+00
T(RU,   -0x1.3fd9043ac3fa9p+2,    0x1.28226894e91aap+6,  0x1.388ee8p-21, INEXACT) // -4.997620637310242308615215733880e+00
T(RZ,   -0x1.3fd9043ac3fa9p+2,    0x1.28226894e91a9p+6,  -0x1.ffffecp-1, INEXACT) // -4.997620637310242308615215733880e+00
T(RN,    0x1.2e167fbee7c56p-5,    0x1.002c906ddb41dp+0,   -0x1.ffffep-2, INEXACT) // 3.687596273743369568176575512553e-02
T(RN,    0x1.3956a6a7c713ap+1,    0x1.74d657120e009p+2,   0x1.ffffcep-2, INEXACT) // 2.447956878588368745397474413039e+00
T(RN,   -0x1.3e70ed9d16809p-3,    0x1.0319d26fea61dp+0,  -0x1.fffffep-2, INEXACT) // -1.554888309063360563033739936145e-01
T(RD,    0x1.eca68da9a3cddp-4,    0x1.01da9aaba0e11p+0, -0x1.414cfap-21, INEXACT) // 1.202760251710403710534436072521e-01
T(RU,    0x1.eca68da9a3cddp-4,    0x1.01da9aaba0e12p+0,   0x1.ffffecp-1, INEXACT) // 1.202760251710403710534436072521e-01
T(RZ,    0x1.eca68da9a3cddp-4,    0x1.01da9aaba0e11p+0, -0x1.414cfap-21, INEXACT) // 1.202760251710403710534436072521e-01
T(RD,    0x1.5fc0e32f2b6d9p-2,    0x1.0f40bfb9b55ecp+0,  -0x1.fffff6p-1, INEXACT) // 3.435092446842254454431042631768e-01
T(RU,    0x1.5fc0e32f2b6d9p-2,    0x1.0f40bfb9b55edp+0,   0x1.24089p-22, INEXACT) // 3.435092446842254454431042631768e-01
T(RZ,    0x1.5fc0e32f2b6d9p-2,    0x1.0f40bfb9b55ecp+0,  -0x1.fffff6p-1, INEXACT) // 3.435092446842254454431042631768e-01
T(RN,   -0x1.22e9d48e413b9p-9,    0x1.00002952d4817p+0,  -0x1.fffff6p-2, INEXACT) // -2.219493099917060636300236708962e-03
T(RN,    0x1.92567509f1ec7p-4,    0x1.013c6aeb9ffdap+0,  -0x1.ffffecp-2, INEXACT) // 9.822698324489485821597867243327e-02
T(RD,    -0x1.1c89ccca44ffp-3,    0x1.027988b36a63dp+0, -0x1.81c76cp-26, INEXACT) // -1.389347075679547849347272858722e-01
T(RU,    -0x1.1c89ccca44ffp-3,    0x1.027988b36a63ep+0,          0x1p+0, INEXACT) // -1.389347075679547849347272858722e-01
T(RZ,    -0x1.1c89ccca44ffp-3,    0x1.027988b36a63dp+0, -0x1.81c76cp-26, INEXACT) // -1.389347075679547849347272858722e-01
T(RD,   -0x1.ca6da5d6fb8f9p+5,   0x1.97bf4ec46235cp+81, -0x1.a7b42ep-21, INEXACT) // -5.730353897052004441547978785820e+01
T(RU,   -0x1.ca6da5d6fb8f9p+5,   0x1.97bf4ec46235dp+81,   0x1.ffffe6p-1, INEXACT) // -5.730353897052004441547978785820e+01
T(RZ,   -0x1.ca6da5d6fb8f9p+5,   0x1.97bf4ec46235cp+81, -0x1.a7b42ep-21, INEXACT) // -5.730353897052004441547978785820e+01
T(RN,    0x1.0ec04f33ee564p-3,    0x1.023d8a180edf9p+0,   0x1.ffffecp-2, INEXACT) // 1.322027385447582803479349422560e-01
T(RN,    0x1.b04e42c8b734dp+7,  0x1.cb185e02abd97p+310,   0x1.fffff6p-2, INEXACT) // 2.161528532718315602778602624312e+02
T(RD,     0x1.f6c06fd9b08ap+1,    0x1.967f41d8b21b3p+4,  -0x1.ffffe2p-1, INEXACT) // 3.927747708600762166497588623315e+00
T(RU,     0x1.f6c06fd9b08ap+1,    0x1.967f41d8b21b4p+4,  0x1.d08486p-21, INEXACT) // 3.927747708600762166497588623315e+00
T(RZ,     0x1.f6c06fd9b08ap+1,    0x1.967f41d8b21b3p+4,  -0x1.ffffe2p-1, INEXACT) // 3.927747708600762166497588623315e+00
T(RD,    0x1.4cc3e7bd17f6cp-2,    0x1.0da2f50348798p+0,  -0x1.ffffe8p-1, INEXACT) // 3.249660691417293190141890590894e-01
T(RU,    0x1.4cc3e7bd17f6cp-2,    0x1.0da2f50348799p+0,  0x1.8d4c1ep-21, INEXACT) // 3.249660691417293190141890590894e-01
T(RZ,    0x1.4cc3e7bd17f6cp-2,    0x1.0da2f50348798p+0,  -0x1.ffffe8p-1, INEXACT) // 3.249660691417293190141890590894e-01
T(RN,  -0x1.22283773c716ap-10,    0x1.00000a46f9314p+0,   0x1.ffffccp-2, INEXACT) // -1.106861481225152824686697172751e-03
T(RN,    0x1.3d67213e096e1p-4,    0x1.00c4dd7f16169p+0,   0x1.ffffccp-2, INEXACT) // 7.749093041692446670598570790389e-02
T(RN,   -0x1.b6f2a9becae96p-5,    0x1.005e1a2baa4ccp+0,  -0x1.fffff4p-2, INEXACT) // -5.358250764251441811136800197346e-02
T(RN,   -0x1.d68878fddd748p+0,    0x1.9c5da2c419a5ap+1,    0x1.fffffp-2, INEXACT) // -1.838019906977438111539413512219e+00
T(RD,   -0x1.d093a234bbe8bp-4,    0x1.01a5ff7e18b5bp+0,  -0x1.fffffcp-1, INEXACT) // -1.134220443889210477861340109484e-01
T(RU,   -0x1.d093a234bbe8bp-4,    0x1.01a5ff7e18b5cp+0,  0x1.b79f52p-24, INEXACT) // -1.134220443889210477861340109484e-01
T(RZ,   -0x1.d093a234bbe8bp-4,    0x1.01a5ff7e18b5bp+0,  -0x1.fffffcp-1, INEXACT) // -1.134220443889210477861340109484e-01
T(RN,    0x1.503484c3559adp+4,   0x1.3e7cdbef3886bp+29,   0x1.ffffcep-2, INEXACT) // 2.101282192518708669126681343187e+01
T(RD,    0x1.dd7b950ad3c78p+7,   0x1.5921129084fdp+343, -0x1.820078p-21, INEXACT) // 2.387413714774627351289382204413e+02
T(RU,    0x1.dd7b950ad3c78p+7,  0x1.5921129084fd1p+343,   0x1.ffffe8p-1, INEXACT) // 2.387413714774627351289382204413e+02
T(RZ,    0x1.dd7b950ad3c78p+7,   0x1.5921129084fdp+343, -0x1.820078p-21, INEXACT) // 2.387413714774627351289382204413e+02
T(RN,    -0x1.64d9789c73dcp-4,    0x1.00f8df107aa06p+0,  -0x1.ffffd8p-2, INEXACT) // -8.712145913818059028699281043373e-02
T(RN,   -0x1.bbb3608d2a518p-7,    0x1.000602129fcddp+0,   0x1.ffffd8p-2, INEXACT) // -1.354067053246636731511642892656e-02
T(RN,   0x1.d8ffea7bacaffp-10,    0x1.00001b4f86004p+0,   0x1.ffffd8p-2, INEXACT) // 1.804350554192424077246115210471e-03
T(RD,   -0x1.aee6866fbeec7p+0,    0x1.646340e03f445p+1, -0x1.df7fcep-21, INEXACT) // -1.683205034524620336000566567236e+00
T(RU,   -0x1.aee6866fbeec7p+0,    0x1.646340e03f446p+1,   0x1.ffffe2p-1, INEXACT) // -1.683205034524620336000566567236e+00
T(RZ,   -0x1.aee6866fbeec7p+0,    0x1.646340e03f445p+1, -0x1.df7fcep-21, INEXACT) // -1.683205034524620336000566567236e+00
T(RN,   -0x1.1b54a29dadf89p-8,     0x1.00009cca2dc3p+0,  -0x1.ffffeap-2, INEXACT) // -4.323281956821641881794082706847e-03
T(RN,    0x1.a3bb565c62949p-3,    0x1.05653098417cdp+0,   0x1.fffff2p-2, INEXACT) // 2.049471613830269600686762032637e-01
T(RD,    0x1.95227a2c281adp-2,    0x1.144c72766e3e7p+0, -0x1.52601ap-21, INEXACT) // 3.956393327189527409082359099557e-01
T(RU,    0x1.95227a2c281adp-2,    0x1.144c72766e3e8p+0,   0x1.ffffeap-1, INEXACT) // 3.956393327189527409082359099557e-01
T(RZ,    0x1.95227a2c281adp-2,    0x1.144c72766e3e7p+0, -0x1.52601ap-21, INEXACT) // 3.956393327189527409082359099557e-01
T(RD,    0x1.9c5dc9af2723cp-8,     0x1.00014c1f4994p+0,  -0x1.fffffep-1, INEXACT) // 6.292211283974110530570200694456e-03
T(RU,    0x1.9c5dc9af2723cp-8,    0x1.00014c1f49941p+0,  0x1.7ef352p-24, INEXACT) // 6.292211283974110530570200694456e-03
T(RZ,    0x1.9c5dc9af2723cp-8,     0x1.00014c1f4994p+0,  -0x1.fffffep-1, INEXACT) // 6.292211283974110530570200694456e-03
T(RN,   -0x1.d89d2aead7e8dp+5,   0x1.2c30240ae3901p+84,         -0x1p-1, INEXACT) // -5.907674201461222907028059125878e+01
T(RN,   -0x1.cf37de62f6016p+4,   0x1.b3d7e4f1129e8p+40,          0x1p-1, INEXACT) // -2.895113981873154074264675728045e+01
T(RN,    0x1.013c954e3a1a8p+7,  0x1.78a2793a1871bp+184,   0x1.ffffc2p-2, INEXACT) // 1.286183266111304419609950855374e+02
T(RN,    0x1.682110b215a6cp+7,  0x1.b70f98b43d4a6p+258,   0x1.ffffc4p-2, INEXACT) // 1.800645805026464358888915739954e+02
T(RD,    0x1.7319ce29158dap+4,    0x1.608650e935cep+32,  -0x1.ffffecp-1, INEXACT) // 2.319380012558472259343034238555e+01
T(RU,    0x1.7319ce29158dap+4,   0x1.608650e935ce1p+32,  0x1.3948c6p-21, INEXACT) // 2.319380012558472259343034238555e+01
T(RZ,    0x1.7319ce29158dap+4,    0x1.608650e935cep+32,  -0x1.ffffecp-1, INEXACT) // 2.319380012558472259343034238555e+01
T(RD,   -0x1.24d5bdd95223cp-3,    0x1.029f14fd52f97p+0, -0x1.e02b8ap-23, INEXACT) // -1.429858047433912870971539632592e-01
T(RU,   -0x1.24d5bdd95223cp-3,    0x1.029f14fd52f98p+0,   0x1.fffff8p-1, INEXACT) // -1.429858047433912870971539632592e-01
T(RZ,   -0x1.24d5bdd95223cp-3,    0x1.029f14fd52f97p+0, -0x1.e02b8ap-23, INEXACT) // -1.429858047433912870971539632592e-01
T(RD,   -0x1.94820718e91d5p-8,    0x1.00013f9596b72p+0,  -0x1.ffffe6p-1, INEXACT) // -6.172301037541368280703313331514e-03
T(RU,   -0x1.94820718e91d5p-8,    0x1.00013f9596b73p+0,  0x1.92d2f8p-21, INEXACT) // -6.172301037541368280703313331514e-03
T(RZ,   -0x1.94820718e91d5p-8,    0x1.00013f9596b72p+0,  -0x1.ffffe6p-1, INEXACT) // -6.172301037541368280703313331514e-03
T(RN,    0x1.3208dd4a5885fp-9,    0x1.00002dbb27872p+0,   0x1.ffffc4p-2, INEXACT) // 2.334858906736278060661815558774e-03
T(RN,    0x1.6685de5e62ca7p+6,  0x1.3d52daca2e89ap+128,  -0x1.ffffd2p-2, INEXACT) // 8.963073108175250069962203269824e+01
T(RN,    0x1.ea25a15b3f808p+0,    0x1.bba3bd582f55ap+1,  -0x1.ffffd8p-2, INEXACT) // 1.914636692788464600312181573827e+00
T(RD,    0x1.5eeb6b5fbc5dap+0,    0x1.0c4f1f591caa8p+1,  -0x1.ffffe6p-1, INEXACT) // 1.370779715416907240665977951721e+00
T(RU,    0x1.5eeb6b5fbc5dap+0,    0x1.0c4f1f591caa9p+1,   0x1.aacd3p-21, INEXACT) // 1.370779715416907240665977951721e+00
T(RZ,    0x1.5eeb6b5fbc5dap+0,    0x1.0c4f1f591caa8p+1,  -0x1.ffffe6p-1, INEXACT) // 1.370779715416907240665977951721e+00
T(RN,    0x1.b6c2c883f9105p-5,    0x1.005e05a41637fp+0,   0x1.ffffecp-2, INEXACT) // 5.355967677295051659891456097284e-02
T(RD,   -0x1.9db2ba29e8cddp-9,    0x1.0000539149ba4p+0, -0x1.3219f4p-21, INEXACT) // -3.156266427099303859687973172754e-03
T(RU,   -0x1.9db2ba29e8cddp-9,    0x1.0000539149ba5p+0,   0x1.ffffecp-1, INEXACT) // -3.156266427099303859687973172754e-03
T(RZ,   -0x1.9db2ba29e8cddp-9,    0x1.0000539149ba4p+0, -0x1.3219f4p-21, INEXACT) // -3.156266427099303859687973172754e-03
T(RD,   -0x1.7bed8fe07bb88p-6,    0x1.00119efde2d3cp+0, -0x1.c49bb4p-21, INEXACT) // -2.318896341779067005184344907320e-02
T(RU,   -0x1.7bed8fe07bb88p-6,    0x1.00119efde2d3dp+0,   0x1.ffffe4p-1, INEXACT) // -2.318896341779067005184344907320e-02
T(RZ,   -0x1.7bed8fe07bb88p-6,    0x1.00119efde2d3cp+0, -0x1.c49bb4p-21, INEXACT) // -2.318896341779067005184344907320e-02
T(RN,    0x1.ad74de9cf1fcdp-9,    0x1.00005a0e22364p+0,   0x1.ffffecp-2, INEXACT) // 3.276493238875111211477753059285e-03
T(RD,   -0x1.fcad8a9b72aa7p+0,    0x1.db93b7e022935p+1, -0x1.cd06d6p-21, INEXACT) // -1.987023032141829181895786859968e+00
T(RU,   -0x1.fcad8a9b72aa7p+0,    0x1.db93b7e022936p+1,   0x1.ffffe4p-1, INEXACT) // -1.987023032141829181895786859968e+00
T(RZ,   -0x1.fcad8a9b72aa7p+0,    0x1.db93b7e022935p+1, -0x1.cd06d6p-21, INEXACT) // -1.987023032141829181895786859968e+00
T(RD,    -0x1.8be1b572d002p+1,    0x1.615aacd135f7ep+3, -0x1.a7ff88p-23, INEXACT) // -3.092825585423284451280778739601e+00
T(RU,    -0x1.8be1b572d002p+1,    0x1.615aacd135f7fp+3,   0x1.fffffap-1, INEXACT) // -3.092825585423284451280778739601e+00
T(RZ,    -0x1.8be1b572d002p+1,    0x1.615aacd135f7ep+3, -0x1.a7ff88p-23, INEXACT) // -3.092825585423284451280778739601e+00
T(RD,    0x1.2322f4cc98dfap+8,  0x1.03cc9f96666ffp+419, -0x1.664c1cp-22, INEXACT) // 2.911365478394724277677596546710e+02
T(RU,    0x1.2322f4cc98dfap+8,    0x1.03cc9f96667p+419,   0x1.fffff4p-1, INEXACT) // 2.911365478394724277677596546710e+02
T(RZ,    0x1.2322f4cc98dfap+8,  0x1.03cc9f96666ffp+419, -0x1.664c1cp-22, INEXACT) // 2.911365478394724277677596546710e+02
T(RD,   -0x1.717921413a66bp+2,    0x1.41827eb34fb0cp+7,  -0x1.fffffep-1, INEXACT) // -5.773018182467789749523490172578e+00
T(RU,   -0x1.717921413a66bp+2,    0x1.41827eb34fb0dp+7,  0x1.072a64p-25, INEXACT) // -5.773018182467789749523490172578e+00
T(RZ,   -0x1.717921413a66bp+2,    0x1.41827eb34fb0cp+7,  -0x1.fffffep-1, INEXACT) // -5.773018182467789749523490172578e+00
T(RD,   -0x1.c6dfbb7558c37p+4,   0x1.02b99055cef8fp+40,  -0x1.ffffe2p-1, INEXACT) // -2.842962213362281076456383743789e+01
T(RU,   -0x1.c6dfbb7558c37p+4,    0x1.02b99055cef9p+40,  0x1.e7f5d4p-21, INEXACT) // -2.842962213362281076456383743789e+01
T(RZ,   -0x1.c6dfbb7558c37p+4,   0x1.02b99055cef8fp+40,  -0x1.ffffe2p-1, INEXACT) // -2.842962213362281076456383743789e+01
T(RN,   -0x1.cb720f0f6cc0ep-7,    0x1.0006712b5446cp+0,  -0x1.ffffccp-2, INEXACT) // -1.402116523136067924304448695239e-02
T(RD,   -0x1.a94f42cf9766ap-4,     0x1.01619d6cd6f6p+0,  -0x1.24de4p-22, INEXACT) // -1.038353547860083880838288905579e-01
T(RU,   -0x1.a94f42cf9766ap-4,    0x1.01619d6cd6f61p+0,   0x1.fffff6p-1, INEXACT) // -1.038353547860083880838288905579e-01
T(RZ,   -0x1.a94f42cf9766ap-4,     0x1.01619d6cd6f6p+0,  -0x1.24de4p-22, INEXACT) // -1.038353547860083880838288905579e-01
T(RN,   0x1.c39a98b7b73e2p-10,    0x1.000018e55102fp+0,   0x1.ffffdep-2, INEXACT) // 1.722732134957321182416878357913e-03
T(RN,   -0x1.27d054972963ep+0,    0x1.becb2e44dc2e6p+0,    0x1.fffffp-2, INEXACT) // -1.155522620110232434598174222629e+00
T(RD,   -0x1.b8c106bd3f245p+1,    0x1.f5328aae3bfe4p+3,  -0x1.4b2d9p-21, INEXACT) // -3.443390695958699954104531570920e+00
T(RU,   -0x1.b8c106bd3f245p+1,    0x1.f5328aae3bfe5p+3,   0x1.ffffecp-1, INEXACT) // -3.443390695958699954104531570920e+00
T(RZ,   -0x1.b8c106bd3f245p+1,    0x1.f5328aae3bfe4p+3,  -0x1.4b2d9p-21, INEXACT) // -3.443390695958699954104531570920e+00
T(RN,   -0x1.2fb0b15a8f633p-5,    0x1.002d09c9bc1d6p+0,  -0x1.ffffe2p-2, INEXACT) // -3.707155837444666562907613638345e-02
T(RN,   -0x1.8cb270da768afp+4,   0x1.b469ec194f924p+34,  -0x1.ffffc4p-2, INEXACT) // -2.479356465661174624415252765175e+01
T(RN,   -0x1.326bf910764ffp+2,    0x1.e0335969e7988p+5,   0x1.ffffd2p-2, INEXACT) // -4.787840143276524962345774838468e+00
T(RD,    0x1.07e8daa2e239cp-5,    0x1.002202c96462ap+0,  -0x1.ffffeep-1, INEXACT) // 3.221552564998050871558632479719e-02
T(RU,    0x1.07e8daa2e239cp-5,    0x1.002202c96462bp+0,  0x1.1e1ec6p-21, INEXACT) // 3.221552564998050871558632479719e-02
T(RZ,    0x1.07e8daa2e239cp-5,    0x1.002202c96462ap+0,  -0x1.ffffeep-1, INEXACT) // 3.221552564998050871558632479719e-02
T(RN,    0x1.05ad4b4640f21p-2,    0x1.086782149ca7ep+0,   0x1.fffff8p-2, INEXACT) // 2.555438768033458374340227692301e-01
T(RN,    0x1.49dc3b5e8fc3bp-1,    0x1.36fdfa634f53dp+0,   0x1.fffff2p-2, INEXACT) // 6.442583611423126077610845641175e-01
T(RD,   -0x1.7718c8cecd546p-5,    0x1.0044b64682165p+0, -0x1.eb18d8p-26, INEXACT) // -4.578818531300980765319508236644e-02
T(RU,   -0x1.7718c8cecd546p-5,    0x1.0044b64682166p+0,          0x1p+0, INEXACT) // -4.578818531300980765319508236644e-02
T(RZ,   -0x1.7718c8cecd546p-5,    0x1.0044b64682165p+0, -0x1.eb18d8p-26, INEXACT) // -4.578818531300980765319508236644e-02
T(RD,    0x1.f0b9ecd0ccaeep+5,   0x1.7e2b2ef6b9dbbp+88,  -0x1.fffff8p-1, INEXACT) // 6.209078372120517030907649314031e+01
T(RU,    0x1.f0b9ecd0ccaeep+5,   0x1.7e2b2ef6b9dbcp+88,  0x1.101068p-22, INEXACT) // 6.209078372120517030907649314031e+01
T(RZ,    0x1.f0b9ecd0ccaeep+5,   0x1.7e2b2ef6b9dbbp+88,  -0x1.fffff8p-1, INEXACT) // 6.209078372120517030907649314031e+01
T(RD,   -0x1.c22acf51863b1p+5,   0x1.225ef31739b4ep+80, -0x1.cacb2ep-21, INEXACT) // -5.627090324107064844838532735594e+01
T(RU,   -0x1.c22acf51863b1p+5,   0x1.225ef31739b4fp+80,   0x1.ffffe4p-1, INEXACT) // -5.627090324107064844838532735594e+01
T(RZ,   -0x1.c22acf51863b1p+5,   0x1.225ef31739b4ep+80, -0x1.cacb2ep-21, INEXACT) // -5.627090324107064844838532735594e+01
T(RD,   -0x1.2577a2f8d9466p+0,    0x1.bb74be7a0adc8p+0,  -0x1.fffff6p-1, INEXACT) // -1.146356759790501111950788981630e+00
T(RU,   -0x1.2577a2f8d9466p+0,    0x1.bb74be7a0adc9p+0,  0x1.5547aap-22, INEXACT) // -1.146356759790501111950788981630e+00
T(RZ,   -0x1.2577a2f8d9466p+0,    0x1.bb74be7a0adc8p+0,  -0x1.fffff6p-1, INEXACT) // -1.146356759790501111950788981630e+00
