// This file is generated by "./lib/proto/generate"

package proto

/*

WebAudio

This domain allows inspection of Web Audio API.
https://webaudio.github.io/web-audio-api/

*/

// WebAudioGraphObjectID An unique ID for a graph object (AudioContext, AudioNode, AudioParam) in Web Audio API.
type WebAudioGraphObjectID string

// WebAudioContextType Enum of BaseAudioContext types.
type WebAudioContextType string

const (
	// WebAudioContextTypeRealtime enum const.
	WebAudioContextTypeRealtime WebAudioContextType = "realtime"

	// WebAudioContextTypeOffline enum const.
	WebAudioContextTypeOffline WebAudioContextType = "offline"
)

// WebAudioContextState Enum of AudioContextState from the spec.
type WebAudioContextState string

const (
	// WebAudioContextStateSuspended enum const.
	WebAudioContextStateSuspended WebAudioContextState = "suspended"

	// WebAudioContextStateRunning enum const.
	WebAudioContextStateRunning WebAudioContextState = "running"

	// WebAudioContextStateClosed enum const.
	WebAudioContextStateClosed WebAudioContextState = "closed"
)

// WebAudioNodeType Enum of AudioNode types.
type WebAudioNodeType string

// WebAudioChannelCountMode Enum of AudioNode::ChannelCountMode from the spec.
type WebAudioChannelCountMode string

const (
	// WebAudioChannelCountModeClampedMax enum const.
	WebAudioChannelCountModeClampedMax WebAudioChannelCountMode = "clamped-max"

	// WebAudioChannelCountModeExplicit enum const.
	WebAudioChannelCountModeExplicit WebAudioChannelCountMode = "explicit"

	// WebAudioChannelCountModeMax enum const.
	WebAudioChannelCountModeMax WebAudioChannelCountMode = "max"
)

// WebAudioChannelInterpretation Enum of AudioNode::ChannelInterpretation from the spec.
type WebAudioChannelInterpretation string

const (
	// WebAudioChannelInterpretationDiscrete enum const.
	WebAudioChannelInterpretationDiscrete WebAudioChannelInterpretation = "discrete"

	// WebAudioChannelInterpretationSpeakers enum const.
	WebAudioChannelInterpretationSpeakers WebAudioChannelInterpretation = "speakers"
)

// WebAudioParamType Enum of AudioParam types.
type WebAudioParamType string

// WebAudioAutomationRate Enum of AudioParam::AutomationRate from the spec.
type WebAudioAutomationRate string

const (
	// WebAudioAutomationRateARate enum const.
	WebAudioAutomationRateARate WebAudioAutomationRate = "a-rate"

	// WebAudioAutomationRateKRate enum const.
	WebAudioAutomationRateKRate WebAudioAutomationRate = "k-rate"
)

// WebAudioContextRealtimeData Fields in AudioContext that change in real-time.
type WebAudioContextRealtimeData struct {
	// CurrentTime The current context time in second in BaseAudioContext.
	CurrentTime float64 `json:"currentTime"`

	// RenderCapacity The time spent on rendering graph divided by render quantum duration,
	// and multiplied by 100. 100 means the audio renderer reached the full
	// capacity and glitch may occur.
	RenderCapacity float64 `json:"renderCapacity"`

	// CallbackIntervalMean A running mean of callback interval.
	CallbackIntervalMean float64 `json:"callbackIntervalMean"`

	// CallbackIntervalVariance A running variance of callback interval.
	CallbackIntervalVariance float64 `json:"callbackIntervalVariance"`
}

// WebAudioBaseAudioContext Protocol object for BaseAudioContext.
type WebAudioBaseAudioContext struct {
	// ContextID ...
	ContextID WebAudioGraphObjectID `json:"contextId"`

	// ContextType ...
	ContextType WebAudioContextType `json:"contextType"`

	// ContextState ...
	ContextState WebAudioContextState `json:"contextState"`

	// RealtimeData (optional) ...
	RealtimeData *WebAudioContextRealtimeData `json:"realtimeData,omitempty"`

	// CallbackBufferSize Platform-dependent callback buffer size.
	CallbackBufferSize float64 `json:"callbackBufferSize"`

	// MaxOutputChannelCount Number of output channels supported by audio hardware in use.
	MaxOutputChannelCount float64 `json:"maxOutputChannelCount"`

	// SampleRate Context sample rate.
	SampleRate float64 `json:"sampleRate"`
}

// WebAudioAudioListener Protocol object for AudioListener.
type WebAudioAudioListener struct {
	// ListenerID ...
	ListenerID WebAudioGraphObjectID `json:"listenerId"`

	// ContextID ...
	ContextID WebAudioGraphObjectID `json:"contextId"`
}

// WebAudioAudioNode Protocol object for AudioNode.
type WebAudioAudioNode struct {
	// NodeID ...
	NodeID WebAudioGraphObjectID `json:"nodeId"`

	// ContextID ...
	ContextID WebAudioGraphObjectID `json:"contextId"`

	// NodeType ...
	NodeType WebAudioNodeType `json:"nodeType"`

	// NumberOfInputs ...
	NumberOfInputs float64 `json:"numberOfInputs"`

	// NumberOfOutputs ...
	NumberOfOutputs float64 `json:"numberOfOutputs"`

	// ChannelCount ...
	ChannelCount float64 `json:"channelCount"`

	// ChannelCountMode ...
	ChannelCountMode WebAudioChannelCountMode `json:"channelCountMode"`

	// ChannelInterpretation ...
	ChannelInterpretation WebAudioChannelInterpretation `json:"channelInterpretation"`
}

// WebAudioAudioParam Protocol object for AudioParam.
type WebAudioAudioParam struct {
	// ParamID ...
	ParamID WebAudioGraphObjectID `json:"paramId"`

	// NodeID ...
	NodeID WebAudioGraphObjectID `json:"nodeId"`

	// ContextID ...
	ContextID WebAudioGraphObjectID `json:"contextId"`

	// ParamType ...
	ParamType WebAudioParamType `json:"paramType"`

	// Rate ...
	Rate WebAudioAutomationRate `json:"rate"`

	// DefaultValue ...
	DefaultValue float64 `json:"defaultValue"`

	// MinValue ...
	MinValue float64 `json:"minValue"`

	// MaxValue ...
	MaxValue float64 `json:"maxValue"`
}

// WebAudioEnable Enables the WebAudio domain and starts sending context lifetime events.
type WebAudioEnable struct{}

// ProtoReq name.
func (m WebAudioEnable) ProtoReq() string { return "WebAudio.enable" }

// Call sends the request.
func (m WebAudioEnable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// WebAudioDisable Disables the WebAudio domain.
type WebAudioDisable struct{}

// ProtoReq name.
func (m WebAudioDisable) ProtoReq() string { return "WebAudio.disable" }

// Call sends the request.
func (m WebAudioDisable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// WebAudioGetRealtimeData Fetch the realtime data from the registered contexts.
type WebAudioGetRealtimeData struct {
	// ContextID ...
	ContextID WebAudioGraphObjectID `json:"contextId"`
}

// ProtoReq name.
func (m WebAudioGetRealtimeData) ProtoReq() string { return "WebAudio.getRealtimeData" }

// Call the request.
func (m WebAudioGetRealtimeData) Call(c Client) (*WebAudioGetRealtimeDataResult, error) {
	var res WebAudioGetRealtimeDataResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// WebAudioGetRealtimeDataResult ...
type WebAudioGetRealtimeDataResult struct {
	// RealtimeData ...
	RealtimeData *WebAudioContextRealtimeData `json:"realtimeData"`
}

// WebAudioContextCreated Notifies that a new BaseAudioContext has been created.
type WebAudioContextCreated struct {
	// Context ...
	Context *WebAudioBaseAudioContext `json:"context"`
}

// ProtoEvent name.
func (evt WebAudioContextCreated) ProtoEvent() string {
	return "WebAudio.contextCreated"
}

// WebAudioContextWillBeDestroyed Notifies that an existing BaseAudioContext will be destroyed.
type WebAudioContextWillBeDestroyed struct {
	// ContextID ...
	ContextID WebAudioGraphObjectID `json:"contextId"`
}

// ProtoEvent name.
func (evt WebAudioContextWillBeDestroyed) ProtoEvent() string {
	return "WebAudio.contextWillBeDestroyed"
}

// WebAudioContextChanged Notifies that existing BaseAudioContext has changed some properties (id stays the same)..
type WebAudioContextChanged struct {
	// Context ...
	Context *WebAudioBaseAudioContext `json:"context"`
}

// ProtoEvent name.
func (evt WebAudioContextChanged) ProtoEvent() string {
	return "WebAudio.contextChanged"
}

// WebAudioAudioListenerCreated Notifies that the construction of an AudioListener has finished.
type WebAudioAudioListenerCreated struct {
	// Listener ...
	Listener *WebAudioAudioListener `json:"listener"`
}

// ProtoEvent name.
func (evt WebAudioAudioListenerCreated) ProtoEvent() string {
	return "WebAudio.audioListenerCreated"
}

// WebAudioAudioListenerWillBeDestroyed Notifies that a new AudioListener has been created.
type WebAudioAudioListenerWillBeDestroyed struct {
	// ContextID ...
	ContextID WebAudioGraphObjectID `json:"contextId"`

	// ListenerID ...
	ListenerID WebAudioGraphObjectID `json:"listenerId"`
}

// ProtoEvent name.
func (evt WebAudioAudioListenerWillBeDestroyed) ProtoEvent() string {
	return "WebAudio.audioListenerWillBeDestroyed"
}

// WebAudioAudioNodeCreated Notifies that a new AudioNode has been created.
type WebAudioAudioNodeCreated struct {
	// Node ...
	Node *WebAudioAudioNode `json:"node"`
}

// ProtoEvent name.
func (evt WebAudioAudioNodeCreated) ProtoEvent() string {
	return "WebAudio.audioNodeCreated"
}

// WebAudioAudioNodeWillBeDestroyed Notifies that an existing AudioNode has been destroyed.
type WebAudioAudioNodeWillBeDestroyed struct {
	// ContextID ...
	ContextID WebAudioGraphObjectID `json:"contextId"`

	// NodeID ...
	NodeID WebAudioGraphObjectID `json:"nodeId"`
}

// ProtoEvent name.
func (evt WebAudioAudioNodeWillBeDestroyed) ProtoEvent() string {
	return "WebAudio.audioNodeWillBeDestroyed"
}

// WebAudioAudioParamCreated Notifies that a new AudioParam has been created.
type WebAudioAudioParamCreated struct {
	// Param ...
	Param *WebAudioAudioParam `json:"param"`
}

// ProtoEvent name.
func (evt WebAudioAudioParamCreated) ProtoEvent() string {
	return "WebAudio.audioParamCreated"
}

// WebAudioAudioParamWillBeDestroyed Notifies that an existing AudioParam has been destroyed.
type WebAudioAudioParamWillBeDestroyed struct {
	// ContextID ...
	ContextID WebAudioGraphObjectID `json:"contextId"`

	// NodeID ...
	NodeID WebAudioGraphObjectID `json:"nodeId"`

	// ParamID ...
	ParamID WebAudioGraphObjectID `json:"paramId"`
}

// ProtoEvent name.
func (evt WebAudioAudioParamWillBeDestroyed) ProtoEvent() string {
	return "WebAudio.audioParamWillBeDestroyed"
}

// WebAudioNodesConnected Notifies that two AudioNodes are connected.
type WebAudioNodesConnected struct {
	// ContextID ...
	ContextID WebAudioGraphObjectID `json:"contextId"`

	// SourceID ...
	SourceID WebAudioGraphObjectID `json:"sourceId"`

	// DestinationID ...
	DestinationID WebAudioGraphObjectID `json:"destinationId"`

	// SourceOutputIndex (optional) ...
	SourceOutputIndex *float64 `json:"sourceOutputIndex,omitempty"`

	// DestinationInputIndex (optional) ...
	DestinationInputIndex *float64 `json:"destinationInputIndex,omitempty"`
}

// ProtoEvent name.
func (evt WebAudioNodesConnected) ProtoEvent() string {
	return "WebAudio.nodesConnected"
}

// WebAudioNodesDisconnected Notifies that AudioNodes are disconnected. The destination can be null, and it means all the outgoing connections from the source are disconnected.
type WebAudioNodesDisconnected struct {
	// ContextID ...
	ContextID WebAudioGraphObjectID `json:"contextId"`

	// SourceID ...
	SourceID WebAudioGraphObjectID `json:"sourceId"`

	// DestinationID ...
	DestinationID WebAudioGraphObjectID `json:"destinationId"`

	// SourceOutputIndex (optional) ...
	SourceOutputIndex *float64 `json:"sourceOutputIndex,omitempty"`

	// DestinationInputIndex (optional) ...
	DestinationInputIndex *float64 `json:"destinationInputIndex,omitempty"`
}

// ProtoEvent name.
func (evt WebAudioNodesDisconnected) ProtoEvent() string {
	return "WebAudio.nodesDisconnected"
}

// WebAudioNodeParamConnected Notifies that an AudioNode is connected to an AudioParam.
type WebAudioNodeParamConnected struct {
	// ContextID ...
	ContextID WebAudioGraphObjectID `json:"contextId"`

	// SourceID ...
	SourceID WebAudioGraphObjectID `json:"sourceId"`

	// DestinationID ...
	DestinationID WebAudioGraphObjectID `json:"destinationId"`

	// SourceOutputIndex (optional) ...
	SourceOutputIndex *float64 `json:"sourceOutputIndex,omitempty"`
}

// ProtoEvent name.
func (evt WebAudioNodeParamConnected) ProtoEvent() string {
	return "WebAudio.nodeParamConnected"
}

// WebAudioNodeParamDisconnected Notifies that an AudioNode is disconnected to an AudioParam.
type WebAudioNodeParamDisconnected struct {
	// ContextID ...
	ContextID WebAudioGraphObjectID `json:"contextId"`

	// SourceID ...
	SourceID WebAudioGraphObjectID `json:"sourceId"`

	// DestinationID ...
	DestinationID WebAudioGraphObjectID `json:"destinationId"`

	// SourceOutputIndex (optional) ...
	SourceOutputIndex *float64 `json:"sourceOutputIndex,omitempty"`
}

// ProtoEvent name.
func (evt WebAudioNodeParamDisconnected) ProtoEvent() string {
	return "WebAudio.nodeParamDisconnected"
}
