#!/bin/sh

# This test makes sure that the `strict` option works correctly.

set -e
set -u
set -x

if ! "$RQ" -I "json::./valid.json" ; then
	echo "expected valid.json not to error by default" 1>&2
	exit 1
fi

if "$RQ" -I "json::./invalid.json" ; then
	echo "expected valid.json to error by default" 1>&2
	exit 1
fi

if ! "$RQ" -I "json:strict=true:./valid.json" ; then
	echo "expected valid.json not to error with strict=true" 1>&2
	exit 1
fi

if "$RQ" -I "json:strict=true:./invalid.json" ; then
	echo "expected valid.json to error by with strict=true" 1>&2
	exit 1
fi

if ! "$RQ" -I "json:strict=false:./valid.json" ; then
	echo "expected valid.json not to error with strict=false" 1>&2
	exit 1
fi

if ! "$RQ" -I "json:strict=false:./invalid.json" ; then
	echo "expected valid.json not to error by with strict=false" 1>&2
	exit 1
fi
