#!/bin/sh

set -e
set -u
cd "$(dirname "$0")/.."

export RQ="./build/rq"

if [ ! -e ./capabilities.json ] ; then
	echo "capabilities.json is not present, do you need to run 'make capabilities'?" 1>&2
	exit 1
fi

if [ ! -x "$RQ" ] ; then
	echo "rq ('$RQ') is not present, do you need to run 'make rq'?" 1>&2
	exit 1
fi

TEMP="$(mktemp -d)"
trap "rm -rf $TEMP" EXIT

"$RQ" capabilities > "$TEMP/capabilities.json"

if ! diff ./capabilities.json "$TEMP/capabilities.json" ; then
	echo "capabilities.json needs to be updated, do you need to run 'make capabilities'?" 1>&2
	exit 1
fi

exit 0
