# -*- coding: utf-8 -*-
# GNU General Public License v3.0 (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)
"""A list of static data"""

from __future__ import absolute_import, division, unicode_literals

# The margin at start/end to consider a video as watched
# This value is used by resumepoints and upnext
SECONDS_MARGIN = 30

# Fallback list of categories so we don't depend on web scraping only
CATEGORIES = [
    {'name': 'Audiodescriptie', 'id': 'met-audiodescriptie', 'msgctxt': 30070},
    {'name': 'Cultuur', 'id': 'cultuur', 'msgctxt': 30071},
    {'name': 'Docu', 'id': 'docu', 'msgctxt': 30072},
    {'name': 'Entertainment', 'id': 'entertainment', 'msgctxt': 30073},
    {'name': 'Films', 'id': 'films', 'msgctxt': 30074},
    {'name': 'Human interest', 'id': 'human-interest', 'msgctxt': 30075},
    {'name': 'Humor', 'id': 'humor', 'msgctxt': 30076},
    {'name': 'Kinderen en jongeren', 'id': 'voor-kinderen', 'msgctxt': 30077},
    {'name': 'Koken', 'id': 'koken', 'msgctxt': 30078},
    {'name': 'Levensbeschouwing', 'id': 'levensbeschouwing', 'msgctxt': 30087},
    {'name': 'Lifestyle', 'id': 'lifestyle', 'msgctxt': 30079},
    {'name': 'Muziek', 'id': 'muziek', 'msgctxt': 30080},
    {'name': 'Nieuws en actua', 'id': 'nieuws-en-actua', 'msgctxt': 30081},
    {'name': 'Nostalgie', 'id': 'nostalgie', 'msgctxt': 30088},
    {'name': 'Series', 'id': 'series', 'msgctxt': 30082},
    {'name': 'Sport', 'id': 'sport', 'msgctxt': 30083},
    {'name': 'Talkshows', 'id': 'talkshows', 'msgctxt': 30084},
    {'name': 'Vlaamse Gebarentaal', 'id': 'met-gebarentaal', 'msgctxt': 30085},
    {'name': 'Wetenschap en natuur', 'id': 'wetenschap-en-natuur', 'msgctxt': 30086},
]

# TODO: Find a solution for the below VRT YouTube channels
#     {'label': 'VRT', 'url': 'https://www.youtube.com/channel/UCojJNXcer3yKj9Q-RWOFZuw'},
#     {'label': 'VRT MAX', 'url': 'https://www.youtube.com/channel/UCt3RWMlMKf5jKg5cvqxC_xA'},
#     {'label': 'VRT met VGT', 'url': 'https://www.youtube.com/channel/UC5M_bvCAK3WkszBw_eCXxKQ'},

CHANNELS = [
    {
        'id': 'O8',
        'name': 'een',
        'label': 'VRT 1',
        'studio': 'Een',
        'live_stream': 'https://www.vrt.be/vrtnu/livestream/video/vrt1/',
        'live_stream_id': 'vualto_een_geo',
        'youtube': [
            {'label': 'VRT 1', 'url': 'https://www.youtube.com/user/welkombijeen'},
            {'label': 'Muziek bij VRT 1', 'url': 'https://www.youtube.com/channel/UC7mPNmdg7ADGt0gH8xOrXpQ'},
        ],
        'has_tvguide': True,
        'logo': 'https://images.vrt.be/orig/2023/04/28/c448d669-e5c1-11ed-91d7-02b7b76bf47f.png',
        'epg_id': 'een.be',
        'preset': 1,
        'vod': True,
    },
    {
        'id': '1H',
        'name': 'canvas',
        'label': 'VRT Canvas',
        'studio': 'Canvas',
        'live_stream': 'https://www.vrt.be/vrtmax/livestream/video/vrt-canvas/',
        'live_stream_id': 'vualto_canvas_geo',
        'youtube': [
            {'label': 'VRT Canvas', 'url': 'https://www.youtube.com/user/CanvasTV'},
            {'label': 'Sporza', 'url': 'https://www.youtube.com/user/SporzaOfficial'},
            {'label': 'Terzake', 'url': 'https://www.youtube.com/user/terzaketv'},
        ],
        'has_tvguide': True,
        'logo': 'https://images.vrt.be/orig/logo/canvas/CANVAS_logo_lichtblauw.jpg',
        'epg_id': 'canvas.be',
        'preset': 2,
        'vod': True,
    },
    {
        'id': 'O9',
        'name': 'ketnet',
        'label': 'Ketnet',
        'studio': 'Ketnet',
        'live_stream': 'https://www.vrt.be/vrtmax/livestream/video/ketnet/',
        'live_stream_id': 'vualto_ketnet_geo',
        'youtube': [
            {'label': 'Ketnet', 'url': 'https://www.youtube.com/user/KetnetVideo'},
            {'label': 'Ketnet Musical', 'url': 'https://www.youtube.com/channel/UCB90ZMfqVLgGtp3Z99h4GWg'},
            {'label': 'Karrewiet', 'url': 'https://www.youtube.com/channel/UCCUHHJrtsoC1oyihO86mnMg'},
        ],
        'has_tvguide': True,
        'logo': 'https://images.vrt.be/orig/logo/ketnet/ketnet_LOGO_rood_geel.png',
        'epg_id': 'ketnet.be',
        'preset': 12,
        'vod': True,
    },
    {
        'id': '',
        'name': 'ketnet-jr',
        'label': 'Ketnet Junior',
        'studio': 'Ketnet Junior',
        'live_stream_id': 'ketnet_jr',
        'youtube': [
            {'label': 'Ketnet Junior', 'url': 'https://www.youtube.com/channel/UCTxm_H52WlKWBEB_h7PjzFA'},
        ],
        'logo': 'https://images.vrt.be/orig/2019/07/19/c309360a-aa10-11e9-abcc-02b7b76bf47f.png',
        'epg_id': 'ketnetjr.be',
        'preset': 11,
        'vod': True,
    },
    {
        'id': '',
        'name': 'podium19',
        'label': 'Podium 19',
        'studio': 'Podium 19',
        'logo': 'https://images.vrt.be/orig/2020/12/19/53f5fa6f-4223-11eb-aae0-02b7b76bf47f.png',
        'vod': True,
    },
    {
        'id': '',
        'name': 'vrt-nu',
        'label': 'VRT NU',
        'studio': 'VRT NU',
        'logo': 'https://www.vrt.be/etc.clientlibs/vrtvideo/clientlibs/clientlib-site/resources/logo-vrt_NU-pos-rgb@4x.png',
        'vod': True,
    },
    {
        'id': 'OE',
        'name': 'sporza',
        'label': 'Sporza',
        'studio': 'Sporza',
        'live_stream_id': 'vualto_sporza_geo',
        'youtube': [
            {'label': 'Sporza', 'url': 'https://www.youtube.com/user/SporzaOfficial'},
        ],
        'logo': 'https://images.vrt.be/orig/logo/sporza/sporza_logo_zwart.png',
        'epg_id': 'sporza.be',
        'preset': 801,
        'vod': True,
    },
    {
        'id': '13',
        'name': 'vrtnws',
        'label': 'VRT NWS',
        'studio': 'VRT NWS',
        'live_stream_id': 'vualto_nieuws',
        # 'live_stream_id': 'vualto_journaal',
        'youtube': [
            {'label': 'VRT NWS', 'url': 'https://www.youtube.com/channel/UC59gT3bFTFNSqafRcluDIsQ'},
            {'label': 'Terzake', 'url': 'https://www.youtube.com/user/terzaketv'},
        ],
        'logo': 'https://images.vrt.be/orig/logos/vrtnws.png',
        'epg_id': 'vrtnws.be',
        'preset': 802,
        'vod': True,
    },
    {
        'id': '11',
        'name': 'radio1',
        'label': 'Radio 1',
        'studio': 'Radio 1',
        'live_stream_id': 'vualto_radio1',
        'youtube': [
            {'label': 'Radio 1', 'url': 'https://www.youtube.com/user/vrtradio1'},
            {'label': 'Universiteit van Vlaanderen', 'url': 'https://www.youtube.com/channel/UC7WpOKbKfzOOnD0PyUN_SYg'},
        ],
        'logo': 'https://images.vrt.be/orig/logos/radio1.png',
        'epg_id': 'radio1.be',
        'preset': 901,
        'vod': True,
    },
    {
        'id': '22',
        'name': 'radio2',
        'label': 'Radio 2',
        'studio': 'Radio 2',
        'live_stream_id': 'vualto_radio2',
        'youtube': [
            {'label': 'Radio 2', 'url': 'https://www.youtube.com/user/radio2inbeeld'},
            {'label': 'Aha!', 'url': 'https://www.youtube.com/channel/UCa9lGLvXB-xJg3d0BjK_tIQ'},
        ],
        'logo': 'https://images.vrt.be/orig/logos/radio2.png',
        'epg_id': 'radio2vlb.be',
        'preset': 902,
        'vod': True,
    },
    {
        'id': '31',
        'name': 'klara',
        'label': 'Klara',
        'studio': 'Klara',
        'live_stream_id': 'vualto_klara',
        'youtube': [
            {'label': 'Klara', 'url': 'https://www.youtube.com/user/klararadio'},
            {'label': 'Iedereen klassiek', 'url': 'https://www.youtube.com/channel/UCgyfqQgt5_K8_zrxHgh_J2w'},
        ],
        'logo': 'https://images.vrt.be/orig/logos/klara.png',
        'epg_id': 'klara.be',
        'preset': 903,
        'vod': True,
    },
    {
        'id': '41',
        'name': 'stubru',
        'label': 'Studio Brussel',
        'studio': 'Studio Brussel',
        # 'live_stream': 'https://stubru.be/live',
        'live_stream_id': 'vualto_stubru',
        'youtube': [
            {'label': 'Studio Brussel', 'url': 'https://www.youtube.com/user/StuBru'},
        ],
        'logo': 'https://images.vrt.be/orig/2019/03/12/1e383cf5-44a7-11e9-abcc-02b7b76bf47f.png',
        'epg_id': 'stubru.be',
        'preset': 904,
        'vod': True,
    },
    {
        'id': '55',
        'name': 'mnm',
        'label': 'MNM',
        'studio': 'MNM',
        # 'live_stream': 'https://mnm.be/kijk/live',
        'live_stream_id': 'vualto_mnm',
        'youbube': [
            {'label': 'MNM', 'url': 'https://www.youtube.com/user/MNMbe'},
        ],
        'logo': 'https://images.vrt.be/orig/logo/mnm/logo_witte_achtergrond.png',
        'epg_id': 'mnm.be',
        'preset': 905,
        'vod': True,
    },
    {
        'id': '',
        'name': 'vrtnxt',
        'label': 'VRT NXT',
        'studio': 'VRT NXT',
        'youtube': [
            {'label': 'VRT NXT', 'url': 'https://www.youtube.com/channel/UCO-VoGCVzhYVwvQvWYJq4-Q'},
        ],
        'vod': True,
    },
    {
        'id': '',
        'name': 'de-warmste-week',
        'label': 'De Warmste Week',
        'studio': 'De Warmste Week',
        'youtube': [
            {'label': 'De Warmste Week', 'url': 'https://www.youtube.com/channel/UC_PsMpKLAp4hSGSXyUCPtxw'},
        ],
        'vod': True,
    },
    {
        'id': '',
        'name': 'vrt-events1',
        'label': 'VRT Events 1',
        'studio': 'VRT',
        'live_stream_id': 'vualto_events1_geo',
        'logo': 'https://images.vrt.be/orig/logo/vrt.png',
        'epg_id': 'vrtevents1.be',
        'preset': 851,
        'vod': False,
    },
    {
        'id': '',
        'name': 'vrt-events2',
        'label': 'VRT Events 2',
        'studio': 'VRT',
        'live_stream_id': 'vualto_events2_geo',
        'logo': 'https://images.vrt.be/orig/logo/vrt.png',
        'epg_id': 'vrtevents2.be',
        'preset': 852,
        'vod': False,
    },
    {
        'id': '',
        'name': 'vrt-events3',
        'label': 'VRT Events 3',
        'studio': 'VRT',
        'live_stream_id': 'vualto_events3_geo',
        'logo': 'https://images.vrt.be/orig/logo/vrt.png',
        'epg_id': 'vrtevents3.be',
        'preset': 853,
        'vod': False,
    },
]

FEATURED = [
    # Tijdsgerelateerd
    {'name': 'Exclusief online', 'id': 'exclusief-online', 'msgctxt': 30100},
    {'name': 'Volledig seizoen', 'id': 'volledig-seizoen', 'msgctxt': 30101},
    {'name': 'Volledige reeks', 'id': 'volledige-reeks', 'msgctxt': 30102},
    {'name': 'Uit het archief', 'id': 'uit-het-archief', 'msgctxt': 30103},
    # {'name: 'Laatste kans', 'id': 'laatste-kans', 'msgctxt': 30104},
    # Inhoudsgerelateerd
    {'name': 'Kortfilm', 'id': 'kortfilm', 'msgctxt': 30120},
    # {'name': '12+', 'id': '12+', 'msgctxt': 30121},
    # {'name': 'Cinema canvas', 'id': 'cinema-canvas', 'msgctxt': 30122},
    # Thema
    {'name': 'Klimaat', 'id': 'klimaat', 'msgctxt': 30128},
    # {'name': 'Koers', 'id': 'koers', 'msgctxt': 30129},
    {'name': 'De warmste week', 'id': 'de-warmste-week', 'msgctxt': 30130},
]

RELATIVE_DATES = [
    {'id': '2-days-ago', 'offset': -2, 'msgctxt': 30330, 'permalink': False},
    {'id': 'yesterday', 'offset': -1, 'msgctxt': 30331, 'permalink': True},
    {'id': 'today', 'offset': 0, 'msgctxt': 30332, 'permalink': True},
    {'id': 'tomorrow', 'offset': 1, 'msgctxt': 30333, 'permalink': True},
    {'id': 'in-2-days', 'offset': 2, 'msgctxt': 30334, 'permalink': False},
]
