/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "Document.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMWrapper.h"
#include "JSNode.h"
#include <JavaScriptCore/DOMJITGetterSetter.h>
#include <JavaScriptCore/Snippet.h>

namespace WebCore {

class WEBCORE_EXPORT JSDocument : public JSNode {
public:
    using Base = JSNode;
    using DOMWrapped = Document;
    static JSDocument* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<Document>&& impl)
    {
        JSDocument* ptr = new (NotNull, JSC::allocateCell<JSDocument>(globalObject->vm())) JSDocument(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static Document* toWrapped(JSC::VM&, JSC::JSValue);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::JSType(JSDocumentWrapperType), StructureFlags), info(), JSC::NonArray);
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    template<typename, JSC::SubspaceAccess mode> static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        if constexpr (mode == JSC::SubspaceAccess::Concurrently)
            return nullptr;
        return subspaceForImpl(vm);
    }
    static JSC::GCClient::IsoSubspace* subspaceForImpl(JSC::VM& vm);
    DECLARE_VISIT_CHILDREN;
    template<typename Visitor> void visitAdditionalChildren(Visitor&);

    template<typename Visitor> static void visitOutputConstraints(JSCell*, Visitor&);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
    Document& wrapped() const
    {
        return static_cast<Document&>(Base::wrapped());
    }
public:
    static constexpr unsigned StructureFlags = Base::StructureFlags | JSC::HasStaticPropertyTable;
protected:
    JSDocument(JSC::Structure*, JSDOMGlobalObject&, Ref<Document>&&);

    void finishCreation(JSC::VM&);
};

WEBCORE_EXPORT JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, Document&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, Document* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<Document>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<Document>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

#if ENABLE(JIT)
Ref<JSC::Snippet> checkSubClassSnippetForJSDocument();
#endif
// DOM JIT Attributes

#if ENABLE(JIT)
Ref<JSC::DOMJIT::CallDOMGetterSnippet> compileDocumentDocumentElementAttribute();
#endif

#if ENABLE(JIT)
Ref<JSC::DOMJIT::CallDOMGetterSnippet> compileDocumentBodyAttribute();
#endif

template<> struct JSDOMWrapperConverterTraits<Document> {
    using WrapperClass = JSDocument;
    using ToWrappedReturnType = Document*;
};
String convertEnumerationToString(Document::ReadyState);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, Document::ReadyState);

template<> std::optional<Document::ReadyState> parseEnumeration<Document::ReadyState>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<Document::ReadyState>();


} // namespace WebCore
#include "JSDocumentCustom.h"
