# NFL Game Pass Kodi Plugin #
**version 0.8.0 — Julius Peppers Edition**

Before reading any further, please understand that while this addon does work,
not all features are supported (or fully tested) and it should be forever
regarded as a beta release. It may crash, spay your puppy, and/or cause your
oven to not heat to 400° F properly.

If you're interested in helping out, just drop us an email or send a pull
request. Patches and (constructive) input are always welcome.

## Any Dependencies? ##

This addon requires Kodi Helix or later. XBMC Gotham and earlier are no longer
supported due to upstream changes in the skinning system.

This addon is part of the official Kodi repository, thus all dependencies are
installed automatically. However, if you're installing straight from source,
make sure the following two dependencies are installed:
 * xmltodict (http://mirrors.kodi.tv/addons/gotham/script.module.xmltodict/)
 * Requests 2.x (http://mirrors.kodi.tv/addons/gotham/script.module.requests/)

## What is NFL Game Pass? ##

NFL Game Pass is website that allows those with subscriptions to watch NFL
games. Archives of old games stretch back to 2009, coaches film (22 man view) is
available, as is audio from each team's radio network. Overall, it is a sweet
service offered by the NFL for those of us who must have our American Football
fix.

## What is Game Pass Domestic? ##

NFL Game Pass Domestic is the USA version of Game Pass, but the service is
blacked out during live games. Previously it lacked other features, but with the
recent revamping (mid-2015) of their service, we have yet to find a side-by-side
comparison of the two services. Information from Game Pass Domestic users would
be most appreciated.

As of mid-August 2015, we do not yet have complete support for Game Pass
Domestic, but work in ongoing and should be stabilizing soon.

## Why write a plugin for Kodi? ##

First off, we love Kodi and like consuming media through its interface.
Secondly, while there is a nice Flash interface, it's... well... written in
Flash. The client is a resource hog, the interface is frequently buggy, and it
includes a bunch of bells and whistles (social media, for example) that are
simply distracting. We're here to watch a game, nothing else.

## What features are currently supported? ##

By now, most core features are supported.

 * Archived games from 2011 to 2014 (both full and condensed)
 * Live games
 * Coaches Film (22 man view)
 * NFL Network - Live
 * A Football Life
 * NFL Films Presents
 * NFL Gameday
 * Playbook
 * NFL RedZone Archives
 * NFL RedZone - Live
 * Sound FX
 * Super Bowl Archives
 * Top 100 Players
 * NFL Total Access

Currently unsupported features:
 * Archived games prior to 2011
 * Alternate team audio
 * Coaches Show

## Release names ##

Want a release to be named after your player/coach of choice? Contribute to the
project in some way (code, art, debugging, beer, brazen — yet effective —
flattery, etc), and we'll gladly name a future release after them.

## Roadmap ##

A rough roadmap follows:

* Continue work towards feature completeness
* Stabilize Game Pass Domestic support
