/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.Sequence;
import gnu.lists.SimpleVector;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class F64Vector
extends SimpleVector
implements Externalizable,
Comparable {
    double[] data;
    protected static double[] empty = new double[0];

    public F64Vector() {
        this.data = empty;
    }

    public F64Vector(int size, double value) {
        double[] array = new double[size];
        this.data = array;
        this.size = size;
        while (--size >= 0) {
            array[size] = value;
        }
    }

    public F64Vector(int size) {
        this.data = new double[size];
        this.size = size;
    }

    public F64Vector(double[] data) {
        this.data = data;
        this.size = data.length;
    }

    public F64Vector(Sequence seq) {
        this.data = new double[seq.size()];
        this.addAll(seq);
    }

    @Override
    public int getBufferLength() {
        return this.data.length;
    }

    @Override
    public void setBufferLength(int length) {
        int oldLength = this.data.length;
        if (oldLength != length) {
            double[] tmp = new double[length];
            System.arraycopy(this.data, 0, tmp, 0, oldLength < length ? oldLength : length);
            this.data = tmp;
        }
    }

    @Override
    protected Object getBuffer() {
        return this.data;
    }

    public final double doubleAt(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.data[index];
    }

    public final double doubleAtBuffer(int index) {
        return this.data[index];
    }

    @Override
    public final Object get(int index) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return Convert.toObject(this.data[index]);
    }

    public final Object getBuffer(int index) {
        return Convert.toObject(this.data[index]);
    }

    @Override
    public final int intAtBuffer(int index) {
        return (int)this.data[index];
    }

    public final void setDoubleAt(int index, double value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.data[index] = value;
    }

    public final void setDoubleAtBuffer(int index, double value) {
        this.data[index] = value;
    }

    public final void setBuffer(int index, Object value) {
        this.data[index] = Convert.toDouble(value);
    }

    @Override
    protected void clearBuffer(int start, int count) {
        while (--count >= 0) {
            this.data[start++] = 0.0;
        }
    }

    @Override
    public int getElementKind() {
        return 26;
    }

    @Override
    public String getTag() {
        return "f64";
    }

    @Override
    public void consumePosRange(int iposStart, int iposEnd, Consumer out) {
        if (out.ignoring()) {
            return;
        }
        int end = iposEnd >>> 1;
        for (int i = iposStart >>> 1; i < end; ++i) {
            out.writeDouble(this.data[i]);
        }
    }

    public int compareTo(Object obj) {
        F64Vector vec2 = (F64Vector)obj;
        double[] arr1 = this.data;
        double[] arr2 = vec2.data;
        int n1 = this.size;
        int n2 = vec2.size;
        int n = n1 > n2 ? n2 : n1;
        for (int i = 0; i < n; ++i) {
            double v1 = arr1[i];
            double v2 = arr2[i];
            if (v1 == v2) continue;
            return v1 > v2 ? 1 : -1;
        }
        return n1 - n2;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int size = this.size;
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeDouble(this.data[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        double[] data = new double[size];
        for (int i = 0; i < size; ++i) {
            data[i] = in.readDouble();
        }
        this.data = data;
        this.size = size;
    }
}

