/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.AttrContainer;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.ExceptionsAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import gnu.bytecode.SwitchState;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.CheckedTarget;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Initializer;
import gnu.expr.Keyword;
import gnu.expr.ModuleExp;
import gnu.expr.ProcInitializer;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.Special;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.lists.LList;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import java.util.Vector;

public class LambdaExp
extends ScopeExp {
    public Expression body;
    public int min_args;
    public int max_args;
    Vector applyMethods;
    Variable argsArray;
    private Declaration firstArgsArrayArg;
    public Keyword[] keywords;
    public Expression[] defaultArgs;
    Declaration capturedVars;
    Variable heapFrame;
    public LambdaExp firstChild;
    public LambdaExp nextSibling;
    static final ApplyExp unknownContinuation = new ApplyExp((Expression)null, null);
    public ApplyExp returnContinuation;
    ReferenceExp[] throwsSpecification;
    public Declaration nameDecl;
    public Field closureEnvField;
    public Field staticLinkField;
    Variable closureEnv;
    static final int INLINE_ONLY = 1;
    static final int CAN_READ = 2;
    static final int CAN_CALL = 4;
    static final int IMPORTS_LEX_VARS = 8;
    static final int NEEDS_STATIC_LINK = 16;
    static final int CANNOT_INLINE = 32;
    static final int CLASS_METHOD = 64;
    static final int METHODS_COMPILED = 128;
    public static final int NO_FIELD = 256;
    static final int DEFAULT_CAPTURES_ARG = 512;
    public static final int SEQUENCE_RESULT = 1024;
    protected static final int NEXT_AVAIL_FLAG = 2048;
    public static String fileFunctionName = "atFileLevel";
    ClassType type = Compilation.typeProcedure;
    int selectorValue;
    Method[] primMethods;
    Variable thisVariable;
    static Method searchForKeywordMethod3;
    static Method searchForKeywordMethod4;
    Initializer initChain;
    Procedure thisValue;
    Object[] properties;
    public Type returnType;

    public void capture(Declaration declaration) {
        if (declaration.isSimple()) {
            if (!(this.capturedVars != null || declaration.isStatic() || this instanceof ModuleExp || this instanceof ClassExp)) {
                this.heapFrame = new Variable("heapFrame");
            }
            declaration.setSimple(false);
            if (!declaration.isPublic()) {
                declaration.nextCapturedVar = this.capturedVars;
                this.capturedVars = declaration;
            }
        }
    }

    public void setExceptions(ReferenceExp[] referenceExpArray) {
        this.throwsSpecification = referenceExpArray;
    }

    public final boolean getInlineOnly() {
        return (this.flags & 1) != 0;
    }

    public final void setInlineOnly(boolean bl) {
        this.setFlag(bl, 1);
    }

    public final boolean getNeedsClosureEnv() {
        return (this.flags & 0x18) != 0;
    }

    public final boolean getNeedsStaticLink() {
        return (this.flags & 0x10) != 0;
    }

    public final void setNeedsStaticLink(boolean bl) {
        this.flags = bl ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    public final boolean getImportsLexVars() {
        return (this.flags & 8) != 0;
    }

    public final void setImportsLexVars(boolean bl) {
        this.flags = bl ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public final void setImportsLexVars() {
        int n = this.flags;
        this.flags |= 8;
        if ((n & 8) == 0 && this.nameDecl != null) {
            this.setCallersNeedStaticLink();
        }
    }

    public final void setNeedsStaticLink() {
        int n = this.flags;
        this.flags |= 0x10;
        if ((n & 0x10) == 0 && this.nameDecl != null) {
            this.setCallersNeedStaticLink();
        }
    }

    void setCallersNeedStaticLink() {
        LambdaExp lambdaExp = this.outerLambda();
        ApplyExp applyExp = this.nameDecl.firstCall;
        while (applyExp != null) {
            for (LambdaExp lambdaExp2 = applyExp.context; lambdaExp2 != lambdaExp; lambdaExp2 = lambdaExp2.outerLambda()) {
                lambdaExp2.setNeedsStaticLink();
            }
            applyExp = applyExp.nextCall;
        }
    }

    public final boolean getCanRead() {
        return (this.flags & 2) != 0;
    }

    public final void setCanRead(boolean bl) {
        this.flags = bl ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public final boolean getCanCall() {
        return (this.flags & 4) != 0;
    }

    public final void setCanCall(boolean bl) {
        this.flags = bl ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public final boolean isClassMethod() {
        return (this.flags & 0x40) != 0;
    }

    public final void setClassMethod(boolean bl) {
        this.flags = bl ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
    }

    public final boolean isModuleBody() {
        return this instanceof ModuleExp;
    }

    public final boolean isClassGenerated() {
        return this.isModuleBody() || this instanceof ClassExp;
    }

    public int getCallConvention() {
        if (this.isModuleBody()) {
            return Compilation.defaultCallConvention >= 2 ? Compilation.defaultCallConvention : 2;
        }
        if (this.isClassMethod()) {
            return 1;
        }
        return Compilation.defaultCallConvention != 0 ? Compilation.defaultCallConvention : 1;
    }

    public final boolean isHandlingTailCalls() {
        return this.isModuleBody() || Compilation.defaultCallConvention >= 3 && !this.isClassMethod();
    }

    public final boolean variable_args() {
        return this.max_args < 0;
    }

    protected ClassType getCompiledClassType(Compilation compilation) {
        if (this.type == Compilation.typeProcedure) {
            throw new Error("internal error: getCompiledClassType");
        }
        return this.type;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(ClassType classType) {
        this.type = classType;
    }

    public int incomingArgs() {
        return this.min_args == this.max_args && this.max_args <= 4 && this.max_args > 0 ? this.max_args : 1;
    }

    int getSelectorValue(Compilation compilation) {
        int n = this.selectorValue;
        if (n == 0) {
            n = compilation.maxSelectorValue;
            compilation.maxSelectorValue = n + this.primMethods.length;
            this.selectorValue = ++n;
        }
        return n;
    }

    public final Method getMethod(int n) {
        if (this.primMethods == null || this.max_args >= 0 && n > this.max_args) {
            return null;
        }
        int n2 = n - this.min_args;
        if (n2 < 0) {
            return null;
        }
        int n3 = this.primMethods.length;
        return this.primMethods[n2 < n3 ? n2 : n3 - 1];
    }

    public final Method getMainMethod() {
        Method[] methodArray = this.primMethods;
        return methodArray == null ? null : methodArray[methodArray.length - 1];
    }

    public final Type restArgType() {
        if (this.min_args == this.max_args) {
            return null;
        }
        if (this.primMethods == null) {
            throw new Error("internal error - restArgType");
        }
        Method[] methodArray = this.primMethods;
        if (this.max_args >= 0 && methodArray.length > this.max_args - this.min_args) {
            return null;
        }
        Method method = methodArray[methodArray.length - 1];
        Type[] typeArray = method.getParameterTypes();
        int n = typeArray.length - 1;
        if (method.getName().endsWith("$X")) {
            --n;
        }
        return typeArray[n];
    }

    public LambdaExp outerLambda() {
        return this.outer == null ? null : this.outer.currentLambda();
    }

    public LambdaExp outerLambdaNotInline() {
        ScopeExp scopeExp = this;
        while ((scopeExp = scopeExp.outer) != null) {
            ScopeExp scopeExp2;
            if (!(scopeExp instanceof LambdaExp) || ((LambdaExp)(scopeExp2 = scopeExp)).getInlineOnly()) continue;
            return scopeExp2;
        }
        return null;
    }

    boolean inlinedIn(LambdaExp lambdaExp) {
        if (!this.getInlineOnly()) {
            return false;
        }
        ScopeExp scopeExp = this.getCaller();
        while (scopeExp != null) {
            if (scopeExp instanceof LambdaExp) {
                LambdaExp lambdaExp2 = scopeExp;
                if (lambdaExp2 == lambdaExp) {
                    return true;
                }
                if (!lambdaExp2.getInlineOnly()) {
                    return false;
                }
            }
            scopeExp = scopeExp.outer;
        }
        return false;
    }

    public LambdaExp getCaller() {
        return this.returnContinuation.context;
    }

    public Variable declareThis(ClassType classType) {
        if (this.thisVariable == null) {
            this.thisVariable = new Variable("this");
            this.getVarScope().addVariableAfter(null, this.thisVariable);
            this.thisVariable.setParameter(true);
        }
        if (this.thisVariable.getType() == null) {
            this.thisVariable.setType(classType);
        }
        if (this.decls != null && this.decls.isThisParameter()) {
            this.decls.var = this.thisVariable;
        }
        return this.thisVariable;
    }

    public Variable declareClosureEnv() {
        if (this.closureEnv == null && this.getNeedsClosureEnv()) {
            Variable variable;
            LambdaExp lambdaExp = this.outerLambda();
            if (lambdaExp instanceof ClassExp) {
                lambdaExp = lambdaExp.outerLambda();
            }
            Variable variable2 = variable = lambdaExp.heapFrame != null ? lambdaExp.heapFrame : lambdaExp.closureEnv;
            if (this.isClassMethod()) {
                this.closureEnv = this.declareThis(this.type);
            } else if (lambdaExp.heapFrame == null && !lambdaExp.getNeedsStaticLink() && !(lambdaExp instanceof ModuleExp)) {
                this.closureEnv = null;
            } else if (!this.isClassGenerated() && !this.getInlineOnly()) {
                Method method = this.getMainMethod();
                if (!method.getStaticFlag()) {
                    this.closureEnv = this.declareThis(method.getDeclaringClass());
                } else {
                    Type type = method.getParameterTypes()[0];
                    this.closureEnv = new Variable("closureEnv", type);
                    this.getVarScope().addVariableAfter(null, this.closureEnv);
                    this.closureEnv.setParameter(true);
                }
            } else if (this.inlinedIn(lambdaExp)) {
                this.closureEnv = variable;
            } else {
                this.closureEnv = new Variable("closureEnv", variable.getType());
                this.getVarScope().addVariable(this.closureEnv);
            }
        }
        return this.closureEnv;
    }

    public LambdaExp() {
    }

    public LambdaExp(int n) {
        this.min_args = n;
        this.max_args = n;
    }

    public LambdaExp(Expression expression) {
        this.body = expression;
    }

    public void loadHeapFrame(Compilation compilation) {
        LambdaExp lambdaExp;
        for (lambdaExp = compilation.curLambda; lambdaExp != this && lambdaExp.getInlineOnly(); lambdaExp = lambdaExp.getCaller()) {
        }
        CodeAttr codeAttr = compilation.getCode();
        if (lambdaExp.heapFrame != null && this == lambdaExp) {
            codeAttr.emitLoad(lambdaExp.heapFrame);
        } else if (lambdaExp.closureEnv != null) {
            codeAttr.emitLoad(lambdaExp.closureEnv);
        } else {
            codeAttr.emitPushThis();
        }
        if (this != lambdaExp) {
            for (LambdaExp lambdaExp2 = lambdaExp.outerLambda(); lambdaExp2 != this; lambdaExp2 = lambdaExp2.outerLambda()) {
                if (lambdaExp2.staticLinkField == null) continue;
                codeAttr.emitGetField(lambdaExp2.staticLinkField);
            }
        }
    }

    Declaration getArg(int n) {
        Declaration declaration = this.firstDecl();
        while (true) {
            if (declaration == null) {
                throw new Error("internal error - getArg");
            }
            if (n == 0) {
                return declaration;
            }
            --n;
            declaration = declaration.nextDecl();
        }
    }

    public void compileEnd(Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        if (!this.getInlineOnly()) {
            if (compilation.method.reachableHere() && (Compilation.defaultCallConvention < 3 || this.isModuleBody() || this.isClassMethod() || this.isHandlingTailCalls())) {
                codeAttr.emitReturn();
            }
            this.popScope(codeAttr);
            if (!Compilation.fewerClasses) {
                codeAttr.popScope();
            }
        }
        if (this.heapFrame != null) {
            compilation.generateConstructor((ClassType)this.heapFrame.getType(), this);
        }
        compilation.generateMatchMethods(this);
        if (Compilation.defaultCallConvention >= 2) {
            compilation.generateApplyMethodsWithContext(this);
        } else {
            compilation.generateApplyMethodsWithoutContext(this);
        }
    }

    Field allocFieldFor(Compilation compilation) {
        if (this.nameDecl != null && this.nameDecl.field != null) {
            return this.nameDecl.field;
        }
        String string = this.getName();
        String string2 = string == null ? "lambda" : Compilation.mangleNameIfNeeded(string);
        int n = 16;
        if (this.nameDecl != null && this.nameDecl.context instanceof ModuleExp) {
            boolean bl = this.nameDecl.needsExternalAccess();
            if (bl) {
                string2 = "$Prvt$" + string2;
            }
            if (this.nameDecl.getFlag(2048)) {
                n |= 8;
                if (!((ModuleExp)this.nameDecl.context).isStatic()) {
                    n &= 0xFFFFFFEF;
                }
            }
            if (!this.nameDecl.isPrivate() || bl) {
                n |= 1;
            }
        } else {
            string2 = string2 + "$Fn" + ++compilation.localFieldIndex;
            if (!this.getNeedsClosureEnv()) {
                n = (n | 8) & 0xFFFFFFEF;
            }
        }
        ClassType classType = this.getOwningLambda().getHeapFrameType();
        ClassType classType2 = Compilation.typeModuleMethod;
        Field field = classType.addField(string2, classType2, n);
        if (this.nameDecl != null) {
            this.nameDecl.field = field;
        }
        return field;
    }

    final void addApplyMethod(LambdaExp lambdaExp) {
        if (this.applyMethods == null) {
            this.applyMethods = new Vector();
        }
        this.applyMethods.addElement(lambdaExp);
    }

    public Field compileSetField(Compilation compilation) {
        if (compilation.usingCPStyle()) {
            this.compile(compilation, Type.pointer_type);
        } else {
            this.compileAsMethod(compilation);
            this.getOwningLambda().addApplyMethod(this);
        }
        return new ProcInitializer((LambdaExp)this, (Compilation)compilation).field;
    }

    public void compile(Compilation compilation, Target target) {
        ClassType classType;
        if (target instanceof IgnoreTarget && (this.getInlineOnly() || !this.getCanRead())) {
            return;
        }
        CodeAttr codeAttr = compilation.getCode();
        if (compilation.usingCPStyle()) {
            ClassType classType2;
            Label label = new Label(codeAttr);
            LambdaExp lambdaExp = compilation.curLambda;
            compilation.curLambda = this;
            this.type = lambdaExp.type;
            this.closureEnv = lambdaExp.closureEnv;
            SwitchState switchState = compilation.fswitch;
            int n = compilation.fswitch.getMaxValue() + 1;
            codeAttr.emitGoto(label);
            Type[] typeArray = codeAttr.saveStackTypeState(true);
            switchState.addCase(n, codeAttr);
            this.allocParameters(compilation);
            this.enterFunction(compilation);
            this.compileBody(compilation);
            this.compileEnd(compilation);
            compilation.curLambda = lambdaExp;
            label.define(codeAttr);
            codeAttr.restoreStackTypeState(typeArray);
            classType = classType2 = compilation.curClass;
        } else {
            LambdaExp lambdaExp = this.outerLambda();
            classType = Compilation.typeModuleMethod;
            if ((this.flags & 0x100) != 0 || compilation.immediate && lambdaExp instanceof ModuleExp) {
                this.compileAsMethod(compilation);
                this.getOwningLambda().addApplyMethod(this);
                ProcInitializer.emitLoadModuleMethod(this, compilation);
            } else {
                Field field = this.compileSetField(compilation);
                if (field.getStaticFlag()) {
                    codeAttr.emitGetStatic(field);
                } else {
                    LambdaExp lambdaExp2 = compilation.curLambda;
                    Variable variable = lambdaExp2.heapFrame != null ? lambdaExp2.heapFrame : lambdaExp2.closureEnv;
                    codeAttr.emitLoad(variable);
                    codeAttr.emitGetField(field);
                }
            }
        }
        target.compileFromStack(compilation, classType);
    }

    public ClassType getHeapFrameType() {
        if (this instanceof ModuleExp || this instanceof ClassExp) {
            return (ClassType)this.getType();
        }
        return (ClassType)this.heapFrame.getType();
    }

    public LambdaExp getOwningLambda() {
        ScopeExp scopeExp = this.outer;
        while (scopeExp != null) {
            if (scopeExp instanceof ModuleExp || scopeExp instanceof ClassExp && this.getNeedsClosureEnv() || scopeExp instanceof LambdaExp && ((LambdaExp)scopeExp).heapFrame != null) {
                return (LambdaExp)scopeExp;
            }
            scopeExp = scopeExp.outer;
        }
        return null;
    }

    void addMethodFor(Compilation compilation, ObjectType objectType) {
        ScopeExp scopeExp = this;
        while (scopeExp != null && !(scopeExp instanceof ClassExp)) {
            scopeExp = scopeExp.outer;
        }
        ClassType classType = scopeExp != null ? ((ClassExp)scopeExp).instanceType : this.getOwningLambda().getHeapFrameType();
        this.addMethodFor(classType, compilation, objectType);
    }

    void addMethodFor(ClassType classTypeArray, Compilation compilation, ObjectType objectType) {
        boolean bl;
        int n;
        Object object2;
        boolean bl2;
        String string = this.getName();
        LambdaExp lambdaExp = this.outerLambda();
        int n2 = this.keywords == null ? 0 : this.keywords.length;
        int n3 = this.defaultArgs == null ? 0 : this.defaultArgs.length - n2;
        int n4 = (this.flags & 0x200) != 0 ? 0 : n3;
        boolean bl3 = this.max_args < 0 || this.min_args + n4 < this.max_args;
        this.primMethods = new Method[n4 + 1];
        int n5 = 0;
        if (this.nameDecl != null && this.nameDecl.getFlag(4096)) {
            bl2 = false;
        } else if (this.nameDecl != null && this.nameDecl.getFlag(2048)) {
            bl2 = true;
        } else if (this.isClassMethod()) {
            if (lambdaExp instanceof ClassExp) {
                object2 = (ClassExp)lambdaExp;
                boolean bl4 = bl2 = ((ClassExp)object2).isMakingClassPair() && objectType != null;
                if (this == ((ClassExp)object2).initMethod) {
                    n5 = 73;
                } else if (this == ((ClassExp)object2).clinitMethod) {
                    n5 = 67;
                    bl2 = true;
                }
            } else {
                bl2 = false;
            }
        } else {
            bl2 = this.thisVariable != null || objectType == classTypeArray ? false : (this.nameDecl != null && this.nameDecl.context instanceof ModuleExp ? ((ModuleExp)(object2 = (ModuleExp)this.nameDecl.context)).getSuperType() == null && ((ModuleExp)object2).getInterfaces() == null : true);
        }
        object2 = new StringBuffer(60);
        int n6 = n = bl2 ? 8 : 0;
        if (this.nameDecl != null) {
            n = this.nameDecl.needsExternalAccess() ? (n |= 1) : (n |= this.nameDecl.getAccessFlags(this.nameDecl.isPrivate() ? (short)0 : 1));
        }
        if (!lambdaExp.isModuleBody() && !(lambdaExp instanceof ClassExp) || string == null) {
            ((StringBuffer)object2).append("lambda");
            ((StringBuffer)object2).append(++compilation.method_counter);
        }
        if (n5 == 67) {
            ((StringBuffer)object2).append("<clinit>");
        } else if (this.getSymbol() != null) {
            ((StringBuffer)object2).append(Compilation.mangleName(string));
        }
        if (this.getFlag(1024)) {
            ((StringBuffer)object2).append("$C");
        }
        boolean bl5 = bl = this.getCallConvention() >= 2 && n5 == 0;
        if (n5 != 0) {
            n = bl2 ? (n & 0xFFFFFFFD) + 1 : (n & 2) + 2;
        }
        if (classTypeArray.isInterface()) {
            n |= 0x400;
        }
        if (!bl2) {
            this.declareThis((ClassType)classTypeArray);
        }
        PrimType primType = this.getFlag(1024) || this.getCallConvention() >= 2 ? Type.void_type : this.getReturnType().getImplementationType();
        int n7 = objectType != null && objectType != classTypeArray ? 1 : 0;
        int n8 = 0;
        if (this.getCallConvention() >= 2 && n5 == 0) {
            n8 = 1;
        }
        int n9 = ((StringBuffer)object2).length();
        for (int i = 0; i <= n4; ++i) {
            ClassType[] classTypeArray2;
            Object object3;
            Declaration declaration;
            int n10;
            ((StringBuffer)object2).setLength(n9);
            int n11 = n10 = this.min_args + i;
            if (i == n4 && bl3) {
                ++n11;
            }
            Type[] typeArray = new Type[n7 + n11 + n8];
            if (n7 > 0) {
                typeArray[0] = objectType;
            }
            if ((declaration = this.firstDecl()) != null && declaration.isThisParameter()) {
                declaration = declaration.nextDecl();
            }
            int n12 = 0;
            while (n12 < n10) {
                typeArray[n7 + n12++] = declaration.getType().getImplementationType();
                declaration = declaration.nextDecl();
            }
            if (n8 != 0) {
                typeArray[typeArray.length - 1] = Compilation.typeCallContext;
            }
            if (n10 < n11) {
                ((StringBuffer)object2).append("$V");
                string = ((StringBuffer)object2).toString();
                Type type = declaration.getType();
                object3 = type.getName();
                if (n2 > 0 || n4 < n3 || !"gnu.lists.LList".equals(object3) && !"java.lang.Object[]".equals(object3)) {
                    type = Compilation.objArrayType;
                    this.argsArray = new Variable("argsArray", Compilation.objArrayType);
                    this.argsArray.setParameter(true);
                }
                this.firstArgsArrayArg = declaration;
                typeArray[typeArray.length - (bl ? 2 : 1)] = type;
            }
            if (bl) {
                ((StringBuffer)object2).append("$X");
            }
            n12 = lambdaExp instanceof ClassExp || lambdaExp instanceof ModuleExp && ((ModuleExp)lambdaExp).getFlag(16384) ? 1 : 0;
            string = ((StringBuffer)object2).toString();
            int n13 = 0;
            int n14 = ((StringBuffer)object2).length();
            block2: while (true) {
                for (classTypeArray2 = classTypeArray; classTypeArray2 != null; classTypeArray2 = classTypeArray2.getSuperclass()) {
                    if (classTypeArray2.getDeclaredMethod(string, typeArray) != null) {
                        ((StringBuffer)object2).setLength(n14);
                        ((StringBuffer)object2).append('$');
                        ((StringBuffer)object2).append(++n13);
                        string = ((StringBuffer)object2).toString();
                        continue;
                    }
                    if (n12 != 0) break block2;
                }
                break;
            }
            this.primMethods[i] = object3 = classTypeArray.addMethod(string, typeArray, primType, n);
            if (this.throwsSpecification == null || this.throwsSpecification.length <= 0) continue;
            n14 = this.throwsSpecification.length;
            classTypeArray2 = new ClassType[n14];
            for (int j = 0; j < n14; ++j) {
                Object object4;
                ClassType classType = null;
                Declaration declaration2 = this.throwsSpecification[j].getBinding();
                if (declaration2 != null) {
                    object4 = declaration2.getValue();
                    if (object4 instanceof ClassExp) {
                        classType = ((ClassExp)object4).getCompiledClassType(compilation);
                    } else {
                        compilation.error('e', "throws specification " + declaration2.getName() + " has non-class lexical binding");
                    }
                }
                if (classType == null) {
                    object4 = this.throwsSpecification[j].getName();
                    int n15 = ((String)object4).length();
                    if (n15 > 2 && ((String)object4).charAt(0) == '<' && ((String)object4).charAt(n15 - 1) == '>') {
                        object4 = ((String)object4).substring(1, n15 - 1);
                    }
                    classType = ClassType.make((String)object4);
                }
                classTypeArray2[j] = classType;
            }
            ExceptionsAttr exceptionsAttr = new ExceptionsAttr((Method)object3);
            exceptionsAttr.setExceptions(classTypeArray2);
        }
    }

    public void allocChildClasses(Compilation compilation) {
        Object object2;
        Object object3;
        Object object4;
        if (this instanceof ModuleExp) {
            ((ModuleExp)this).allocFields(compilation);
        } else {
            object4 = this.getMainMethod();
            object3 = this.firstDecl();
            while (true) {
                if (object3 == this.firstArgsArrayArg && this.argsArray != null) {
                    this.getVarScope().addVariable(this.argsArray);
                }
                if (!this.getInlineOnly() && this.getCallConvention() >= 2 && (this.firstArgsArrayArg == null ? object3 == null : (this.argsArray != null ? object3 == this.firstArgsArrayArg : object3 == this.firstArgsArrayArg.nextDecl()))) {
                    object2 = this.getVarScope().addVariable(null, Compilation.typeCallContext, "$ctx");
                    ((Variable)object2).setParameter(true);
                }
                if (object3 == null) break;
                object2 = ((Declaration)object3).var;
                if (((Declaration)object3).isSimple() && !((Declaration)object3).isIndirectBinding()) {
                    object2 = ((Declaration)object3).allocateVariable(null);
                } else {
                    String string = Compilation.mangleName(((Declaration)object3).getName()).intern();
                    Type type = ((Declaration)object3).getType().getImplementationType();
                    ((Declaration)object3).var = this.getVarScope().addVariable(null, type, string);
                    object2 = ((Declaration)object3).var;
                    ((Variable)object2).setParameter(true);
                }
                object3 = ((Declaration)object3).nextDecl();
            }
        }
        this.declareClosureEnv();
        if (compilation.usingCPStyle() && compilation.curClass == compilation.mainClass) {
            return;
        }
        this.allocFrame(compilation);
        object4 = this.firstChild;
        while (object4 != null) {
            if (!((LambdaExp)object4).isClassGenerated() && !((LambdaExp)object4).getInlineOnly()) {
                if (!((LambdaExp)object4).getNeedsClosureEnv()) {
                    object3 = null;
                } else if (this instanceof ClassExp) {
                    object3 = this.getCompiledClassType(compilation);
                } else if ("$finit$".equals(this.getName())) {
                    object3 = this.outerLambda().getCompiledClassType(compilation);
                } else {
                    object2 = this;
                    while (((LambdaExp)object2).heapFrame == null) {
                        object2 = ((LambdaExp)object2).outerLambda();
                    }
                    object3 = (ClassType)((LambdaExp)object2).heapFrame.getType();
                }
                ((LambdaExp)object4).addMethodFor(compilation, (ObjectType)object3);
            }
            object4 = ((LambdaExp)object4).nextSibling;
        }
    }

    public void allocFrame(Compilation compilation) {
        if (this.heapFrame != null) {
            ClassType classType;
            if (this instanceof ModuleExp || this instanceof ClassExp) {
                classType = this.getCompiledClassType(compilation);
            } else {
                classType = new ClassType(compilation.generateClassName("frame"));
                classType.setSuper(compilation.getModuleType());
                compilation.addClass(classType);
            }
            this.heapFrame.setType(classType);
        }
    }

    void allocParameters(Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        int n = 0;
        int n2 = 0;
        codeAttr.locals.enterScope(this.getVarScope());
        int n3 = this.getLine();
        if (n3 != 0) {
            codeAttr.putLineNumber(this.getFile(), n3);
        }
        for (Declaration declaration = this.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            Variable variable = declaration.var;
            if (this.argsArray != null && this.min_args == this.max_args && this.primMethods == null && this.getCallConvention() < 2) {
                codeAttr.emitLoad(this.argsArray);
                codeAttr.emitPushInt(n2);
                codeAttr.emitArrayLoad(Type.pointer_type);
                declaration.getType().emitCoerceFromObject(codeAttr);
                codeAttr.emitStore(declaration.getVariable());
            }
            ++n2;
            ++n;
        }
        if (this.heapFrame != null) {
            this.heapFrame.allocateLocal(codeAttr);
        }
    }

    void enterFunction(Compilation compilation) {
        int n;
        AttrContainer attrContainer;
        CodeAttr codeAttr = compilation.getCode();
        this.getVarScope().setStartPC(codeAttr);
        if (this.closureEnv != null && !this.closureEnv.isParameter() && !compilation.usingCPStyle()) {
            if (!this.getInlineOnly()) {
                codeAttr.emitPushThis();
                Field field = this.closureEnvField;
                if (field == null) {
                    field = this.outerLambda().closureEnvField;
                }
                codeAttr.emitGetField(field);
                codeAttr.emitStore(this.closureEnv);
            } else if (!this.inlinedIn(this.outerLambda())) {
                this.outerLambda().loadHeapFrame(compilation);
                codeAttr.emitStore(this.closureEnv);
            }
        }
        if (!compilation.usingCPStyle()) {
            int n2;
            if (this.heapFrame == null) {
                n2 = 8;
                attrContainer = this.currentModule().getCompiledClassType(compilation);
            } else {
                n2 = 0;
                attrContainer = (ClassType)this.heapFrame.getType();
            }
            Declaration declaration = this.capturedVars;
            while (declaration != null) {
                if (declaration.field == null) {
                    declaration.makeField((ClassType)attrContainer, compilation, null);
                }
                declaration = declaration.nextCapturedVar;
            }
        }
        if (this.heapFrame != null && !compilation.usingCPStyle()) {
            ClassType classType = (ClassType)this.heapFrame.getType();
            if (this.closureEnv != null && !(this instanceof ModuleExp)) {
                this.staticLinkField = classType.addField("staticLink", this.closureEnv.getType());
            }
            if (!(this instanceof ModuleExp) && !(this instanceof ClassExp)) {
                codeAttr.emitNew(classType);
                codeAttr.emitDup(classType);
                attrContainer = Compilation.getConstructor(classType, this);
                codeAttr.emitInvokeSpecial((Method)attrContainer);
                if (this.staticLinkField != null) {
                    codeAttr.emitDup(this.heapFrame.getType());
                    codeAttr.emitLoad(this.closureEnv);
                    codeAttr.emitPutField(this.staticLinkField);
                }
                codeAttr.emitStore(this.heapFrame);
            }
        }
        Variable variable = this.argsArray;
        if (this.min_args == this.max_args && !Compilation.fewerClasses && this.primMethods == null && this.getCallConvention() < 2) {
            variable = null;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.keywords == null ? 0 : this.keywords.length;
        int n7 = n = this.defaultArgs == null ? 0 : this.defaultArgs.length - n6;
        if (this instanceof ModuleExp) {
            return;
        }
        int n8 = -1;
        int n9 = 0;
        Method method = this.getMainMethod();
        Variable variable2 = compilation.callContextVar;
        for (Declaration declaration = this.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            Variable variable3 = compilation.callContextVar = this.getCallConvention() < 2 ? null : this.getVarScope().lookup("$ctx");
            if (declaration == this.firstArgsArrayArg && variable != null) {
                if (this.primMethods != null) {
                    n8 = n3;
                    n9 = n8 - this.min_args;
                } else {
                    n8 = 0;
                    n9 = 0;
                }
            }
            if (n8 >= 0 || !declaration.isSimple() || declaration.isIndirectBinding()) {
                Type type;
                Type type2 = declaration.getType();
                Type type3 = type = method == null || n8 >= 0 ? Type.pointer_type : type2;
                if (!declaration.isSimple()) {
                    declaration.loadOwningObject(null, compilation);
                }
                if (n8 < 0) {
                    codeAttr.emitLoad(declaration.getVariable());
                } else if (n3 < this.min_args) {
                    codeAttr.emitLoad(variable);
                    codeAttr.emitPushInt(n3);
                    codeAttr.emitArrayLoad(Type.pointer_type);
                } else if (n3 < this.min_args + n) {
                    codeAttr.emitPushInt(n3 - n8);
                    codeAttr.emitLoad(variable);
                    codeAttr.emitArrayLength();
                    codeAttr.emitIfIntLt();
                    codeAttr.emitLoad(variable);
                    codeAttr.emitPushInt(n3 - n8);
                    codeAttr.emitArrayLoad(Type.pointer_type);
                    codeAttr.emitElse();
                    this.defaultArgs[n9 + n4++].compile(compilation, type2);
                    codeAttr.emitFi();
                } else if (this.max_args < 0 && n3 == this.min_args + n) {
                    codeAttr.emitLoad(variable);
                    codeAttr.emitPushInt(n3 - n8);
                    codeAttr.emitInvokeStatic(Compilation.makeListMethod);
                    type = Compilation.scmListType;
                } else {
                    Type[] typeArray;
                    codeAttr.emitLoad(variable);
                    codeAttr.emitPushInt(this.min_args + n - n8);
                    compilation.compileConstant(this.keywords[n5++]);
                    Expression expression = this.defaultArgs[n9 + n4++];
                    if (expression instanceof QuoteExp) {
                        if (searchForKeywordMethod4 == null) {
                            typeArray = new Type[]{Compilation.objArrayType, Type.int_type, Type.pointer_type, Type.pointer_type};
                            searchForKeywordMethod4 = Compilation.scmKeywordType.addMethod("searchForKeyword", typeArray, Type.pointer_type, 9);
                        }
                        expression.compile(compilation, type2);
                        codeAttr.emitInvokeStatic(searchForKeywordMethod4);
                    } else {
                        if (searchForKeywordMethod3 == null) {
                            typeArray = new Type[]{Compilation.objArrayType, Type.int_type, Type.pointer_type};
                            searchForKeywordMethod3 = Compilation.scmKeywordType.addMethod("searchForKeyword", typeArray, Type.pointer_type, 9);
                        }
                        codeAttr.emitInvokeStatic(searchForKeywordMethod3);
                        codeAttr.emitDup(1);
                        compilation.compileConstant(Special.dfault);
                        codeAttr.emitIfEq();
                        codeAttr.emitPop(1);
                        expression.compile(compilation, type2);
                        codeAttr.emitFi();
                    }
                }
                if (type2 != type) {
                    CheckedTarget.emitCheckedCoerce(compilation, this, n3 + 1, type2);
                }
                if (declaration.isIndirectBinding()) {
                    declaration.pushIndirectBinding(compilation);
                }
                if (declaration.isSimple()) {
                    codeAttr.emitStore(declaration.getVariable());
                } else {
                    codeAttr.emitPutField(declaration.field);
                }
            }
            ++n3;
        }
        compilation.callContextVar = variable2;
    }

    void compileChildMethods(Compilation compilation) {
        LambdaExp lambdaExp = this.firstChild;
        while (lambdaExp != null) {
            if (!lambdaExp.getCanRead() && !lambdaExp.getInlineOnly()) {
                lambdaExp.compileAsMethod(compilation);
            }
            lambdaExp = lambdaExp.nextSibling;
        }
    }

    void compileAsMethod(Compilation compilation) {
        int n;
        if ((this.flags & 0x80) != 0) {
            return;
        }
        this.flags |= 0x80;
        Method method = compilation.method;
        LambdaExp lambdaExp = compilation.curLambda;
        compilation.curLambda = this;
        Method method2 = this.primMethods[0];
        boolean bl = method2.getStaticFlag();
        int n2 = this.primMethods.length - 1;
        Type type = this.restArgType();
        int[] nArray = null;
        if (n2 > 0) {
            nArray = new int[this.min_args + n2];
            n = 0;
            Declaration declaration = this.firstDecl();
            while (n < this.min_args + n2) {
                nArray[n++] = declaration.flags;
                declaration = declaration.nextDecl();
            }
        }
        n = this.getCallConvention() >= 2 ? 1 : 0;
        for (int i = 0; i <= n2; ++i) {
            compilation.method = this.primMethods[i];
            if (i < n2) {
                Object object2;
                int n3;
                CodeAttr codeAttr = compilation.method.startCode();
                for (n3 = i + 1; n3 < n2 && this.defaultArgs[n3] instanceof QuoteExp; ++n3) {
                }
                boolean bl2 = !bl;
                boolean bl3 = n3 == n2 && type != null;
                Variable variable = compilation.callContextVar;
                Variable variable2 = codeAttr.getArg(0);
                if (!bl) {
                    codeAttr.emitPushThis();
                    if (this.getNeedsClosureEnv()) {
                        this.closureEnv = variable2;
                    }
                    variable2 = codeAttr.getArg(1);
                }
                Declaration declaration = this.firstDecl();
                int n4 = 0;
                while (n4 < this.min_args + i) {
                    declaration.flags |= 0x40;
                    declaration.var = variable2;
                    codeAttr.emitLoad(variable2);
                    variable2 = variable2.nextVar();
                    ++n4;
                    declaration = declaration.nextDecl();
                }
                compilation.callContextVar = n != 0 ? variable2 : null;
                n4 = i;
                while (n4 < n3) {
                    object2 = StackTarget.getInstance(declaration.getType());
                    this.defaultArgs[n4].compile(compilation, (Target)object2);
                    ++n4;
                    declaration = declaration.nextDecl();
                }
                if (bl3) {
                    QuoteExp quoteExp;
                    object2 = type.getName();
                    if ("gnu.lists.LList".equals(object2)) {
                        quoteExp = new QuoteExp(LList.Empty);
                    } else if ("java.lang.Object[]".equals(object2)) {
                        quoteExp = new QuoteExp(Values.noArgs);
                    } else {
                        throw new Error("unimplemented #!rest type " + (String)object2);
                    }
                    quoteExp.compile(compilation, type);
                }
                if (n != 0) {
                    codeAttr.emitLoad(variable2);
                }
                if (bl) {
                    codeAttr.emitInvokeStatic(this.primMethods[n3]);
                } else {
                    codeAttr.emitInvokeVirtual(this.primMethods[n3]);
                }
                codeAttr.emitReturn();
                this.closureEnv = null;
                compilation.callContextVar = variable;
                continue;
            }
            if (nArray != null) {
                int n5 = 0;
                Declaration declaration = this.firstDecl();
                while (n5 < this.min_args + n2) {
                    declaration.flags = nArray[n5++];
                    declaration.var = null;
                    declaration = declaration.nextDecl();
                }
            }
            compilation.method.initCode();
            this.allocChildClasses(compilation);
            this.allocParameters(compilation);
            this.enterFunction(compilation);
            this.compileBody(compilation);
            this.compileEnd(compilation);
        }
        this.compileChildMethods(compilation);
        compilation.method = method;
        compilation.curLambda = lambdaExp;
    }

    public void compileBody(Compilation compilation) {
        Target target;
        Variable variable = compilation.callContextVar;
        compilation.callContextVar = null;
        if (this.getCallConvention() >= 2) {
            Variable variable2 = this.getVarScope().lookup("$ctx");
            if (variable2 != null && variable2.getType() == Compilation.typeCallContext) {
                compilation.callContextVar = variable2;
            }
            target = ConsumerTarget.makeContextTarget(compilation);
        } else {
            target = Target.pushValue(this.getReturnType());
        }
        this.body.compileWithPosition(compilation, target, this.body.getLine() > 0 ? this.body : this);
        compilation.callContextVar = variable;
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkLambdaExp(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
        this.walkChildrenOnly(expWalker);
        this.walkProperties(expWalker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void walkChildrenOnly(ExpWalker expWalker) {
        LambdaExp lambdaExp = expWalker.currentLambda;
        expWalker.currentLambda = this;
        try {
            expWalker.walkDefaultArgs(this);
            if (expWalker.exitValue == null && this.body != null) {
                this.body = expWalker.walk(this.body);
            }
        }
        finally {
            expWalker.currentLambda = lambdaExp;
        }
    }

    protected final void walkProperties(ExpWalker expWalker) {
        if (this.properties != null) {
            int n = this.properties.length;
            for (int i = 1; i < n; i += 2) {
                Object object2 = this.properties[i];
                if (!(object2 instanceof Expression)) continue;
                this.properties[i] = expWalker.walk((Expression)this.properties[i]);
            }
        }
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock("(Lambda/", ")", 2);
        Object object2 = this.getSymbol();
        if (object2 != null) {
            outPort.print(object2);
            outPort.print('/');
        }
        outPort.print(this.id);
        outPort.print('/');
        outPort.print("fl:");
        outPort.print(Integer.toHexString(this.flags));
        outPort.writeSpaceFill();
        this.printLineColumn(outPort);
        outPort.startLogicalBlock("(", false, ")");
        Special special = null;
        int n = 0;
        int n2 = 0;
        int n3 = this.keywords == null ? 0 : this.keywords.length;
        int n4 = this.defaultArgs == null ? 0 : this.defaultArgs.length - n3;
        Declaration declaration = this.firstDecl();
        if (declaration != null && declaration.isThisParameter()) {
            n = -1;
        }
        while (declaration != null) {
            Special special2 = n < this.min_args ? null : (n < this.min_args + n4 ? Special.optional : (this.max_args < 0 && n == this.min_args + n4 ? Special.rest : Special.key));
            if (declaration != this.firstDecl()) {
                outPort.writeSpaceFill();
            }
            if (special2 != special) {
                outPort.print(special2);
                outPort.writeSpaceFill();
            }
            Expression expression = null;
            if (special2 == Special.optional || special2 == Special.key) {
                expression = this.defaultArgs[n2++];
            }
            if (expression != null) {
                outPort.print('(');
            }
            declaration.printInfo(outPort);
            if (expression != null && expression != QuoteExp.falseExp) {
                outPort.print(' ');
                expression.print(outPort);
                outPort.print(')');
            }
            ++n;
            special = special2;
            declaration = declaration.nextDecl();
        }
        outPort.endLogicalBlock(")");
        outPort.writeSpaceLinear();
        if (this.body == null) {
            outPort.print("<null body>");
        } else {
            this.body.print(outPort);
        }
        outPort.endLogicalBlock(")");
    }

    protected final String getExpClassName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public String toString() {
        String string = this.getExpClassName() + ':' + this.getSymbol() + '/' + this.id + '/';
        int n = this.getLine();
        if (n <= 0 && this.body != null) {
            n = this.body.getLine();
        }
        if (n > 0) {
            string = string + "l:" + n;
        }
        return string;
    }

    public Object getProperty(Object object2, Object object3) {
        if (this.properties != null) {
            int n = this.properties.length;
            while ((n -= 2) >= 0) {
                if (this.properties[n] != object2) continue;
                return this.properties[n + 1];
            }
        }
        return object3;
    }

    public synchronized void setProperty(Object object2, Object object3) {
        this.properties = Procedure.setProperty(this.properties, object2, object3);
    }

    public final Type getReturnType() {
        if (this.returnType == null) {
            this.returnType = Type.pointer_type;
            if (this.body != null) {
                this.returnType = this.body.getType();
            }
        }
        return this.returnType;
    }

    public final void setReturnType(Type type) {
        this.returnType = type;
    }
}

