/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.lists.FString;
import gnu.mapping.CallContext;
import gnu.mapping.InPort;
import gnu.mapping.Symbol;
import gnu.mapping.Table2D;
import gnu.mapping.WrappedException;
import gnu.mapping.WrongType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;

public class URI_utils {
    private static Symbol keyClassLoader = new Symbol(null, "(class-loader)");
    public static final String CLASS_RESOURCE_URI_PREFIX = "class-resource:/";
    public static final int CLASS_RESOURCE_URI_PREFIX_LENGTH = 16;

    public static boolean isAbsolute(Object uri) {
        if (uri instanceof URL) {
            return true;
        }
        if (uri instanceof File) {
            return ((File)uri).isAbsolute();
        }
        if (uri instanceof URI) {
            return ((URI)uri).isAbsolute();
        }
        return InPort.uriSchemeSpecified(uri.toString());
    }

    static URL resourceURL(Object uri, String str) throws IOException {
        ClassLoader loader = URI_utils.getClassLoaderForURI(uri);
        if (loader == null) {
            throw new IOException("unknown class-loader for URI '" + str + '\'');
        }
        URL url = loader.getResource(str.substring(16));
        if (url == null) {
            throw new FileNotFoundException(str);
        }
        return url;
    }

    public static URL FiletoURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (Throwable ex) {
            throw WrappedException.wrapIfNeeded(ex);
        }
    }

    public static URL toURL(Object uri) throws IOException {
        if ((uri = URI_utils.toFileOrURL(uri)) instanceof File) {
            return URI_utils.FiletoURL((File)uri);
        }
        return (URL)uri;
    }

    public static long lastModified(Object uri) {
        try {
            uri = URI_utils.toFileOrURL(uri);
            if (uri instanceof File) {
                return ((File)uri).lastModified();
            }
            return ((URL)uri).openConnection().getLastModified();
        }
        catch (Throwable ex) {
            return 0L;
        }
    }

    public static Object toFileOrURL(Object uri) throws IOException {
        if (uri instanceof URL || uri instanceof File) {
            return uri;
        }
        String str = uri.toString();
        if (str.startsWith(CLASS_RESOURCE_URI_PREFIX)) {
            return URI_utils.resourceURL(uri, str);
        }
        if (!InPort.uriSchemeSpecified(str)) {
            CallContext ctx = CallContext.getInstance();
            String base = ctx.getBaseUriRaw();
            if (base == null || !InPort.uriSchemeSpecified(base)) {
                char fileSep = File.separatorChar;
                str = str.replace('/', fileSep);
                File file = new File(str);
                if (base == null || file.isAbsolute()) {
                    return file;
                }
                File dir = new File(base.replace('/', fileSep));
                if (!dir.isDirectory()) {
                    dir = dir.getParentFile();
                }
                return new File(dir, str);
            }
            try {
                str = URI_utils.resolve(str, base).toString();
            }
            catch (URISyntaxException ex) {
                throw new IOException("invalid URI syntax: '" + str + '\'');
            }
        }
        if (str.startsWith("file:")) {
            try {
                return new File(new URI(str));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new URL(str);
    }

    public static InputStream getInputStream(Object uri) throws IOException {
        if ((uri = URI_utils.toFileOrURL(uri)) instanceof File) {
            return new FileInputStream((File)uri);
        }
        return ((URL)uri).openConnection().getInputStream();
    }

    public static OutputStream getOutputStream(Object uri) throws IOException {
        if ((uri = URI_utils.toFileOrURL(uri)) instanceof File) {
            return new FileOutputStream((File)uri);
        }
        URLConnection conn = ((URL)uri).openConnection();
        conn.setDoInput(false);
        conn.setDoOutput(true);
        return conn.getOutputStream();
    }

    public static URI toURI(Object uri) throws URISyntaxException {
        if (uri instanceof String || uri instanceof FString) {
            return URI_utils.nametoURI(uri.toString());
        }
        if (uri instanceof File) {
            return URI_utils.FiletoURI((File)uri);
        }
        if (uri instanceof URL) {
            uri = URI_utils.URLtoURI((URL)uri);
        }
        return (URI)uri;
    }

    static URI URLtoURI(URL url) throws URISyntaxException {
        return new URI(url.toString());
    }

    public static String toURIString(Object uri) throws URISyntaxException {
        if (uri instanceof String || uri instanceof FString) {
            return URI_utils.nametoURIString(uri.toString());
        }
        if (uri instanceof File) {
            return URI_utils.FiletoURI((File)uri).toString();
        }
        if (uri instanceof URL) {
            uri = URI_utils.URLtoURI((URL)uri);
        }
        return ((URI)uri).toString();
    }

    public static String nametoURIString(String str) throws URISyntaxException {
        if (InPort.uriSchemeSpecified(str)) {
            return str;
        }
        char fileSep = File.separatorChar;
        if (fileSep != '/') {
            str = str.replace('/', fileSep);
        }
        return URI_utils.FiletoURI(new File(str)).toString();
    }

    public static URI nametoURI(String str) throws URISyntaxException {
        try {
            return new URI(str);
        }
        catch (URISyntaxException ex) {
            if (InPort.uriSchemeSpecified(str)) {
                throw ex;
            }
            char fileSep = File.separatorChar;
            if (fileSep != '/') {
                str = str.replace('/', fileSep);
            }
            return URI_utils.FiletoURI(new File(str));
        }
    }

    public static URI FiletoURI(File file) throws URISyntaxException {
        if (file.isAbsolute()) {
            return file.toURI();
        }
        String fname = file.toString();
        char fileSep = File.separatorChar;
        if (fileSep != '/') {
            fname = fname.replace(fileSep, '/');
        }
        return new URI(null, null, fname, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ClassLoader getClassLoaderForURI(Object uri) {
        Table2D table;
        Table2D table2D = table = Table2D.getInstance();
        synchronized (table2D) {
            return (ClassLoader)table.get(uri, keyClassLoader, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setClassLoaderForURI(Object uri, ClassLoader loader) {
        Table2D table;
        Table2D table2D = table = Table2D.getInstance();
        synchronized (table2D) {
            table.put(uri, keyClassLoader, loader);
        }
    }

    public static URI makeClassResourceURI(Class clas) {
        URI uri;
        String cname = clas.getName();
        int dot = cname.lastIndexOf(46);
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(CLASS_RESOURCE_URI_PREFIX);
        if (dot >= 0) {
            sbuf.append(cname.substring(0, dot));
            sbuf.append('/');
            cname = cname.substring(dot + 1);
        }
        sbuf.append(cname);
        String str = sbuf.toString();
        try {
            uri = new URI(str);
        }
        catch (Throwable ex) {
            throw WrappedException.wrapIfNeeded(ex);
        }
        ClassLoader loader = clas.getClassLoader();
        URI_utils.setClassLoaderForURI(uri, loader);
        return uri;
    }

    public static URI resolve(Object relative, Object base) throws URISyntaxException {
        URI resolved;
        String string;
        String rstr;
        if (relative instanceof URL) {
            return URI_utils.URLtoURI((URL)relative);
        }
        if (relative instanceof URI) {
            URI rel = (URI)relative;
            if (rel.isAbsolute()) {
                return rel;
            }
            rstr = rel.toString();
        } else if (relative instanceof String || relative instanceof FString) {
            rstr = relative.toString();
            if (InPort.uriSchemeSpecified(rstr)) {
                return URI_utils.toURI(rstr);
            }
        } else if (relative instanceof File) {
            File file = (File)relative;
            if (file.isAbsolute()) {
                return file.toURI();
            }
            rstr = file.toString();
        } else {
            throw new WrongType("resolve-uri", 1, "uri/file/string");
        }
        char fileSep = File.separatorChar;
        if (fileSep != '/') {
            if (rstr.length() >= 2 && (rstr.charAt(1) == ':' && Character.isLetter(rstr.charAt(0)) || rstr.charAt(0) == fileSep && rstr.charAt(1) == fileSep)) {
                return URI_utils.toURI(new File(rstr));
            }
            string = rstr.replace(fileSep, '/');
        }
        if ((resolved = URI_utils.toURI(base).resolve(new URI(null, string, null))).toString().startsWith(CLASS_RESOURCE_URI_PREFIX)) {
            ClassLoader loader = URI_utils.getClassLoaderForURI(base);
            URI_utils.setClassLoaderForURI(resolved, loader);
        }
        return resolved;
    }

    public static Object relativize(Object in, Object base) throws URISyntaxException, IOException {
        char ci;
        char cb;
        int i;
        String baseStr = URI_utils.toURI(base).normalize().toString();
        String inStr = URI_utils.toURI(URI_utils.toURL(in)).normalize().toString();
        int baseLen = baseStr.length();
        int inLen = inStr.length();
        int sl = 0;
        int colon = 0;
        for (i = 0; i < baseLen && i < inLen && (cb = baseStr.charAt(i)) == (ci = inStr.charAt(i)); ++i) {
            if (cb == '/') {
                sl = i;
            }
            if (cb != ':') continue;
            colon = i;
        }
        if (colon <= 0 || sl <= colon + 2 && baseLen > colon + 2 && baseStr.charAt(colon + 2) == '/' || colon + 2 == 16 && inStr.substring(0, colon + 2).equals(CLASS_RESOURCE_URI_PREFIX) && URI_utils.getClassLoaderForURI(base) != URI_utils.getClassLoaderForURI(in)) {
            return in;
        }
        baseStr = baseStr.substring(sl + 1);
        inStr = inStr.substring(sl + 1);
        StringBuffer sbuf = new StringBuffer();
        sl = 0;
        i = baseLen = baseStr.length();
        while (--i >= 0) {
            if (baseStr.charAt(i) != '/') continue;
            sbuf.append("../");
        }
        sbuf.append(inStr);
        return sbuf.toString();
    }
}

