/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.lang;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.LetExp;
import gnu.expr.ReferenceExp;
import gnu.expr.TryExp;
import gnu.jemacs.buffer.Buffer;
import gnu.kawa.reflect.Invoke;
import kawa.lang.Syntax;
import kawa.lang.Translator;

public class SaveExcursion
extends Syntax {
    boolean bufferOnly;
    public static ClassType typeSaveExcursion = ClassType.make("gnu.jemacs.lang.SaveExcursion");
    public static ClassType typeBuffer = ClassType.make("gnu.jemacs.buffer.Buffer");

    public SaveExcursion(boolean bufferOnly) {
        this.bufferOnly = bufferOnly;
    }

    public Expression rewrite(Object obj, Translator tr) {
        ApplyExp finalizer;
        LetExp let2;
        Declaration savedPointMark;
        Expression[] inits1 = new Expression[]{Invoke.makeInvokeStatic(typeBuffer, "getCurrent", Expression.noExpressions)};
        LetExp let1 = new LetExp(inits1);
        Declaration savedBuffer = let1.addDeclaration(null, typeBuffer);
        savedBuffer.noteValue(inits1[0]);
        tr.push(let1);
        if (this.bufferOnly) {
            savedPointMark = null;
            let2 = let1;
        } else {
            Expression[] inits2 = new Expression[1];
            let2 = new LetExp(inits2);
            savedPointMark = let2.addDeclaration(null, Type.long_type);
            Expression[] args = new Expression[]{new ReferenceExp(savedBuffer)};
            inits2[0] = Invoke.makeInvokeStatic(typeSaveExcursion, "savePointMark", args);
            savedBuffer.noteValue(inits2[0]);
            tr.push(let2);
        }
        Expression body = tr.rewrite_body(obj);
        if (this.bufferOnly) {
            Expression[] args = new Expression[]{new ReferenceExp(savedBuffer)};
            finalizer = Invoke.makeInvokeStatic(typeBuffer, "setBuffer", args);
        } else {
            tr.pop(let2);
            let1.body = let2;
            Expression[] args = new Expression[]{new ReferenceExp(savedBuffer), new ReferenceExp(savedPointMark)};
            finalizer = Invoke.makeInvokeStatic(typeSaveExcursion, "restoreBufferPointMark", args);
        }
        tr.pop(let1);
        let2.body = new TryExp(body, finalizer);
        return let1;
    }

    public static long savePointMark(Buffer buffer) {
        return buffer.savePointMark();
    }

    public static void restoreBufferPointMark(Buffer buffer, long pointMark) {
        Buffer.setCurrent(buffer);
        buffer.restorePointMark(pointMark);
    }
}

