/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml;

import gnu.lists.Consumer;
import gnu.text.LineBufferedReader;
import gnu.text.LineInputStreamReader;
import gnu.text.Path;
import gnu.text.SourceMessages;
import gnu.xml.XMLFilter;
import java.io.IOException;
import java.io.InputStream;

public class XMLParser {
    private static final int EXPECT_NAME_MODIFIER = 1;
    private static final int SKIP_SPACES_MODIFIER = 2;
    private static final int INIT_STATE = 0;
    private static final int TEXT_STATE = 1;
    private static final int BEGIN_ELEMENT_STATE = 2;
    private static final int END_ELEMENT_STATE = 4;
    private static final int SAW_ENTITY_REF = 6;
    private static final int ATTRIBUTE_SEEN_NAME_STATE = 8;
    private static final int MAYBE_ATTRIBUTE_STATE = 10;
    private static final int ATTRIBUTE_SEEN_EQ_STATE = 11;
    private static final int DOCTYPE_SEEN_STATE = 13;
    private static final int DOCTYPE_NAME_SEEN_STATE = 16;
    private static final int SAW_LEFT_STATE = 14;
    private static final int SAW_LEFT_SLASH_STATE = 19;
    private static final int SAW_LEFT_EXCL_STATE = 20;
    private static final int SAW_LEFT_QUEST_STATE = 21;
    private static final int SAW_LEFT_EXCL_MINUS_STATE = 22;
    private static final int SAW_AMP_STATE = 25;
    private static final int SAW_AMP_SHARP_STATE = 26;
    private static final int EXPECT_RIGHT_STATE = 27;
    private static final int PREV_WAS_CR_STATE = 28;
    private static final int INIT_LEFT_QUEST_STATE = 30;
    private static final int INIT_TEXT_STATE = 31;
    private static final int INIT_LEFT_STATE = 34;
    private static final int INVALID_VERSION_DECL = 35;
    private static final int SAW_ERROR = 36;
    private static final int SAW_EOF_ERROR = 37;
    static final String BAD_ENCODING_SYNTAX = "bad 'encoding' declaration";
    static final String BAD_STANDALONE_SYNTAX = "bad 'standalone' declaration";

    public static void parse(Object uri, SourceMessages messages, Consumer out) throws IOException {
        XMLParser.parse(Path.openInputStream(uri), uri, messages, out);
    }

    public static LineInputStreamReader XMLStreamReader(InputStream strm) throws IOException {
        int b3;
        LineInputStreamReader in = new LineInputStreamReader(strm);
        int b1 = in.getByte();
        int b2 = b1 < 0 ? -1 : in.getByte();
        int n = b3 = b2 < 0 ? -1 : in.getByte();
        if (b1 == 239 && b2 == 187 && b3 == 191) {
            in.resetStart(3);
            in.setCharset("UTF-8");
        } else if (b1 == 255 && b2 == 254 && b3 != 0) {
            in.resetStart(2);
            in.setCharset("UTF-16LE");
        } else if (b1 == 254 && b2 == 255 && b3 != 0) {
            in.resetStart(2);
            in.setCharset("UTF-16BE");
        } else {
            int b4;
            int n2 = b4 = b3 < 0 ? -1 : in.getByte();
            if (b1 == 76 && b2 == 111 && b3 == 167 && b4 == 148) {
                throw new RuntimeException("XMLParser: EBCDIC encodings not supported");
            }
            in.resetStart(0);
            if (b1 == 60 && (b2 == 63 && b3 == 120 && b4 == 109 || b2 == 0 && b3 == 63 && b4 == 0) || b1 == 0 && b2 == 60 && b3 == 0 && b4 == 63) {
                char[] buffer = in.buffer;
                if (buffer == null) {
                    in.buffer = buffer = new char[8192];
                }
                int pos = 0;
                int quote = 0;
                while (true) {
                    int b;
                    if ((b = in.getByte()) == 0) {
                        continue;
                    }
                    if (b < 0) break;
                    buffer[pos++] = (char)(b & 0xFF);
                    if (quote == 0) {
                        if (b == 62) break;
                        if (b != 39 && b != 34) continue;
                        quote = b;
                        continue;
                    }
                    if (b != quote) continue;
                    quote = 0;
                }
                in.pos = 0;
                in.limit = pos;
            } else {
                in.setCharset("UTF-8");
            }
        }
        in.setKeepFullLines(false);
        return in;
    }

    public static void parse(InputStream strm, Object uri, SourceMessages messages, Consumer out) throws IOException {
        LineInputStreamReader in = XMLParser.XMLStreamReader(strm);
        if (uri != null) {
            in.setName(uri);
        }
        XMLParser.parse((LineBufferedReader)in, messages, out);
        in.close();
    }

    public static void parse(LineBufferedReader in, SourceMessages messages, Consumer out) throws IOException {
        XMLFilter filter = new XMLFilter(out);
        filter.setMessages(messages);
        filter.setSourceLocator(in);
        filter.startDocument();
        Path uri = in.getPath();
        if (uri != null) {
            filter.writeDocumentUri(uri);
        }
        XMLParser.parse(in, filter);
        filter.endDocument();
    }

    public static void parse(LineBufferedReader in, SourceMessages messages, XMLFilter filter) throws IOException {
        filter.setMessages(messages);
        filter.setSourceLocator(in);
        filter.startDocument();
        Path uri = in.getPath();
        if (uri != null) {
            filter.writeDocumentUri(uri);
        }
        XMLParser.parse(in, filter);
        filter.endDocument();
        in.close();
    }

    /*
     * Unable to fully structure code
     */
    public static void parse(LineBufferedReader in, XMLFilter out) {
        buffer = in.buffer;
        pos = in.pos;
        limit = in.limit;
        state = 0;
        terminator = '<';
        continue_state = 14;
        ch = ' ';
        length = 0;
        dstart = -1;
        message = null;
        start = limit;
        block29: while (true) {
            switch (state) {
                case 0: {
                    state = 1;
                    state = 31;
                    ** GOTO lbl438
                }
                case 31: {
                    if (ch != 60) ** GOTO lbl22
                    state = 34;
                    ** GOTO lbl438
lbl22:
                    // 1 sources

                    state = 1;
                    continue block29;
                }
                case 34: {
                    if (ch != 63) ** GOTO lbl29
                    start = pos;
                    state = 33;
                    ** GOTO lbl438
lbl29:
                    // 1 sources

                    state = 14;
                    continue block29;
                }
                case 35: {
                    pos = dstart;
                    message = "invalid xml version specifier";
                }
                case 36: {
                    in.pos = pos;
                    out.error('e', message);
                    while (pos < limit) {
                        if ((ch = buffer[pos++]) != 62) continue;
                        state = 1;
                        ** GOTO lbl438
                    }
                    break block29;
                }
                case 37: {
                    in.pos = pos;
                    out.error('f', "unexpected end-of-file");
                    return;
                }
                case 1: {
                    start = pos - 1;
                    length = pos;
                    while (true) {
                        if (ch == terminator) {
                            state = continue_state;
                            break;
                        }
                        if (ch == '&') {
                            state = 25;
                            break;
                        }
                        if (ch != 13) ** GOTO lbl81
                        length = pos - length;
                        in.pos = pos;
                        if (length > 0) {
                            out.textFromParser(buffer, start, length);
                        }
                        if (pos >= limit) ** GOTO lbl78
                        ch = buffer[pos];
                        if (ch == '\n') {
                            start = pos++;
                            length = pos;
                        } else {
                            out.linefeedFromParser();
                            if (ch == '\u0085') {
                                start = pos++;
                                length = pos + 1;
                            } else {
                                in.incrLineNumber(1, pos);
                                start = pos++;
                                length = pos;
                                continue;
                            }
                        }
                        in.incrLineNumber(1, pos);
                        ** GOTO lbl93
lbl78:
                        // 1 sources

                        out.linefeedFromParser();
                        state = 28;
                        ** GOTO lbl438
lbl81:
                        // 1 sources

                        if (ch == '\u0085' || ch == '\u2028') {
                            length = pos - length;
                            in.pos = pos - 1;
                            if (length > 0) {
                                out.textFromParser(buffer, start, length);
                            }
                            out.linefeedFromParser();
                            in.incrLineNumber(1, pos);
                            length = pos + 1;
                            start = pos;
                        } else if (ch == '\n') {
                            in.incrLineNumber(1, pos);
                        }
lbl93:
                        // 5 sources

                        if (pos == limit) {
                            --length;
                            break;
                        }
                        ch = buffer[pos++];
                    }
                    length = pos - length;
                    if (length > 0) {
                        in.pos = pos;
                        out.textFromParser(buffer, start, length);
                    }
                    start = buffer.length;
                    ** GOTO lbl438
                }
                case 28: {
                    state = 1;
                    if (!(ch == '\n' | ch == '\u0085')) ** GOTO lbl109
                    in.incrLineNumber(1, pos);
                    ** GOTO lbl438
lbl109:
                    // 1 sources

                    in.incrLineNumber(1, pos - 1);
                    continue block29;
                }
                case 12: 
                case 15: 
                case 23: 
                case 29: 
                case 32: {
                    if (ch == 32 || ch == '\t') ** GOTO lbl438
                    if (ch != '\n' && ch != '\r' && ch != '\u0085' && ch != 8232) ** GOTO lbl116
                    in.incrLineNumber(1, pos);
                    ** GOTO lbl438
lbl116:
                    // 1 sources

                    state -= 2;
                    continue block29;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 17: 
                case 24: 
                case 33: {
                    length = start + 1;
                    while (true) {
                        if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_' || ch == ':' || ch >= '\u00c0' && (ch <= '\u02ff' || ch >= '\u0370' && (ch <= '\u1fff' && ch != '\u037e' || ch >= '\u200c' && (ch <= '\u200d' || ch >= '\u2070' && ch <= '\u218f' || ch >= '\u2c00' && ch <= '\u2fef' || ch >= '\u3001' && ch <= '\ud7ff' || ch >= '\uf900' && ch <= '\ufffd'))) || pos > length && ch >= '0' && ch <= '9' || ch == '.' || ch == '-' || ch == '\u00b7' || ch > '\u0300' && (ch <= '\u036f' || ch >= '\u203f' && ch <= '\u2040'))) {
                            --state;
                            if ((length = pos - length) != 0) continue block29;
                            message = state == 8 ? "missing or invalid attribute name" : (state == 2 || state == 4 ? "missing or invalid element name" : "missing or invalid name");
                            state = 36;
                            continue block29;
                        }
                        if (pos < limit) {
                            ch = buffer[pos++];
                            continue;
                        }
                        ** GOTO lbl438
                        break;
                    }
                }
                case 26: {
                    while (true) {
                        if (ch == ';') {
                            in.pos = pos;
                            out.emitCharacterReference(length, buffer, start, pos - 1 - start);
                            state = 1;
                        } else {
                            if (ch == 'x' && dstart == 0) {
                                dstart = 16;
                            } else {
                                if (length >= 0x8000000 || (digit = Character.digit(ch, base = dstart == 0 ? 10 : dstart)) < 0) break;
                                length = length * base + digit;
                            }
                            if (pos < limit) {
                                ch = buffer[pos++];
                                continue;
                            }
                        }
                        ** GOTO lbl438
                        break;
                    }
                    in.pos = pos;
                    out.error('e', "invalid character reference");
                    state = 1;
                    ** GOTO lbl438
                }
                case 25: {
                    if (ch != 35) ** GOTO lbl158
                    state = 26;
                    start = pos;
                    length = 0;
                    dstart = 0;
                    ** GOTO lbl438
lbl158:
                    // 1 sources

                    start = pos - 1;
                    state = 7;
                    continue block29;
                }
                case 6: {
                    in.pos = pos;
                    if (ch != ';') {
                        out.error('w', "missing ';'");
                    }
                    out.emitEntityReference(buffer, start, length);
                    start = limit;
                    state = 1;
                    ** GOTO lbl438
                }
                case 14: {
                    if (ch != 47) ** GOTO lbl173
                    state = 19;
                    ** GOTO lbl438
lbl173:
                    // 1 sources

                    if (ch != 63) ** GOTO lbl177
                    start = pos;
                    state = 24;
                    ** GOTO lbl438
lbl177:
                    // 1 sources

                    if (ch != 33) ** GOTO lbl181
                    state = 20;
                    start = pos;
                    ** GOTO lbl438
lbl181:
                    // 1 sources

                    start = pos - 1;
                    state = 3;
                    continue block29;
                }
                case 2: {
                    in.pos = pos - length;
                    out.emitStartElement(buffer, start, length);
                    state = 12;
                    start = limit;
                    continue block29;
                }
                case 21: 
                case 30: {
                    if (dstart < 0) {
                        dstart = pos - 1;
                    }
                    while (true) {
                        if (ch != 62 || buffer[end = pos - 2] != '?' || end < dstart) ** GOTO lbl313
                        in.pos = pos;
                        if (length != 3 || buffer[start] != 'x' || buffer[start + 1] != 'm' || buffer[start + 2] != 'l') ** GOTO lbl308
                        if (state == 30) {
                            if (end <= dstart + 7 || buffer[dstart] != 'v' || buffer[dstart + 1] != 'e' || buffer[dstart + 2] != 'r' || buffer[dstart + 3] != 's' || buffer[dstart + 4] != 'i' || buffer[dstart + 5] != 'o' || buffer[dstart + 6] != 'n') {
                                pos = dstart;
                                message = "xml declaration without version";
                                state = 36;
                                continue block29;
                            }
                            ch = buffer[dstart += 7];
                            while (Character.isWhitespace(ch) && ++dstart < end) {
                                ch = buffer[dstart];
                            }
                            if (ch != '=') {
                                state = 35;
                                continue block29;
                            }
                            ch = buffer[++dstart];
                            while (Character.isWhitespace(ch) && ++dstart < end) {
                                ch = buffer[dstart];
                            }
                            if (ch != '\'' && ch != '\"') {
                                state = 35;
                                continue block29;
                            }
                            quote = ch;
                            i = ++dstart;
                            while (true) {
                                if (i == end) {
                                    state = 35;
                                    continue block29;
                                }
                                ch = buffer[i];
                                if (ch == quote) break;
                                ++i;
                            }
                            if ((i != dstart + 3 || buffer[dstart] != '1' || buffer[dstart + 1] != '.' || (ch = buffer[dstart + 2]) != '0') && ch != '1') {
                                state = 35;
                                continue block29;
                            }
                            for (dstart = i + 1; dstart < end && Character.isWhitespace(buffer[dstart]); ++dstart) {
                            }
                            if (end > dstart + 7 && buffer[dstart] == 'e' && buffer[dstart + 1] == 'n' && buffer[dstart + 2] == 'c' && buffer[dstart + 3] == 'o' && buffer[dstart + 4] == 'd' && buffer[dstart + 5] == 'i' && buffer[dstart + 6] == 'n' && buffer[dstart + 7] == 'g') {
                                ch = buffer[dstart += 8];
                                while (Character.isWhitespace(ch) && ++dstart < end) {
                                    ch = buffer[dstart];
                                }
                                if (ch != '=') {
                                    message = "bad 'encoding' declaration";
                                    state = 36;
                                    continue block29;
                                }
                                ch = buffer[++dstart];
                                while (Character.isWhitespace(ch) && ++dstart < end) {
                                    ch = buffer[dstart];
                                }
                                if (ch != '\'' && ch != '\"') {
                                    message = "bad 'encoding' declaration";
                                    state = 36;
                                    continue block29;
                                }
                                quote = ch;
                                i = ++dstart;
                                while (true) {
                                    if (i == end) {
                                        message = "bad 'encoding' declaration";
                                        state = 36;
                                        continue block29;
                                    }
                                    ch = buffer[i];
                                    if (ch == quote) break;
                                    ++i;
                                }
                                encoding = new String(buffer, dstart, i - dstart);
                                if (in instanceof LineInputStreamReader) {
                                    ((LineInputStreamReader)in).setCharset(encoding);
                                }
                                for (dstart = i + 1; dstart < end && Character.isWhitespace(buffer[dstart]); ++dstart) {
                                }
                            }
                            if (end > dstart + 9 && buffer[dstart] == 's' && buffer[dstart + 1] == 't' && buffer[dstart + 2] == 'a' && buffer[dstart + 3] == 'n' && buffer[dstart + 4] == 'd' && buffer[dstart + 5] == 'a' && buffer[dstart + 6] == 'l' && buffer[dstart + 7] == 'o' && buffer[dstart + 8] == 'n' && buffer[dstart + 9] == 'e') {
                                ch = buffer[dstart += 10];
                                while (Character.isWhitespace(ch) && ++dstart < end) {
                                    ch = buffer[dstart];
                                }
                                if (ch != '=') {
                                    message = "bad 'standalone' declaration";
                                    state = 36;
                                    continue block29;
                                }
                                ch = buffer[++dstart];
                                while (Character.isWhitespace(ch) && ++dstart < end) {
                                    ch = buffer[dstart];
                                }
                                if (ch != '\'' && ch != '\"') {
                                    message = "bad 'standalone' declaration";
                                    state = 36;
                                    continue block29;
                                }
                                quote = ch;
                                i = ++dstart;
                                while (true) {
                                    if (i == end) {
                                        message = "bad 'standalone' declaration";
                                        state = 36;
                                        continue block29;
                                    }
                                    ch = buffer[i];
                                    if (ch == quote) break;
                                    ++i;
                                }
                                if (!(i == dstart + 3 && buffer[dstart] == 'y' && buffer[dstart + 1] == 'e' && buffer[dstart + 2] == 's' || i == dstart + 2 && buffer[dstart] == 'n' && buffer[dstart + 1] == 'o')) {
                                    message = "bad 'standalone' declaration";
                                    state = 36;
                                    continue block29;
                                }
                                for (dstart = i + 1; dstart < end && Character.isWhitespace(buffer[dstart]); ++dstart) {
                                }
                            }
                            if (end != dstart) {
                                message = "junk at end of xml declaration";
                                pos = dstart;
                                state = 36;
                                continue block29;
                            }
                        } else {
                            message = "<?xml must be at start of file";
                            state = 36;
                            continue block29;
lbl308:
                            // 1 sources

                            out.processingInstructionFromParser(buffer, start, length, dstart, end - dstart);
                        }
                        start = limit;
                        dstart = -1;
                        state = 1;
                        ** GOTO lbl438
lbl313:
                        // 1 sources

                        if (pos < limit) {
                            ch = buffer[pos++];
                            continue;
                        }
                        ** GOTO lbl438
                        break;
                    }
                }
                case 20: {
                    while (true) {
                        if (ch != 62) ** GOTO lbl333
                        length = pos - 1 - start;
                        if (length >= 4 && buffer[start] == '-' && buffer[start + 1] == '-') {
                            if (buffer[pos - 2] == '-' && buffer[pos - 3] == '-') {
                                in.pos = pos;
                                out.commentFromParser(buffer, start + 2, length - 4);
                                break;
                            }
                        } else {
                            if (length < 6 || buffer[start] != '[' || buffer[start + 1] != 'C' || buffer[start + 2] != 'D' || buffer[start + 3] != 'A' || buffer[start + 4] != 'T' || buffer[start + 5] != 'A' || buffer[start + 6] != '[') break;
                            if (buffer[pos - 2] == ']' && buffer[pos - 3] == ']') {
                                in.pos = pos;
                                out.writeCDATA(buffer, start + 7, pos - 10 - start);
                                break;
                            }
                        }
                        ** GOTO lbl-1000
lbl333:
                        // 1 sources

                        if (pos == start + 7 && buffer[start] == 'D' && buffer[start + 1] == 'O' && buffer[start + 2] == 'C' && buffer[start + 3] == 'T' && buffer[start + 4] == 'Y' && buffer[start + 5] == 'P' && ch == 'E') {
                            start = limit;
                            state = 15;
                        } else if (pos < limit) {
                            ch = buffer[pos++];
                            continue;
                        }
                        ** GOTO lbl438
                        break;
                    }
                    start = limit;
                    state = 1;
                    ** GOTO lbl438
                }
                case 13: {
                    state = 17;
                    start = pos - 1;
                    continue block29;
                }
                case 16: {
                    if (dstart < 0) {
                        dstart = pos - 1;
                        dstart -= start;
                        dstart <<= 1;
                        terminator = '\u0000';
                    }
                    while (true) {
                        if (ch != '\'' && ch != 34) ** GOTO lbl362
                        if (terminator != '\u0000') ** GOTO lbl359
                        terminator = ch;
                        ** GOTO lbl-1000
lbl359:
                        // 1 sources

                        if (terminator != ch) ** GOTO lbl-1000
                        terminator = '\u0000';
                        ** GOTO lbl-1000
lbl362:
                        // 1 sources

                        if (terminator != '\u0000') ** GOTO lbl-1000
                        if (ch != 91) ** GOTO lbl366
                        dstart |= 1;
                        ** GOTO lbl-1000
lbl366:
                        // 1 sources

                        if (ch != 93) ** GOTO lbl369
                        dstart &= -2;
                        ** GOTO lbl-1000
lbl369:
                        // 1 sources

                        if (ch == '>' && (dstart & 1) == 0) {
                            in.pos = pos;
                            dstart >>= 1;
                            out.emitDoctypeDecl(buffer, start, length, dstart += start, pos - 1 - dstart);
                            terminator = '<';
                            start = limit;
                            dstart = -1;
                            state = 1;
                        } else if (pos < limit) {
                            ch = buffer[pos++];
                            continue;
                        }
                        ** GOTO lbl438
                        break;
                    }
                }
                case 10: {
                    terminator = '<';
                    continue_state = 14;
                    if (ch != 47) ** GOTO lbl391
                    in.pos = pos;
                    out.emitEndAttributes();
                    out.emitEndElement(null, 0, 0);
                    state = 27;
                    ** GOTO lbl438
lbl391:
                    // 1 sources

                    if (ch != 62) ** GOTO lbl396
                    in.pos = pos;
                    out.emitEndAttributes();
                    state = 1;
                    ** GOTO lbl438
lbl396:
                    // 1 sources

                    start = pos - 1;
                    state = 9;
                    continue block29;
                }
                case 8: {
                    if (ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n' || ch == '\u0085' || ch == '\u2028') ** GOTO lbl438
                    in.pos = pos - length;
                    out.emitStartAttribute(buffer, start, length);
                    start = limit;
                    if (ch != 61) ** GOTO lbl407
                    state = 11;
                    ** GOTO lbl438
lbl407:
                    // 1 sources

                    out.emitEndAttributes();
                    message = "missing or misplaced '=' after attribute name";
                    state = 36;
                    continue block29;
                }
                case 11: {
                    if (ch == '\'' || ch == '\"') {
                        terminator = ch;
                        continue_state = 12;
                        state = 1;
                    } else if (ch != ' ' && ch != '\t' && ch != '\r' && ch != '\n' && ch != '\u0085' && ch != '\u2028') {
                        message = "missing or unquoted attribute value";
                        state = 36;
                        continue block29;
                    }
                    ** GOTO lbl438
                }
                case 19: {
                    start = pos - 1;
                    state = 5;
                    continue block29;
                }
                case 4: {
                    in.pos = pos;
                    out.emitEndElement(buffer, start, length);
                    start = limit;
                    state = 29;
                    continue block29;
                }
                case 27: {
                    if (ch != '>') {
                        message = "missing '>'";
                        state = 36;
                        continue block29;
                    }
                    state = 1;
                }
lbl438:
                // 33 sources

                default: {
                    if (pos < limit) {
                        ch = buffer[pos++];
                        continue block29;
                    }
                    saved = pos - start;
                    try {
                        if (saved > 0) {
                            in.pos = start;
                            in.mark(saved + 1);
                        }
                        in.pos = pos;
                        x = in.read();
                        if (x < 0) {
                            if (state == 1 || state == 28) {
                                return;
                            }
                            state = 37;
                            continue block29;
                        }
                        if (saved > 0) {
                            in.reset();
                            in.skip(saved);
                        } else {
                            in.unread_quick();
                        }
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex.getMessage());
                    }
                    pos = in.pos;
                    buffer = in.buffer;
                    limit = in.limit;
                    start = saved > 0 ? pos - saved : limit;
                    ch = buffer[pos++];
                    continue block29;
                }
            }
            break;
        }
    }
}

