/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.kawa.functions.IsEqv;
import gnu.kawa.functions.SetArrayExp;
import gnu.kawa.functions.SetListExp;
import gnu.kawa.functions.Setter;
import gnu.kawa.reflect.ArrayGet;
import gnu.kawa.reflect.Invoke;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.math.Numeric;
import gnu.text.Char;
import java.io.Externalizable;

public class CompilationHelpers {
    static final ClassType typeList = ClassType.make("java.util.List");
    static final ClassType setterType = ClassType.make("gnu.kawa.functions.Setter");
    static final Field setterField = setterType.getDeclaredField("setter");
    public static final Declaration setterDecl = new Declaration((Object)"setter", setterField);

    private static boolean nonNumeric(Expression exp) {
        if (exp instanceof QuoteExp) {
            Object value = ((QuoteExp)exp).getValue();
            return !(value instanceof Numeric) && !(value instanceof Char) && !(value instanceof Symbol);
        }
        return false;
    }

    public static Expression inlineApplyToArgs(ApplyExp exp, InlineCalls walker, boolean argsInlined, Procedure applyToArgs) {
        Expression[] args = exp.getArgs();
        int nargs = args.length - 1;
        if (nargs >= 0) {
            ClassType ctype;
            ApplyExp result;
            Expression proc = args[0];
            if (!argsInlined) {
                if (proc instanceof LambdaExp) {
                    Expression[] rargs = new Expression[nargs];
                    System.arraycopy(args, 1, rargs, 0, nargs);
                    return walker.walk(new ApplyExp(proc, rargs));
                }
                args[0] = proc = walker.walk(proc);
            }
            Type ptype = proc.getType().getRealType();
            Compilation comp = walker.getCompilation();
            Language language = comp.getLanguage();
            if (ptype.isSubtype(Compilation.typeProcedure)) {
                Expression[] rargs = new Expression[nargs];
                System.arraycopy(args, 1, rargs, 0, nargs);
                return proc.inline(new ApplyExp(proc, rargs), walker, null, argsInlined);
            }
            if (!argsInlined) {
                for (int i = 1; i <= nargs; ++i) {
                    args[i] = walker.walk(args[i]);
                }
            }
            if (Invoke.checkKnownClass(ptype, comp) < 0) {
                return exp;
            }
            if (ptype.isSubtype(Compilation.typeType) || language.getTypeFor(proc, false) != null) {
                result = new ApplyExp(Invoke.make, args);
            } else if (ptype instanceof ArrayType) {
                Type elementType = ((ArrayType)ptype).getComponentType();
                result = new ApplyExp(new ArrayGet(elementType), args);
            } else if (ptype instanceof ClassType && (ctype = (ClassType)ptype).isSubclass(typeList) && nargs == 1) {
                Method get = ctype.getMethod("get", new Type[]{Type.intType});
                result = new ApplyExp(get, args);
            } else {
                return exp;
            }
            result.setLine(exp);
            return walker.walkApplyOnly(result);
        }
        return exp;
    }

    public static Expression inlineSetter(ApplyExp exp, InlineCalls walker, boolean argsInlined, Procedure proc) {
        exp.walkArgs(walker, argsInlined);
        Expression[] args = exp.getArgs();
        if (args.length == 1) {
            Procedure setter;
            Object value;
            Declaration decl;
            ClassType ctype;
            Expression arg = args[0];
            Type argType = arg.getType();
            if (argType instanceof ArrayType) {
                return new SetArrayExp(arg, (ArrayType)argType);
            }
            if (argType instanceof ClassType && (ctype = (ClassType)argType).isSubclass(typeList)) {
                if (exp instanceof SetListExp) {
                    return exp;
                }
                return new SetListExp(exp.getFunction(), args);
            }
            if (arg instanceof ReferenceExp && (decl = ((ReferenceExp)arg).getBinding()) != null) {
                arg = decl.getValue();
            }
            if (arg instanceof QuoteExp && (value = ((QuoteExp)arg).getValue()) instanceof Procedure && (setter = ((Procedure)value).getSetter()) instanceof Procedure) {
                if (setter instanceof Externalizable) {
                    return new QuoteExp(setter);
                }
                Declaration decl2 = Declaration.getDeclaration(setter);
                if (decl2 != null) {
                    return new ReferenceExp(decl2);
                }
            }
        }
        return exp;
    }

    public static Expression inlineIsEqv(ApplyExp exp, InlineCalls walker, boolean argsInlined, Procedure proc) {
        exp.walkArgs(walker, argsInlined);
        Expression[] args = exp.getArgs();
        if (CompilationHelpers.nonNumeric(args[0]) || CompilationHelpers.nonNumeric(args[1])) {
            return new ApplyExp(((IsEqv)proc).isEq, args);
        }
        return exp;
    }

    static {
        setterDecl.noteValue(new QuoteExp(Setter.setter));
    }
}

