/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.JtagTester;
import com.sun.electric.tool.simulation.test.NanosimLogicSettable;
import com.sun.electric.tool.simulation.test.NanosimModel;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HsimModel
extends NanosimModel {
    protected String simFile;
    protected static final Pattern patSimTime = Pattern.compile("tnow=(\\S+)ns");
    public static final double badtime = -1.0;
    protected static final Pattern[] patNodeInfo = new Pattern[]{Pattern.compile(".*?V=(\\S+), dV/dt=(\\S+) (\\S+), time=(\\S+)"), Pattern.compile(".*?Constant node capacitance\\s+: (\\S+) (\\S+)"), Pattern.compile(".*?Voltage-dependent node capacitance\\s+: (\\S+) (\\S+)"), Pattern.compile(".*?Total node capacitance\\s+: (\\S+) (\\S+)")};

    @Override
    public void setNodeVoltage(String node, double value2) {
        if (this.assuraRCXNetlist) {
            node = node.replaceAll("\\.", "/");
        } else if (this.starRCXTNetlist) {
            if (node.startsWith("x")) {
                node = node.substring(1);
            }
            node = node.replaceAll("\\.x?", "/");
        }
        node = node.replaceAll("\\[", "?");
        node = node.replaceAll("\\]", "?");
        String cmd = "fv " + node + " " + value2;
        this.issueCommand(cmd);
        String result2 = this.getLastCommandOutput().toString();
        if (!result2.startsWith("HSIM >")) {
            throw new RuntimeException("command \"" + cmd + "\" gave the following error: " + result2);
        }
    }

    public void releaseNodeVoltage(String node) {
        if (this.assuraRCXNetlist) {
            node = node.replaceAll("\\.", "/");
        } else if (this.starRCXTNetlist) {
            if (node.startsWith("x")) {
                node = node.substring(1);
            }
            node = node.replaceAll("\\.x?", "/");
        }
        node = node.replaceAll("\\[", "?");
        node = node.replaceAll("\\]", "?");
        String cmd = "rv " + node + "";
        this.issueCommand(cmd);
        String result2 = this.getLastCommandOutput().toString();
        if (!result2.startsWith("HSIM >")) {
            throw new RuntimeException("command \"" + cmd + "\" gave the following error: " + result2);
        }
    }

    @Override
    public void disableNode(String node) {
        this.setNodeVoltage(node, 0.0);
    }

    @Override
    public void enableNode(String node) {
        this.releaseNodeVoltage(node);
    }

    protected boolean checkRcx() {
        System.out.println(this.simFile);
        try {
            String line;
            BufferedReader freader = new BufferedReader(new FileReader(this.simFile));
            for (int i = 0; i < 20 && (line = freader.readLine()) != null; ++i) {
                if (line.matches("\\*  PROGRAM .*?assura.*")) {
                    this.assuraRCXNetlist = true;
                    System.out.println("Info: Running on Assura extracted netlist, will replace all '.' in net names with '/'");
                } else {
                    if (!line.matches("\\*|PROGRAM .*?Star-RCXT.*")) continue;
                    this.starRCXTNetlist = true;
                    System.out.println("Info: Running on Star-RCXT extracted netlist, will replace all '.x' in net names with '/'");
                }
                break;
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    boolean start_(String command, String simFile, int recordSim) {
        this.setPrompt("HSIM > ");
        this.simFile = simFile;
        if (!this.checkRcx()) {
            return false;
        }
        if (!this.startProcess(command + " -time 90000 " + simFile + " -o " + simFile, null, null, simFile + ".run")) {
            return false;
        }
        this.vdd = 0.9;
        this.timeStep = this.getSimTres();
        for (NanosimLogicSettable ls : this.logicSettables) {
            if (ls.init()) continue;
            System.out.println("LogicSettable initialization failed, aborting.");
            return false;
        }
        for (JtagTester tester : this.jtagTesters) {
            tester.reset();
        }
        return true;
    }

    public double getSimTime() {
        double tmp;
        this.issueCommand("pt");
        String result2 = this.getLastCommandOutput().toString();
        if (!result2.startsWith("tnow")) {
            System.out.println(">> Error in getSimTime : no tnow");
            return -1.0;
        }
        Matcher m = patSimTime.matcher(result2);
        if (!m.find()) {
            System.out.println(">> Error in getSimTime : no match");
            return -1.0;
        }
        try {
            tmp = Double.parseDouble(m.group(1));
        }
        catch (NumberFormatException e) {
            System.out.println(">> Error in getSimTime : bad number conversion");
            return -1.0;
        }
        return tmp;
    }

    @Override
    public void waitNS(double nanoseconds, boolean applyVoltages) {
        double tmp;
        if (applyVoltages) {
            this.applyVoltages();
        }
        if ((tmp = this.getSimTime()) != -1.0) {
            this.simTime = tmp;
        }
        double stopTime = this.simTime + nanoseconds;
        this.issueCommand("stop -at " + stopTime);
        this.issueCommand("cont");
        this.simTime = stopTime;
    }

    @Override
    public double getSimTres() {
        return 0.01;
    }

    @Override
    public void applyVoltages() {
        this.releaseNodes(new ArrayList(this.nodesToSet.keySet()));
        for (Map.Entry entry : this.nodesToSet.entrySet()) {
            String node = (String)entry.getKey();
            Double voltage = (Double)entry.getValue();
            if (this.assuraRCXNetlist) {
                node = node.replaceAll("\\.", "/");
            } else if (this.starRCXTNetlist) {
                if (node.startsWith("x")) {
                    node = node.substring(1);
                }
                node = node.replaceAll("\\.x?", "/");
            }
            this.setNodeVoltage(node, voltage);
        }
        this.nodesToSet.clear();
    }

    @Override
    public void releaseNodes(List nodes) {
        for (String node : nodes) {
            if (this.assuraRCXNetlist) {
                node = node.replaceAll("\\.", "/");
            } else if (this.starRCXTNetlist) {
                if (node.startsWith("x")) {
                    node = node.substring(1);
                }
                node = node.replaceAll("\\.x?", "/");
            }
            this.releaseNodeVoltage(node);
        }
    }

    @Override
    protected List getNodeInfo(List nodes, boolean returnState) {
        if (this.nodesToSet.size() > 0) {
            this.applyVoltages();
        }
        if (this.assuraRCXNetlist || this.starRCXTNetlist) {
            ArrayList<String> nodesfixed = new ArrayList<String>();
            for (String node : nodes) {
                if (this.assuraRCXNetlist) {
                    node = node.replaceAll("\\.", "/");
                } else if (this.starRCXTNetlist) {
                    if (node.startsWith("x")) {
                        node = node.substring(1);
                    }
                    node = node.replaceAll("\\.x?", "/");
                }
                nodesfixed.add(node);
            }
            nodes = nodesfixed;
        }
        ArrayList<String> nodeslc = new ArrayList<String>();
        ArrayList<Number> voltages = new ArrayList<Number>();
        StringBuffer cmd = new StringBuffer();
        cmd.append("nv ");
        boolean error = false;
        Iterator it = nodes.iterator();
        while (it.hasNext() && !error) {
            String node = (String)it.next();
            node = node.toLowerCase();
            nodeslc.add(node);
            String nodex = node;
            nodex = nodex.replaceAll("\\[", "?");
            nodex = nodex.replaceAll("\\]", "?");
            if (nodex.equals("vss")) {
                voltages.add(0);
                continue;
            }
            cmd.append(nodex);
            this.issueCommand(cmd.toString());
            String result2 = this.getLastCommandOutput().toString();
            if (!result2.startsWith("Node " + node)) {
                System.out.println("Error on getInfoNode: for node " + node + "; result:\n  " + result2);
                error = true;
                continue;
            }
            Double voltage = new Double(0.0);
            Double dvdt = new Double(0.0);
            Double time = new Double(0.0);
            Double cap = new Double(0.0);
            Double vcap = new Double(0.0);
            Double tcap = new Double(0.0);
            for (int patternIndex = 0; patternIndex < patNodeInfo.length && !error; ++patternIndex) {
                Matcher m = patNodeInfo[patternIndex].matcher(result2);
                if (!m.find()) {
                    System.out.println(">> Error on getInfoNode : for node " + node);
                    System.out.println(">> Pattern " + patternIndex + " : " + patNodeInfo[patternIndex]);
                    System.out.println(">> String : " + result2);
                    error = true;
                    continue;
                }
                try {
                    switch (patternIndex) {
                        case 0: {
                            voltage = Double.parseDouble(m.group(1));
                            dvdt = Double.parseDouble(m.group(2));
                            break;
                        }
                        case 1: {
                            cap = Double.parseDouble(m.group(1));
                            break;
                        }
                        case 2: {
                            vcap = Double.parseDouble(m.group(1));
                            break;
                        }
                        case 3: {
                            tcap = Double.parseDouble(m.group(1));
                            break;
                        }
                        case 4: {
                            break;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    System.out.println(">> Error on get_info_node: NumberFormatException for node " + node);
                    System.out.println(">> Pattern: " + patNodeInfo[patternIndex]);
                    System.out.println(">> String: " + result2);
                    for (int ngroup = 0; ngroup <= m.groupCount(); ++ngroup) {
                        System.out.println(">> Group " + ngroup + " : " + m.group(ngroup));
                    }
                    error = true;
                    continue;
                }
                result2 = result2.substring(m.end());
            }
            voltages.add(returnState ? (voltage >= this.vdd / 2.0 ? 1.0 : 0.0) : voltage);
        }
        if (error) {
            return null;
        }
        return voltages;
    }

    public void saveDatabase(String filename) {
        this.issueCommand("savesim filename");
    }

    public void restartDatabase(String filename, double timens) {
        this.issueCommand("restart " + timens + " " + filename);
    }

    public static void main(String[] args) {
        HsimModel nm = new HsimModel();
        nm.start("hsim64", "rc.sp", 0);
        nm.issueCommand("pt");
        nm.waitNS(2.0);
        nm.finish();
    }
}

