/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitiveNodeGroup;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.tool.user.dialogs.ComponentMenu;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;

public class ComponentMenuTab
extends PreferencePanel {
    private ComponentMenu theMenu;
    private Technology tech;

    public ComponentMenuTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.theMenu = new ComponentMenu(parent, false);
    }

    public JPanel getUserPreferencesPanel() {
        return this.theMenu.getPanel();
    }

    public String getName() {
        return "Component Menu";
    }

    public void init() {
        this.tech = Technology.getCurrent();
        Xml.Technology xTech = new Xml.Technology();
        Iterator<ArcProto> it = this.tech.getArcs();
        while (it.hasNext()) {
            ArcProto ap = it.next();
            Xml.ArcProto curArc = new Xml.ArcProto();
            curArc.name = ap.getName();
            xTech.arcs.add(curArc);
        }
        HashSet<PrimitiveNodeGroup> groupsDone = new HashSet<PrimitiveNodeGroup>();
        Iterator<PrimitiveNode> it2 = this.tech.getNodes();
        while (it2.hasNext()) {
            Xml.PrimitiveNodeGroup ng;
            PrimitiveNode pnp = it2.next();
            if (pnp.getFunction() == PrimitiveNode.Function.NODE) continue;
            PrimitiveNodeGroup group = pnp.getPrimitiveNodeGroup();
            if (group != null) {
                if (groupsDone.contains(group)) continue;
                ng = new Xml.PrimitiveNodeGroup();
                for (PrimitiveNode pn : group.getNodes()) {
                    Xml.PrimitiveNode n = new Xml.PrimitiveNode();
                    n.name = pn.getName();
                    ng.nodes.add(n);
                }
                xTech.nodeGroups.add(ng);
                groupsDone.add(group);
                continue;
            }
            ng = new Xml.PrimitiveNodeGroup();
            ng.isSingleton = true;
            Xml.PrimitiveNode n = new Xml.PrimitiveNode();
            n.name = pnp.getName();
            ng.nodes.add(n);
            xTech.nodeGroups.add(ng);
        }
        Object[][] menuArray = this.makeMenuArray(ComponentMenu.getMenuPalette(this.tech));
        Object[][] defMenuArray = this.makeMenuArray(this.tech.getFactoryMenuPalette());
        this.theMenu.showTechnology(this.tech.getTechName(), xTech, menuArray, defMenuArray);
    }

    private Object[][] makeMenuArray(Xml.MenuPalette curMenu) {
        int menuWid = curMenu.numColumns;
        int menuHei = (curMenu.menuBoxes.size() + menuWid - 1) / menuWid;
        Object[][] menuArray = new Object[menuHei][menuWid];
        for (int y = 0; y < menuHei; ++y) {
            for (int x = 0; x < menuWid; ++x) {
                List<?> menuBoxList;
                int index = y * menuWid + x;
                List<?> list = menuBoxList = index < curMenu.menuBoxes.size() ? curMenu.menuBoxes.get(index) : null;
                if (menuBoxList == null || menuBoxList.isEmpty()) continue;
                menuArray[y][x] = menuBoxList.size() > 1 ? new ArrayList(menuBoxList) : menuBoxList.get(0);
            }
        }
        return menuArray;
    }

    public void term() {
        int menuWid;
        if (!this.theMenu.isChanged()) {
            return;
        }
        Xml.MenuPalette xmp = new Xml.MenuPalette();
        Object[][] menuArray = this.theMenu.getMenuInfo();
        int menuHei = menuArray.length;
        xmp.numColumns = menuWid = menuArray[0].length;
        xmp.menuBoxes = new ArrayList();
        for (int y = 0; y < menuHei; ++y) {
            for (int x = 0; x < menuWid; ++x) {
                Object item = null;
                if (menuArray[y] != null) {
                    item = menuArray[y][x];
                }
                if (item instanceof List) {
                    xmp.menuBoxes.add((List)item);
                    continue;
                }
                ArrayList<Object> subList = new ArrayList<Object>();
                if (item != null) {
                    subList.add(item);
                }
                xmp.menuBoxes.add(subList);
            }
        }
        ComponentMenu.ComponentMenuPreferences cmp = new ComponentMenu.ComponentMenuPreferences(false);
        cmp.menuXmls.put(this.tech, xmp.writeXml());
        this.putPrefs(cmp);
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            wf.getPaletteTab().loadForTechnology(this.tech, wf);
        }
    }

    public boolean resetThis() {
        this.theMenu.factoryReset();
        return true;
    }

    public void reset() {
        ComponentMenu.ComponentMenuPreferences cmp = new ComponentMenu.ComponentMenuPreferences(true);
        this.putPrefs(cmp);
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            wf.getPaletteTab().loadForTechnology(this.tech, wf);
        }
    }
}

