/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.EJob;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.User;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUserInterface
extends Client
implements UserInterface {
    private TechId curTechId;
    private LibId curLibId;
    private Job.Key jobKey = new Job.Key(-1, 0, false);

    protected AbstractUserInterface(int connectionId) {
        super(connectionId);
    }

    @Override
    public Job.Key getJobKey() {
        return this.jobKey;
    }

    @Override
    public EDatabase getDatabase() {
        return EDatabase.clientDatabase();
    }

    @Override
    public Technology getCurrentTechnology() {
        EDatabase database = this.getDatabase();
        Technology tech = null;
        if (this.curTechId != null) {
            tech = database.getTech(this.curTechId);
        }
        if (tech == null) {
            tech = database.getTechPool().findTechnology(User.getDefaultTechnology());
        }
        if (tech == null) {
            tech = database.getTechPool().findTechnology("mocmos");
        }
        return tech;
    }

    public TechId getCurrentTechId() {
        return this.curTechId;
    }

    public void setCurrentTechnology(Technology tech) {
        if (tech != null) {
            this.curTechId = tech.getId();
        }
    }

    @Override
    public Library getCurrentLibrary() {
        return this.curLibId != null ? this.getDatabase().getLib(this.curLibId) : null;
    }

    public LibId getCurrentLibraryId() {
        return this.curLibId;
    }

    public void setCurrentLibrary(Library lib) {
        this.curLibId = lib != null ? lib.getId() : null;
    }

    protected abstract void addEvent(Client.ServerEvent var1);

    public void finishInitialization() {
    }

    protected void updateNetworkErrors(Cell cell, List<ErrorLogger.MessageLog> errors) {
        if (!errors.isEmpty()) {
            System.out.println(errors.size() + " network errors in " + cell);
        }
    }

    protected void updateIncrementalDRCErrors(Cell cell, List<ErrorLogger.MessageLog> newErrors, List<ErrorLogger.MessageLog> delErrors) {
        if (!newErrors.isEmpty()) {
            System.out.println(newErrors.size() + " drc errors in " + cell);
        }
    }

    public int saveHighlights() {
        return 0;
    }

    public void restoreHighlights(int highlightsId) {
    }

    public void showUndoRedoStatus(boolean newUndoEnabled, boolean newRedoEnabled) {
    }

    protected abstract void showJobQueue(Job.Inform[] var1);

    protected void showSnapshot(Snapshot newSnapshot, boolean undoRedo) {
    }

    protected abstract void terminateJob(EJob var1);

    @Override
    public void beep() {
    }

    protected void setClientThread() {
        assert (Job.clientThread == null);
        Job.clientThread = Thread.currentThread();
    }
}

