# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=shared-mime-info
VER=0.30
THIS=$MOD-$VER
HEX=`echo $THIS | md5sum | cut -d' ' -f1`

TARGET=c:/devel/target/$HEX
DEPS=`/devel/src/tml/latest.sh glib`
libxml2=`/devel/src/tml/latest.sh libxml2`

# Avoid the silly "relink" stuff in libtool
sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

usedev

MY_PKG_CONFIG_PATH=""
for D in $DEPS; do
    PATH=/devel/dist/$D/bin:$PATH
    MY_PKG_CONFIG_PATH=/devel/dist/$D/lib/pkgconfig:$MY_PKG_CONFIG_PATH
done

MSGFMT=/opt/gnu/bin/msgfmt GMSGFMT=/opt/gnu/bin/msgfmt PKG_CONFIG_PATH=$MY_PKG_CONFIG_PATH:$PKG_CONFIG_PATH CC='gcc -mtune=pentium3 -mthreads' CPPFLAGS="-I/opt/win_iconv/include -I/opt/proxy-libintl/include -I/devel/dist/$libxml2/include" LDFLAGS="-Wl,--enable-auto-image-base -L/opt/proxy-libintl/lib -Wl,--exclude-libs=libintl.a -L/devel/dist/$libxml2/lib" CFLAGS=-O2 ./configure --disable-static --prefix=$TARGET &&
make install &&

(cd /devel/target/$HEX &&
zip -r -D /tmp/$MOD-$VER.zip bin/update-mime-database.exe .
) &&

(cd /devel/src/tml && zip /tmp/$MOD-dev-$VER.zip make/$THIS.sh) &&
manifestify /tmp/$MOD*-$VER.zip
