#	This script manages the cockpit placards, based on the loaded model

var model = getprop("/sim/aero");

var placard_canvas = canvas.new({
	"name": "Placards",
	"size": [1024, 1024],
	"view": [1024, 1024],
	"mipmapping": 1
});

placard_canvas.addPlacement({"node": "placards.panel"});

var svg_group = placard_canvas.createGroup();

var font_mapper = func(family, weight) {
	if( weight == "bold" ){
		return "LiberationFonts/LiberationSans-Bold.ttf";
	} else {
		return "LiberationFonts/LiberationSans-Regular.ttf";
	}
	
};

canvas.parsesvg( svg_group, "Aircraft/HK36/src/panel_placards.svg", {'font-mapper': font_mapper});

if( model != "hk36-tts" and model != "hk36-ttc" ){
	svg_group.getElementById( "turbo_text" ).hide();
}
