##########################################
##	arcus.nas: General functions	##
##########################################

# Livery System
if ( getprop("/sim/model/variant") == 1 ){
	aircraft.livery.init( "Aircraft/Arcus/Models/Liveries-m" );
} else {
	aircraft.livery.init( "Aircraft/Arcus/Models/Liveries-s" );
}

# Rain
aircraft.rain.init();

# Windcheck
#	helper for wind information, triggered by keypress calling arcus.windcheck()
var windcheck = func{
	wd=getprop("/environment/wind-from-heading-deg");
	ch=getprop("/orientation/heading-deg");
	ws=getprop("/environment/wind-speed-kt");
	var wdi=wd-ch;
	if(wdi<0){
		gui.popupTip(sprintf("Wind from %d degrees left at %.1f knots", -wdi, ws));
	}else{
		gui.popupTip(sprintf("Wind from %d degrees right at %.1f knots", wdi, ws));
	}
}

# Woolthread
#	vibrating yaw string: instrument module
io.include("Aircraft/Generic/soaring-instrumentation-sdk.nas");

var yawstring = YawString.new(
	on_update: update_prop("instrumentation/yawstring"));

var string_instrument = Instrument.new(
	components: [yawstring],
	enable: 1);
