NAME
    RISCOS::File -- native file operations

SYNOPSIS
        use RISCOS::File 'globlist';
        @ARGV = globlist (@ARGV);
        # Simulate Unix-like filename globbing of command line arguments

        use RISCOS::File 'os_file';
        @info = os_file 'perl';


DESCRIPTION
    `RISCOS::File' provides RISC OS specific functions to access
    files, and a function `globcontrol' to control the globbing
    performed by the perl builtins `< >' and `glob'.

    settype <type>, <filename>...
        Sets the filetype of a list of files. *filename* can
        actually be a reference to a filehandle, and *type* can be
        specified as a number or a string - strings are passed to
        `OS_FSControl 31' which will also convert hexadecimal
        strings such as `FFF' and `&102' to numbers.

        Returns 0 for complete success, 1 if any errors occurred.

    gettype <filename>...
        Returns the numeric filetype of a list of files, or in
        scalar context the filetype of the first file. As you might
        expect *filename* can also be a filehandle (*i.e* reference
        to a typeglob, or an IO object). Returns `undef' for
        filenames/handles that do not correspond to disc files, or
        to files that are untyped.

    getdatestamp <filename>...
        In scalar context the returns the datestamp of the first
        file as a 5 byte scalar, or `undef' for filenames/handles
        that do not correspond to disc files, or to files that are
        untyped. In array context returns the list of datestamps
        corresponding to the list of files.

    globlist
        Passes a list of patterns to glob, and returns an list of
        the results. If any pattern matches zero files, it is
        returned verbatim (the same approach used by Unix shells).
        Note that this differs from `< >' and `glob', which return
        an empty list if the pattern does not match.

    load <file>
        Loads the file specified. If *file* is actually a reference
        to a scalar, it is taken as referring to the contents of the
        notional file, and this is returned. If *file* is a
        reference to a handle, this is used, otherwise *file* is
        taken to be a filename.

        In scalar context returns the file contents, or undefined
        for failure. In array context returns an array (*file
        contents*, `os_file (5, *file*)'), or an array (*file
        contents*) if `os_file 5' fails (*e.g.* the handle could not
        be converted to a filename).

    os_file <reason>, <filename>
        Performs the specified `OS_File'. Returns `R0' in scalar
        context, an array of `R0'-`R9' in array context. Oddly
        enough *filename* can actually be a filehandle, which is
        converted to a filename to call `OS_File'.

    filetype <load addr>...
        `filetype' returns the numberic filetype from the load
        address given, or `undef' if the load address is not for a
        stamped file. In scalar context it returns the filetype from
        the first argument, in array context `filetype' returns a
        list of filetypes corresponding to the argument list.

    copy <from>, <to> [, <flags>]
        `copy' calls the RISC OS `*copy' command copy to copy a file
        (`OS_FSControl 26' to be precise). *flags* default to 0 [*],
        and are as for `OS_FSControl 26' *except* that bit 13 is
        toggled. This means that by default an appropriately sized
        user buffer is provided internally, avoiding problems
        copying to/from archives. [Appropriately sized is currently
        implemented as `min( *filesize*, 128K )' ]. If *to* or
        *from* are filehandles then they are converted to filenames
        (if possible) before calling `OS_FSControl 26'.

        * If flags are not supplied then force is turned on unless
        the target is locked. This means that you can copy over a
        destination file automatically.


  glob_control

    `glob_control' allows the script to control various options that
    control how the `< >' operator and underlying `glob' function
    work. `glob_control' returns the current/old setting of the
    control flags. If passed a defined value it uses this as the new
    flag settings, otherwise the control flags are left unchanged.
    `glob_control' will `croak' if reserved bits in the flags are
    not zero - always use the `fileglob_*' subroutines provided to
    construct flag settings.

    fileglob_PrintExpandedPaths
        the default setting - causes globbing to
        (recursively)expand Path variables passed in. With this

        	glob ('System:Modules.a*')


        returns

        	ADFS::Bagpuss.$.!BOOT.Resources.!System.310.Modules.ABCLib
        	ADFS::Bagpuss.$.!BOOT.Resources.!System.310.Modules.ABIMod
        	ADFS::Bagpuss.$.!BOOT.Resources.!System.Modules.ABIMod


        System:Modules.ABCLib System:Modules.ABIMod
        System:Modules.ABIMod

    fileglob_PrintOriginalPath
        causes globbing output to retain Path variables passed in,
        although recursive expansion is used internally. Setting
        this turns off *fileglob_PrintExpandedPaths*, likewise
        setting *fileglob_PrintExpandedPaths* turns off
        *fileglob_PrintOriginalPath*. If both are set the result is
        undefined.

        With this

        	glob ('System:Modules.a*')


        returns

        	System:Modules.ABCLib
        	System:Modules.ABIMod
        	System:Modules.ABIMod


    fileglob_PrintPathMask
        bitmask of the acceptable values for the above printing
        options.

    fileglob_IncludeDotFiles
        When filename conversion is on,globbing a pattern not
        starting '`*'' includes files starting '`/'' - *i.e.* Unix
        "dot" files mapped to RISC OS.

        When filename conversion is off this flag has no effect.

    fileglob_SkipDotFiles
        When filename conversion is on,globbing a pattern not
        starting '`*'' does not include files starting '`/'' - use a
        pattern explicitly starting '`/'', *e.g.* '`/*'' to match
        these files. This is the default setting, as it is
        consistent with Unix.

        When filename conversion is off this flag has no effect.

    fileglob_DotFilesMask
        bitmask of the acceptable values for the above dot files
        options.

    fileglob_SplitOnWhitespace
        This is the default setting.With this flag `glob' will split
        patterns on whitespace, and glob on each section. So

        	<aa* *q*z>


        will glob as

        	<aa*>
        	<*q*z>


        This is consistent with Unix, and consistent with Fileswitch
        taking '` '' and other whitespace as the end of a filename.
        This is the default setting.

    fileglob_DontSplitOnWhitespace
        With this flag `glob' takes no special notice of whitespace.

    fileglob_WhitespaceMask
        bitmask of the acceptable values for the above whitespace
        options.

    fileglob_ImagesAreDirectories
        This is the default setting - with this flag `glob' will
        treat any images it finds in the path being globbed just
        like directories, and match against their contents. This is
        consistent with the behaviour of the desktop filer.

    fileglob_ImagesAreFiles
        With this flag `glob' will treat non-leaf images as files,
        not directories. This means that `glob' will not return the
        contents of any images.

        So if $.FestiveRd is an image containing 2 files 52 and
        Shop,

        	glob "\$.FestiveRd.*"


        or

        	glob "\$.Festi##Rd.*"


        will return

        	$.FestiveRd.52
        	$.FestiveRd.Shop


        with the normal behaviour, but

        	


        (*i.e.* nothing) with this flag enabled, as images are to be
        treated as normal files now, and hence listing the contents
        in any way is forbidden.

        This flag has no effect on image files found as leafnames in
        globbing patterns, as `glob' makes no distinction between
        files, images, directories, (or any future object type)
        found as a leafname.

        Note that any non-ADFS floppy disks are actually image files
        - with this flag set `glob "ADFS::0.\$.*"' will not give a
        listing of the root directory of an `MS-DOS' floppy, because
        a check will be made on `$', which is actually an image, not
        a directory. This is a documented consequence of the RISC OS
        implementation of foreign format discs.

        Note also that this flag only affects `glob', and no other
        part of perl. In particular `-d' will still return true and
        `-f' false for an image.

    fileglob_WhitespaceMask
        bitmask of the acceptable values for the above image
        options.


BUGS
    Not so much bugs in this module but points to note with the
    port's core globbing:

    `glob' relies on `OS_GBPB' to perform globbing, so in theory
    will work with case sensitive filesystems (which the PRM states
    are allowed). This means that

    *   Unix globs with ranges enclosed in `[]' do not work.

    *   glob results are not sorted - they are returned in the same
        order as the filesystem returns via `OS_GBPB'. This means
        that:

    *       For RISC OS filesystems that return filenames in sorted
            order, this order is case insensitive, whereas Unix glob
            returns filenames in case sensitive order.

    *       Not all RISC OS filesystems sort their directory output in
            any way.


    The upshot is if you really need the output from globbing to be
    sorted, `sort' it yourself.

AUTHOR
    Nicholas Clark <nick@unfortu.net>

