/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.api;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.protocol.ws.api.ConnectionRejected;
import org.apache.wicket.protocol.ws.api.IWebSocketConnectionFilter;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class WebSocketConnectionOriginFilter
implements IWebSocketConnectionFilter {
    public static final int POLICY_VIOLATION_ERROR_CODE = 1008;
    public static final String ORIGIN_MISMATCH = "Origin mismatch";
    private final List<String> allowedDomains;

    public WebSocketConnectionOriginFilter(List<String> allowedDomains) {
        this.allowedDomains = (List)Args.notNull(allowedDomains, (String)"allowedDomains");
    }

    @Override
    public ConnectionRejected doFilter(HttpServletRequest servletRequest) {
        String oUrl;
        if (this.allowedDomains != null && !this.allowedDomains.isEmpty() && this.invalid(oUrl = this.getOriginUrl(servletRequest), this.allowedDomains)) {
            return new ConnectionRejected(1008, ORIGIN_MISMATCH);
        }
        return null;
    }

    public void setAllowedDomains(Iterable<String> domains) {
        this.allowedDomains.clear();
        if (domains != null) {
            for (String domain : domains) {
                this.allowedDomains.add(domain);
            }
        }
    }

    public List<String> getAllowedDomains() {
        return this.allowedDomains;
    }

    private boolean invalid(String oUrl, List<String> allowedDomains) {
        return Strings.isEmpty((CharSequence)oUrl) || !allowedDomains.contains(oUrl);
    }

    private String getOriginUrl(HttpServletRequest servletRequest) {
        Enumeration originHeaderValues = servletRequest.getHeaders("Origin");
        List origins = originHeaderValues != null ? Collections.list(originHeaderValues) : Collections.emptyList();
        if (origins.size() != 1) {
            return null;
        }
        return (String)origins.get(0);
    }
}

