/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.processor.ThrowExceptionProcessor;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="error")
@XmlRootElement(name="throwException")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ThrowExceptionDefinition
extends NoOutputDefinition<ThrowExceptionDefinition> {
    @XmlAttribute
    private String ref;
    @XmlAttribute
    private String message;
    @XmlTransient
    private Exception exception;
    @XmlAttribute
    private String exceptionType;
    @XmlTransient
    private Class<? extends Exception> exceptionClass;

    public String toString() {
        return "ThrowException[" + this.description() + "]";
    }

    protected String description() {
        return this.exception != null ? this.exception.getClass().getCanonicalName() : "ref:" + this.ref;
    }

    @Override
    public String getLabel() {
        return "throwException[" + this.description() + "]";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) {
        if (this.ref != null && this.exception == null) {
            this.exception = routeContext.getCamelContext().getRegistry().lookupByNameAndType(this.ref, Exception.class);
        }
        if (this.exceptionType != null && this.exceptionClass == null) {
            try {
                this.exceptionClass = routeContext.getCamelContext().getClassResolver().resolveMandatoryClass(this.exceptionType, Exception.class);
            }
            catch (ClassNotFoundException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        if (this.exception == null && this.exceptionClass == null) {
            throw new IllegalArgumentException("exception or exceptionClass/exceptionType must be configured on: " + this);
        }
        return new ThrowExceptionProcessor(this.exception, this.exceptionClass, this.message);
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public void setExceptionType(String exceptionType) {
        this.exceptionType = exceptionType;
    }

    public Class<? extends Exception> getExceptionClass() {
        return this.exceptionClass;
    }

    public void setExceptionClass(Class<? extends Exception> exceptionClass) {
        this.exceptionClass = exceptionClass;
    }
}

