/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.apache.vinci.debug.Debug;
import org.apache.vinci.transport.BaseClient;
import org.apache.vinci.transport.Frame;
import org.apache.vinci.transport.ServiceDownException;
import org.apache.vinci.transport.ServiceException;
import org.apache.vinci.transport.Transportable;
import org.apache.vinci.transport.TransportableFactory;
import org.apache.vinci.transport.VNSException;
import org.apache.vinci.transport.VinciFrame;
import org.apache.vinci.transport.context.VinciContext;
import org.apache.vinci.transport.vns.client.ResolveResult;

public class VinciClient
extends BaseClient {
    private int level = -2;
    private int instance = -1;
    private String serviceName = null;
    private VinciContext context = null;

    public VinciClient(String service_name) throws ServiceDownException, VNSException {
        this(service_name, VinciFrame.getVinciFrameFactory());
    }

    public VinciClient(String service_name, TransportableFactory factory) throws ServiceDownException, VNSException {
        super(factory);
        this.open(service_name);
    }

    public VinciClient(String service_name, TransportableFactory factory, VinciContext myContext) throws ServiceDownException, VNSException {
        super(factory);
        this.setContext(myContext);
        this.open(service_name);
    }

    public VinciClient(String service_name, VinciContext myContext) throws ServiceDownException, VNSException {
        this(service_name, VinciFrame.getVinciFrameFactory(), myContext);
    }

    public VinciClient(String service_name, int connectTimeout) throws ServiceDownException, VNSException {
        this(service_name, VinciFrame.getVinciFrameFactory(), connectTimeout);
    }

    public VinciClient(String service_name, TransportableFactory factory, int connectTimeout) throws ServiceDownException, VNSException {
        super(factory, connectTimeout);
        this.open(service_name);
    }

    public VinciClient(String service_name, TransportableFactory factory, VinciContext myContext, int connectTimeout) throws ServiceDownException, VNSException {
        super(factory, connectTimeout);
        this.setContext(myContext);
        this.open(service_name);
    }

    public VinciClient(String service_name, VinciContext myContext, int connectTimeout) throws ServiceDownException, VNSException {
        this(service_name, VinciFrame.getVinciFrameFactory(), myContext, connectTimeout);
    }

    public VinciClient() {
    }

    public VinciClient(TransportableFactory f) {
        super(f);
    }

    public int getLevel() {
        return this.level;
    }

    public int getInstance() {
        return this.instance;
    }

    public static Transportable sendAndReceive(Transportable in, String service_name, TransportableFactory factory) throws IOException, ServiceException, ServiceDownException, VNSException {
        return VinciContext.getGlobalContext().sendAndReceive(in, service_name, factory);
    }

    public static Transportable sendAndReceive(Transportable in, String service_name, TransportableFactory factory, int socket_timeout) throws IOException, ServiceException {
        return VinciContext.getGlobalContext().sendAndReceive(in, service_name, factory, socket_timeout);
    }

    public static Transportable sendAndReceive(Transportable in, String service_name, TransportableFactory factory, int socket_timeout, int connect_timeout) throws IOException, ServiceException {
        return VinciContext.getGlobalContext().sendAndReceive(in, service_name, factory, socket_timeout, connect_timeout);
    }

    public VinciContext getContext() {
        if (this.context == null) {
            return VinciContext.getGlobalContext();
        }
        return this.context;
    }

    public void setContext(VinciContext c) {
        this.context = c;
    }

    public String getQualifiedServiceName() {
        return ResolveResult.unqualifiedName(this.serviceName) + "[" + this.getLevel() + "," + this.getHost() + "," + this.getInstance() + "]";
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void open(String service_name) throws ServiceDownException, VNSException {
        int colonIndex;
        this.serviceName = service_name;
        ResolveResult response = null;
        Frame query = null;
        boolean connectFailed = false;
        VinciContext myContext = this.getContext();
        boolean usedCache = false;
        ArrayList<CallSite> alreadyTried = null;
        String vnsHost = myContext.getVNSHost();
        int vnsPort = myContext.getVNSPort();
        int atIndex = service_name.indexOf(64);
        if (atIndex != -1 && (colonIndex = (vnsHost = service_name.substring(atIndex + 1)).indexOf(58)) != -1) {
            try {
                vnsPort = Integer.parseInt(vnsHost.substring(colonIndex + 1));
            }
            catch (NumberFormatException e) {
                throw new VNSException("Bad vns port specification in service name: " + service_name);
            }
            vnsHost = vnsHost.substring(0, colonIndex);
        }
        while (true) {
            try {
                response = myContext.getCachedResolveResult(this.serviceName);
                if (response == null) {
                    usedCache = false;
                    if (query == null) {
                        query = ResolveResult.composeQuery(this.serviceName);
                    }
                    response = (ResolveResult)BaseClient.sendAndReceive(query, vnsHost, vnsPort, ResolveResult.factory, myContext.getVNSResolveTimeout());
                    myContext.cacheResolveResult(this.serviceName, response);
                } else {
                    usedCache = true;
                    Debug.p("Using cached VNS entry.");
                }
            }
            catch (IOException e) {
                if (myContext.areStaleLookupsAllowed()) {
                    response = myContext.getStaleCachedResolveResult(this.serviceName);
                    if (response == null) {
                        throw new ServiceDownException("VNS inaccessible: " + e);
                    }
                    Debug.reportException(e);
                    Debug.p("VNS is not accessible, using STALE cached resolve result.");
                }
            }
            catch (ServiceException e) {
                if (connectFailed) {
                    throw new ServiceDownException("Could not connect to service: " + this.serviceName);
                }
                throw new VNSException(e.getMessage());
            }
            response.initializeIterator();
            while (response.hasMore()) {
                ResolveResult.ServiceLocator locator = response.getNext();
                if (alreadyTried != null && alreadyTried.contains(locator.host + ":" + locator.port)) continue;
                try {
                    this.open(locator.host, locator.port);
                    this.instance = locator.instance;
                    this.level = response.priority;
                    Debug.p("Resolved " + this.serviceName + " to: " + locator.host + ":" + locator.port);
                    return;
                }
                catch (IOException e) {
                    Debug.p("WARNING: Failed to connect to service at (" + locator.host + ":" + locator.port + "):" + e.getMessage());
                    connectFailed = true;
                    if (alreadyTried == null) {
                        alreadyTried = new ArrayList<CallSite>();
                    }
                    alreadyTried.add((CallSite)((Object)(locator.host + ":" + locator.port)));
                }
            }
            if (usedCache) {
                myContext.flushFromCache(this.serviceName);
                Debug.p("Retrying service resolution without using cache.");
                continue;
            }
            if (response.priority == 0 || ResolveResult.isQualified(this.serviceName)) break;
            Debug.p("VinciClient.open(String)", "Resolving with lower priority than: " + response.priority);
            myContext.flushFromCache(this.serviceName);
            int next_level = response.priority;
            next_level = next_level == -1 ? Integer.MAX_VALUE : --next_level;
            query = ResolveResult.composeQuery(this.serviceName, next_level);
        }
        throw new ServiceDownException("Could not connect to service: " + this.serviceName);
    }

    @Override
    protected void reopen(Exception e) throws IOException {
        Debug.p("Trying to reopen connection due to exception: " + e);
        this.close();
        this.open(this.serviceName);
    }

    @Override
    protected boolean isSocketKeepAliveEnabled() {
        return this.getContext().isSocketKeepAliveEnabled();
    }

    public static VinciFrame rpc(Transportable in, String service_name) throws IOException, ServiceException, ServiceDownException, VNSException {
        return VinciContext.getGlobalContext().rpc(in, service_name);
    }

    public static VinciFrame rpc(Transportable in, String service_name, int timeout) throws IOException, ServiceException, ServiceDownException, VNSException {
        return VinciContext.getGlobalContext().rpc(in, service_name, timeout);
    }

    public static VinciFrame rpc(Transportable in, String service_name, int timeout, int connect_timeout) throws IOException, ServiceException, ServiceDownException, VNSException {
        return VinciContext.getGlobalContext().rpc(in, service_name, timeout, connect_timeout);
    }

    public static void main(String[] args) throws Exception {
        Frame ping = new VinciFrame().fadd("vinci:PING", "hi");
        System.out.println(VinciClient.rpc(ping, args[0]));
    }
}

