/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.migratev3.jcas;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.EmptyStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.github.javaparser.printer.PrettyPrinter;
import com.github.javaparser.printer.PrettyPrinterConfiguration;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.CommandLineParser;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.internal.util.UIMAClassLoader;
import org.apache.uima.internal.util.function.Runnable_withException;
import org.apache.uima.migratev3.jcas.UimaDecompiler;
import org.apache.uima.pear.tools.PackageBrowser;
import org.apache.uima.pear.tools.PackageInstaller;
import org.apache.uima.util.FileUtils;

public class MigrateJCas
extends VoidVisitorAdapter<Object> {
    private static final int[] indent = new int[1];
    private static final Integer INTEGER0 = 0;
    private static int nextContainerId = 0;
    private static final JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
    private static final String SOURCE_FILE_ROOTS = "-sourcesRoots";
    private static final String CLASS_FILE_ROOTS = "-classesRoots";
    private static final String OUTPUT_DIRECTORY = "-outputDirectory";
    private static final String MIGRATE_CLASSPATH = "-migrateClasspath";
    private static final Type intType = PrimitiveType.intType();
    private static final Type callSiteType = JavaParser.parseType((String)"CallSite");
    private static final Type methodHandleType = JavaParser.parseType((String)"MethodHandle");
    private static final Type stringType = JavaParser.parseType((String)"String");
    private static final EnumSet<Modifier> public_static_final = EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL);
    private static final EnumSet<Modifier> private_static_final = EnumSet.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL);
    private static final PrettyPrinterConfiguration printWithoutComments = new PrettyPrinterConfiguration();
    private static final PrettyPrinterConfiguration printCu;
    private static final String ERROR_DECOMPILING = "!!! ERROR:";
    private static boolean isSource;
    private static Path tempDir;
    private String packageName;
    private String className;
    private String packageAndClassNameSlash;
    private CommonConverted current_cc;
    private Path current_path;
    private Container current_container;
    private String outputDirectory;
    private String outDirConverted;
    private String outDirSkipped;
    private String outDirLog;
    private Container[] sourcesRoots = null;
    private Container[] classesRoots = null;
    private CompilationUnit cu;
    private ClassLoader cachedMigrateClassLoader = null;
    private String migrateClasspath = null;
    private Map<String, Integer> nextCcId = new HashMap<String, Integer>();
    private Map<String, CommonConverted> sourceToCommonConverted = new HashMap<String, CommonConverted>();
    private Map<String, List<CommonConverted>> classname2multiSources = new TreeMap<String, List<CommonConverted>>();
    private final List<PathContainerAndReason> nonJCasFiles = new ArrayList<PathContainerAndReason>();
    private final List<PathContainerAndReason> failedMigration = new ArrayList<PathContainerAndReason>();
    private final List<PathContainerAndReason> skippedBuiltins = new ArrayList<PathContainerAndReason>();
    private final List<PathContainerAndReason> deletedCheckModified = new ArrayList<PathContainerAndReason>();
    private final List<String1AndString2> pathWorkaround = new ArrayList<String1AndString2>();
    private final List<String1AndString2> pearClassReplace = new ArrayList<String1AndString2>();
    private final List<String1AndString2> jarClassReplace = new ArrayList<String1AndString2>();
    private final List<PathContainerAndReason> manualInspection = new ArrayList<PathContainerAndReason>();
    private boolean isV2JCas;
    private boolean isConvert2v3;
    private boolean isBuiltinJCas;
    private MethodDeclaration get_set_method;
    private String featName;
    private boolean isGetter;
    private boolean isArraySetter;
    private Object rangeNamePart;
    private String rangeNameV2Part;
    private NodeList<BodyDeclaration<?>> fi_fields = new NodeList();
    private Set<String> featNames = new HashSet<String>();
    private boolean hasV2Constructors;
    private boolean hasV3Constructors;
    private boolean error_decompiling = false;
    private boolean badClassName;
    private int itemCount;
    private boolean unableToCompile;
    private final StringBuilder psb = new StringBuilder();
    private static final Pattern refGetter;
    private static final Pattern word1;
    private static final Pattern implementsEmpty;

    private static StringBuilder si(StringBuilder sb) {
        return Misc.indent((StringBuilder)sb, (int[])indent);
    }

    private static StringBuilder flush(StringBuilder sb) {
        System.out.print(sb);
        sb.setLength(0);
        return sb;
    }

    public static void main(String[] args) {
        new MigrateJCas().run(args);
    }

    void run(String[] args) {
        boolean isOk;
        CommandLineParser clp = this.parseCommandArgs(args);
        System.out.format("Output top directory: %s%n", this.outputDirectory);
        FileUtils.deleteRecursive((File)new File(this.outputDirectory));
        boolean bl = isSource = this.sourcesRoots != null;
        if (isSource) {
            isOk = this.processRootsCollection("source", this.sourcesRoots, clp);
        } else {
            if (javaCompiler == null) {
                System.out.println("The migration tool cannot compile the migrated files, \n  because no Java compiler is available.\n  To make one available, run this tool using a Java JDK, not JRE");
            }
            isOk = this.processRootsCollection("classes", this.classesRoots, clp);
        }
        if (this.error_decompiling) {
            isOk = false;
        }
        isOk = this.report() && isOk;
        System.out.println("Migration finished " + (isOk ? "with no unusual conditions." : "with 1 or more unusual conditions that need manual checking."));
    }

    private void postProcessPearOrJar(Container container) {
        Path outDir = Paths.get(this.outputDirectory, container.isJar ? "jars" : "pears", Integer.toString(container.id));
        MigrateJCas.withIOX(() -> Files.createDirectories(outDir, new FileAttribute[0]));
        MigrateJCas.si(this.psb).append("Replacing .class files in copy of ").append(container.rootOrig);
        MigrateJCas.flush(this.psb);
        try {
            Path lastPartOfPath = container.rootOrig.getFileName();
            if (null == lastPartOfPath) {
                throw new RuntimeException("Internal Error");
            }
            Path pearOrJarCopy = Paths.get(this.outputDirectory, container.isJar ? "jars" : "pears", Integer.toString(container.id), lastPartOfPath.toString());
            Files.copy(container.rootOrig, pearOrJarCopy, new CopyOption[0]);
            FileSystem pfs = FileSystems.newFileSystem(pearOrJarCopy, (ClassLoader)null);
            indent[0] = indent[0] + 2;
            String[] previousSkip = new String[]{""};
            container.v3CompiledPathAndContainerItemPath.forEach(c_p -> {
                if (Files.exists(c_p.v3CompiledPath, new LinkOption[0])) {
                    MigrateJCas.withIOX(() -> Files.copy(c_p.v3CompiledPath, pfs.getPath(c_p.pathInContainer, new String[0]), StandardCopyOption.REPLACE_EXISTING));
                    this.reportPearOrJarClassReplace(pearOrJarCopy.toString(), c_p.v3CompiledPath.toString(), container);
                } else {
                    String pstr;
                    String pstr2 = pstr = c_p.v3CompiledPath.toString();
                    if (previousSkip[0] != "") {
                        int cmn = this.findFirstCharDifferent(previousSkip[0], pstr);
                        pstr2 = cmn > 5 ? "..." + pstr.substring(cmn) : pstr;
                    }
                    previousSkip[0] = pstr;
                    MigrateJCas.si(this.psb).append("Skipping replacing ").append(pstr2).append(" because it could not be found, perhaps due to compile errors.");
                    MigrateJCas.flush(this.psb);
                }
            });
            indent[0] = indent[0] - 2;
            pfs.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean compileV3SourcesCommon2(Container container) {
        List cups;
        String classesBaseDir = this.outDirConverted + "v3-classes/" + container.id;
        String classpath = this.getCompileClassPath(container);
        Path containerRoot = null;
        TreeMap<Integer, ArrayList> cu_path_strings_by_ccId = new TreeMap<Integer, ArrayList>();
        indent[0] = indent[0] + 2;
        boolean isEmpty = true;
        for (CommonConverted cc : container.convertedItems) {
            if (cc.v3SourcePath == null) continue;
            isEmpty = false;
            Path itemPath = cc.getV2SourcePath(container);
            if (null == containerRoot) {
                containerRoot = container.isJar || container.isPear ? itemPath.getFileSystem().getPath("/", new String[0]) : container.rootOrig;
            }
            String relativePathInContainer = containerRoot.relativize(itemPath).toString();
            container.v3CompiledPathAndContainerItemPath.add(new V3CompiledPathAndContainerItemPath(Paths.get(classesBaseDir, "a" + cc.id, cc.fqcn_slash + ".class"), relativePathInContainer));
            ArrayList items = cu_path_strings_by_ccId.computeIfAbsent(cc.id, x -> new ArrayList());
            items.add(cc.v3SourcePath.toString());
        }
        if (isEmpty) {
            MigrateJCas.si(this.psb).append("Skipping compiling for container ").append(container.id).append(" ").append(container.rootOrig);
            MigrateJCas.si(this.psb).append("  because non of the v2 classes were migrated (might have been built-ins)");
            MigrateJCas.flush(this.psb);
            return false;
        }
        MigrateJCas.si(this.psb).append("Compiling for container ").append(container.id).append(" ").append(container.rootOrig);
        MigrateJCas.flush(this.psb);
        boolean resultOk = true;
        int ccId = 0;
        while ((cups = (List)cu_path_strings_by_ccId.get(ccId)) != null) {
            StandardJavaFileManager fileManager = javaCompiler.getStandardFileManager(null, null, Charset.forName("UTF-8"));
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromStrings(cups);
            String classesBaseDirN = classesBaseDir + "/a" + ccId;
            MigrateJCas.withIOX(() -> Files.createDirectories(Paths.get(classesBaseDirN, new String[0]), new FileAttribute[0]));
            List<String> options = Arrays.asList("-d", classesBaseDirN, "-classpath", classpath);
            MigrateJCas.si(this.psb).append("Compiling for commonConverted version ").append(ccId).append(", ").append(cups.size()).append(" classes");
            MigrateJCas.flush(this.psb);
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            resultOk = javaCompiler.getTask(null, fileManager, diagnostics, options, null, compilationUnits).call() != false && resultOk;
            indent[0] = indent[0] + 2;
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                int pos;
                JavaFileObject s = (JavaFileObject)diagnostic.getSource();
                MigrateJCas.si(this.psb).append((Object)diagnostic.getKind());
                int lineno = (int)diagnostic.getLineNumber();
                if ((long)lineno != -1L) {
                    this.psb.append(" on line ").append(diagnostic.getLineNumber());
                }
                if ((long)(pos = (int)diagnostic.getPosition()) != -1L) {
                    this.psb.append(", position: ").append(diagnostic.getColumnNumber());
                }
                if (s != null) {
                    this.psb.append(" in ").append(s.toUri());
                }
                MigrateJCas.si(this.psb).append("  ").append(diagnostic.getMessage(null));
                MigrateJCas.flush(this.psb);
            }
            MigrateJCas.withIOX(() -> fileManager.close());
            indent[0] = indent[0] - 2;
            MigrateJCas.si(this.psb).append("Compilation finished").append(resultOk ? " with no errors." : "with some errors.");
            MigrateJCas.flush(this.psb);
            ++ccId;
        }
        indent[0] = indent[0] - 2;
        this.unableToCompile = !resultOk;
        return true;
    }

    private String getCompileClassPath(Container container) {
        URLClassLoader systemClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        URL[] urls = systemClassLoader.getURLs();
        StringBuilder cp = new StringBuilder();
        boolean firstTime = true;
        for (URL url : urls) {
            if (!firstTime) {
                cp.append(File.pathSeparatorChar);
            } else {
                firstTime = false;
            }
            cp.append(url.getPath());
        }
        Container c = container;
        while (c != null) {
            if (c.isPear) {
                cp.append(File.pathSeparator).append(c.pearClasspath);
            }
            c = c.parent;
        }
        if (null != this.migrateClasspath) {
            cp.append(File.pathSeparator).append(Misc.expandClasspath((String)this.migrateClasspath));
        }
        c = container;
        ArrayList<String> ss = new ArrayList<String>();
        while (c != null) {
            if (c.isJar) {
                ss.add(c.root.toString());
            }
            c = c.parent;
        }
        Collections.reverse(ss);
        ss.forEach(s -> cp.append(File.pathSeparator).append((String)s));
        return cp.toString();
    }

    private boolean processRootsCollection(String kind, Container[] roots, CommandLineParser clp) {
        this.unableToCompile = false;
        this.psb.setLength(0);
        MigrateJCas.indent[0] = 0;
        this.itemCount = 1;
        for (Container rootContainer : roots) {
            this.showWorkStart(rootContainer);
            this.getAndProcessCandidatesInContainer(rootContainer);
        }
        MigrateJCas.si(this.psb).append("Total number of candidates processed: ").append(this.itemCount - 1);
        MigrateJCas.flush(this.psb);
        MigrateJCas.indent[0] = 0;
        return !this.unableToCompile;
    }

    private void showWorkStart(Container rootContainer) {
        MigrateJCas.si(this.psb).append("Migrating " + rootContainer.rootOrig.toString());
        indent[0] = indent[0] + 2;
        MigrateJCas.si(this.psb).append("Each character is one class");
        MigrateJCas.si(this.psb).append("  . means normal class");
        MigrateJCas.si(this.psb).append("  b means built in");
        MigrateJCas.si(this.psb).append("  i means identical duplicate");
        MigrateJCas.si(this.psb).append("  d means non-identical definition for the same JCas class");
        MigrateJCas.si(this.psb).append("  nnn at the end of the line is the number of classes migrated\n");
        MigrateJCas.flush(this.psb);
    }

    private CommandLineParser parseCommandArgs(String[] args) {
        CommandLineParser clp = MigrateJCas.createCmdLineParser();
        try {
            clp.parseCmdLine(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!this.checkCmdLineSyntax(clp)) {
            this.printUsage();
            System.exit(2);
        }
        if (clp.isInArgsList(CLASS_FILE_ROOTS)) {
            this.classesRoots = this.getRoots(clp, CLASS_FILE_ROOTS);
        }
        if (clp.isInArgsList(SOURCE_FILE_ROOTS)) {
            this.sourcesRoots = this.getRoots(clp, SOURCE_FILE_ROOTS);
        }
        return clp;
    }

    private Container[] getRoots(CommandLineParser clp, String kind) {
        String[] paths = clp.getParamArgument(kind).split("\\" + File.pathSeparator);
        Container[] cs = new Container[paths.length];
        int i = 0;
        for (String path : paths) {
            cs[i++] = new Container(null, Paths.get(path, new String[0]));
        }
        return cs;
    }

    private CommonConverted getSource(Path p, Container container) {
        try {
            CommonConverted cc;
            byte[] localV2ByteCode = null;
            if (!isSource) {
                String v2Source;
                localV2ByteCode = Files.readAllBytes(p);
                cc = container.origBytesToCommonConverted.get(localV2ByteCode);
                if (null != cc) {
                    return cc;
                }
                try {
                    v2Source = this.decompile(localV2ByteCode, container.pearClasspath);
                }
                catch (RuntimeException e) {
                    this.badClassName = true;
                    e.printStackTrace();
                    v2Source = null;
                }
                if (this.badClassName) {
                    System.err.println("Candidate with bad Class Name is: " + p.toString());
                    return null;
                }
                byte[] finalbc = localV2ByteCode;
                cc = this.sourceToCommonConverted.computeIfAbsent(v2Source, src -> new CommonConverted((String)src, finalbc, p, container, this.packageAndClassNameSlash));
                container.origBytesToCommonConverted.put(localV2ByteCode, cc);
            } else {
                String v2Source = FileUtils.reader2String((Reader)Files.newBufferedReader(p));
                cc = this.sourceToCommonConverted.get(v2Source);
                if (null == cc) {
                    cc = new CommonConverted(v2Source, null, p, container, "unknown");
                    this.sourceToCommonConverted.put(v2Source, cc);
                } else {
                    cc.containersAndV2Paths.add(new ContainerAndPath(p, container));
                }
            }
            if (!container.convertedItems.contains(cc)) {
                container.convertedItems.add(cc);
            }
            return cc;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrate(CommonConverted cc, Container container, Path path) {
        if (null == cc) {
            System.err.println("Skipping this component due to decompile failure: " + path.toString());
            System.err.println("  in container: " + container);
            this.isConvert2v3 = false;
            this.error_decompiling = true;
            return;
        }
        if (cc.v3Source != null) {
            boolean identical = this.collectInfoForReports(cc);
            assert (identical);
            this.psb.append("i");
            MigrateJCas.flush(this.psb);
            cc.containersAndV2Paths.add(new ContainerAndPath(path, container));
            return;
        }
        assert (cc.v2Source != null);
        this.packageName = null;
        this.className = null;
        this.packageAndClassNameSlash = null;
        this.cu = null;
        String source = cc.v2Source;
        this.isConvert2v3 = true;
        this.isV2JCas = false;
        this.isBuiltinJCas = false;
        this.featNames.clear();
        this.fi_fields.clear();
        try {
            this.current_cc = cc;
            this.current_container = container;
            this.current_path = path;
            if (source.startsWith(ERROR_DECOMPILING)) {
                System.err.println("Decompiling failed for class: " + cc.toString() + "\n got: " + Misc.elide((String)source, (int)300, (boolean)false));
                System.err.println("Please check the migrateClasspath");
                if (null == this.migrateClasspath) {
                    System.err.println("classpath of this app is");
                    System.err.println(System.getProperty("java.class.path"));
                } else {
                    URL[] urls;
                    System.err.println(" first part of migrateClasspath argument was: " + Misc.elide((String)this.migrateClasspath, (int)300, (boolean)false));
                    System.err.println("  Value used was:");
                    for (URL url : urls = Misc.classpath2urls((String)this.migrateClasspath)) {
                        System.err.println("    " + url.toString());
                    }
                }
                System.err.println("Skipping this component");
                this.isConvert2v3 = false;
                this.error_decompiling = true;
                return;
            }
            StringReader sr = new StringReader(source);
            try {
                this.cu = JavaParser.parse((Reader)sr);
                this.addImport("java.lang.invoke.CallSite");
                this.addImport("java.lang.invoke.MethodHandle");
                this.addImport("org.apache.uima.cas.impl.CASImpl");
                this.addImport("org.apache.uima.cas.impl.TypeImpl");
                this.addImport("org.apache.uima.cas.impl.TypeSystemImpl");
                this.visit(this.cu, null);
                new removeEmptyStmts().visit(this.cu, null);
                if (this.isConvert2v3) {
                    this.removeImport("org.apache.uima.jcas.cas.TOP_Type");
                }
                if (this.isConvert2v3 && this.fi_fields.size() > 0) {
                    NodeList classMembers = ((TypeDeclaration)this.cu.getTypes().get(0)).getMembers();
                    int positionOfFirstConstructor = this.findConstructor(classMembers);
                    if (positionOfFirstConstructor < 0) {
                        throw new RuntimeException();
                    }
                    classMembers.addAll(positionOfFirstConstructor, this.fi_fields);
                }
                ImportDeclaration firstImport = (ImportDeclaration)this.cu.getImports().get(0);
                String transformedMessage = String.format(" Migrated by uimaj-v3-migration-jcas, %s%n Container: %s%n Path in container: %s%n", new Date(), container.toString1(), path.toString()).replace('\\', '/');
                Optional existingComment = firstImport.getComment();
                if (existingComment.isPresent()) {
                    Comment comment = (Comment)existingComment.get();
                    comment.setContent(comment.getContent() + "\n" + transformedMessage);
                } else {
                    firstImport.setBlockComment(transformedMessage);
                }
                if (isSource) {
                    this.sourceToCommonConverted.put(source, cc);
                }
                boolean identicalFound = this.collectInfoForReports(cc);
                assert (!identicalFound);
                if (this.isV2JCas) {
                    this.writeV2Orig(cc, this.isConvert2v3);
                }
                if (this.isConvert2v3) {
                    cc.v3Source = new PrettyPrinter(printCu).print((Node)this.cu);
                    this.writeV3(cc);
                }
                this.psb.append(this.isBuiltinJCas ? "b" : (this.classname2multiSources.get(cc.fqcn_slash).size() == 1 ? "." : "d"));
                MigrateJCas.flush(this.psb);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new UIMARuntimeException((Throwable)e);
            }
            catch (Exception e) {
                System.out.println("debug: exception caught, source was\n" + source);
                throw new UIMARuntimeException((Throwable)e);
            }
        }
        finally {
            this.current_cc = null;
            this.current_container = null;
            this.current_path = null;
        }
    }

    private boolean collectInfoForReports(CommonConverted cc) {
        String fqcn_slash = cc.fqcn_slash;
        List commonConverteds = this.classname2multiSources.computeIfAbsent(fqcn_slash, k -> new ArrayList());
        boolean found = commonConverteds.contains(cc);
        if (!found) {
            commonConverteds.add(cc);
        }
        return found;
    }

    public void visit(AnnotationDeclaration n, Object ignore) {
        this.updateClassName((TypeDeclaration<?>)n);
        super.visit(n, ignore);
    }

    public void visit(EnumDeclaration n, Object ignore) {
        this.updateClassName((TypeDeclaration<?>)n);
        super.visit(n, ignore);
    }

    public void visit(ClassOrInterfaceDeclaration n, Object ignore) {
        Node parent;
        Optional maybeParent = n.getParentNode();
        if (maybeParent.isPresent() && (parent = (Node)maybeParent.get()) instanceof CompilationUnit) {
            this.updateClassName((TypeDeclaration<?>)n);
            if (this.isBuiltinJCas) {
                super.visit(n, ignore);
                return;
            }
            NodeList supers = n.getExtendedTypes();
            if (supers == null || supers.size() == 0) {
                this.reportNotJCasClass("class doesn't extend a superclass");
                super.visit(n, ignore);
                return;
            }
            NodeList members = n.getMembers();
            this.setHasJCasConstructors(members);
            if (this.hasV2Constructors && this.hasTypeFields(members)) {
                this.reportV2Class();
                super.visit(n, ignore);
                return;
            }
            if (this.hasV2Constructors) {
                this.reportNotJCasClassMissingTypeFields();
                return;
            }
            if (this.hasV3Constructors) {
                this.reportV3Class();
                return;
            }
            this.reportNotJCasClass("missing v2 constructors");
            return;
        }
        super.visit(n, ignore);
    }

    public void visit(PackageDeclaration n, Object ignored) {
        this.packageName = n.getNameAsString();
        super.visit(n, ignored);
    }

    public void visit(ConstructorDeclaration n, Object ignored) {
        super.visit(n, ignored);
        if (!this.isConvert2v3) {
            return;
        }
        NodeList ps = n.getParameters();
        if (ps.size() == 2 && this.getParmTypeName((List<Parameter>)ps, 0).equals("int") && this.getParmTypeName((List<Parameter>)ps, 1).equals("TOP_Type")) {
            this.setParameter((List<Parameter>)ps, 0, "TypeImpl", "type");
            this.setParameter((List<Parameter>)ps, 1, "CASImpl", "casImpl");
            NodeList stmts = n.getBody().getStatements();
            if (!(stmts.get(0) instanceof ExplicitConstructorInvocationStmt)) {
                this.recordBadConstructor("missing super call");
                return;
            }
            NodeList args = ((ExplicitConstructorInvocationStmt)stmts.get(0)).getArguments();
            args.set(0, (Node)new NameExpr("type"));
            args.set(1, (Node)new NameExpr("casImpl"));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void visit(MethodDeclaration n, Object ignore) {
        block12: {
            block14: {
                block13: {
                    name = n.getNameAsString();
                    this.isArraySetter = false;
                    this.isGetter = false;
                    if (name.length() < 4 || !(this.isGetter = name.startsWith("get")) && !name.startsWith("set") || !Character.isUpperCase(name.charAt(3)) || name.equals("getTypeIndexID")) break block12;
                    ps = n.getParameters();
                    if (!this.isGetter) break block13;
                    if (ps.size() <= 1) break block14;
                    break block12;
                }
                if (ps.size() > 2 || ps.size() == 0) break block12;
                if (ps.size() != 2) break block14;
                if (!this.getParmTypeName((List<Parameter>)ps, 0).equals("int")) break block12;
                this.isArraySetter = true;
            }
            if ((i = (bodyString = ((BlockStmt)n.getBody().get()).toString(MigrateJCas.printWithoutComments)).indexOf("jcasType.ll_cas.ll_")) < 0) break block12;
            s = bodyString.substring(i + "jcasType.ll_cas.ll_get".length());
            if (!s.startsWith("FSForRef(")) ** GOTO lbl23
            i = s.indexOf("jcasType.ll_cas.ll_");
            if (i < 0) {
                this.reportUnrecognizedV2Code("Found \"jcasType.ll_cas.ll_[set or get]...FSForRef(\" but didn't find following \"jcasType.ll_cas_ll_\"\n" + n.toString());
            } else {
                s = s.substring(i + "jcasType.ll_cas.ll_get".length());
lbl23:
                // 2 sources

                if ((i = s.indexOf("Value")) < 0) {
                    this.reportUnrecognizedV2Code("Found \"jcasType.ll_cas.ll_[set or get]\" but didn't find following \"Value\"\n" + n.toString());
                } else {
                    this.rangeNameV2Part = s = Character.toUpperCase(s.charAt(0)) + s.substring(1, i);
                    this.rangeNamePart = s.equals("Ref") != false ? "Feature" : s;
                    i = bodyString.indexOf("jcasType).casFeatCode_");
                    if (i == -1) {
                        this.reportUnrecognizedV2Code("Didn't find \"...jcasType).casFeatCode_\"\n" + n.toString());
                    } else {
                        m = MigrateJCas.word1.matcher(bodyString.substring(i + "jcasType).casFeatCode_".length()));
                        if (!m.find()) {
                            this.reportUnrecognizedV2Code("Found \"...jcasType).casFeatCode_\" but didn't find subsequent word\n" + n.toString());
                        } else {
                            this.featName = m.group(1);
                            fromMethod = Character.toLowerCase(name.charAt(3)) + name.substring(4);
                            if (!this.featName.equals(fromMethod) && !(Character.toLowerCase(this.featName.charAt(0)) + this.featName.substring(1)).equals(fromMethod)) {
                                this.reportMismatchedFeatureName(String.format("%-25s %s", new Object[]{this.featName, name}));
                            }
                            if (this.featNames.add(this.featName)) {
                                initCallSite = new MethodCallExpr((Expression)new NameExpr("TypeSystemImpl"), "createCallSite");
                                initCallSite.addArgument((Expression)new FieldAccessExpr((Expression)new NameExpr(this.className), "class"));
                                initCallSite.addArgument((Expression)new StringLiteralExpr(this.featName));
                                vd_FC = new VariableDeclarator(MigrateJCas.callSiteType, "_FC_" + this.featName, (Expression)initCallSite);
                                this.fi_fields.add((Node)new FieldDeclaration(MigrateJCas.private_static_final, vd_FC));
                                initInvoker = new MethodCallExpr((Expression)new NameExpr(vd_FC.getName()), "dynamicInvoker");
                                vd_FH = new VariableDeclarator(MigrateJCas.methodHandleType, "_FH_" + this.featName, (Expression)initInvoker);
                                this.fi_fields.add((Node)new FieldDeclaration(MigrateJCas.private_static_final, vd_FH));
                                vd_fn = new VariableDeclarator(MigrateJCas.stringType, "_FeatName_" + this.featName, (Expression)new StringLiteralExpr(this.featName));
                                this.fi_fields.add((Node)new FieldDeclaration(MigrateJCas.public_static_final, vd_fn));
                            }
                            if (this.isGetter && "Feature".equals(this.rangeNamePart)) {
                                for (Statement stmt : ((BlockStmt)n.getBody().get()).getStatements()) {
                                    if (!(stmt instanceof ReturnStmt) || !((e = this.getUnenclosedExpr((Expression)((ReturnStmt)stmt).getExpression().get())) instanceof MethodCallExpr) || !MigrateJCas.refGetter.matcher(methodName = ((MethodCallExpr)e).getNameAsString()).matches()) continue;
                                    this.addCastExpr(stmt, n.getType());
                                }
                            }
                            this.get_set_method = n;
                        }
                    }
                }
            }
        }
        super.visit(n, ignore);
        this.get_set_method = null;
    }

    public void visit(IfStmt n, Object ignore) {
        BinaryExpr be;
        Expression c = n.getCondition();
        if (c instanceof BinaryExpr && (be = (BinaryExpr)c).getLeft() instanceof FieldAccessExpr && ((FieldAccessExpr)be.getLeft()).getNameAsString().equals("featOkTst")) {
            Expression e;
            BinaryExpr be2;
            if (!(be.getRight() instanceof BinaryExpr && (be2 = (BinaryExpr)be.getRight()).getRight() instanceof NullLiteralExpr && be2.getLeft() instanceof FieldAccessExpr && (e = this.getExpressionFromStmt(n.getThenStmt())) instanceof MethodCallExpr && ((MethodCallExpr)e).getNameAsString().equals("throwFeatMissing"))) {
                this.reportDeletedCheckModified("The featOkTst was modified:\n" + n.toString() + "\n");
            }
            BlockStmt parent = (BlockStmt)n.getParentNode().get();
            NodeList stmts = parent.getStatements();
            stmts.set(stmts.indexOf(n), new EmptyStmt());
            return;
        }
        super.visit(n, ignore);
    }

    public void visit(MethodCallExpr n, Object ignore) {
        Node updatedNode;
        block10: {
            block11: {
                Optional p2;
                Optional p1;
                Optional p3 = null;
                updatedNode = null;
                if (this.get_set_method == null) break block10;
                if (n.getNameAsString().equals("checkArrayBounds") && (p1 = n.getParentNode()).isPresent() && p1.get() instanceof ExpressionStmt && (p2 = ((Node)p1.get()).getParentNode()).isPresent() && p2.get() instanceof BlockStmt && (p3 = ((Node)p2.get()).getParentNode()).isPresent() && p3.get() == this.get_set_method) {
                    NodeList stmts = ((BlockStmt)p2.get()).getStatements();
                    stmts.set(stmts.indexOf(p1.get()), (Node)new EmptyStmt());
                    return;
                }
                boolean useGetter = this.isGetter || this.isArraySetter;
                if (!n.getNameAsString().startsWith("ll_" + (useGetter ? "get" : "set") + this.rangeNameV2Part + "Value")) break block11;
                NodeList args = n.getArguments();
                if (args.size() != (useGetter ? 2 : 3)) break block10;
                String suffix = useGetter ? "Nc" : (this.rangeNamePart.equals("Feature") ? "NcWj" : "Nfc");
                String methodName = "_" + (useGetter ? "get" : "set") + this.rangeNamePart + "Value" + suffix;
                args.remove(0);
                n.setScope(null);
                n.setName(methodName);
            }
            String z = "ll_" + (this.isGetter ? "get" : "set");
            String nname = n.getNameAsString();
            if (nname.startsWith(z) && nname.endsWith("ArrayValue")) {
                String s = nname.substring(z.length());
                if ((s = s.substring(0, s.length() - "Value".length())).equals("RefArray")) {
                    s = "FSArray";
                }
                if (s.equals("IntArray")) {
                    s = "IntegerArray";
                }
                EnclosedExpr ee = new EnclosedExpr((Expression)new CastExpr((Type)new ClassOrInterfaceType(s), (Expression)n.getArguments().get(0)));
                n.setScope((Expression)ee);
                n.setName(this.isGetter ? "get" : "set");
                n.getArguments().remove(0);
            }
            if (n.getNameAsString().equals("ll_getFSForRef") || n.getNameAsString().equals("ll_getFSRef")) {
                updatedNode = this.replaceInParent((Node)n, (Expression)n.getArguments().get(0));
            }
        }
        if (updatedNode != null) {
            updatedNode.accept((VoidVisitor)this, null);
        } else {
            super.visit(n, null);
        }
    }

    public void visit(FieldAccessExpr n, Object ignore) {
        String nname = n.getNameAsString();
        if (this.get_set_method != null) {
            Expression e;
            Optional oe;
            if (nname.startsWith("casFeatCode_") && (oe = n.getScope()).isPresent() && (e = this.getUnenclosedExpr((Expression)oe.get())) instanceof CastExpr && "jcasType".equals(this.getName(((CastExpr)e).getExpression()))) {
                String featureName = nname.substring("casFeatCode_".length());
                MethodCallExpr getint = new MethodCallExpr(null, "wrapGetIntCatchException");
                getint.addArgument((Expression)new NameExpr("_FH_" + featureName));
                this.replaceInParent((Node)n, (Expression)getint);
                return;
            }
            if (nname.startsWith("casFeatCode_")) {
                this.reportMigrateFailed("Found field casFeatCode_ ... without a previous cast expr using jcasType");
            }
        }
        super.visit(n, ignore);
    }

    private boolean report() {
        System.out.println("\n\nMigration Summary");
        System.out.format("Output top directory: %s%n", this.outputDirectory);
        System.out.format("Date/time: %tc%n", new Date());
        this.pprintRoots("Sources", this.sourcesRoots);
        this.pprintRoots("Classes", this.classesRoots);
        boolean isOk2 = true;
        try {
            isOk2 = this.reportPaths("Workaround Directories", "workaroundDir.txt", this.pathWorkaround) && isOk2;
            isOk2 = this.reportPaths("Reports of converted files where a deleted check was customized", "deletedCheckModified.txt", this.deletedCheckModified) && isOk2;
            isOk2 = this.reportPaths("Reports of converted files needing manual inspection", "manualInspection.txt", this.manualInspection) && isOk2;
            isOk2 = this.reportPaths("Reports of files which failed migration", "failed.txt", this.failedMigration) && isOk2;
            isOk2 = this.reportPaths("Reports of non-JCas files", "NonJCasFiles.txt", this.nonJCasFiles) && isOk2;
            isOk2 = this.reportPaths("Builtin JCas classes - skipped - need manual checking to see if they are modified", "skippedBuiltins.txt", this.skippedBuiltins) && isOk2;
            this.reportPaths("Reports of updated Jars", "jarFileUpdates.txt", this.jarClassReplace);
            this.reportPaths("Reports of updated PEARs", "pearFileUpdates.txt", this.pearClassReplace);
            return isOk2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pprintRoots(String kind, Container[] roots) {
        if (roots != null && roots.length > 0) {
            try (BufferedWriter bw = Files.newBufferedWriter(this.makePath(this.outDirLog + "ItemsProcessed"), StandardOpenOption.CREATE);){
                this.logPrintNl(kind + " Roots:", bw);
                indent[0] = indent[0] + 2;
                try {
                    for (Container container : roots) {
                        this.pprintContainer(container, bw);
                    }
                    this.logPrintNl("", bw);
                }
                finally {
                    indent[0] = indent[0] - 2;
                }
            }
            catch (IOException e) {
                throw new UIMARuntimeException((Throwable)e);
            }
        }
    }

    private void pprintContainer(Container container, BufferedWriter bw) throws IOException {
        this.logPrintNl(container.toString(), bw);
        if (container.subContainers.size() > 1) {
            this.logPrintNl("", bw);
            indent[0] = indent[0] + 2;
            for (Container subc : container.subContainers) {
                this.pprintContainer(subc, bw);
            }
        }
    }

    private Path makePath(String name) throws IOException {
        Path p = Paths.get(name, new String[0]);
        Path parent = p.getParent();
        if (parent == null) {
            return p;
        }
        try {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            this.current_container.haveDifferentCapitalizedNamesCollidingOnWindows = true;
            Path fn = parent.getFileName();
            if (fn == null) {
                throw new IllegalArgumentException();
            }
            String newDir = fn.toString() + "_c";
            Path parent2 = parent.getParent();
            Path p2 = parent2 == null ? Paths.get(newDir, new String[0]) : Paths.get(parent2.toString(), newDir);
            try {
                Files.createDirectories(p2, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e2) {
                throw new RuntimeException(e2);
            }
            this.reportPathWorkaround(parent.toString(), p2.toString());
            Path lastPartOfPath = p.getFileName();
            if (null == lastPartOfPath) {
                throw new RuntimeException();
            }
            return Paths.get(p2.toString(), lastPartOfPath.toString());
        }
        return p;
    }

    private void logPrint(String msg, Writer bw) throws IOException {
        System.out.print(msg);
        bw.write(msg);
    }

    private void logPrintNl(String msg, Writer bw) throws IOException {
        this.logPrint(msg, bw);
        this.logPrint("\n", bw);
    }

    private <T, U> boolean reportPaths(String title, String fileName, List<? extends Report2<T, U>> items) throws IOException {
        if (items.size() == 0) {
            System.out.println("There were no " + title);
            return true;
        }
        System.out.println("\n" + title);
        for (int i = 0; i < title.length(); ++i) {
            System.out.print('=');
        }
        System.out.println("");
        try (BufferedWriter bw = Files.newBufferedWriter(this.makePath(this.outDirLog + fileName), StandardOpenOption.CREATE);){
            ArrayList<Report2<T, U>> sorted = new ArrayList<Report2<T, U>>(items);
            this.sortReport2(sorted);
            int max = 0;
            int nbrFirsts = 0;
            Comparable prevFirst = null;
            for (Report2 report2 : sorted) {
                max = Math.max(max, report2.getFirstLength());
                Comparable first = report2.getFirst();
                if (first == prevFirst) continue;
                prevFirst = first;
                ++nbrFirsts;
            }
            int i = 1;
            boolean bl = nbrFirsts <= sorted.size() / 4;
            prevFirst = null;
            for (Report2 report2 : sorted) {
                if (bl) {
                    if (prevFirst != report2.getFirst()) {
                        prevFirst = report2.getFirst();
                        this.logPrintNl(String.format("\n  For: %s", report2.getFirst()), bw);
                    }
                    this.logPrintNl(String.format("    %5d   %s", i, report2.getSecond()), bw);
                } else {
                    this.logPrintNl(String.format("%5d %-" + max + "s %s", i, report2.getFirst(), report2.getSecond()), bw);
                }
                ++i;
            }
            System.out.println("");
        }
        return false;
    }

    private boolean isZipFs(Object o) {
        return o.getClass().getName().contains("zipfs");
    }

    private <T, U> void sortReport2(List<? extends Report2<T, U>> items) {
        items.sort((o1, o2) -> {
            int r = this.protectedCompare(o1.getFirst(), o2.getFirst());
            if (r == 0) {
                r = this.protectedCompare(o1.getSecond(), o2.getSecond());
            }
            return r;
        });
    }

    private <T> int protectedCompare(Comparable<T> comparable, Comparable<T> comparable2) {
        try {
            if (this.isZipFs(comparable)) {
                if (this.isZipFs(comparable2)) {
                    return comparable.compareTo(comparable2);
                }
                return 1;
            }
            if (this.isZipFs(comparable2)) {
                return -1;
            }
            return comparable.compareTo(comparable2);
        }
        catch (ClassCastException e) {
            System.out.format("Internal error: c1: %b  c2: %b%n c1: %s%n c2: %s%n", this.isZipFs(comparable), this.isZipFs(comparable2), comparable.getClass().getName(), comparable2.getClass().getName());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAndProcessCandidatesInContainer(Container container) {
        if (container.isSingleJavaSource) {
            this.getCandidates_processFile2(container.root, container);
        } else {
            try (Stream<Path> stream = Files.walk(container.root, FileVisitOption.FOLLOW_LINKS);){
                stream.forEachOrdered(p -> this.getCandidates_processFile2((Path)p, container));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.removeNonJCas(container);
        if (container.candidates.size() == 0 && container.subContainers.size() == 0) {
            Container parent = container.parent;
            if (parent != null) {
                parent.subContainers.remove(container);
            }
            return;
        }
        MigrateJCas.si(this.psb).append("Migrating JCas files ");
        this.psb.append(container.isJar ? "in Jar: " : (container.isPear ? "in Pear: " : "from root: "));
        this.psb.append(container.rootOrig);
        indent[0] = indent[0] + 2;
        MigrateJCas.si(this.psb);
        MigrateJCas.flush(this.psb);
        try {
            for (Path path : container.candidates) {
                CommonConverted cc = this.getSource(path, container);
                this.migrate(cc, container, path);
                if (this.itemCount % 50 == 0) {
                    this.psb.append(" ").append(this.itemCount);
                    MigrateJCas.si(this.psb);
                    MigrateJCas.flush(this.psb);
                }
                ++this.itemCount;
            }
            this.psb.append(" ").append(this.itemCount - 1);
            MigrateJCas.flush(this.psb);
            if (isSource) {
                return;
            }
            if (!isSource && !container.haveDifferentCapitalizedNamesCollidingOnWindows && javaCompiler != null) {
                boolean somethingCompiled = this.compileV3SourcesCommon2(container);
                if ((container.isPear || container.isJar) && somethingCompiled) {
                    this.postProcessPearOrJar(container);
                }
                return;
            }
            this.unableToCompile = true;
            return;
        }
        finally {
            indent[0] = indent[0] - 2;
        }
    }

    private void removeNonJCas(Container container) {
        Iterator<Path> it = container.candidates.iterator();
        while (it.hasNext()) {
            String candidate = it.next().toString();
            if (container.isSingleJavaSource || container._Types.contains(candidate)) continue;
            it.remove();
        }
    }

    private void getCandidates_processFile2(Path path, Container container) {
        String pathString = path.toString();
        boolean isPear = pathString.endsWith(".pear");
        boolean isJar = pathString.endsWith(".jar");
        if (isPear || isJar) {
            Container subc = new Container(container, path);
            this.getAndProcessCandidatesInContainer(subc);
            return;
        }
        if (pathString.endsWith(isSource ? ".java" : ".class")) {
            this.addToCandidates(path, container);
        }
    }

    private void addToCandidates(Path path, Container container) {
        String ps = path.toString();
        if (ps.endsWith(isSource ? "_Type.java" : "_Type.class")) {
            container._Types.add(isSource ? ps.substring(0, ps.length() - 10) + ".java" : ps.substring(0, ps.length() - 11) + ".class");
            return;
        }
        if (ps.contains("$")) {
            return;
        }
        container.candidates.add(path);
    }

    private static Path getTempOutputPathForJarOrPear(Path path) throws IOException {
        Path localTempDir = MigrateJCas.getTempDir();
        if (path == null) {
            throw new IllegalArgumentException();
        }
        Path fn = path.getFileName();
        if (fn == null) {
            throw new IllegalArgumentException();
        }
        Path tempPath = Files.createTempFile(localTempDir, fn.toString(), "", new FileAttribute[0]);
        tempPath.toFile().deleteOnExit();
        return tempPath;
    }

    private static Path getTempDir() throws IOException {
        if (tempDir == null) {
            tempDir = Files.createTempDirectory("migrateJCas", new FileAttribute[0]);
            tempDir.toFile().deleteOnExit();
        }
        return tempDir;
    }

    private static final CommandLineParser createCmdLineParser() {
        CommandLineParser parser = new CommandLineParser();
        parser.addParameter(SOURCE_FILE_ROOTS, true);
        parser.addParameter(CLASS_FILE_ROOTS, true);
        parser.addParameter(OUTPUT_DIRECTORY, true);
        parser.addParameter(MIGRATE_CLASSPATH, true);
        return parser;
    }

    private final boolean checkCmdLineSyntax(CommandLineParser clp) {
        if (clp.getRestArgs().length > 0) {
            System.err.println("Error parsing CVD command line: unknown argument(s):");
            String[] args = clp.getRestArgs();
            for (int i = 0; i < args.length; ++i) {
                System.err.print(" ");
                System.err.print(args[i]);
            }
            System.err.println();
            return false;
        }
        if (!clp.isInArgsList(SOURCE_FILE_ROOTS) && !clp.isInArgsList(CLASS_FILE_ROOTS)) {
            System.err.println("Neither sources file roots nor classes file roots parameters specified; please specify just one.");
            return false;
        }
        if (clp.isInArgsList(SOURCE_FILE_ROOTS) && clp.isInArgsList(CLASS_FILE_ROOTS)) {
            System.err.println("both sources file roots and classes file roots parameters specified; please specify just one.");
            return false;
        }
        if (clp.isInArgsList(OUTPUT_DIRECTORY)) {
            this.outputDirectory = Paths.get(clp.getParamArgument(OUTPUT_DIRECTORY), new String[0]).toString();
            if (!this.outputDirectory.endsWith("/")) {
                this.outputDirectory = this.outputDirectory + "/";
            }
        } else {
            try {
                this.outputDirectory = Files.createTempDirectory("migrateJCasOutput", new FileAttribute[0]).toString() + "/";
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        this.outDirConverted = this.outputDirectory + "converted/";
        this.outDirSkipped = this.outputDirectory + "not-converted/";
        this.outDirLog = this.outputDirectory + "logs/";
        if (clp.isInArgsList(MIGRATE_CLASSPATH)) {
            this.migrateClasspath = clp.getParamArgument(MIGRATE_CLASSPATH);
        } else if (clp.isInArgsList(CLASS_FILE_ROOTS)) {
            System.err.println("WARNING: classes file roots is specified, but the\n       migrateClasspath parameter is missing\n");
        }
        return true;
    }

    private String decompile(byte[] b, String pearClasspath) {
        String classNameWithSlashes;
        this.badClassName = false;
        this.packageAndClassNameSlash = classNameWithSlashes = Misc.classNameFromByteCode((byte[])b);
        ClassLoader cl = this.getClassLoader(pearClasspath);
        UimaDecompiler ud = new UimaDecompiler(cl, null);
        if (classNameWithSlashes == null || classNameWithSlashes.length() < 2) {
            System.err.println("Failed to extract class name from binary code, name found was \"" + (classNameWithSlashes == null ? "null" : classNameWithSlashes) + "\"\n  byte array was:");
            System.err.println(Misc.dumpByteArray((byte[])b, (int)2000));
            this.badClassName = true;
        }
        return ud.decompileToString(classNameWithSlashes, b);
    }

    private ClassLoader getClassLoader(String pearClasspath) {
        if (null == pearClasspath) {
            if (null == this.cachedMigrateClassLoader) {
                this.cachedMigrateClassLoader = null == this.migrateClasspath ? ((Object)((Object)this)).getClass().getClassLoader() : new UIMAClassLoader(Misc.classpath2urls((String)this.migrateClasspath));
            }
            return this.cachedMigrateClassLoader;
        }
        try {
            return new UIMAClassLoader((String)(null == this.migrateClasspath ? pearClasspath : pearClasspath + File.pathSeparator + this.migrateClasspath));
        }
        catch (MalformedURLException e) {
            throw new UIMARuntimeException((Throwable)e);
        }
    }

    private void addImport(String s) {
        this.cu.getImports().add((Node)new ImportDeclaration(new Name(s), false, false));
    }

    private void removeImport(String s) {
        Iterator it = this.cu.getImports().iterator();
        while (it.hasNext()) {
            ImportDeclaration impDcl = (ImportDeclaration)it.next();
            if (!impDcl.getNameAsString().equals(s)) continue;
            it.remove();
            break;
        }
    }

    private Node replaceInParent(Node n, Expression v) {
        Optional maybeParent = n.getParentNode();
        if (maybeParent.isPresent()) {
            Node parent = (Node)n.getParentNode().get();
            if (parent instanceof EnclosedExpr) {
                ((EnclosedExpr)parent).setInner(v);
            } else if (parent instanceof MethodCallExpr) {
                NodeList args = ((MethodCallExpr)parent).getArguments();
                args.set(args.indexOf(n), v);
                v.setParentNode(parent);
            } else if (parent instanceof ExpressionStmt) {
                ((ExpressionStmt)parent).setExpression(v);
            } else if (parent instanceof CastExpr) {
                ((CastExpr)parent).setExpression(v);
            } else if (parent instanceof ReturnStmt) {
                ((ReturnStmt)parent).setExpression(v);
            } else if (parent instanceof AssignExpr) {
                ((AssignExpr)parent).setValue(v);
            } else if (parent instanceof VariableDeclarator) {
                ((VariableDeclarator)parent).setInitializer(v);
            } else if (parent instanceof ObjectCreationExpr) {
                NodeList args = ((ObjectCreationExpr)parent).getArguments();
                int i = args.indexOf(n);
                if (i < 0) {
                    throw new RuntimeException();
                }
                args.set(i, v);
            } else {
                System.out.println(parent.getClass().getName());
                throw new RuntimeException();
            }
            return v;
        }
        System.out.println("internal error replacing in parent: no parent for node: " + n.getClass().getName());
        System.out.println("   node: " + n.toString());
        System.out.println("   expression replacing: " + v.toString());
        throw new RuntimeException();
    }

    private void setParameter(List<Parameter> ps, int i, String t, String name) {
        Parameter p = ps.get(i);
        p.setType((Type)new ClassOrInterfaceType(t));
        p.setName(new SimpleName(name));
    }

    private int findConstructor(NodeList<BodyDeclaration<?>> classMembers) {
        int i = 0;
        for (BodyDeclaration bd : classMembers) {
            if (bd instanceof ConstructorDeclaration) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean hasTypeFields(NodeList<BodyDeclaration<?>> members) {
        boolean hasType = false;
        boolean hasTypeId = false;
        for (BodyDeclaration bd : members) {
            FieldDeclaration f;
            EnumSet m;
            if (!(bd instanceof FieldDeclaration) || !(m = (f = (FieldDeclaration)bd).getModifiers()).contains(Modifier.PUBLIC) || !m.contains(Modifier.STATIC) || !m.contains(Modifier.FINAL)) continue;
            NodeList vds = f.getVariables();
            for (VariableDeclarator vd : vds) {
                if (!vd.getType().equals((Object)intType)) continue;
                String n = vd.getNameAsString();
                if (n.equals("type")) {
                    hasType = true;
                }
                if (n.equals("typeIndexID")) {
                    hasTypeId = true;
                }
                if (!hasTypeId || !hasType) continue;
                return true;
            }
        }
        return false;
    }

    private void setHasJCasConstructors(NodeList<BodyDeclaration<?>> members) {
        boolean has0ArgConstructor = false;
        boolean has1ArgJCasConstructor = false;
        boolean has2ArgJCasConstructorV2 = false;
        boolean has2ArgJCasConstructorV3 = false;
        for (BodyDeclaration bd : members) {
            if (!(bd instanceof ConstructorDeclaration)) continue;
            NodeList ps = ((ConstructorDeclaration)bd).getParameters();
            if (ps.size() == 0) {
                has0ArgConstructor = true;
            }
            if (ps.size() == 1 && this.getParmTypeName((List<Parameter>)ps, 0).equals("JCas")) {
                has1ArgJCasConstructor = true;
            }
            if (ps.size() != 2) continue;
            if (this.getParmTypeName((List<Parameter>)ps, 0).equals("int") && this.getParmTypeName((List<Parameter>)ps, 1).equals("TOP_Type")) {
                has2ArgJCasConstructorV2 = true;
                continue;
            }
            if (!this.getParmTypeName((List<Parameter>)ps, 0).equals("TypeImpl") || !this.getParmTypeName((List<Parameter>)ps, 1).equals("CASImpl")) continue;
            has2ArgJCasConstructorV3 = true;
        }
        this.hasV2Constructors = has0ArgConstructor && has1ArgJCasConstructor && has2ArgJCasConstructorV2;
        this.hasV3Constructors = has0ArgConstructor && has1ArgJCasConstructor && has2ArgJCasConstructorV3;
    }

    private String getParmTypeName(List<Parameter> p, int i) {
        return this.getTypeName(p.get(i).getType());
    }

    private String getTypeName(Type t) {
        if (t instanceof PrimitiveType) {
            return ((PrimitiveType)t).toString();
        }
        if (t instanceof ClassOrInterfaceType) {
            return ((ClassOrInterfaceType)t).getNameAsString();
        }
        Misc.internalError();
        return null;
    }

    private String getName(Expression e) {
        if ((e = this.getUnenclosedExpr(e)) instanceof NameExpr) {
            return ((NameExpr)e).getNameAsString();
        }
        if (e instanceof FieldAccessExpr) {
            return ((FieldAccessExpr)e).getNameAsString();
        }
        return null;
    }

    private void updateClassName(TypeDeclaration<?> n) {
        Node node;
        Optional pnode = n.getParentNode();
        if (pnode.isPresent() && (node = (Node)pnode.get()) instanceof CompilationUnit) {
            CompilationUnit cu2 = (CompilationUnit)node;
            this.className = cu2.getType(0).getNameAsString();
            String packageAndClassName = this.className.contains(".") ? this.className : this.packageName + "." + this.className;
            this.packageAndClassNameSlash = packageAndClassName.replace('.', '/');
            assert (this.current_cc.fqcn_slash == null || this.current_cc.fqcn_slash.equals(this.packageAndClassNameSlash));
            this.current_cc.fqcn_slash = this.packageAndClassNameSlash;
            TypeImpl ti = TypeSystemImpl.staticTsi.getType(Misc.javaClassName2UimaTypeName((String)packageAndClassName));
            if (null != ti) {
                this.skippedBuiltins.add(new PathContainerAndReason(this.current_path, this.current_container, "built-in"));
                this.isBuiltinJCas = true;
                this.isConvert2v3 = false;
                return;
            }
            VariableDeclarator vd_typename = new VariableDeclarator(stringType, "_TypeName", (Expression)new StringLiteralExpr(packageAndClassName));
            this.fi_fields.add((Node)new FieldDeclaration(public_static_final, vd_typename));
            return;
        }
    }

    private Expression getExpressionFromStmt(Statement stmt) {
        if ((stmt = this.getStmtFromStmt(stmt)) instanceof ExpressionStmt) {
            return this.getUnenclosedExpr(((ExpressionStmt)stmt).getExpression());
        }
        return null;
    }

    private Expression getUnenclosedExpr(Expression e) {
        while (e instanceof EnclosedExpr) {
            e = (Expression)((EnclosedExpr)e).getInner().get();
        }
        return e;
    }

    private Statement getStmtFromStmt(Statement stmt) {
        while (stmt instanceof BlockStmt) {
            NodeList stmts = ((BlockStmt)stmt).getStatements();
            if (stmts.size() == 1) {
                stmt = (Statement)stmts.get(0);
                continue;
            }
            return null;
        }
        return stmt;
    }

    private void addCastExpr(Statement stmt, Type castType) {
        ReturnStmt rstmt = (ReturnStmt)stmt;
        Optional o_expr = rstmt.getExpression();
        Expression expr = o_expr.isPresent() ? (Expression)o_expr.get() : null;
        CastExpr ce = new CastExpr(castType, expr);
        rstmt.setExpression((Expression)ce);
        if (expr != null) {
            expr.setParentNode((Node)ce);
        }
    }

    private void recordBadConstructor(String msg) {
        this.reportMigrateFailed("Constructor is incorrect, " + msg);
    }

    private void migrationFailed(String reason) {
        this.failedMigration.add(new PathContainerAndReason(this.current_path, this.current_container, reason));
        this.isConvert2v3 = false;
    }

    private void reportMigrateFailed(String m) {
        System.out.format("Skipping this file due to error: %s, path: %s%n", m, this.current_path);
        this.migrationFailed(m);
    }

    private void reportV2Class() {
        this.isV2JCas = true;
    }

    private void reportV3Class() {
        this.isConvert2v3 = true;
    }

    private void reportNotJCasClass(String reason) {
        this.nonJCasFiles.add(new PathContainerAndReason(this.current_path, this.current_container, reason));
        this.isConvert2v3 = false;
    }

    private void reportNotJCasClassMissingTypeFields() {
        this.reportNotJCasClass("missing required type and/or typeIndexID static fields");
    }

    private void reportDeletedCheckModified(String m) {
        this.deletedCheckModified.add(new PathContainerAndReason(this.current_path, this.current_container, m));
    }

    private void reportMismatchedFeatureName(String m) {
        this.manualInspection.add(new PathContainerAndReason(this.current_path, this.current_container, "This getter/setter name doesn't match internal feature name: " + m));
    }

    private void reportUnrecognizedV2Code(String m) {
        this.migrationFailed("V2 code not recognized:\n" + m);
    }

    private void reportPathWorkaround(String orig, String modified) {
        this.pathWorkaround.add(new String1AndString2(orig, modified));
    }

    private void reportPearOrJarClassReplace(String pearOrJar, String classname, Container kind) {
        if (kind.isPear) {
            this.pearClassReplace.add(new String1AndString2(pearOrJar, classname));
        } else {
            this.jarClassReplace.add(new String1AndString2(pearOrJar, classname));
        }
    }

    private String getBaseOutputPath(CommonConverted cc, boolean isV2, boolean wasConverted) {
        StringBuilder sb = new StringBuilder();
        sb.append(wasConverted ? this.outDirConverted : this.outDirSkipped);
        sb.append(isV2 ? "v2/" : "v3/");
        sb.append("a").append(cc.getId()).append('/');
        sb.append(cc.fqcn_slash).append(".java");
        return sb.toString();
    }

    private void writeV2Orig(CommonConverted cc, boolean wasConverted) throws IOException {
        String base = this.getBaseOutputPath(cc, true, wasConverted);
        FileUtils.writeToFile((Path)this.makePath(base), (String)cc.v2Source);
    }

    private void writeV3(CommonConverted cc) throws IOException {
        String base = this.getBaseOutputPath(cc, false, true);
        cc.v3SourcePath = this.makePath(base);
        String data = this.fixImplementsBug(cc.v3Source);
        FileUtils.writeToFile((Path)cc.v3SourcePath, (String)data);
    }

    private void printUsage() {
        System.out.println("Usage: java org.apache.uima.migratev3.jcas.MigrateJCas \n  [-sourcesRoots <One-or-more-directories-or-jars-separated-by-Path-separator, or a path to a single JCas source class>]\n  [-classesRoots <One-or-more-directories-or-jars-or-pears-separated-by-Path-separator>]\n  [-outputDirectory a-writable-directory-path (optional)\n     if omitted, a temporary directory is used\n     if not omitted, the directory contents WILL BE ERASED at the start.\n  [-migrateClasspath a-class-path to use in decompiling, when -classesRoots is specified\n                     also used when compiling the migrated classes.\n  NOTE: either -sourcesRoots or -classesRoots is required, but only one may be specified.\n  NOTE: classesRoots are scanned for JCas classes, which are then decompiled, and the results processed like sourcesRoots\n");
    }

    private String fixImplementsBug(String data) {
        return implementsEmpty.matcher(data).replaceAll("{");
    }

    private static void withIOX(Runnable_withException r) {
        try {
            r.run();
        }
        catch (Exception e) {
            throw new UIMARuntimeException((Throwable)e);
        }
    }

    private int findFirstCharDifferent(String s1, String s2) {
        int s1l = s1.length();
        int s2l = s2.length();
        int i = 0;
        while (i != s1l && i != s2l) {
            if (s1.charAt(i) != s2.charAt(i)) {
                return i;
            }
            ++i;
        }
        return i;
    }

    static {
        printWithoutComments.setPrintComments(false);
        printCu = new PrettyPrinterConfiguration();
        printCu.setIndent("  ");
        isSource = false;
        tempDir = null;
        refGetter = Pattern.compile("(ll_getRef(Array)?Value)|(ll_getFSForRef)");
        word1 = Pattern.compile("\\A(\\w*)");
        implementsEmpty = Pattern.compile("implements  \\{");
    }

    private static class Container
    implements Comparable<Container> {
        final int id = nextContainerId++;
        final Container parent;
        Path root;
        final Path rootOrig;
        final Set<Container> subContainers = new TreeSet<Container>();
        final List<Path> candidates = new ArrayList<Path>();
        final List<CommonConverted> convertedItems = new ArrayList<CommonConverted>();
        final List<V3CompiledPathAndContainerItemPath> v3CompiledPathAndContainerItemPath = new ArrayList<V3CompiledPathAndContainerItemPath>();
        final boolean isPear;
        final boolean isJar;
        final boolean isSingleJavaSource;
        final Set<String> _Types = new HashSet<String>();
        boolean haveDifferentCapitalizedNamesCollidingOnWindows = false;
        String pearClasspath;
        private Map<byte[], CommonConverted> origBytesToCommonConverted = new HashMap<byte[], CommonConverted>();

        Container(Container parent, Path root) {
            this.parent = parent;
            if (parent != null) {
                parent.subContainers.add(this);
                this.pearClasspath = parent.pearClasspath;
            }
            this.rootOrig = root;
            String s = root.toString().toLowerCase();
            this.isJar = s.endsWith(".jar");
            this.isPear = s.endsWith(".pear");
            this.isSingleJavaSource = s.endsWith(".java");
            this.root = this.isPear || this.isJar ? this.installJarOrPear() : root;
        }

        private Path installJarOrPear() {
            try {
                Path theJarOrPear = this.rootOrig;
                if (!theJarOrPear.getFileSystem().equals(FileSystems.getDefault())) {
                    theJarOrPear = MigrateJCas.getTempOutputPathForJarOrPear(theJarOrPear);
                    Files.copy(this.rootOrig, theJarOrPear, StandardCopyOption.REPLACE_EXISTING);
                }
                if (this.isPear) {
                    File pearInstallDir = Files.createTempDirectory(MigrateJCas.getTempDir(), "installedPear", new FileAttribute[0]).toFile();
                    PackageBrowser ip = PackageInstaller.installPackage((File)pearInstallDir, (File)this.rootOrig.toFile(), (boolean)false);
                    String newClasspath = ip.buildComponentClassPath();
                    String parentClasspath = this.parent.pearClasspath;
                    this.pearClasspath = null == parentClasspath || 0 == parentClasspath.length() ? newClasspath : newClasspath + File.pathSeparator + parentClasspath;
                }
                FileSystem pfs = FileSystems.newFileSystem(theJarOrPear, (ClassLoader)null);
                return pfs.getPath("/", new String[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            StringBuilder sb = this.toString1();
            indent[0] = indent[0] + 2;
            try {
                MigrateJCas.si(sb);
                sb.append("subContainers=");
                Misc.addElementsToStringBuilder((int[])indent, (StringBuilder)sb, (Collection)Misc.setAsList(this.subContainers), (int)-1, (sbx, i) -> sbx.append(i.id)).append(',');
                MigrateJCas.si(sb).append("paths migrated=");
                Misc.addElementsToStringBuilder((int[])indent, (StringBuilder)sb, this.candidates, (int)-1, StringBuilder::append).append(',');
            }
            finally {
                indent[0] = indent[0] - 2;
                MigrateJCas.si(sb).append(']');
            }
            return sb.toString();
        }

        public StringBuilder toString1() {
            StringBuilder sb = new StringBuilder();
            MigrateJCas.si(sb);
            sb.append(this.isJar ? "Jar " : (this.isPear ? "PEAR " : ""));
            sb.append("container [id=").append(this.id).append(", parent.id=").append(null == this.parent ? "null" : Integer.valueOf(this.parent.id)).append(", root or pathToJarOrPear=").append(this.rootOrig).append(',');
            return sb;
        }

        public int hashCode() {
            return 31 * this.id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Container other = (Container)obj;
            return this.id == other.id;
        }

        @Override
        public int compareTo(Container o) {
            return Integer.compare(this.id, o.id);
        }
    }

    private class CommonConverted {
        int id = -1;
        final String v2Source;
        final byte[] v2ByteCode;
        final Set<ContainerAndPath> containersAndV2Paths = new HashSet<ContainerAndPath>();
        String v3Source;
        Path v3SourcePath;
        String fqcn_slash;

        CommonConverted(String origSource, byte[] v2ByteCode, Path path, Container container, String fqcn_slash) {
            this.v2Source = origSource;
            this.v2ByteCode = v2ByteCode;
            this.containersAndV2Paths.add(new ContainerAndPath(path, container));
            this.fqcn_slash = fqcn_slash;
        }

        Path getV2SourcePath(Container container) {
            for (ContainerAndPath cp : this.containersAndV2Paths) {
                if (cp.container != container) continue;
                return cp.path;
            }
            throw new RuntimeException("internalError");
        }

        int getId() {
            if (this.id < 0) {
                Integer nextId = MigrateJCas.this.nextCcId.computeIfAbsent(this.fqcn_slash, s -> INTEGER0);
                MigrateJCas.this.nextCcId.put(this.fqcn_slash, nextId + 1);
                this.id = nextId;
            }
            return this.id;
        }

        public int hashCode() {
            return this.v2Source == null ? 0 : this.v2Source.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof CommonConverted && this.v2Source != null && this.v2Source.equals(((CommonConverted)obj).v2Source);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int maxLen = 10;
            MigrateJCas.si(sb).append("CommonConverted [v2Source=").append(Misc.elide((String)this.v2Source, (int)100));
            indent[0] = indent[0] + 2;
            try {
                MigrateJCas.si(sb).append("v2ByteCode=");
                sb.append(this.v2ByteCode != null ? Arrays.toString(Arrays.copyOf(this.v2ByteCode, Math.min(this.v2ByteCode.length, maxLen))) : "null").append(',');
                MigrateJCas.si(sb).append("containersAndPaths=").append(this.containersAndV2Paths != null ? Misc.ppList((int[])indent, (List)Misc.setAsList(this.containersAndV2Paths), (int)-1, StringBuilder::append) : "null").append(',');
                MigrateJCas.si(sb).append("v3SourcePath=").append(this.v3SourcePath).append(',');
                MigrateJCas.si(sb).append("fqcn_slash=").append(this.fqcn_slash).append("]").append('\n');
            }
            finally {
                indent[0] = indent[0] - 2;
            }
            return sb.toString();
        }
    }

    private static class V3CompiledPathAndContainerItemPath {
        final Path v3CompiledPath;
        final String pathInContainer;

        public V3CompiledPathAndContainerItemPath(Path v3CompiledPath, String pathInContainer) {
            this.v3CompiledPath = v3CompiledPath;
            this.pathInContainer = pathInContainer;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            MigrateJCas.si(sb).append("v3CompiledPathAndContainerPartPath [");
            indent[0] = indent[0] + 2;
            try {
                MigrateJCas.si(sb).append("v3CompiledPath=").append(this.v3CompiledPath);
                MigrateJCas.si(sb).append("pathInContainer=").append(this.pathInContainer);
            }
            finally {
                indent[0] = indent[0] - 2;
                MigrateJCas.si(sb).append("]");
            }
            return sb.toString();
        }
    }

    private static class ContainerAndPath
    implements Comparable<ContainerAndPath> {
        final Path path;
        final Container container;

        ContainerAndPath(Path path, Container container) {
            this.path = path;
            this.container = container;
        }

        @Override
        public int compareTo(ContainerAndPath o) {
            int r = this.path.compareTo(o.path);
            if (r != 0) {
                return r;
            }
            return Integer.compare(this.container.id, o.container.id);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ContainerAndPath [path=").append(this.path).append(", container=").append(this.container.id).append("]");
            return sb.toString();
        }
    }

    private class removeEmptyStmts
    extends VoidVisitorAdapter<Object> {
        private removeEmptyStmts() {
        }

        public void visit(BlockStmt n, Object ignore) {
            n.getStatements().removeIf(statement -> statement instanceof EmptyStmt);
            super.visit(n, ignore);
        }
    }

    private static abstract class Report2<T, U> {
        private Report2() {
        }

        public abstract Comparable<T> getFirst();

        public abstract Comparable<U> getSecond();

        abstract int getFirstLength();
    }

    private static class PathContainerAndReason
    extends Report2<ContainerAndPath, String> {
        final ContainerAndPath cap;
        final String reason;

        PathContainerAndReason(ContainerAndPath cap, String reason) {
            this.cap = cap;
            this.reason = reason;
        }

        PathContainerAndReason(Path path, Container container, String reason) {
            this(new ContainerAndPath(path, container), reason);
        }

        @Override
        public Comparable<ContainerAndPath> getFirst() {
            return this.cap;
        }

        @Override
        public Comparable<String> getSecond() {
            return this.reason;
        }

        @Override
        int getFirstLength() {
            return this.cap.toString().length();
        }
    }

    private static class String1AndString2
    extends Report2<String, String> {
        String s1;
        String s2;

        String1AndString2(String s1, String s2) {
            this.s1 = s1;
            this.s2 = s2;
        }

        @Override
        public Comparable<String> getFirst() {
            return this.s1;
        }

        @Override
        public Comparable<String> getSecond() {
            return this.s2;
        }

        @Override
        int getFirstLength() {
            return this.s1.toString().length();
        }
    }
}

