/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.uima.resource.RelativePathResolver;
import org.apache.uima.util.impl.Constants;

public class RelativePathResolver_impl
implements RelativePathResolver {
    private List<String> mDataPath;
    private URL[] mBaseUrls;
    private ClassLoader mClassLoader;

    public RelativePathResolver_impl() {
        this(null);
        this.mClassLoader = this.getClass().getClassLoader();
    }

    public RelativePathResolver_impl(ClassLoader aClassLoader) {
        String dataPath = null;
        try {
            dataPath = System.getProperty("uima.datapath");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (dataPath == null) {
            try {
                dataPath = System.getProperty("user.dir");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (dataPath == null) {
            dataPath = "";
        }
        try {
            this.setDataPath(dataPath);
        }
        catch (MalformedURLException e) {
            this.mDataPath = Collections.emptyList();
            this.mBaseUrls = Constants.EMPTY_URL_ARRAY;
        }
        this.mClassLoader = aClassLoader;
    }

    @Override
    @Deprecated
    public String getDataPath() {
        String pathSepChar = System.getProperty("path.separator");
        return this.mDataPath.stream().collect(Collectors.joining(pathSepChar));
    }

    @Override
    public List<String> getDataPathElements() {
        return this.mDataPath;
    }

    @Override
    public void setDataPathElements(File ... aPaths) throws MalformedURLException {
        if (aPaths == null) {
            this.mDataPath = Collections.emptyList();
            this.mBaseUrls = Constants.EMPTY_URL_ARRAY;
            return;
        }
        this.mDataPath = Collections.unmodifiableList(Arrays.stream(aPaths).map(File::getPath).map(s -> s.replace(File.separator, "/")).collect(Collectors.toList()));
        this.mBaseUrls = new URL[aPaths.length];
        for (int i = 0; i < aPaths.length; ++i) {
            this.mBaseUrls[i] = aPaths[i].toURL();
        }
    }

    @Override
    public void setDataPathElements(String ... aPaths) throws MalformedURLException {
        if (aPaths == null) {
            this.mDataPath = null;
            this.mBaseUrls = null;
            return;
        }
        this.mDataPath = Collections.unmodifiableList(Arrays.stream(aPaths).collect(Collectors.toList()));
        this.mBaseUrls = new URL[aPaths.length];
        for (int i = 0; i < aPaths.length; ++i) {
            this.mBaseUrls[i] = new File(aPaths[i]).toURL();
        }
    }

    @Override
    @Deprecated
    public void setDataPath(String aPath) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        ArrayList<String> paths = new ArrayList<String>();
        String pathSepChar = System.getProperty("path.separator");
        StringTokenizer tokenizer = new StringTokenizer(aPath, pathSepChar);
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            paths.add(tok);
            URL url = new File(tok).toURL();
            urls.add(url);
        }
        this.mBaseUrls = urls.toArray(new URL[urls.size()]);
        this.mDataPath = Collections.unmodifiableList(paths);
    }

    @Override
    public URL resolveRelativePath(URL aRelativeUrl) {
        URL[] baseUrls = this.getBaseUrls();
        for (int i = 0; i < baseUrls.length; ++i) {
            try {
                URL absUrl = new URL(baseUrls[i], aRelativeUrl.toString());
                if (!this.fileExistsAtUrl(absUrl)) continue;
                return absUrl;
            }
            catch (MalformedURLException absUrl) {
                // empty catch block
            }
        }
        if (aRelativeUrl.getPath().startsWith("/") && this.fileExistsAtUrl(aRelativeUrl)) {
            return aRelativeUrl;
        }
        String f = aRelativeUrl.getFile();
        URL absURL = null;
        if (this.mClassLoader != null) {
            absURL = this.mClassLoader.getResource(f);
        }
        if (absURL == null) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            absURL = tccl.getResource(f);
        }
        if (absURL == null && this.mClassLoader == null) {
            absURL = ClassLoader.getSystemClassLoader().getResource(f);
        }
        return absURL;
    }

    @Override
    public void setPathResolverClassLoader(ClassLoader aClassLoader) {
        this.mClassLoader = aClassLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean fileExistsAtUrl(URL aUrl) {
        try (InputStream testStream = aUrl.openStream();){
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected URL[] getBaseUrls() {
        return this.mBaseUrls;
    }
}

