package de.averbis;

import java.util.HashMap;

import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;

import de.averbis.types.Testannotation;

/**
 * @author entwicklerteam
 */
public class AnnotatorOne extends JCasAnnotator_ImplBase {

	private AnalysisEngine annotatortwo;


	@Override
	public void initialize(UimaContext context) throws ResourceInitializationException {

		super.initialize(context);
		ResourceManager resourceManager = this.getResourceManager(context);
		AnalysisEngineDescription annotatorTwoDescription = AnalysisEngineFactory.createEngineDescription(AnnotatorTwo.class);
		this.annotatortwo = UIMAFramework.produceAnalysisEngine(annotatorTwoDescription, resourceManager, new HashMap<String, Object>());
	}


	@Override
	public void process(JCas jCas) throws AnalysisEngineProcessException {

		System.out.println("Processing AnnotatorOne....");
		this.annotatortwo.process(jCas);

		for (Testannotation testannotation : JCasUtil.select(jCas, Testannotation.class)) {

			System.out.println("Print the test feature: " + testannotation.getTestfeature());
		}
	}


	protected ResourceManager getResourceManager(UimaContext context) {

		ResourceManager rm = null;

		if (context instanceof UimaContextAdmin) {

			rm = ((UimaContextAdmin) context).getResourceManager();

		} else {

			rm = UIMAFramework.newDefaultResourceManager();
		}
		return rm;
	}


	@Override
	public void destroy() {

		super.destroy();
		this.annotatortwo.destroy();
		this.annotatortwo = null;
	}
}