/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class InvocationExpression
extends Expression {
    public InvocationExpression(int offset, Expression target, Iterable<Expression> arguments) {
        super(offset);
        this.addChild(target, Roles.TARGET_EXPRESSION);
        if (arguments != null) {
            for (Expression argument : arguments) {
                this.addChild(argument, Roles.ARGUMENT);
            }
        }
    }

    public InvocationExpression(int offset, Expression target, Expression ... arguments) {
        super(offset);
        this.addChild(target, Roles.TARGET_EXPRESSION);
        if (arguments != null) {
            for (Expression argument : arguments) {
                this.addChild(argument, Roles.ARGUMENT);
            }
        }
    }

    public final Expression getTarget() {
        return this.getChildByRole(Roles.TARGET_EXPRESSION);
    }

    public final void setTarget(Expression value) {
        this.setChildByRole(Roles.TARGET_EXPRESSION, value);
    }

    public final AstNodeCollection<Expression> getArguments() {
        return this.getChildrenByRole(Roles.ARGUMENT);
    }

    public final JavaTokenNode getLeftParenthesisToken() {
        return this.getChildByRole(Roles.LEFT_PARENTHESIS);
    }

    public final JavaTokenNode getRightParenthesisToken() {
        return this.getChildByRole(Roles.LEFT_PARENTHESIS);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitInvocationExpression(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof InvocationExpression) {
            InvocationExpression otherExpression = (InvocationExpression)other;
            return this.getTarget().matches(otherExpression.getTarget(), match) && this.getArguments().matches(otherExpression.getArguments(), match);
        }
        return false;
    }
}

