/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class MemberReferenceExpression
extends Expression {
    public MemberReferenceExpression(int offset, Expression target, String memberName, Iterable<AstType> typeArguments) {
        super(offset);
        this.addChild(target, Roles.TARGET_EXPRESSION);
        this.setMemberName(memberName);
        if (typeArguments != null) {
            for (AstType argument : typeArguments) {
                this.addChild(argument, Roles.TYPE_ARGUMENT);
            }
        }
    }

    public MemberReferenceExpression(int offset, Expression target, String memberName, AstType ... typeArguments) {
        super(offset);
        this.addChild(target, Roles.TARGET_EXPRESSION);
        this.setMemberName(memberName);
        if (typeArguments != null) {
            for (AstType argument : typeArguments) {
                this.addChild(argument, Roles.TYPE_ARGUMENT);
            }
        }
    }

    public final String getMemberName() {
        return this.getChildByRole(Roles.IDENTIFIER).getName();
    }

    public final void setMemberName(String name) {
        this.setChildByRole(Roles.IDENTIFIER, Identifier.create(name));
    }

    public final Identifier getMemberNameToken() {
        return this.getChildByRole(Roles.IDENTIFIER);
    }

    public final void setMemberNameToken(Identifier token) {
        this.setChildByRole(Roles.IDENTIFIER, token);
    }

    public final Expression getTarget() {
        return this.getChildByRole(Roles.TARGET_EXPRESSION);
    }

    public final void setTarget(Expression value) {
        this.setChildByRole(Roles.TARGET_EXPRESSION, value);
    }

    public final AstNodeCollection<AstType> getTypeArguments() {
        return this.getChildrenByRole(Roles.TYPE_ARGUMENT);
    }

    public final JavaTokenNode getDotToken() {
        return this.getChildByRole(Roles.DOT);
    }

    public final JavaTokenNode getLeftChevronToken() {
        return this.getChildByRole(Roles.LEFT_CHEVRON);
    }

    public final JavaTokenNode getRightChevronToken() {
        return this.getChildByRole(Roles.RIGHT_CHEVRON);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitMemberReferenceExpression(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof MemberReferenceExpression) {
            MemberReferenceExpression otherExpression = (MemberReferenceExpression)other;
            return !otherExpression.isNull() && this.getTarget().matches(otherExpression.getTarget(), match) && MemberReferenceExpression.matchString(this.getMemberName(), otherExpression.getMemberName()) && this.getTypeArguments().matches(otherExpression.getTypeArguments(), match);
        }
        return false;
    }
}

