/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.soap;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Part;
import org.apache.axis.attachments.AttachmentUtils;
import org.apache.axis.encoding.Base64;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Messages;
import org.apache.uima.internal.util.SerializationUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BinaryDeserializer
extends DeserializerImpl {
    private static final long serialVersionUID = 1351090281481173811L;
    private StringBuffer buf = new StringBuffer();

    public void startElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        String href;
        if (!context.isDoneParsing() && this.myElement == null) {
            try {
                this.myElement = this.makeNewElement(namespace, localName, prefix, attributes, context);
            }
            catch (AxisFault axisFault) {
                throw new SAXException((Exception)((Object)axisFault));
            }
            context.pushNewElement(this.myElement);
        }
        SOAPConstants soapConstants = context.getMessageContext().getSOAPConstants();
        QName type = context.getTypeFromAttributes(namespace, localName, attributes);
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"gotType00", (String)"Deser", (String)("" + type)));
        }
        if ((href = attributes.getValue(soapConstants.getAttrHref())) != null) {
            Object ref = context.getObjectByRef(href);
            if (ref instanceof SOAPBodyElement) {
                SOAPBodyElement bodyElem = (SOAPBodyElement)ref;
                href = bodyElem.getAttributeValue(soapConstants.getAttrHref());
                ref = context.getObjectByRef(href);
            }
            if (ref instanceof Part) {
                try {
                    DataHandler dataHandler = AttachmentUtils.getActivationDataHandler((Part)((Part)ref));
                    Object content = dataHandler.getContent();
                    try (ObjectInputStream objStream = new ObjectInputStream((InputStream)content);){
                        this.setValue(objStream.readObject());
                    }
                }
                catch (AxisFault e) {
                    throw new SAXException(e.getMessage());
                }
                catch (IOException e) {
                    throw new SAXException(e.getMessage());
                }
                catch (ClassNotFoundException e) {
                    throw new SAXException(e.getMessage());
                }
            }
        }
        if (this.getValue() == null) {
            super.startElement(namespace, localName, prefix, attributes, context);
        }
    }

    public void onStartElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        this.buf.setLength(0);
    }

    public void onEndElement(String arg0, String arg1, DeserializationContext arg2) throws SAXException {
        try {
            String base64str;
            if (this.getValue() == null && (base64str = this.buf.toString()).length() > 0) {
                byte[] bytes = Base64.decode((String)base64str);
                this.setValue(SerializationUtils.deserialize((byte[])bytes));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.buf.append(ch, start, length);
    }
}

