/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.verbalize;

import java.util.Iterator;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.verbalize.RutaVerbalizer;

public class VerbalizerUtils {
    private RutaVerbalizer verbalizer;

    public VerbalizerUtils(RutaVerbalizer verbalizer) {
        this.verbalizer = verbalizer;
    }

    public String verbalizeList(List<?> list) {
        StringBuilder result = new StringBuilder();
        Iterator<?> it = list.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            result.append(obj.toString());
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public String verbalizeTypeList(List<Type> list) {
        StringBuilder result = new StringBuilder();
        Iterator<Type> it = list.iterator();
        while (it.hasNext()) {
            Type type = it.next();
            result.append(this.verbalizer.verbalizeType(type));
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public String verbalizeExpressionList(List<? extends IRutaExpression> list) {
        if (list == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        Iterator<? extends IRutaExpression> it = list.iterator();
        while (it.hasNext()) {
            IRutaExpression e = it.next();
            result.append(this.verbalizer.verbalize(e));
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }
}

