/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.verbalize;

import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.ruta.expression.AnnotationTypeExpression;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.MatchReference;
import org.apache.uima.ruta.expression.NullExpression;
import org.apache.uima.ruta.expression.annotation.AnnotationAddressExpression;
import org.apache.uima.ruta.expression.annotation.AnnotationLabelExpression;
import org.apache.uima.ruta.expression.annotation.AnnotationVariableExpression;
import org.apache.uima.ruta.expression.annotation.IAnnotationExpression;
import org.apache.uima.ruta.expression.bool.BooleanFeatureExpression;
import org.apache.uima.ruta.expression.bool.BooleanListVariableExpression;
import org.apache.uima.ruta.expression.bool.BooleanNumberExpression;
import org.apache.uima.ruta.expression.bool.BooleanTypeExpression;
import org.apache.uima.ruta.expression.bool.BooleanVariableExpression;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.bool.SimpleBooleanExpression;
import org.apache.uima.ruta.expression.bool.SimpleBooleanListExpression;
import org.apache.uima.ruta.expression.feature.FeatureExpression;
import org.apache.uima.ruta.expression.feature.FeatureMatchExpression;
import org.apache.uima.ruta.expression.feature.GenericFeatureExpression;
import org.apache.uima.ruta.expression.feature.SimpleFeatureExpression;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.expression.list.UntypedListExpression;
import org.apache.uima.ruta.expression.number.ComposedNumberExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.number.NegativeNumberExpression;
import org.apache.uima.ruta.expression.number.NumberFeatureExpression;
import org.apache.uima.ruta.expression.number.NumberListVariableExpression;
import org.apache.uima.ruta.expression.number.NumberVariableExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberListExpression;
import org.apache.uima.ruta.expression.resource.ReferenceWordListExpression;
import org.apache.uima.ruta.expression.resource.ReferenceWordTableExpression;
import org.apache.uima.ruta.expression.resource.WordListExpression;
import org.apache.uima.ruta.expression.resource.WordTableExpression;
import org.apache.uima.ruta.expression.string.ComposedStringExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.string.LiteralStringExpression;
import org.apache.uima.ruta.expression.string.SimpleStringExpression;
import org.apache.uima.ruta.expression.string.SimpleStringListExpression;
import org.apache.uima.ruta.expression.string.StringFeatureExpression;
import org.apache.uima.ruta.expression.string.StringListVariableExpression;
import org.apache.uima.ruta.expression.string.StringVariableExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.expression.type.SimpleTypeExpression;
import org.apache.uima.ruta.expression.type.SimpleTypeListExpression;
import org.apache.uima.ruta.expression.type.TypeListVariableExpression;
import org.apache.uima.ruta.expression.type.TypeVariableExpression;
import org.apache.uima.ruta.verbalize.RutaVerbalizer;

public class ExpressionVerbalizer {
    private RutaVerbalizer verbalizer;

    public ExpressionVerbalizer(RutaVerbalizer verbalizer) {
        this.verbalizer = verbalizer;
    }

    public String verbalize(IRutaExpression expression) {
        if (expression instanceof NullExpression) {
            return "null";
        }
        if (expression instanceof GenericFeatureExpression) {
            return this.verbalize(((GenericFeatureExpression)expression).getFeatureExpression());
        }
        if (expression instanceof AnnotationTypeExpression) {
            return this.verbalize((AnnotationTypeExpression)expression);
        }
        if (expression instanceof IAnnotationExpression) {
            return this.verbalize((IAnnotationExpression)expression);
        }
        if (expression instanceof ITypeExpression) {
            return this.verbalize((ITypeExpression)expression);
        }
        if (expression instanceof IBooleanExpression) {
            return this.verbalize((IBooleanExpression)expression);
        }
        if (expression instanceof INumberExpression) {
            return this.verbalize((INumberExpression)expression);
        }
        if (expression instanceof WordListExpression) {
            return this.verbalize((WordListExpression)expression);
        }
        if (expression instanceof WordTableExpression) {
            return this.verbalize((WordTableExpression)expression);
        }
        if (expression instanceof ListExpression) {
            return this.verbalize((ListExpression)expression);
        }
        if (expression instanceof FeatureMatchExpression) {
            return this.verbalize((FeatureMatchExpression)expression);
        }
        if (expression instanceof FeatureExpression) {
            return this.verbalize((FeatureExpression)expression);
        }
        if (expression instanceof IStringExpression) {
            return this.verbalize((IStringExpression)expression);
        }
        if (expression instanceof MatchReference) {
            return this.verbalize((MatchReference)expression);
        }
        return expression.getClass().getSimpleName();
    }

    public String verbalize(WordTableExpression expression) {
        if (expression instanceof ReferenceWordTableExpression) {
            ReferenceWordTableExpression e = (ReferenceWordTableExpression)expression;
            return e.getRef();
        }
        return expression.getClass().getSimpleName();
    }

    public String verbalize(WordListExpression expression) {
        if (expression instanceof ReferenceWordListExpression) {
            ReferenceWordListExpression e = (ReferenceWordListExpression)expression;
            return e.getRef();
        }
        return expression.getClass().getSimpleName();
    }

    public String verbalize(ListExpression<?> expression) {
        if (expression instanceof SimpleBooleanListExpression) {
            SimpleBooleanListExpression e = (SimpleBooleanListExpression)expression;
            return "{" + this.verbalizer.verbalizeExpressionList(e.getList()) + "}";
        }
        if (expression instanceof BooleanListVariableExpression) {
            BooleanListVariableExpression e = (BooleanListVariableExpression)expression;
            return e.getVar();
        }
        if (expression instanceof SimpleNumberListExpression) {
            SimpleNumberListExpression e = (SimpleNumberListExpression)expression;
            return "{" + this.verbalizer.verbalizeExpressionList(e.getList()) + "}";
        }
        if (expression instanceof NumberListVariableExpression) {
            NumberListVariableExpression e = (NumberListVariableExpression)expression;
            return e.getVar();
        }
        if (expression instanceof SimpleStringListExpression) {
            SimpleStringListExpression e = (SimpleStringListExpression)expression;
            return "{" + this.verbalizer.verbalizeExpressionList(e.getList()) + "}";
        }
        if (expression instanceof StringListVariableExpression) {
            StringListVariableExpression e = (StringListVariableExpression)expression;
            return e.getVar();
        }
        if (expression instanceof SimpleTypeListExpression) {
            SimpleTypeListExpression e = (SimpleTypeListExpression)expression;
            return "{" + this.verbalizer.verbalizeExpressionList(e.getList()) + "}";
        }
        if (expression instanceof TypeListVariableExpression) {
            TypeListVariableExpression e = (TypeListVariableExpression)expression;
            return e.getVar();
        }
        if (expression instanceof UntypedListExpression) {
            UntypedListExpression e = (UntypedListExpression)expression;
            return "{" + this.verbalizer.verbalizeExpressionList(e.getList()) + "}";
        }
        return expression.getClass().getSimpleName();
    }

    public String verbalize(INumberExpression expression) {
        if (expression == null) {
            return "";
        }
        if (expression instanceof NegativeNumberExpression) {
            NegativeNumberExpression e = (NegativeNumberExpression)expression;
            return "-(" + e.getExpression() + ")";
        }
        if (expression instanceof NumberVariableExpression) {
            NumberVariableExpression e = (NumberVariableExpression)expression;
            return e.getVar();
        }
        if (expression instanceof SimpleNumberExpression) {
            SimpleNumberExpression e = (SimpleNumberExpression)expression;
            return e.getNumber().toString();
        }
        if (expression instanceof ComposedNumberExpression) {
            ComposedNumberExpression e = (ComposedNumberExpression)expression;
            INumberExpression ne = e.getExpressions().get(0);
            if (ne == null) {
                return "";
            }
            StringBuilder result = new StringBuilder(this.verbalize(ne));
            for (int i = 0; i < e.getOperators().size(); ++i) {
                result.append(" " + e.getOperators().get(i) + " ");
                if (e.getExpressions().size() <= i + 1) continue;
                result.append(this.verbalize(e.getExpressions().get(i + 1)));
            }
            return result.toString();
        }
        if (expression instanceof NumberFeatureExpression) {
            return this.verbalize(((NumberFeatureExpression)expression).getFe());
        }
        return expression.getClass().getSimpleName();
    }

    public String verbalize(IBooleanExpression expression) {
        if (expression == null) {
            return "";
        }
        if (expression instanceof BooleanNumberExpression) {
            BooleanNumberExpression e = (BooleanNumberExpression)expression;
            return this.verbalize(e.getFristExpression()) + " " + e.getOperator() + " " + this.verbalize(e.getSecondExpression());
        }
        if (expression instanceof BooleanTypeExpression) {
            BooleanTypeExpression e = (BooleanTypeExpression)expression;
            return this.verbalize(e.getFristExpression()) + " " + e.getOperator() + " " + this.verbalize(e.getSecondExpression());
        }
        if (expression instanceof BooleanVariableExpression) {
            BooleanVariableExpression e = (BooleanVariableExpression)expression;
            return e.getVar();
        }
        if (expression instanceof SimpleBooleanExpression) {
            SimpleBooleanExpression e = (SimpleBooleanExpression)expression;
            return e.getPrimitiveValue() ? "true" : "false";
        }
        if (expression instanceof BooleanFeatureExpression) {
            return this.verbalize(((BooleanFeatureExpression)expression).getFe());
        }
        return expression.getClass().getSimpleName();
    }

    public String verbalize(IStringExpression expression) {
        if (expression == null) {
            return "";
        }
        if (expression instanceof INumberExpression) {
            return this.verbalize((INumberExpression)expression);
        }
        if (expression instanceof ITypeExpression) {
            return this.verbalize((ITypeExpression)expression);
        }
        if (expression instanceof IBooleanExpression) {
            return this.verbalize((IBooleanExpression)expression);
        }
        if (expression instanceof ListExpression) {
            return this.verbalize((ListExpression)expression);
        }
        if (expression instanceof LiteralStringExpression) {
            return this.verbalize((LiteralStringExpression)expression);
        }
        if (expression instanceof StringFeatureExpression) {
            return this.verbalize(((StringFeatureExpression)expression).getFe());
        }
        return expression.getClass().getSimpleName();
    }

    public String verbalize(LiteralStringExpression expression) {
        if (expression == null) {
            return "";
        }
        if (expression instanceof ComposedStringExpression) {
            ComposedStringExpression e = (ComposedStringExpression)expression;
            StringBuilder sb = new StringBuilder();
            Iterator<IStringExpression> it = e.getExpressions().iterator();
            while (it.hasNext()) {
                IStringExpression each = it.next();
                sb.append(this.verbalize(each));
                if (!it.hasNext()) continue;
                sb.append(" + ");
            }
            return sb.toString();
        }
        if (expression instanceof StringVariableExpression) {
            StringVariableExpression e = (StringVariableExpression)expression;
            return e.getVar();
        }
        if (expression instanceof SimpleStringExpression) {
            SimpleStringExpression e = (SimpleStringExpression)expression;
            return "\"" + e.getValue() + "\"";
        }
        return expression.getClass().getSimpleName();
    }

    public String verbalize(ITypeExpression expression) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof SimpleTypeExpression) {
            SimpleTypeExpression e = (SimpleTypeExpression)expression;
            String type = e.getTypeString();
            int indexOf = type.lastIndexOf(".");
            if (indexOf != -1) {
                type = type.substring(indexOf + 1, type.length());
            }
            if (type.equals("DocumentAnnotation")) {
                type = "Document";
            }
            return type;
        }
        if (expression instanceof TypeVariableExpression) {
            TypeVariableExpression e = (TypeVariableExpression)expression;
            return e.getVar();
        }
        return expression.getClass().getSimpleName();
    }

    public String verbalize(IAnnotationExpression expression) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof AnnotationAddressExpression) {
            AnnotationAddressExpression e = (AnnotationAddressExpression)expression;
            return "$" + e.getAddress();
        }
        if (expression instanceof AnnotationVariableExpression) {
            AnnotationVariableExpression e = (AnnotationVariableExpression)expression;
            return e.getVar();
        }
        if (expression instanceof AnnotationLabelExpression) {
            AnnotationLabelExpression e = (AnnotationLabelExpression)expression;
            return e.getLabel();
        }
        return expression.getClass().getSimpleName();
    }

    public String verbalize(MatchReference expression) {
        String match = expression.getMatch();
        if (match == null) {
            String string = expression.toString();
            if (StringUtils.equals((CharSequence)string, (CharSequence)"uima.tcas.DocumentAnnotation")) {
                return "Document";
            }
            return string;
        }
        if (expression.getArgument() != null) {
            return match + expression.getComparator() + this.verbalizer.verbalize(expression.getArgument());
        }
        return match;
    }

    public String verbalize(AnnotationTypeExpression expression) {
        return this.verbalize(expression.getReference());
    }

    public String verbalize(FeatureExpression expression) {
        StringBuilder sb = new StringBuilder();
        if (expression instanceof SimpleFeatureExpression) {
            SimpleFeatureExpression sfe = (SimpleFeatureExpression)expression;
            sb.append(sfe.getMatchReference().getMatch());
        } else if (expression instanceof NullExpression) {
            sb.append("null");
        }
        return sb.toString();
    }

    public String verbalize(FeatureMatchExpression expression) {
        return this.verbalize((FeatureExpression)expression) + expression.getOp() + this.verbalize(expression.getArg());
    }
}

