/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.uima.ruta.ide.parser.ast;

import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;

/**
 * Simple statement with just one expression argument.
 * 
 */
public abstract class RutaSimpleStatement extends Statement {
  private Expression expression;

  public RutaSimpleStatement(int sourceStart, int sourceEnd, Expression expression) {
    super(sourceStart, sourceEnd);
    this.expression = expression;
  }

  /*
   * (non-Javadoc)
   * 
   * @see org.eclipse.dltk.ast.statements.Statement#getKind()
   */
  @Override
  public abstract int getKind();

  @Override
  public void traverse(ASTVisitor visitor) throws Exception {
    if (visitor.visit(this)) {
      if(expression != null) {
        expression.traverse(visitor);
      }
      visitor.endvisit(this);
    }
  }

  public Expression getExpression() {
    return this.expression;
  }

  public String toString() {
    return this.getClass().getSimpleName() + " : " + super.toString();
  }
}
