/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.turbine.util.FormMessage;

public class FormMessages {
    private final Hashtable<String, List<String>> forms_messages = new Hashtable();
    private final Hashtable<String, List<String>> fields_messages = new Hashtable();
    private final Hashtable<String, List<String>> messages_fields = new Hashtable();
    private final Hashtable<String, List<String>> forms_fields = new Hashtable();

    public void setMessage(String formName, String fieldName, long returnCode) {
        this.setMessage(formName, fieldName, String.valueOf(returnCode));
    }

    public void setMessage(String formName, String fieldName, String messageName) {
        String formFieldName = formName + "-" + fieldName;
        this.addValue(this.forms_messages, formName, messageName);
        this.addValue(this.fields_messages, formFieldName, messageName);
        this.addValue(this.messages_fields, messageName, formFieldName);
        this.addValue(this.forms_fields, formName, formFieldName);
    }

    private void addValue(Hashtable<String, List<String>> table, String key, String value) {
        if (!table.containsKey(key)) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            table.put(key, values);
        } else {
            List<String> values = table.get(key);
            if (!values.contains(value)) {
                values.add(value);
            }
        }
    }

    private final List<String> getValues(Hashtable<String, List<String>> table, String key) {
        return table.get(key);
    }

    public FormMessage[] getFormMessages(String formName) {
        List<String> messages = this.getValues(this.forms_messages, formName);
        if (messages != null) {
            FormMessage[] result = new FormMessage[messages.size()];
            for (int i = 0; i < messages.size(); ++i) {
                result[i] = new FormMessage(formName);
                String messageName = messages.get(i);
                result[i].setMessage(messageName);
                List<String> fields = this.getValues(this.messages_fields, messageName);
                for (int j = 0; j < fields.size(); ++j) {
                    String fieldName = fields.get(j);
                    if (!this.formHasField(formName, fieldName)) continue;
                    result[i].setFieldName(fieldName);
                }
            }
            return result;
        }
        return null;
    }

    public FormMessage[] getFormMessages(String formName, String fieldName) {
        String key = formName + "-" + fieldName;
        List<String> messages = this.getValues(this.fields_messages, key);
        if (messages != null) {
            FormMessage[] result = new FormMessage[messages.size()];
            for (int i = 0; i < messages.size(); ++i) {
                result[i] = new FormMessage(formName, fieldName);
                String messageName = messages.get(i);
                result[i].setMessage(messageName);
            }
            return result;
        }
        return null;
    }

    private boolean formHasField(String formName, String fieldName) {
        List<String> fields = this.getValues(this.forms_fields, formName);
        Iterator<String> iter = fields.iterator();
        while (iter.hasNext()) {
            if (!fieldName.equals(iter.next().toString())) continue;
            return true;
        }
        return false;
    }
}

