/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.ui;

import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.pull.PullService;
import org.apache.turbine.services.servlet.ServletService;
import org.apache.turbine.services.ui.UIService;
import org.apache.turbine.util.ServerData;
import org.apache.turbine.util.uri.DataURI;

public class TurbineUIService
extends TurbineBaseService
implements UIService {
    private static Log log = LogFactory.getLog(TurbineUIService.class);
    private static final String SKINS_DIRECTORY = "/ui/skins";
    private static final String IMAGES_DIRECTORY = "/images";
    private static final String SKIN_PROPERTY = "tool.ui.skin";
    private static final String IMAGEDIR_PROPERTY = "tool.ui.dir.image";
    private static final String SKINDIR_PROPERTY = "tool.ui.dir.skin";
    private static final String CSS_PROPERTY = "tool.ui.css";
    private static final String RELATIVE_PROPERTY = "tool.ui.want.relative";
    public static final String SKIN_PROPERTY_DEFAULT = "default";
    private String skinsDirectory;
    private static final String SKIN_PROPS_FILE = "skin.props";
    private static final String DEFAULT_SKIN_CSS_FILE = "skin.css";
    private ServletService servletService;
    private String imagesDirectory;
    private String cssFile;
    private boolean wantRelative = false;
    private ConcurrentHashMap<String, Properties> skins = new ConcurrentHashMap();

    @Override
    public void refresh() {
        this.clearSkins();
    }

    @Override
    public void refresh(String skinName) {
        this.clearSkin(skinName);
    }

    private Properties getSkinProperties(String skinName) {
        Properties skinProperties = this.skins.get(skinName);
        return null != skinProperties ? skinProperties : this.loadSkin(skinName);
    }

    @Override
    public String get(String skinName, String key) {
        Properties skinProperties = this.getSkinProperties(skinName);
        return skinProperties.getProperty(key);
    }

    @Override
    public String get(String key) {
        return this.get(this.getWebappSkinName(), key);
    }

    @Override
    public String[] getSkinNames() {
        File skinsDir = new File(this.servletService.getRealPath(this.skinsDirectory));
        return skinsDir.list((FilenameFilter)DirectoryFileFilter.INSTANCE);
    }

    private void clearSkins() {
        this.skins.clear();
        log.debug((Object)"All skins were cleared.");
    }

    private void clearSkin(String skinName) {
        if (!skinName.equals(SKIN_PROPERTY_DEFAULT)) {
            this.skins.remove(SKIN_PROPERTY_DEFAULT);
        }
        this.skins.remove(skinName);
        log.debug((Object)("The skin \"" + skinName + "\" was cleared (will also clear \"default\" skin)."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadSkin(String skinName) {
        Properties defaultSkinProperties = null;
        if (!StringUtils.equals((String)skinName, (String)SKIN_PROPERTY_DEFAULT)) {
            defaultSkinProperties = this.getSkinProperties(SKIN_PROPERTY_DEFAULT);
        }
        Properties skinProperties = new Properties(defaultSkinProperties);
        StringBuilder sb = new StringBuilder();
        sb.append('/').append(this.skinsDirectory);
        sb.append('/').append(skinName);
        sb.append('/').append(SKIN_PROPS_FILE);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading selected skin from: " + sb.toString()));
        }
        InputStream is = null;
        try {
            is = this.servletService.getResourceAsStream(sb.toString());
            skinProperties.load(is);
        }
        catch (Exception e) {
            block9: {
                block8: {
                    Properties properties;
                    try {
                        log.error((Object)("Cannot load skin: " + skinName + ", from: " + sb.toString()), (Throwable)e);
                        if (StringUtils.equals((String)skinName, (String)this.getWebappSkinName()) || StringUtils.equals((String)skinName, (String)SKIN_PROPERTY_DEFAULT)) break block8;
                        log.error((Object)("Attempting to return the skin configured for webapp instead of " + skinName));
                        properties = this.getSkinProperties(this.getWebappSkinName());
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    return properties;
                }
                if (StringUtils.equals((String)skinName, (String)SKIN_PROPERTY_DEFAULT)) break block9;
                log.error((Object)("Return the default skin instead of " + skinName));
                Properties properties = skinProperties;
                IOUtils.closeQuietly((InputStream)is);
                return properties;
            }
            log.error((Object)"No skins available - returning an empty Properties");
            Properties properties = new Properties();
            IOUtils.closeQuietly((InputStream)is);
            return properties;
        }
        IOUtils.closeQuietly((InputStream)is);
        this.skins.put(skinName, skinProperties);
        return skinProperties;
    }

    @Override
    public String getWebappSkinName() {
        return Turbine.getConfiguration().getString(SKIN_PROPERTY, SKIN_PROPERTY_DEFAULT);
    }

    @Override
    public String image(String skinName, String imageId, ServerData serverData) {
        return this.getSkinResource(serverData, skinName, this.imagesDirectory, imageId);
    }

    @Override
    public String image(String skinName, String imageId) {
        return this.image(skinName, imageId, Turbine.getDefaultServerData());
    }

    @Override
    public String getStylecss(String skinName, ServerData serverData) {
        return this.getSkinResource(serverData, skinName, null, this.cssFile);
    }

    @Override
    public String getStylecss(String skinName) {
        return this.getStylecss(skinName, Turbine.getDefaultServerData());
    }

    @Override
    public String getScript(String skinName, String filename, ServerData serverData) {
        return this.getSkinResource(serverData, skinName, null, filename);
    }

    @Override
    public String getScript(String skinName, String filename) {
        return this.getScript(skinName, filename, Turbine.getDefaultServerData());
    }

    private String stripSlashes(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return "";
        }
        String ret = path;
        int len = ret.length() - 1;
        if (ret.charAt(len) == '/') {
            ret = ret.substring(0, len);
        }
        if (len > 0 && ret.charAt(0) == '/') {
            ret = ret.substring(1);
        }
        return ret;
    }

    private String getSkinResource(ServerData serverData, String skinName, String subDir, String resourceName) {
        StringBuilder sb = new StringBuilder(this.skinsDirectory);
        sb.append("/").append(skinName);
        if (subDir != null) {
            sb.append("/").append(subDir);
        }
        sb.append("/").append(this.stripSlashes(resourceName));
        DataURI du = new DataURI(serverData);
        du.setScriptName(sb.toString());
        return this.wantRelative ? du.getRelativeLink() : du.getAbsoluteLink();
    }

    @Override
    public void init() throws InitializationException {
        Configuration cfg = Turbine.getConfiguration();
        this.servletService = (ServletService)TurbineServices.getInstance().getService("ServletService");
        PullService pullService = (PullService)TurbineServices.getInstance().getService("PullService");
        StringBuilder sb = new StringBuilder();
        sb.append(this.stripSlashes(pullService.getResourcesDirectory()));
        sb.append("/");
        sb.append(this.stripSlashes(cfg.getString(SKINDIR_PROPERTY, SKINS_DIRECTORY)));
        this.skinsDirectory = sb.toString();
        this.imagesDirectory = this.stripSlashes(cfg.getString(IMAGEDIR_PROPERTY, IMAGES_DIRECTORY));
        this.cssFile = cfg.getString(CSS_PROPERTY, DEFAULT_SKIN_CSS_FILE);
        this.wantRelative = cfg.getBoolean(RELATIVE_PROPERTY, false);
        this.setInit(true);
    }

    @Override
    public void shutdown() {
        this.clearSkins();
        this.setInit(false);
    }
}

