package org.apache.turbine.services.security.torque.om;


import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.ObjectUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.ComboKey;
import org.apache.torque.om.DateKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.StringKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.Transaction;





/**
 * This class was autogenerated by Torque on:
 *
 * [Thu Jun 23 17:25:46 CEST 2011]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to TurbineRolePermission
 */
public abstract class BaseTurbineRolePermission extends BaseObject
{
    /** Serial version */
    private static final long serialVersionUID = 1308842746584L;

    /** The Peer class */
    private static final TurbineRolePermissionPeer peer =
        new TurbineRolePermissionPeer();


    /** The value for the roleId field */
    private int roleId;

    /** The value for the permissionId field */
    private int permissionId;


    /**
     * Get the RoleId
     *
     * @return int
     */
    public int getRoleId()
    {
        return roleId;
    }


    /**
     * Set the value of RoleId
     *
     * @param v new value
     */
    public void setRoleId(int v) throws TorqueException
    {

        if (this.roleId != v)
        {
            this.roleId = v;
            setModified(true);
        }


        if (aTurbineRole != null && !(aTurbineRole.getRoleId() == v))
        {
            aTurbineRole = null;
        }

    }

    /**
     * Get the PermissionId
     *
     * @return int
     */
    public int getPermissionId()
    {
        return permissionId;
    }


    /**
     * Set the value of PermissionId
     *
     * @param v new value
     */
    public void setPermissionId(int v) throws TorqueException
    {

        if (this.permissionId != v)
        {
            this.permissionId = v;
            setModified(true);
        }


        if (aTurbinePermission != null && !(aTurbinePermission.getPermissionId() == v))
        {
            aTurbinePermission = null;
        }

    }

    



    private TurbineRole aTurbineRole;

    /**
     * Declares an association between this object and a TurbineRole object
     *
     * @param v TurbineRole
     * @throws TorqueException
     */
    public void setTurbineRole(TurbineRole v) throws TorqueException
    {
        if (v == null)
        {
            setRoleId( 0);
        }
        else
        {
            setRoleId(v.getRoleId());
        }
        aTurbineRole = v;
    }


    /**
     * Returns the associated TurbineRole object.
     * If it was not retrieved before, the object is retrieved from
     * the database
     *
     * @return the associated TurbineRole object
     * @throws TorqueException
     */
    public TurbineRole getTurbineRole()
        throws TorqueException
    {
        if (aTurbineRole == null && (this.roleId != 0))
        {
            aTurbineRole = TurbineRolePeer.retrieveByPK(SimpleKey.keyFor(this.roleId));
        }
        return aTurbineRole;
    }

    /**
     * Return the associated TurbineRole object
     * If it was not retrieved before, the object is retrieved from
     * the database using the passed connection
     *
     * @param connection the connection used to retrieve the associated object
     *        from the database, if it was not retrieved before
     * @return the associated TurbineRole object
     * @throws TorqueException
     */
    public TurbineRole getTurbineRole(Connection connection)
        throws TorqueException
    {
        if (aTurbineRole == null && (this.roleId != 0))
        {
            aTurbineRole = TurbineRolePeer.retrieveByPK(SimpleKey.keyFor(this.roleId), connection);
        }
        return aTurbineRole;
    }

    /**
     * Provides convenient way to set a relationship based on a
     * ObjectKey, for example
     * <code>bar.setFooKey(foo.getPrimaryKey())</code>
     *
     */
    public void setTurbineRoleKey(ObjectKey key) throws TorqueException
    {

        setRoleId(((NumberKey) key).intValue());
    }




    private TurbinePermission aTurbinePermission;

    /**
     * Declares an association between this object and a TurbinePermission object
     *
     * @param v TurbinePermission
     * @throws TorqueException
     */
    public void setTurbinePermission(TurbinePermission v) throws TorqueException
    {
        if (v == null)
        {
            setPermissionId( 0);
        }
        else
        {
            setPermissionId(v.getPermissionId());
        }
        aTurbinePermission = v;
    }


    /**
     * Returns the associated TurbinePermission object.
     * If it was not retrieved before, the object is retrieved from
     * the database
     *
     * @return the associated TurbinePermission object
     * @throws TorqueException
     */
    public TurbinePermission getTurbinePermission()
        throws TorqueException
    {
        if (aTurbinePermission == null && (this.permissionId != 0))
        {
            aTurbinePermission = TurbinePermissionPeer.retrieveByPK(SimpleKey.keyFor(this.permissionId));
        }
        return aTurbinePermission;
    }

    /**
     * Return the associated TurbinePermission object
     * If it was not retrieved before, the object is retrieved from
     * the database using the passed connection
     *
     * @param connection the connection used to retrieve the associated object
     *        from the database, if it was not retrieved before
     * @return the associated TurbinePermission object
     * @throws TorqueException
     */
    public TurbinePermission getTurbinePermission(Connection connection)
        throws TorqueException
    {
        if (aTurbinePermission == null && (this.permissionId != 0))
        {
            aTurbinePermission = TurbinePermissionPeer.retrieveByPK(SimpleKey.keyFor(this.permissionId), connection);
        }
        return aTurbinePermission;
    }

    /**
     * Provides convenient way to set a relationship based on a
     * ObjectKey, for example
     * <code>bar.setFooKey(foo.getPrimaryKey())</code>
     *
     */
    public void setTurbinePermissionKey(ObjectKey key) throws TorqueException
    {

        setPermissionId(((NumberKey) key).intValue());
    }
   
        
    private static List<String> fieldNames = null;

    /**
     * Generate a list of field names.
     *
     * @return a list of field names
     */
    public static synchronized List<String> getFieldNames()
    {
        if (fieldNames == null)
        {
            fieldNames = new ArrayList<String>();
            fieldNames.add("RoleId");
            fieldNames.add("PermissionId");
            fieldNames = Collections.unmodifiableList(fieldNames);
        }
        return fieldNames;
    }

    /**
     * Retrieves a field from the object by field (Java) name passed in as a String.
     *
     * @param name field name
     * @return value
     */
    public Object getByName(String name)
    {
        if (name.equals("RoleId"))
        {
            return new Integer(getRoleId());
        }
        if (name.equals("PermissionId"))
        {
            return new Integer(getPermissionId());
        }
        return null;
    }

    /**
     * Set a field in the object by field (Java) name.
     *
     * @param name field name
     * @param value field value
     * @return True if value was set, false if not (invalid name / protected field).
     * @throws IllegalArgumentException if object type of value does not match field object type.
     * @throws TorqueException If a problem occurs with the set[Field] method.
     */
    public boolean setByName(String name, Object value )
        throws TorqueException, IllegalArgumentException
    {
        if (name.equals("RoleId"))
        {
            if (value == null || ! (Integer.class.isInstance(value)))
            {
                throw new IllegalArgumentException("setByName: value parameter was null or not an Integer object.");
            }
            setRoleId(((Integer) value).intValue());
            return true;
        }
        if (name.equals("PermissionId"))
        {
            if (value == null || ! (Integer.class.isInstance(value)))
            {
                throw new IllegalArgumentException("setByName: value parameter was null or not an Integer object.");
            }
            setPermissionId(((Integer) value).intValue());
            return true;
        }
        return false;
    }

    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     *
     * @param name peer name
     * @return value
     */
    public Object getByPeerName(String name)
    {
        if (name.equals(TurbineRolePermissionPeer.ROLE_ID))
        {
            return new Integer(getRoleId());
        }
        if (name.equals(TurbineRolePermissionPeer.PERMISSION_ID))
        {
            return new Integer(getPermissionId());
        }
        return null;
    }

    /**
     * Set field values by Peer Field Name
     *
     * @param name field name
     * @param value field value
     * @return True if value was set, false if not (invalid name / protected field).
     * @throws IllegalArgumentException if object type of value does not match field object type.
     * @throws TorqueException If a problem occurs with the set[Field] method.
     */
    public boolean setByPeerName(String name, Object value)
        throws TorqueException, IllegalArgumentException
    {
      if (TurbineRolePermissionPeer.ROLE_ID.equals(name))
        {
            return setByName("RoleId", value);
        }
      if (TurbineRolePermissionPeer.PERMISSION_ID.equals(name))
        {
            return setByName("PermissionId", value);
        }
        return false;
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     *
     * @param pos position in xml schema
     * @return value
     */
    public Object getByPosition(int pos)
    {
        if (pos == 0)
        {
            return new Integer(getRoleId());
        }
        if (pos == 1)
        {
            return new Integer(getPermissionId());
        }
        return null;
    }

    /**
     * Set field values by its position (zero based) in the XML schema.
     *
     * @param position The field position
     * @param value field value
     * @return True if value was set, false if not (invalid position / protected field).
     * @throws IllegalArgumentException if object type of value does not match field object type.
     * @throws TorqueException If a problem occurs with the set[Field] method.
     */
    public boolean setByPosition(int position, Object value)
        throws TorqueException, IllegalArgumentException
    {
    if (position == 0)
        {
            return setByName("RoleId", value);
        }
    if (position == 1)
        {
            return setByName("PermissionId", value);
        }
        return false;
    }
     
    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     *
     * @throws Exception
     */
    public void save() throws Exception
    {
        save(TurbineRolePermissionPeer.DATABASE_NAME);
    }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     * Note: this code is here because the method body is
     * auto-generated conditionally and therefore needs to be
     * in this file instead of in the super class, BaseObject.
     *
     * @param dbName
     * @throws TorqueException
     */
    public void save(String dbName) throws TorqueException
    {
        Connection con = null;
        try
        {
            con = Transaction.begin(dbName);
            save(con);
            Transaction.commit(con);
        }
        catch(TorqueException e)
        {
            Transaction.safeRollback(con);
            throw e;
        }
    }

    /** flag to prevent endless save loop, if this object is referenced
        by another object which falls in this transaction. */
    private boolean alreadyInSave = false;
    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     *
     * @param con
     * @throws TorqueException
     */
    public void save(Connection con) throws TorqueException
    {
        if (!alreadyInSave)
        {
            alreadyInSave = true;



            // If this object has been modified, then save it to the database.
            if (isModified())
            {
                if (isNew())
                {
                    TurbineRolePermissionPeer.doInsert((TurbineRolePermission) this, con);
                    setNew(false);
                }
                else
                {
                    TurbineRolePermissionPeer.doUpdate((TurbineRolePermission) this, con);
                }
            }

            alreadyInSave = false;
        }
    }



    private final SimpleKey[] pks = new SimpleKey[2];
    private final ComboKey comboPK = new ComboKey(pks);

    /**
     * Set the PrimaryKey with an ObjectKey
     *
     * @param key
     */
    public void setPrimaryKey(ObjectKey key) throws TorqueException
    {
        SimpleKey[] keys = (SimpleKey[]) key.getValue();
        setRoleId(((NumberKey)keys[0]).intValue());
        setPermissionId(((NumberKey)keys[1]).intValue());
    }

    /**
     * Set the PrimaryKey using SimpleKeys.
     *
     * @param roleId int
     * @param permissionId int
     */
    public void setPrimaryKey( int roleId, int permissionId)
        throws TorqueException
    {
        setRoleId(roleId);
        setPermissionId(permissionId);
    }

    /**
     * Set the PrimaryKey using a String.
     */
    public void setPrimaryKey(String key) throws TorqueException
    {
        setPrimaryKey(new ComboKey(key));
    }

    /**
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey()
    {
        pks[0] = SimpleKey.keyFor(getRoleId());
        pks[1] = SimpleKey.keyFor(getPermissionId());
        return comboPK;
    }
 

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
     * It then fills all the association collections and sets the
     * related objects to isNew=true.
     */
    public TurbineRolePermission copy() throws TorqueException
    {
        return copy(true);
    }

    /**
     * Makes a copy of this object using connection.
     * It creates a new object filling in the simple attributes.
     * It then fills all the association collections and sets the
     * related objects to isNew=true.
     *
     * @param con the database connection to read associated objects.
     */
    public TurbineRolePermission copy(Connection con) throws TorqueException
    {
        return copy(true, con);
    }

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
     * If the parameter deepcopy is true, it then fills all the
     * association collections and sets the related objects to
     * isNew=true.
     *
     * @param deepcopy whether to copy the associated objects.
     */
    public TurbineRolePermission copy(boolean deepcopy) throws TorqueException
    {
        return copyInto(new TurbineRolePermission(), deepcopy);
    }

    /**
     * Makes a copy of this object using connection.
     * It creates a new object filling in the simple attributes.
     * If the parameter deepcopy is true, it then fills all the
     * association collections and sets the related objects to
     * isNew=true.
     *
     * @param deepcopy whether to copy the associated objects.
     * @param con the database connection to read associated objects.
     */
    public TurbineRolePermission copy(boolean deepcopy, Connection con) throws TorqueException
    {
        return copyInto(new TurbineRolePermission(), deepcopy, con);
    }
  
    /**
     * Fills the copyObj with the contents of this object.
     * The associated objects are also copied and treated as new objects.
     *
     * @param copyObj the object to fill.
     */
    protected TurbineRolePermission copyInto(TurbineRolePermission copyObj) throws TorqueException
    {
        return copyInto(copyObj, true);
    }

  
    /**
     * Fills the copyObj with the contents of this object using connection.
     * The associated objects are also copied and treated as new objects.
     *
     * @param copyObj the object to fill.
     * @param con the database connection to read associated objects.
     */
    protected TurbineRolePermission copyInto(TurbineRolePermission copyObj, Connection con) throws TorqueException
    {
        return copyInto(copyObj, true, con);
    }
  
    /**
     * Fills the copyObj with the contents of this object.
     * If deepcopy is true, The associated objects are also copied
     * and treated as new objects.
     *
     * @param copyObj the object to fill.
     * @param deepcopy whether the associated objects should be copied.
     */
    protected TurbineRolePermission copyInto(TurbineRolePermission copyObj, boolean deepcopy) throws TorqueException
    {
        copyObj.setRoleId(roleId);
        copyObj.setPermissionId(permissionId);

        copyObj.setRoleId( 0);
        copyObj.setPermissionId( 0);

        if (deepcopy)
        {
        }
        return copyObj;
    }
        
    
    /**
     * Fills the copyObj with the contents of this object using connection.
     * If deepcopy is true, The associated objects are also copied
     * and treated as new objects.
     *
     * @param copyObj the object to fill.
     * @param deepcopy whether the associated objects should be copied.
     * @param con the database connection to read associated objects.
     */
    protected TurbineRolePermission copyInto(TurbineRolePermission copyObj, boolean deepcopy, Connection con) throws TorqueException
    {
        copyObj.setRoleId(roleId);
        copyObj.setPermissionId(permissionId);

        copyObj.setRoleId( 0);
        copyObj.setPermissionId( 0);

        if (deepcopy)
        {
        }
        return copyObj;
    }
    
    

    /**
     * returns a peer instance associated with this om.  Since Peer classes
     * are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     */
    public TurbineRolePermissionPeer getPeer()
    {
        return peer;
    }

    /**
     * Retrieves the TableMap object related to this Table data without
     * compiler warnings of using getPeer().getTableMap().
     *
     * @return The associated TableMap object.
     */
    public TableMap getTableMap() throws TorqueException
    {
        return TurbineRolePermissionPeer.getTableMap();
    }


    public String toString()
    {
        StringBuffer str = new StringBuffer();
        str.append("TurbineRolePermission:\n");
        str.append("RoleId = ")
           .append(getRoleId())
           .append("\n");
        str.append("PermissionId = ")
           .append(getPermissionId())
           .append("\n");
        return(str.toString());
    }
}
