/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.dsfactory;

import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.dbcp.datasources.SharedPoolDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.dsfactory.AbstractDataSourceFactory;

public class SharedPoolDataSourceFactory
extends AbstractDataSourceFactory {
    private static Log log = LogFactory.getLog((Class)SharedPoolDataSourceFactory.class);
    private SharedPoolDataSource ds = null;

    public DataSource getDataSource() {
        return this.ds;
    }

    public void initialize(Configuration configuration) throws TorqueException {
        super.initialize(configuration);
        ConnectionPoolDataSource cpds = this.initCPDS(configuration);
        SharedPoolDataSource dataSource = this.initJdbc2Pool(configuration);
        dataSource.setConnectionPoolDataSource(cpds);
        this.ds = dataSource;
    }

    private SharedPoolDataSource initJdbc2Pool(Configuration configuration) throws TorqueException {
        Configuration conf;
        log.debug((Object)"Starting initJdbc2Pool");
        SharedPoolDataSource dataSource = new SharedPoolDataSource();
        Configuration c = Torque.getConfiguration();
        if (c == null || c.isEmpty()) {
            log.warn((Object)"Global Configuration not set, no Default pool data source configured!");
        } else {
            conf = c.subset("defaults.pool");
            this.applyConfiguration(conf, dataSource);
        }
        conf = configuration.subset("pool");
        this.applyConfiguration(conf, dataSource);
        return dataSource;
    }

    public void close() throws TorqueException {
        try {
            this.ds.close();
        }
        catch (Exception e) {
            log.error((Object)"Exception caught during close()", (Throwable)e);
            throw new TorqueException(e);
        }
        this.ds = null;
    }
}

