/*
 * Decompiled with CFR 0.152.
 */
package com.metaparadigm.jsonrpc;

import com.metaparadigm.jsonrpc.AbstractSerializer;
import com.metaparadigm.jsonrpc.MarshallException;
import com.metaparadigm.jsonrpc.ObjectMatch;
import com.metaparadigm.jsonrpc.SerializerState;
import com.metaparadigm.jsonrpc.UnmarshallException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONObject;

public class ListSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 1L;
    private static Class[] _serializableClasses = new Class[]{List.class, ArrayList.class, LinkedList.class, Vector.class};
    private static Class[] _JSONClasses = new Class[]{JSONObject.class};

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public boolean canSerialize(Class clazz, Class jsonClazz) {
        return super.canSerialize(clazz, jsonClazz) || (jsonClazz == null || jsonClazz == JSONObject.class) && List.class.isAssignableFrom(clazz);
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        int i;
        JSONObject jso = (JSONObject)o;
        String java_class = jso.getString("javaClass");
        if (java_class == null) {
            throw new UnmarshallException("no type hint");
        }
        if (!(java_class.equals("java.util.List") || java_class.equals("java.util.AbstractList") || java_class.equals("java.util.LinkedList") || java_class.equals("java.util.ArrayList") || java_class.equals("java.util.Vector"))) {
            throw new UnmarshallException("not a List");
        }
        JSONArray jsonlist = jso.getJSONArray("list");
        if (jsonlist == null) {
            throw new UnmarshallException("list missing");
        }
        ObjectMatch m = new ObjectMatch(-1);
        try {
            for (i = 0; i < jsonlist.length(); ++i) {
                m = this.ser.tryUnmarshall(state, null, jsonlist.get(i)).max(m);
            }
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("element " + i + " " + e.getMessage());
        }
        return m;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        int i;
        JSONObject jso = (JSONObject)o;
        String java_class = jso.getString("javaClass");
        if (java_class == null) {
            throw new UnmarshallException("no type hint");
        }
        AbstractList al = null;
        if (java_class.equals("java.util.List") || java_class.equals("java.util.AbstractList") || java_class.equals("java.util.ArrayList")) {
            al = new ArrayList();
        } else if (java_class.equals("java.util.LinkedList")) {
            al = new LinkedList();
        } else if (java_class.equals("java.util.Vector")) {
            al = new Vector();
        } else {
            throw new UnmarshallException("not a List");
        }
        JSONArray jsonlist = jso.getJSONArray("list");
        if (jsonlist == null) {
            throw new UnmarshallException("list missing");
        }
        try {
            for (i = 0; i < jsonlist.length(); ++i) {
                ((AbstractList)al).add(this.ser.unmarshall(state, null, jsonlist.get(i)));
            }
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("element " + i + " " + e.getMessage());
        }
        return al;
    }

    public Object marshall(SerializerState state, Object o) throws MarshallException {
        List list = (List)o;
        JSONObject obj = new JSONObject();
        JSONArray arr = new JSONArray();
        if (this.ser.getMarshallClassHints()) {
            obj.put("javaClass", o.getClass().getName());
        }
        obj.put("list", arr);
        int index = 0;
        try {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                arr.put(this.ser.marshall(state, i.next()));
                ++index;
            }
        }
        catch (MarshallException e) {
            throw new MarshallException("element " + index + " " + e.getMessage());
        }
        return obj;
    }
}

