/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules;

import java.util.List;
import org.apache.turbine.Turbine;
import org.apache.turbine.modules.Assembler;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.assemblerbroker.AssemblerBrokerService;
import org.apache.turbine.services.assemblerbroker.TurbineAssemblerBroker;
import org.apache.turbine.util.RunData;

public abstract class GenericLoader<T extends Assembler> {
    protected AssemblerBrokerService ab = TurbineAssemblerBroker.getService();
    private boolean reload = false;
    private static final String TURBINE_PACKAGE = "org.apache.turbine.modules";
    private static List<String> TURBINE_PACKAGES = null;

    public void exec(PipelineData pipelineData, String name) throws Exception {
        RunData data = this.getRunData(pipelineData);
        this.exec(data, name);
    }

    @Deprecated
    public abstract void exec(RunData var1, String var2) throws Exception;

    public boolean reload() {
        return this.reload;
    }

    public GenericLoader setReload(boolean reload) {
        this.reload = reload;
        return this;
    }

    public static String getBasePackage() {
        return TURBINE_PACKAGE;
    }

    public static List<String> getPackages() {
        List<String> packages;
        if (TURBINE_PACKAGES == null) {
            TURBINE_PACKAGES = Turbine.getConfiguration().getList("module.packages");
        }
        if (!(packages = TURBINE_PACKAGES).contains(TURBINE_PACKAGE)) {
            packages.add(TURBINE_PACKAGE);
        }
        return packages;
    }

    protected T getAssembler(String type, String name) throws Exception {
        Assembler asm = null;
        try {
            if (this.ab != null) {
                asm = this.ab.getAssembler(type, name);
            }
        }
        catch (ClassCastException cce) {
            asm = null;
        }
        if (asm == null) {
            List<String> packages = GenericLoader.getPackages();
            throw new ClassNotFoundException("\n\n\tRequested " + type + " not found: " + name + "\n\tTurbine looked in the following " + "modules.packages path: \n\t" + packages.toString() + "\n");
        }
        return (T)asm;
    }

    private RunData getRunData(PipelineData pipelineData) {
        if (!(pipelineData instanceof RunData)) {
            throw new RuntimeException("Can't cast to rundata from pipeline data.");
        }
        return (RunData)pipelineData;
    }
}

