/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.jce.crypto;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import org.apache.fulcrum.jce.crypto.CryptoStreamFactory;
import org.apache.fulcrum.jce.crypto.CryptoStreamFactoryImpl;
import org.apache.fulcrum.jce.crypto.HexConverter;
import org.apache.fulcrum.jce.crypto.StreamUtil;
import org.apache.fulcrum.jce.crypto.extended.CryptoStreamFactoryJ8Template;
import org.apache.fulcrum.jce.crypto.extended.CryptoUtilJ8;

public class CryptoUtil {
    private static CryptoUtil instance;
    protected CryptoStreamFactory cryptoStreamFactory;

    public static synchronized CryptoUtil getInstance() {
        if (instance == null) {
            instance = new CryptoUtil();
        }
        return instance;
    }

    protected CryptoUtil() {
        this.cryptoStreamFactory = CryptoStreamFactoryImpl.getInstance();
    }

    public static synchronized CryptoUtil getInstance(byte[] salt, int count) {
        if (instance == null) {
            instance = new CryptoUtil(salt, count);
        }
        return instance;
    }

    protected CryptoUtil(byte[] salt, int count) {
        this.cryptoStreamFactory = CryptoStreamFactoryImpl.getInstance(salt, count);
    }

    public void encrypt(Object source, Object target, char[] password) throws GeneralSecurityException, IOException {
        this.encrypt(this.getCryptoStreamFactory(), source, target, password);
    }

    public void encrypt(CryptoStreamFactory factory, Object source, Object target, char[] password) throws GeneralSecurityException, IOException {
        InputStream is = StreamUtil.createInputStream(source);
        OutputStream os = StreamUtil.createOutputStream(target);
        OutputStream eos = factory.getOutputStream(os, password);
        StreamUtil.copy(is, eos);
    }

    public String encryptStringWithClearCode(String plainText, char[] password) throws GeneralSecurityException, IOException {
        return this.encryptString(this.getCryptoStreamFactory(), plainText, password, true);
    }

    public String encryptString(String plainText, char[] password) throws GeneralSecurityException, IOException {
        return this.encryptString(this.getCryptoStreamFactory(), plainText, password, false);
    }

    public String encryptString(CryptoStreamFactory factory, String plainText, char[] password, boolean withClearCode) throws GeneralSecurityException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.encrypt(factory, plainText, baos, password);
        String prefix = withClearCode ? (this instanceof CryptoUtilJ8 ? ((CryptoStreamFactoryJ8Template)((CryptoUtilJ8)this).getCryptoStreamFactory()).getType().getClearCode() : "J8_AES064;") : "";
        return prefix + HexConverter.toString(baos.toByteArray());
    }

    public void decrypt(Object source, Object target, char[] password) throws GeneralSecurityException, IOException {
        this.decrypt(this.getCryptoStreamFactory(), source, target, password);
    }

    public String decryptStringWithClearCode(String cipherText, char[] password) throws GeneralSecurityException, IOException {
        return this.decryptString(this.getCryptoStreamFactory(), cipherText.substring(10), password);
    }

    public String decryptString(String cipherText, char[] password) throws GeneralSecurityException, IOException {
        return this.decryptString(this.getCryptoStreamFactory(), cipherText, password);
    }

    public String decryptString(String cipherText, char[] password, boolean withClearCode) throws GeneralSecurityException, IOException {
        return this.decryptString(this.getCryptoStreamFactory(), withClearCode ? cipherText.substring("J8_AES064;".length()) : cipherText, password);
    }

    protected void decrypt(CryptoStreamFactory factory, Object source, Object target, char[] password) throws GeneralSecurityException, IOException {
        InputStream is = StreamUtil.createInputStream(source);
        OutputStream os = StreamUtil.createOutputStream(target);
        InputStream dis = factory.getInputStream(is, password);
        StreamUtil.copy(dis, os);
    }

    public String decryptString(CryptoStreamFactory factory, String cipherText, char[] password) throws GeneralSecurityException, IOException {
        byte[] buffer = HexConverter.toBytes(cipherText);
        ByteArrayOutputStream bais = new ByteArrayOutputStream();
        this.decrypt(factory, buffer, bais, password);
        return new String(bais.toByteArray(), "utf-8");
    }

    public static long copy(InputStream is, OutputStream os) throws IOException {
        return StreamUtil.copy(is, os);
    }

    public CryptoStreamFactory getCryptoStreamFactory() {
        return this.cryptoStreamFactory;
    }
}

