/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import java.awt.geom.AffineTransform;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.provider.MapProjection;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.util.j2d.ParameterizedAffine;
import org.apache.sis.util.internal.DoubleDouble;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

@XmlTransient
public final class Equirectangular
extends AbstractProvider {
    private static final long serialVersionUID = -278288251842178001L;
    public static final String NAME = "Equidistant Cylindrical (Spherical)";
    public static final ParameterDescriptor<Double> STANDARD_PARALLEL;
    static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> LONGITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> FALSE_EASTING;
    public static final ParameterDescriptor<Double> FALSE_NORTHING;
    static final ParameterDescriptorGroup PARAMETERS;

    public Equirectangular() {
        super(CylindricalProjection.class, PARAMETERS, EllipsoidalCS.class, true, CartesianCS.class, false);
    }

    private static double getAndStore(Parameters source, ParameterValueGroup target, ParameterDescriptor<Double> descriptor) throws IllegalArgumentException {
        double value = source.doubleValue(descriptor);
        MapProjection.validate(descriptor, value);
        if (value != 0.0) {
            target.parameter(descriptor.getName().getCode()).setValue(value);
        }
        return value;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup parameters) throws FactoryException {
        Parameters p = Parameters.castOrWrap(parameters);
        ContextualParameters context = new ContextualParameters(PARAMETERS, 2, 2);
        double a = Equirectangular.getAndStore(p, context, MapProjection.SEMI_MAJOR);
        double b = Equirectangular.getAndStore(p, context, MapProjection.SEMI_MINOR);
        double \u03bb0 = Equirectangular.getAndStore(p, context, LONGITUDE_OF_ORIGIN);
        double \u03c60 = Equirectangular.getAndStore(p, context, LATITUDE_OF_ORIGIN);
        double \u03c61 = Equirectangular.getAndStore(p, context, STANDARD_PARALLEL);
        double fe = Equirectangular.getAndStore(p, context, FALSE_EASTING);
        double fn = Equirectangular.getAndStore(p, context, FALSE_NORTHING);
        \u03c61 = Math.toRadians(\u03c61);
        MatrixSIS normalize = context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        normalize.convertBefore(0, Math.cos(\u03c61), null);
        context.normalizeGeographicInputs(\u03bb0).convertBefore(1, null, -\u03c60);
        if (a != b) {
            double rs = b / a;
            double sin\u03c61 = Math.sin(\u03c61);
            a = b / (1.0 - (1.0 - rs * rs) * (sin\u03c61 * sin\u03c61));
        }
        DoubleDouble k = DoubleDouble.of(a, true);
        MatrixSIS denormalize = context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        denormalize.convertAfter(0, k, DoubleDouble.of(fe, true));
        denormalize.convertAfter(1, k, DoubleDouble.of(fn, true));
        MathTransform mt = context.completeTransform(factory, MathTransforms.identity(2));
        if (mt instanceof AffineTransform) {
            mt = new ParameterizedAffine((AffineTransform)((Object)mt), context, true);
        }
        return mt;
    }

    static {
        ParameterBuilder builder = Equirectangular.builder();
        STANDARD_PARALLEL = Equirectangular.createLatitude((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8823")).addIdentifier(Citations.GEOTIFF, "3078")).addName("Latitude of 1st standard parallel")).addName(Citations.OGC, "standard_parallel_1")).addName(Citations.ESRI, "Standard_Parallel_1")).addName(Citations.NETCDF, "standard_parallel")).addName(Citations.GEOTIFF, "StdParallel1")).addName(Citations.PROJ4, "lat_ts"), false);
        LONGITUDE_OF_ORIGIN = Equirectangular.createLongitude((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8802")).addIdentifier(Citations.GEOTIFF, "3088")).addName("Longitude of natural origin")).addName(Citations.OGC, "central_meridian")).addName(Citations.ESRI, "Central_Meridian")).addName(Citations.NETCDF, "longitude_of_projection_origin")).addName(Citations.GEOTIFF, "CenterLong")).addName(Citations.PROJ4, "lon_0"));
        FALSE_EASTING = Equirectangular.createShift((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8806")).addIdentifier(Citations.GEOTIFF, "3082")).addName("False easting")).addName(Citations.OGC, "false_easting")).addName(Citations.ESRI, "False_Easting")).addName(Citations.NETCDF, "false_easting")).addName(Citations.GEOTIFF, "FalseEasting")).addName(Citations.PROJ4, "x_0"));
        FALSE_NORTHING = Equirectangular.createShift((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8807")).addIdentifier(Citations.GEOTIFF, "3083")).addName("False northing")).addName(Citations.OGC, "false_northing")).addName(Citations.ESRI, "False_Northing")).addName(Citations.NETCDF, "false_northing")).addName(Citations.GEOTIFF, "FalseNorthing")).addName(Citations.PROJ4, "y_0"));
        LATITUDE_OF_ORIGIN = Equirectangular.createZeroConstant(((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8801")).addIdentifier(Citations.GEOTIFF, "3089")).addName("Latitude of natural origin")).addName(Citations.OGC, "latitude_of_origin")).addName(Citations.ESRI, "Latitude_Of_Origin")).addName(Citations.NETCDF, "latitude_of_projection_origin")).addName(Citations.GEOTIFF, "CenterLat")).addName(Citations.PROJ4, "lat_0")).setRemarks(Resources.formatInternational((short)12, (Object)0))).setRequired(false));
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)Equirectangular.addIdentifierAndLegacy(builder, "1029", "9823").addName(NAME)).addName("Plate Carr\u00e9e")).addName(Citations.OGC, "Equirectangular")).addName(Citations.ESRI, "Plate_Carree")).addName(Citations.GEOTIFF, "CT_Equirectangular")).addName(Citations.PROJ4, "eqc")).addIdentifier(Citations.GEOTIFF, "17")).createGroupForMapProjection(STANDARD_PARALLEL, LATITUDE_OF_ORIGIN, LONGITUDE_OF_ORIGIN, FALSE_EASTING, FALSE_NORTHING);
    }
}

