/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.serialization.pipes;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.serialization.pipes.JsonFetchEmitTuple;

public class JsonFetchEmitTupleList {
    public static List<FetchEmitTuple> fromJson(Reader reader) throws IOException {
        JsonNode root = new ObjectMapper().readTree(reader);
        if (!root.isArray()) {
            throw new IOException("FetchEmitTupleList must be an array");
        }
        ArrayList<FetchEmitTuple> list = new ArrayList<FetchEmitTuple>();
        for (JsonNode n : root) {
            FetchEmitTuple t = JsonFetchEmitTuple.parseFetchEmitTuple(n);
            list.add(t);
        }
        return list;
    }

    public static String toJson(List<FetchEmitTuple> list) throws IOException {
        StringWriter writer = new StringWriter();
        JsonFetchEmitTupleList.toJson(list, writer);
        return writer.toString();
    }

    public static void toJson(List<FetchEmitTuple> list, Writer writer) throws IOException {
        try (JsonGenerator jsonGenerator = new JsonFactory().setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(TikaConfig.getMaxJsonStringFieldLength()).build()).createGenerator(writer);){
            jsonGenerator.writeStartArray();
            for (FetchEmitTuple t : list) {
                JsonFetchEmitTuple.writeTuple(t, jsonGenerator);
            }
            jsonGenerator.writeEndArray();
        }
    }
}

