/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.core.textstats;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tika.eval.core.textstats.LanguageAwareTokenCountStats;
import org.apache.tika.eval.core.tokens.AlphaIdeographFilterFactory;
import org.apache.tika.eval.core.tokens.CommonTokenCountManager;
import org.apache.tika.eval.core.tokens.CommonTokenResult;
import org.apache.tika.eval.core.tokens.LangModel;
import org.apache.tika.eval.core.tokens.TokenCounts;
import org.apache.tika.language.detect.LanguageResult;

public class CommonTokens
implements LanguageAwareTokenCountStats<CommonTokenResult> {
    private final CommonTokenCountManager commonTokenCountManager;

    public CommonTokens() {
        this(new CommonTokenCountManager());
    }

    public CommonTokens(CommonTokenCountManager mgr) {
        this.commonTokenCountManager = mgr;
    }

    @Override
    public CommonTokenResult calculate(List<LanguageResult> languages, TokenCounts tokenCounts) {
        Pair<String, LangModel> pair = this.commonTokenCountManager.getLangTokens(languages.get(0).getLanguage());
        String actualLangCode = pair.getKey();
        Set<String> commonTokens = pair.getValue().getTokens();
        int numUniqueCommonTokens = 0;
        int numCommonTokens = 0;
        int numUniqueAlphabeticTokens = 0;
        int numAlphabeticTokens = 0;
        for (Map.Entry<String, MutableInt> e : tokenCounts.getTokens().entrySet()) {
            String token = e.getKey();
            int count = e.getValue().intValue();
            if (AlphaIdeographFilterFactory.isAlphabetic(token.toCharArray(), token.length())) {
                numAlphabeticTokens += count;
                ++numUniqueAlphabeticTokens;
            }
            if (!commonTokens.contains(token)) continue;
            numCommonTokens += count;
            ++numUniqueCommonTokens;
        }
        return new CommonTokenResult(actualLangCode, numUniqueCommonTokens, numCommonTokens, numUniqueAlphabeticTokens, numAlphabeticTokens);
    }
}

