/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs.builders;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.tika.batch.ConsumersManager;
import org.apache.tika.batch.FileResource;
import org.apache.tika.batch.FileResourceConsumer;
import org.apache.tika.batch.OutputStreamFactory;
import org.apache.tika.batch.ParserFactory;
import org.apache.tika.batch.builders.AbstractConsumersBuilder;
import org.apache.tika.batch.builders.BatchProcessBuilder;
import org.apache.tika.batch.builders.IContentHandlerFactoryBuilder;
import org.apache.tika.batch.builders.IParserFactoryBuilder;
import org.apache.tika.batch.fs.AbstractFSConsumer;
import org.apache.tika.batch.fs.BasicTikaFSConsumer;
import org.apache.tika.batch.fs.FSConsumersManager;
import org.apache.tika.batch.fs.FSOutputStreamFactory;
import org.apache.tika.batch.fs.FSUtil;
import org.apache.tika.batch.fs.RecursiveParserWrapperFSConsumer;
import org.apache.tika.batch.fs.StreamOutRPWFSConsumer;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.filter.MetadataFilter;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.RecursiveParserWrapper;
import org.apache.tika.sax.BasicContentHandlerFactory;
import org.apache.tika.sax.ContentHandlerFactory;
import org.apache.tika.util.ClassLoaderUtil;
import org.apache.tika.util.PropsUtil;
import org.apache.tika.util.XMLDOMUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BasicTikaFSConsumersBuilder
extends AbstractConsumersBuilder {
    @Override
    public ConsumersManager build(Node node, Map<String, String> runtimeAttributes, ArrayBlockingQueue<FileResource> queue) {
        TikaConfig config;
        Long consumersManagerMaxMillis;
        boolean streamOut;
        boolean recursiveParserWrapper;
        block36: {
            Node tikaConfigNode;
            recursiveParserWrapper = false;
            String recursiveParserWrapperString = runtimeAttributes.get("recursiveParserWrapper");
            if (recursiveParserWrapperString != null) {
                recursiveParserWrapper = PropsUtil.getBoolean(recursiveParserWrapperString, recursiveParserWrapper);
            } else {
                Node recursiveParserWrapperNode = node.getAttributes().getNamedItem("recursiveParserWrapper");
                if (recursiveParserWrapperNode != null) {
                    recursiveParserWrapper = PropsUtil.getBoolean(recursiveParserWrapperNode.getNodeValue(), recursiveParserWrapper);
                }
            }
            streamOut = false;
            String streamOutString = runtimeAttributes.get("streamOut");
            if (streamOutString != null) {
                streamOut = PropsUtil.getBoolean(streamOutString, streamOut);
            } else {
                Node streamOutNode = node.getAttributes().getNamedItem("streamout");
                if (streamOutNode != null) {
                    streamOut = PropsUtil.getBoolean(streamOutNode.getNodeValue(), streamOut);
                }
            }
            consumersManagerMaxMillis = null;
            String consumersManagerMaxMillisString = runtimeAttributes.get("consumersManagerMaxMillis");
            if (consumersManagerMaxMillisString != null) {
                consumersManagerMaxMillis = PropsUtil.getLong(consumersManagerMaxMillisString, null);
            } else {
                Node consumersManagerMaxMillisNode = node.getAttributes().getNamedItem("consumersManagerMaxMillis");
                if (consumersManagerMaxMillis == null && consumersManagerMaxMillisNode != null) {
                    consumersManagerMaxMillis = PropsUtil.getLong(consumersManagerMaxMillisNode.getNodeValue(), null);
                }
            }
            config = null;
            String tikaConfigPath = runtimeAttributes.get("c");
            if (tikaConfigPath == null && (tikaConfigNode = node.getAttributes().getNamedItem("tikaConfig")) != null) {
                tikaConfigPath = PropsUtil.getString(tikaConfigNode.getNodeValue(), null);
            }
            if (tikaConfigPath != null) {
                try (InputStream is = Files.newInputStream(Paths.get(tikaConfigPath, new String[0]), new OpenOption[0]);){
                    config = new TikaConfig(is);
                    break block36;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            config = TikaConfig.getDefaultConfig();
        }
        LinkedList<FileResourceConsumer> consumers = new LinkedList<FileResourceConsumer>();
        int numConsumers = BatchProcessBuilder.getNumConsumers(runtimeAttributes);
        NodeList nodeList = node.getChildNodes();
        Node contentHandlerFactoryNode = null;
        Node parserFactoryNode = null;
        Node outputStreamFactoryNode = null;
        block17: for (int i = 0; i < nodeList.getLength(); ++i) {
            String cn;
            Node child = nodeList.item(i);
            switch (cn = child.getNodeName()) {
                case "parser": {
                    parserFactoryNode = child;
                    continue block17;
                }
                case "contenthandler": {
                    contentHandlerFactoryNode = child;
                    continue block17;
                }
                case "outputstream": {
                    outputStreamFactoryNode = child;
                }
            }
        }
        if (contentHandlerFactoryNode == null || parserFactoryNode == null || outputStreamFactoryNode == null) {
            throw new RuntimeException("You must specify a ContentHandlerFactory, a ParserFactory and an OutputStreamFactory");
        }
        ContentHandlerFactory contentHandlerFactory = this.getContentHandlerFactory(contentHandlerFactoryNode, runtimeAttributes);
        ParserFactory parserFactory = this.getParserFactory(parserFactoryNode, runtimeAttributes);
        OutputStreamFactory outputStreamFactory = this.getOutputStreamFactory(outputStreamFactoryNode, runtimeAttributes, contentHandlerFactory, recursiveParserWrapper);
        Parser parser = parserFactory.getParser(config);
        if (recursiveParserWrapper) {
            MetadataFilter metadataFilter = config.getMetadataFilter();
            parser = new RecursiveParserWrapper(parser);
            for (int i = 0; i < numConsumers; ++i) {
                AbstractFSConsumer c = null;
                c = streamOut ? new StreamOutRPWFSConsumer(queue, parser, contentHandlerFactory, outputStreamFactory, metadataFilter) : new RecursiveParserWrapperFSConsumer(queue, parser, contentHandlerFactory, outputStreamFactory, metadataFilter);
                consumers.add(c);
            }
        } else {
            for (int i = 0; i < numConsumers; ++i) {
                BasicTikaFSConsumer c = new BasicTikaFSConsumer(queue, parser, contentHandlerFactory, outputStreamFactory);
                consumers.add(c);
            }
        }
        FSConsumersManager manager = new FSConsumersManager(consumers);
        if (consumersManagerMaxMillis != null) {
            manager.setConsumersManagerMaxMillis(consumersManagerMaxMillis);
        }
        return manager;
    }

    private ContentHandlerFactory getContentHandlerFactory(Node node, Map<String, String> runtimeAttributes) {
        Map<String, String> localAttrs = XMLDOMUtil.mapifyAttrs(node, runtimeAttributes);
        String className = localAttrs.get("builderClass");
        if (className == null) {
            throw new RuntimeException("Must specify builderClass for contentHandler");
        }
        IContentHandlerFactoryBuilder builder = ClassLoaderUtil.buildClass(IContentHandlerFactoryBuilder.class, className);
        return builder.build(node, (Map)runtimeAttributes);
    }

    private ParserFactory getParserFactory(Node node, Map<String, String> runtimeAttributes) {
        Map<String, String> localAttrs = XMLDOMUtil.mapifyAttrs(node, runtimeAttributes);
        String className = localAttrs.get("builderClass");
        IParserFactoryBuilder builder = ClassLoaderUtil.buildClass(IParserFactoryBuilder.class, className);
        return builder.build(node, runtimeAttributes);
    }

    private OutputStreamFactory getOutputStreamFactory(Node node, Map<String, String> runtimeAttributes, ContentHandlerFactory contentHandlerFactory, boolean useRecursiveParserWrapper) {
        String suffix;
        Map<String, String> attrs = XMLDOMUtil.mapifyAttrs(node, runtimeAttributes);
        Path outputDir = PropsUtil.getPath(attrs.get("outputDir"), null);
        String compressionString = attrs.get("compression");
        FSOutputStreamFactory.COMPRESSION compression = FSOutputStreamFactory.COMPRESSION.NONE;
        if (compressionString != null) {
            if (compressionString.contains("bz")) {
                compression = FSOutputStreamFactory.COMPRESSION.BZIP2;
            } else if (compressionString.contains("gz")) {
                compression = FSOutputStreamFactory.COMPRESSION.GZIP;
            } else if (compressionString.contains("zip")) {
                compression = FSOutputStreamFactory.COMPRESSION.ZIP;
            }
        }
        if ((suffix = attrs.get("outputSuffix")) == null) {
            StringBuilder sb = new StringBuilder();
            if (useRecursiveParserWrapper) {
                sb.append("json");
            } else if (contentHandlerFactory instanceof BasicContentHandlerFactory) {
                this.appendSuffix(((BasicContentHandlerFactory)contentHandlerFactory).getType(), sb);
            }
            this.appendCompression(compression, sb);
            suffix = sb.toString();
        }
        return new FSOutputStreamFactory(outputDir, FSUtil.HANDLE_EXISTING.SKIP, compression, suffix);
    }

    private void appendCompression(FSOutputStreamFactory.COMPRESSION compression, StringBuilder sb) {
        switch (compression) {
            case NONE: {
                break;
            }
            case ZIP: {
                sb.append(".zip");
                break;
            }
            case BZIP2: {
                sb.append(".bz2");
                break;
            }
            case GZIP: {
                sb.append(".gz");
            }
        }
    }

    private void appendSuffix(BasicContentHandlerFactory.HANDLER_TYPE type, StringBuilder sb) {
        switch (type) {
            case XML: {
                sb.append("xml");
                break;
            }
            case HTML: {
                sb.append("html");
                break;
            }
            default: {
                sb.append("txt");
            }
        }
    }
}

