/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.inject;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.inject.Initializable;
import org.apache.struts2.inject.InternalContext;
import org.apache.struts2.inject.InternalFactory;

class InitializableFactory<T>
implements InternalFactory<T> {
    private static final Logger LOG = LogManager.getLogger(InitializableFactory.class);
    private final InternalFactory<T> internalFactory;

    private InitializableFactory(InternalFactory<T> internalFactory) {
        this.internalFactory = internalFactory;
    }

    public static <T> InternalFactory<T> wrapIfNeeded(InternalFactory<T> internalFactory) {
        if (Initializable.class.isAssignableFrom(internalFactory.type())) {
            return new InitializableFactory<T>(internalFactory);
        }
        return internalFactory;
    }

    @Override
    public T create(InternalContext context) {
        T instance = this.internalFactory.create(context);
        if (Initializable.class.isAssignableFrom(instance.getClass())) {
            ((Initializable)instance).init();
        } else {
            LOG.error("Class {} is not marked as {}!", (Object)this.internalFactory.getClass().getName(), (Object)Initializable.class.getName());
        }
        return instance;
    }

    @Override
    public Class<? extends T> type() {
        return this.internalFactory.type();
    }
}

