/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.analytics.dataset;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.analytics.dataset.DataMeasure;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class BaseDataMeasure
implements DataMeasure,
Serializable {
    private static final long serialVersionUID = 10200L;
    public static final String EXCEPTION_MESSAGE_KEY_MEASURE_INCREMENTER_LOAD_ERROR = "engine.analytics.dataset.measure.incrementer.load.error";
    public static final String EXCEPTION_MESSAGE_KEY_MEASURE_VALUE_LOAD_ERROR = "engine.analytics.dataset.measure.value.load.error";
    protected String name;
    protected JRExpression labelExpression;
    protected String valueClassName;
    private transient Class<?> valueClass;
    protected JRExpression valueExpression;
    protected CalculationEnum calculation;
    protected String incrementerFactoryClassName;
    private transient Class<?> incrementerFactoryClass;

    public BaseDataMeasure() {
    }

    public BaseDataMeasure(DataMeasure measure, JRBaseObjectFactory factory) {
        factory.put(measure, this);
        this.name = measure.getName();
        this.labelExpression = factory.getExpression(measure.getLabelExpression());
        this.valueClassName = measure.getValueClassName();
        this.valueExpression = factory.getExpression(measure.getValueExpression());
        this.calculation = measure.getCalculation();
        this.incrementerFactoryClassName = measure.getIncrementerFactoryClassName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JRExpression getLabelExpression() {
        return this.labelExpression;
    }

    @Override
    public String getValueClassName() {
        return this.valueClassName;
    }

    protected void setValueClassName(String valueClassName) {
        this.valueClassName = valueClassName;
        this.valueClass = null;
    }

    @Override
    public Class<?> getValueClass() {
        String className;
        if (this.valueClass == null && (className = JRClassLoader.getClassRealName(this.valueClassName)) != null) {
            try {
                this.valueClass = JRClassLoader.loadClassForName(className);
            }
            catch (ClassNotFoundException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_MEASURE_VALUE_LOAD_ERROR, null, e);
            }
        }
        return this.valueClass;
    }

    @Override
    public JRExpression getValueExpression() {
        return this.valueExpression;
    }

    @Override
    public CalculationEnum getCalculation() {
        return this.calculation;
    }

    @Override
    public String getIncrementerFactoryClassName() {
        return this.incrementerFactoryClassName;
    }

    @Override
    public Class<?> getIncrementerFactoryClass() {
        String className;
        if (this.incrementerFactoryClass == null && (className = JRClassLoader.getClassRealName(this.incrementerFactoryClassName)) != null) {
            try {
                this.incrementerFactoryClass = JRClassLoader.loadClassForName(className);
            }
            catch (ClassNotFoundException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_MEASURE_INCREMENTER_LOAD_ERROR, null, e);
            }
        }
        return this.incrementerFactoryClass;
    }

    protected void setIncrementerFactoryClassName(String incrementerFactoryClassName) {
        this.incrementerFactoryClassName = incrementerFactoryClassName;
        this.incrementerFactoryClass = null;
    }

    @Override
    public Object clone() {
        BaseDataMeasure clone = null;
        try {
            clone = (BaseDataMeasure)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.labelExpression = JRCloneUtils.nullSafeClone(this.labelExpression);
        clone.valueExpression = JRCloneUtils.nullSafeClone(this.valueExpression);
        return clone;
    }
}

