/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import net.sf.jasperreports.engine.JRGraphicElement;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.FillEnum;

public abstract class JRBaseGraphicElement
extends JRBaseElement
implements JRGraphicElement {
    private static final long serialVersionUID = 10200L;
    protected JRPen linePen;
    protected FillEnum fill;

    protected JRBaseGraphicElement(JRGraphicElement graphicElement, JRBaseObjectFactory factory) {
        super(graphicElement, factory);
        this.linePen = graphicElement.getLinePen().clone(this);
        this.fill = graphicElement.getOwnFill();
    }

    @Override
    public JRPen getLinePen() {
        return this.linePen;
    }

    @Override
    public FillEnum getFill() {
        return this.getStyleResolver().getFill(this);
    }

    @Override
    public FillEnum getOwnFill() {
        return this.fill;
    }

    @Override
    public void setFill(FillEnum fill) {
        FillEnum old = this.fill;
        this.fill = fill;
        this.getEventSupport().firePropertyChange("fill", old, this.fill);
    }

    @Override
    public Float getDefaultLineWidth() {
        return JRPen.LINE_WIDTH_1;
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    public Object clone() {
        JRBaseGraphicElement clone = (JRBaseGraphicElement)super.clone();
        clone.linePen = this.linePen.clone(clone);
        return clone;
    }
}

