/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.junit5;

import org.apache.sling.testing.mock.sling.junit5.SlingContext;
import org.apache.sling.testing.mock.sling.junit5.SlingContextExtension;
import org.junit.jupiter.api.extension.ExtensionContext;

final class SlingContextStore {
    private static final ExtensionContext.Namespace Sling_CONTEXT_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{SlingContextExtension.class});

    private SlingContextStore() {
    }

    public static SlingContext getSlingContext(ExtensionContext extensionContext, Object testInstance) {
        return (SlingContext)((Object)SlingContextStore.getStore(extensionContext).get(testInstance, SlingContext.class));
    }

    public static SlingContext getOrCreateSlingContext(ExtensionContext extensionContext, Object testInstance) {
        SlingContext context = SlingContextStore.getSlingContext(extensionContext, testInstance);
        if (context == null) {
            context = SlingContextStore.createSlingContext(extensionContext);
            SlingContextStore.storeSlingContext(extensionContext, testInstance, context);
        }
        return context;
    }

    public static void removeSlingContext(ExtensionContext extensionContext, Object testInstance) {
        SlingContextStore.getStore(extensionContext).remove(testInstance);
    }

    public static void storeSlingContext(ExtensionContext extensionContext, Object testInstance, SlingContext slingContext) {
        SlingContextStore.getStore(extensionContext).put(testInstance, (Object)slingContext);
    }

    private static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(Sling_CONTEXT_NAMESPACE);
    }

    private static SlingContext createSlingContext(ExtensionContext extensionContext) {
        SlingContext slingContext = new SlingContext();
        slingContext.setUpContext();
        return slingContext;
    }
}

