/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.metric.util;

import java.util.Map;
import java.util.function.BiFunction;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.HistogramStats;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.jetbrains.annotations.NotNull;

public class StatsProviderUtil {
    private final StatisticsProvider statisticsProvider;
    private final BiFunction<String, Map<String, String>, String> METRIC = (name, labels) -> labels.entrySet().stream().reduce(name, (n, e) -> n + ";" + (String)e.getKey() + "=" + (String)e.getValue(), (n1, n2) -> n1 + n2);

    public StatsProviderUtil(@NotNull StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
    }

    public BiFunction<String, Map<String, String>, HistogramStats> getHistoStats() {
        return (name, labels) -> this.statisticsProvider.getHistogram(this.METRIC.apply((String)name, (Map<String, String>)labels), StatsOptions.METRICS_ONLY);
    }

    public BiFunction<String, Map<String, String>, CounterStats> getCounterStats() {
        return (name, labels) -> this.statisticsProvider.getCounterStats(this.METRIC.apply((String)name, (Map<String, String>)labels), StatsOptions.METRICS_ONLY);
    }

    public BiFunction<String, Map<String, String>, TimerStats> getTimerStats() {
        return (name, labels) -> this.statisticsProvider.getTimer(this.METRIC.apply((String)name, (Map<String, String>)labels), StatsOptions.METRICS_ONLY);
    }

    public BiFunction<String, Map<String, String>, MeterStats> getMeterStats() {
        return (name, labels) -> this.statisticsProvider.getMeter(this.METRIC.apply((String)name, (Map<String, String>)labels), StatsOptions.METRICS_ONLY);
    }
}

