/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.webdav.impl.helper;

import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.sling.jcr.webdav.impl.helper.SlingResourceLocator;

public class SlingLocatorFactory
implements DavLocatorFactory {
    private final String workspaceName;

    public SlingLocatorFactory(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public DavResourceLocator createResourceLocator(String prefix, String href) {
        if (href == null) {
            throw new IllegalArgumentException("Request handle must not be null.");
        }
        if (prefix != null && prefix.length() > 0 && href.startsWith(prefix)) {
            href = href.substring(prefix.length());
        }
        if (href.endsWith("/")) {
            href = href.substring(0, href.length() - 1);
        }
        String resourcePath = "".equals(href) ? "/" : Text.unescape((String)href);
        return new SlingResourceLocator(prefix, this.workspaceName, resourcePath, this);
    }

    public DavResourceLocator createResourceLocator(String prefix, String workspacePath, String resourcePath) {
        return this.createResourceLocator(prefix, workspacePath, resourcePath, true);
    }

    public DavResourceLocator createResourceLocator(String prefix, String workspacePath, String resourcePath, boolean isResourcePath) {
        return new SlingResourceLocator(prefix, workspacePath, resourcePath, this);
    }
}

