/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.impl.felix.utils.resource;

import java.util.Map;
import org.osgi.framework.Version;
import org.osgi.resource.Resource;

public final class ResourceUtils {
    private ResourceUtils() {
        throw new UnsupportedOperationException();
    }

    public static String toString(Resource res, String namespace, Map<String, Object> attrs, Map<String, String> dirs) {
        StringBuilder sb = new StringBuilder();
        if (res != null) {
            sb.append("[").append(res).append("] ");
        }
        sb.append(namespace);
        for (String key : attrs.keySet()) {
            sb.append("; ");
            ResourceUtils.append(sb, key, attrs.get(key), true);
        }
        for (String key : dirs.keySet()) {
            sb.append("; ");
            ResourceUtils.append(sb, key, dirs.get(key), false);
        }
        return sb.toString();
    }

    private static void append(StringBuilder sb, String key, Object val, boolean attribute) {
        sb.append(key);
        if (val instanceof Version) {
            sb.append(":Version=");
            sb.append(val);
        } else if (val instanceof Long) {
            sb.append(":Long=");
            sb.append(val);
        } else if (val instanceof Double) {
            sb.append(":Double=");
            sb.append(val);
        } else if (val instanceof Iterable) {
            Iterable it = (Iterable)val;
            String scalar = null;
            for (Object o : it) {
                String ts;
                if (o instanceof String) {
                    ts = "String";
                } else if (o instanceof Long) {
                    ts = "Long";
                } else if (o instanceof Double) {
                    ts = "Double";
                } else if (o instanceof Version) {
                    ts = "Version";
                } else {
                    throw new IllegalArgumentException("Unsupported scalar type: " + o);
                }
                if (scalar == null) {
                    scalar = ts;
                    continue;
                }
                if (scalar.equals(ts)) continue;
                throw new IllegalArgumentException("Unconsistent list type for attribute " + key);
            }
            sb.append(":List<").append(scalar).append(">=");
            sb.append("\"");
            boolean first = true;
            for (Object o : it) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(o.toString().replace("\"", "\\\"").replace(",", "\\,"));
            }
            sb.append("\"");
        } else {
            sb.append(attribute ? "=" : ":=");
            String s = val.toString();
            if (s.matches("[0-9a-zA-Z_\\-.]*")) {
                sb.append(s);
            } else {
                sb.append("\"").append(s.replace("\"", "\\\\")).append("\"");
            }
        }
    }
}

